#[macro_use]
extern crate zflags;

static V1: zflags::optv = option!(None, "x", "exec", None, 8, None);
static V2: zflags::optv = option!("fi", "x", "exec", None, None, "help");
static V3: zflags::optv = option!("s2", "x", "exec", "file", "ls", None);

mod sub {
    static V: zflags::optv = option!(None, "d", None, "day", "1970-1-1", "default date");
    pub fn print() {
        let date = V.str().unwrap();
        println!("date {}", date);
    }
}

fn main() {
    option_parse!("clap", "v0.1.0");
    let s1: i32 = V1.parse().unwrap();
    println!("{}", s1);

    match V2.parse::<String>() {
        Ok(n) => println!("fi -x {}", n),
        Err(s) => println!("{}", s),
    }

    match V3.str() {
        Ok(n) => println!("s2 -x {}", n),
        Err(s) => println!("{}", s),
    }
}
