use crate::{zest_block::ZestBlock, zest_digest::zest_digest, zest_hash::zest4096};

//Can be parallelized. Keep in mind that the key,
//init_ctr_enc, init_result_dgst, and init_ctr_dgst
//should be consistent across encoding and decoding.

//The key should be unique for every single message (as a nonce in itself)
//for maximum protection.

pub fn zest_enc(
    padded_text: Vec<ZestBlock>,
    key: ZestBlock,
    init_ctr_enc: Option<ZestBlock>,
    init_result_dgst: Option<ZestBlock>,
    init_ctr_dgst: Option<ZestBlock>,
) -> Vec<ZestBlock> {
    //Variables needed for encryption
    let mut cipher_text = vec![];
    let mut counter = init_ctr_enc.unwrap_or_else(ZestBlock::new);
    for text_block in padded_text.clone() {
        //Generate next CSPRNG data stream and squash in the cipher text.
        let mut cipher_block = zest4096(key ^ counter);
        cipher_block ^= text_block;
        counter.increment_block();
        cipher_text.push(cipher_block);
    }
    //Add the computed digest to the block stream, and encrypt it as well.
    let digest = zest_digest(padded_text, init_result_dgst, init_ctr_dgst);
    let cipher_stream = zest4096(key ^ counter);
    cipher_text.push(digest ^ cipher_stream);
    //Return the cipher text + digest
    cipher_text
}
