use crate::zest_block::ZestBlock;
use crate::zest_hash::zest4096;

// Used to get a digest out of a variable length of bytes.
// Can be performed in parallel:
// Essentially pads input, splits into blocks,
// hashes each block individually,
// XORS the result.

//input: Padded bytes.
//init_result: initialized vector for the result
//init_ctr: initialized counter which is XOR-ED along every message
#[inline]
pub fn zest_digest(
    padded: Vec<ZestBlock>,
    init_result: Option<ZestBlock>,
    init_ctr: Option<ZestBlock>,
) -> ZestBlock {
    let mut result_block = init_result.unwrap_or_else(ZestBlock::new);
    let mut counter_block = init_ctr.unwrap_or_else(ZestBlock::new);
    for block in padded {
        result_block ^= zest4096(zest4096(block) ^ counter_block);
        counter_block.increment_block();
    }
    result_block
}
