use crate::{zest_block::ZestBlock, zest_hash::zest4096};

//Can be parallelized. Keep in mind that the key,
//init_ctr_enc, init_result_dgst, and init_ctr_dgst
//should be consistent across encoding and decoding.

//The key should be unique for every single message (as a nonce in itself)
//for maximum protection.

pub fn zest_enc(
    padded_text: Vec<ZestBlock>,
    key: ZestBlock,
    init_ctr_enc: Option<ZestBlock>,
    init_result_dgst: Option<ZestBlock>,
    init_ctr_dgst: Option<ZestBlock>,
) -> Vec<ZestBlock> {
    //Variables needed for encryption
    let mut cipher_text = vec![];
    let mut counter = init_ctr_enc.unwrap_or_else(ZestBlock::new);
    //Variables needed for decryption
    let mut result_dgst = init_result_dgst.unwrap_or_else(ZestBlock::new);
    let mut ctr_dgst = init_ctr_dgst.unwrap_or_else(ZestBlock::new);
    for text_block in padded_text {
        //Generate next CSPRNG data stream and squash in the cipher text.
        let mut cipher_block = zest4096(key ^ counter);
        cipher_block ^= text_block;
        counter.increment_block();
        cipher_text.push(cipher_block);

        //Compute partial digest
        result_dgst ^= zest4096(text_block) + ctr_dgst;
        ctr_dgst.increment_block();
    }
    //Add the computed digest to the block stream
    cipher_text.push(result_dgst);
    //Return the cipher text + digest
    cipher_text
}
