use crate::zest_block::ZestBlock;
use crate::zest_hash::zest4096;
use crate::zest_pad::pad;

// Used to get a digest out of a variable length of bytes.
// Can be performed in parallel:
// Essentially pads input, splits into blocks,
// hashes each block individually,
// XORS the result.

#[inline]
pub fn zest_digest(input: &[u8], init_vec: Option<ZestBlock>) -> ZestBlock {
    let blocks = pad(input);
    let mut result_block = init_vec.unwrap_or_else(ZestBlock::new);
    for block in blocks {
        result_block ^= zest4096(block);
    }
    result_block
}
