//Not using the num crate to avoid compiler overhead

pub trait NumberSupport {
    fn abs(self) -> Self;
    const MAX: Self;
}

macro_rules! num_support_signed {
	($($t:ty),*) => {
		$(impl NumberSupport for $t {
			#[inline(always)]
			fn abs(self) -> Self {
				Self::abs(self)
			}
			const MAX: Self = Self::MAX;
		})*
	}
}

macro_rules! num_support_unsigned {
	($($t:ty),*) => {
		$(impl NumberSupport for $t {
			#[inline(always)]
			fn abs(self) -> Self {
				self
			}
			const MAX: Self = Self::MAX;
		})*
	}
}

num_support_signed!(i8, i16, i32, i64, i128, isize);
num_support_unsigned!(u8, u16, u32, u64, u128, usize);
