use crate::zest_block::ZestBlock;
use crate::zest_hash;
use crate::zest_pad;

//Used to get a digest out of a variable length of bytes.

#[inline]
pub fn zest_digest(input: &[u8], init_vec: Option<ZestBlock>) -> ZestBlock {
    let mut padded = zest_pad::pad(input);
    let mut digest = init_vec.unwrap_or_else(ZestBlock::new);
    while let Some(last_item) = padded.pop() {
        for i in 0..64 {
            digest[i] ^= last_item[i];
        }
        digest = zest_hash::zest4096(digest);
    }
    digest
}
