use crate::{zest_block::ZestBlock, zest_hash::zest4096, zest_pad::de_pad};

// WARNING:
// If the incorrect key is used, at least one byte
// is taken off the output when it tries to de-pad it.
pub fn zest_dec(cipher_blocks: Vec<ZestBlock>, key: ZestBlock) -> Vec<u8> {
    let mut text_out = vec![];
    let mut counter = ZestBlock::new();
    for block in cipher_blocks {
        let mut hashed_out = zest4096(key ^ counter);
        hashed_out ^= block;
        text_out.push(hashed_out);
        counter.increment_block();
    }
    let mut out_bytes = blocks_to_bytes(text_out);
    de_pad(&mut out_bytes);
    out_bytes
}

#[inline(always)]
fn blocks_to_bytes(blocks: Vec<ZestBlock>) -> Vec<u8> {
    let mut decoded_bytes = vec![];
    for block in blocks {
        decoded_bytes.append(&mut block.data_u8().to_vec())
    }
    decoded_bytes
}
