use crate::zest_block::ZestBlock;

// Takes in arbitrary length input and pads it to needed length.
#[inline(always)]
pub fn pad(input: &[u8]) -> Vec<ZestBlock> {
    let mut un_padded = input.to_vec();
    un_padded.push(0xFF);
    let alignment_add = 0x200 - (un_padded.len() & 0x1FF);
    un_padded.resize(un_padded.len() + alignment_add, 0);
    to_blocks(un_padded)
}

// Takes in blocks and de-pads it back to original size.
#[inline(always)]
pub fn de_pad(input: &mut Vec<u8>) {
    while input.pop() == Some(0) {}
}

#[inline(always)]
fn to_blocks(input: Vec<u8>) -> Vec<ZestBlock> {
    let mut blocks: Vec<ZestBlock> = vec![];
    for block in input.array_chunks::<512>() {
        blocks.push((*block).into());
    }
    blocks
}
