pub trait NumberSupport {
    fn abs(self) -> Self;
    const MAX: Self;
}
impl NumberSupport for i8 {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for i16 {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for i32 {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for i64 {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for i128 {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for isize {
    #[inline(always)]
    fn abs(self) -> Self {
        Self::abs(self)
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for u8 {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for u16 {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for u32 {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for u64 {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for u128 {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
impl NumberSupport for usize {
    #[inline(always)]
    fn abs(self) -> Self {
        self
    }
    const MAX: Self = Self::MAX;
}
