use crate::{zest_block::ZestBlock, zest_hash::zest4096, zest_pad::pad};

//BEWARE: The key is very important. Don't use keys with all values identical.
//This results in insecure encryption.

//BEWARE: When the key == the counter, there is NO ENCRYPTION.
//You can solve this problem by only using part of the key as the key, and the
//rest of the key as a constant + nonce/iv

pub fn zest_enc(input: &[u8], key: ZestBlock) -> Vec<u8> {
    let padded = pad(input);
    let mut cipher_text = vec![];
    let mut counter = ZestBlock::new();
    for block in padded {
        let mut xored_input = key;
        for i in 0..64 {
            xored_input[i] ^= counter[i];
        }
        let mut hashed_out = zest4096(xored_input);
        for i in 0..64 {
            hashed_out[i] ^= block[i];
        }
        cipher_text.push(hashed_out);
        counter.increment_block();
    }
    let mut encoded_bytes = vec![];
    for block in cipher_text {
        encoded_bytes.append(&mut block.data_u8().to_vec());
    }
    encoded_bytes
}
