// Takes in arbitrary length input and pads it to needed length.
pub fn pad(input: &[u8]) -> Vec<[u64; 64]> {
    let mut un_padded = input.to_vec();
    un_padded.push(0xFF);
    let alignment_add = 0x200 - (un_padded.len() & 0x1FF);
    un_padded.resize(un_padded.len() + alignment_add, 0);
    to_blocks(un_padded)
}
// Takes in blocks and de-pads it back to original size.
pub fn de_pad(input: &mut Vec<u8>) {
    while input.pop() == Some(0) {}
}

pub fn to_blocks(input: Vec<u8>) -> Vec<[u64; 64]> {
    let blocks: Vec<u64> = input
        .chunks_exact(8)
        .map(|chunk| {
            let arr: &[u8; 8] = chunk.try_into().unwrap();
            u64::from_be_bytes(*arr)
        })
        .collect();
    let padded: Vec<[u64; 64]> = blocks
        .chunks_exact(64)
        .map(|block| {
            let block: &[u64; 64] = block.try_into().unwrap();
            block
        })
        .cloned()
        .collect();
    padded
}
