use crate::{
    counter::inc_counter,
    zest_hash::zest4096,
    zest_pad::{pad, to_blocks},
};

//BEWARE: The key is very important. Don't use keys with all values identical.
//This results in insecure encryption.

//BEWARE: When the key == the counter, there is NO ENCRYPTION.
//You can solve this problem by only using part of the key as the key, and the
//rest of the key as a constant + nonce/iv
pub fn zest_enc(input: &[u8], key: [u64; 64]) -> Vec<u8> {
    let padded = pad(input);
    let mut cipher_text = vec![];
    let mut counter = [0_u64; 64];
    for block in padded {
        let mut xored_input = key;
        for i in 0..64 {
            xored_input[i] ^= counter[i];
        }
        let mut hashed_out = zest4096(xored_input);
        for i in 0..64 {
            hashed_out[i] ^= block[i];
        }
        cipher_text.push(hashed_out);
        inc_counter(&mut counter);
    }
    let mut encoded_bytes = vec![];
    for block in cipher_text {
        for chunk in block {
            encoded_bytes.append(&mut chunk.to_be_bytes().to_vec());
        }
    }
    encoded_bytes
}

// Can be used to simply use a 512 byte slice convert to a block, for use in
// key-ing the zest_enc function.
pub fn bytes_to_block(bytes: &[u8]) -> [u64; 64] {
    to_blocks(bytes.to_vec())[0]
}
