use crate::zest_hash;
use crate::zest_pad;

//Used to get a digest out of a variable length of bytes.

pub fn zest_digest(input: &[u8], init_vec: Option<[u64; 64]>) -> [u8; 512] {
    let mut padded = zest_pad::pad(input);
    let mut digest = init_vec.unwrap_or([0_u64; 64]);
    while let Some(last_item) = padded.pop() {
        for i in 0..64 {
            digest[i] ^= last_item[i];
        }
        digest = zest_hash::zest4096(digest);
    }
    let mut bytes_out = [0_u8; 512];
    for (c, chunk) in bytes_out.chunks_exact_mut(8).enumerate() {
        for (b, byte_out) in digest[c].to_be_bytes().iter().enumerate() {
            chunk[b] = *byte_out;
        }
    }
    bytes_out
}
