use crate::{
    counter::inc_counter,
    zest_hash::zest4096,
    zest_pad::{de_pad, to_blocks},
};

// WARNING:
// If the incorrect key is used, at least one byte
// is taken off the output when it tries to de-pad it.
pub fn zest_dec(input: &[u8], key: [u64; 64]) -> Vec<u8> {
    let cipher_blocks = to_blocks(input.to_vec());
    let mut text_out = vec![];
    let mut counter = [0_u64; 64];
    for block in cipher_blocks {
        let mut xored_input = key;
        for i in 0..64 {
            xored_input[i] ^= counter[i];
        }
        let mut hashed_out = zest4096(xored_input);
        for i in 0..64 {
            hashed_out[i] ^= block[i];
        }
        text_out.push(hashed_out);
        inc_counter(&mut counter);
    }
    blocks_to_bytes(text_out)
}

fn blocks_to_bytes(blocks: Vec<[u64; 64]>) -> Vec<u8> {
    let mut decoded_bytes = vec![];
    for block in blocks {
        for chunk in block {
            decoded_bytes.append(&mut chunk.to_be_bytes().to_vec());
        }
    }
    de_pad(&mut decoded_bytes);
    decoded_bytes
}
