use std::num::Wrapping;

pub fn inc_counter(counter: &mut [u64]) {
    let mut carry: u64 = 1;
    for elem in counter.iter_mut().rev() {
        *elem = (Wrapping(*elem) + Wrapping(carry)).0;
        carry = (*elem < carry) as u64;
    }
}
