/*
 * ZeroTierOne Service API
 *
 * <p> This API controls the ZeroTier service that runs in the background on your computer. This is how zerotier-cli, and the macOS and Windows apps control the service. </p> <p> API requests must be authenticated via an authentication token. ZeroTier One saves this token in the authtoken.secret file in its working directory. This token may be supplied via the X-ZT1-Auth HTTP request header. </p> <p> For example: <code>curl -H \"X-ZT1-Auth: $TOKEN\" http://localhost:9993/status</code> </p> <p> The token can be found in: <ul> <li>Mac :: /Library/Application Support/ZeroTier/One</li> <li>Windows :: \\ProgramData\\ZeroTier\\One</li> <li>Linux :: /var/lib/zerotier-one</li> </ul> </p> <p> You can get the OpenAPI spec here as well: <code>https://docs.zerotier.com/openapi/servicev1.json</code></p>
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct PeerPaths {
    #[serde(rename = "active", skip_serializing_if = "Option::is_none")]
    pub active: Option<bool>,
    #[serde(rename = "address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(rename = "expired", skip_serializing_if = "Option::is_none")]
    pub expired: Option<bool>,
    #[serde(rename = "lastReceive", skip_serializing_if = "Option::is_none")]
    pub last_receive: Option<i64>,
    #[serde(rename = "lastSend", skip_serializing_if = "Option::is_none")]
    pub last_send: Option<i64>,
    #[serde(rename = "preferred", skip_serializing_if = "Option::is_none")]
    pub preferred: Option<bool>,
    #[serde(rename = "trustedPathId", skip_serializing_if = "Option::is_none")]
    pub trusted_path_id: Option<i32>,
}

impl PeerPaths {
    pub fn new() -> PeerPaths {
        PeerPaths {
            active: None,
            address: None,
            expired: None,
            last_receive: None,
            last_send: None,
            preferred: None,
            trusted_path_id: None,
        }
    }
}


