/*
 * ZeroTierOne Service API
 *
 * <p> This API controls the ZeroTier service that runs in the background on your computer. This is how zerotier-cli, and the macOS and Windows apps control the service. </p> <p> API requests must be authenticated via an authentication token. ZeroTier One saves this token in the authtoken.secret file in its working directory. This token may be supplied via the X-ZT1-Auth HTTP request header. </p> <p> For example: <code>curl -H \"X-ZT1-Auth: $TOKEN\" http://localhost:9993/status</code> </p> <p> The token can be found in: <ul> <li>Mac :: /Library/Application Support/ZeroTier/One</li> <li>Windows :: \\ProgramData\\ZeroTier\\One</li> <li>Linux :: /var/lib/zerotier-one</li> </ul> </p> <p> You can get the OpenAPI spec here as well: <code>https://docs.zerotier.com/openapi/servicev1.json</code></p>
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ControllerNetwork {
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "nwid", skip_serializing_if = "Option::is_none")]
    pub nwid: Option<String>,
    #[serde(rename = "objtype", skip_serializing_if = "Option::is_none")]
    pub objtype: Option<String>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "creationTime", skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<f32>,
    #[serde(rename = "private", skip_serializing_if = "Option::is_none")]
    pub private: Option<bool>,
    #[serde(rename = "enableBroadcast", skip_serializing_if = "Option::is_none")]
    pub enable_broadcast: Option<bool>,
    #[serde(rename = "v4AssignMode", skip_serializing_if = "Option::is_none")]
    pub v4_assign_mode: Option<Box<crate::models::ControllerNetworkV4AssignMode>>,
    #[serde(rename = "v6AssignMode", skip_serializing_if = "Option::is_none")]
    pub v6_assign_mode: Option<Box<crate::models::ControllerNetworkV6AssignMode>>,
    #[serde(rename = "mtu", skip_serializing_if = "Option::is_none")]
    pub mtu: Option<i32>,
    #[serde(rename = "multicastLimit", skip_serializing_if = "Option::is_none")]
    pub multicast_limit: Option<i32>,
    #[serde(rename = "revision", skip_serializing_if = "Option::is_none")]
    pub revision: Option<i32>,
    #[serde(rename = "routes", skip_serializing_if = "Option::is_none")]
    pub routes: Option<Vec<crate::models::ControllerNetworkRoutes>>,
    #[serde(rename = "ipAssignmentPools", skip_serializing_if = "Option::is_none")]
    pub ip_assignment_pools: Option<Vec<crate::models::ControllerNetworkIpAssignmentPools>>,
    #[serde(rename = "rules", skip_serializing_if = "Option::is_none")]
    pub rules: Option<Vec<serde_json::Value>>,
    #[serde(rename = "capabilities", skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<Vec<serde_json::Value>>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<serde_json::Value>>,
    #[serde(rename = "remoteTraceTarget", skip_serializing_if = "Option::is_none")]
    pub remote_trace_target: Option<String>,
    #[serde(rename = "remoteTraceLevel", skip_serializing_if = "Option::is_none")]
    pub remote_trace_level: Option<i32>,
}

impl ControllerNetwork {
    pub fn new() -> ControllerNetwork {
        ControllerNetwork {
            id: None,
            nwid: None,
            objtype: None,
            name: None,
            creation_time: None,
            private: None,
            enable_broadcast: None,
            v4_assign_mode: None,
            v6_assign_mode: None,
            mtu: None,
            multicast_limit: None,
            revision: None,
            routes: None,
            ip_assignment_pools: None,
            rules: None,
            capabilities: None,
            tags: None,
            remote_trace_target: None,
            remote_trace_level: None,
        }
    }
}


