# Rust API client for zerotier-one-api

<p> This API controls the ZeroTier service that runs in the background on your computer. This is how zerotier-cli, and the macOS and Windows apps control the service. </p> <p> API requests must be authenticated via an authentication token. ZeroTier One saves this token in the authtoken.secret file in its working directory. This token may be supplied via the X-ZT1-Auth HTTP request header. </p> <p> For example: <code>curl -H \"X-ZT1-Auth: $TOKEN\" http://localhost:9993/status</code> </p> <p> The token can be found in: <ul> <li>Mac :: /Library/Application Support/ZeroTier/One</li> <li>Windows :: \\ProgramData\\ZeroTier\\One</li> <li>Linux :: /var/lib/zerotier-one</li> </ul> </p> <p> You can get the OpenAPI spec here as well: <code>https://docs.zerotier.com/openapi/servicev1.json</code></p>


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.1.0
- Package version: 0.1.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `zerotier-one-api` and add the following to `Cargo.toml` under `[dependencies]`:

```
zerotier-one-api = { path = "./zerotier-one-api" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:9993*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ControllerApi* | [**generate_controller_network**](docs/ControllerApi.md#generate_controller_network) | **POST** /controller/network/{controllerID}______ | Generate Random Network ID.
*ControllerApi* | [**get_controller_network**](docs/ControllerApi.md#get_controller_network) | **GET** /controller/network/{networkID} | Get Network by ID.
*ControllerApi* | [**get_controller_network_member**](docs/ControllerApi.md#get_controller_network_member) | **GET** /controller/network/{networkID}/member{nodeID} | Get Network Member Details by ID.
*ControllerApi* | [**get_controller_network_members**](docs/ControllerApi.md#get_controller_network_members) | **GET** /controller/network/{networkID}/member | List Network Members.
*ControllerApi* | [**get_controller_networks**](docs/ControllerApi.md#get_controller_networks) | **GET** /controller/network | List Networks.
*ControllerApi* | [**get_controller_status**](docs/ControllerApi.md#get_controller_status) | **GET** /controller | Get Controller Status.
*ControllerApi* | [**set_controller_network**](docs/ControllerApi.md#set_controller_network) | **POST** /controller/network/{networkID} | Create or Update a Network.
*NetworkApi* | [**delete_network**](docs/NetworkApi.md#delete_network) | **DELETE** /network/{networkID} | Leave a network.
*NetworkApi* | [**get_network**](docs/NetworkApi.md#get_network) | **GET** /network/{networkID} | Get a joined Network membership configuration by Network ID.
*NetworkApi* | [**get_networks**](docs/NetworkApi.md#get_networks) | **GET** /network | Get all network memberships.
*NetworkApi* | [**update_network**](docs/NetworkApi.md#update_network) | **POST** /network/{networkID} | Join a network or update it's configuration by Network ID.
*PeerApi* | [**get_peer**](docs/PeerApi.md#get_peer) | **GET** /peer/{address} | Get information about a specific peer by Node ID.
*PeerApi* | [**get_peers**](docs/PeerApi.md#get_peers) | **GET** /peer | Get all peers.
*StatusApi* | [**get_status**](docs/StatusApi.md#get_status) | **GET** /status | Node status and addressing info.


## Documentation For Models

 - [ControllerNetwork](docs/ControllerNetwork.md)
 - [ControllerNetworkIpAssignmentPools](docs/ControllerNetworkIpAssignmentPools.md)
 - [ControllerNetworkMember](docs/ControllerNetworkMember.md)
 - [ControllerNetworkRoutes](docs/ControllerNetworkRoutes.md)
 - [ControllerNetworkV4AssignMode](docs/ControllerNetworkV4AssignMode.md)
 - [ControllerNetworkV6AssignMode](docs/ControllerNetworkV6AssignMode.md)
 - [ControllerStatus](docs/ControllerStatus.md)
 - [Network](docs/Network.md)
 - [NetworkAllOf](docs/NetworkAllOf.md)
 - [NetworkAllOf1](docs/NetworkAllOf1.md)
 - [NetworkAllOf1Dns](docs/NetworkAllOf1Dns.md)
 - [NetworkAllOf1MulticastSubscriptions](docs/NetworkAllOf1MulticastSubscriptions.md)
 - [Peer](docs/Peer.md)
 - [PeerPaths](docs/PeerPaths.md)
 - [Status](docs/Status.md)
 - [StatusConfig](docs/StatusConfig.md)
 - [StatusConfigSettings](docs/StatusConfigSettings.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



