/*
 * ZeroTierOne Service API
 *
 * <p> This API controls the ZeroTier service that runs in the background on your computer. This is how zerotier-cli, and the macOS and Windows apps control the service. </p> <p> API requests must be authenticated via an authentication token. ZeroTier One saves this token in the authtoken.secret file in its working directory. This token may be supplied via the X-ZT1-Auth HTTP request header. </p> <p> For example: <code>curl -H \"X-ZT1-Auth: $TOKEN\" http://localhost:9993/status</code> </p> <p> The token can be found in: <ul> <li>Mac :: /Library/Application Support/ZeroTier/One</li> <li>Windows :: \\ProgramData\\ZeroTier\\One</li> <li>Linux :: /var/lib/zerotier-one</li> </ul> </p> 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Status {
    #[serde(rename = "address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    #[serde(rename = "clock", skip_serializing_if = "Option::is_none")]
    pub clock: Option<i32>,
    #[serde(rename = "config", skip_serializing_if = "Option::is_none")]
    pub config: Option<Box<crate::models::StatusConfig>>,
    #[serde(rename = "online", skip_serializing_if = "Option::is_none")]
    pub online: Option<bool>,
    #[serde(rename = "planetWorldId", skip_serializing_if = "Option::is_none")]
    pub planet_world_id: Option<f32>,
    #[serde(rename = "planetWorldTimestamp", skip_serializing_if = "Option::is_none")]
    pub planet_world_timestamp: Option<f32>,
    #[serde(rename = "publicIdentity", skip_serializing_if = "Option::is_none")]
    pub public_identity: Option<String>,
    #[serde(rename = "tcpFallbackActive", skip_serializing_if = "Option::is_none")]
    pub tcp_fallback_active: Option<bool>,
    #[serde(rename = "version", skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    #[serde(rename = "versionBuild", skip_serializing_if = "Option::is_none")]
    pub version_build: Option<i32>,
    #[serde(rename = "versionMajor", skip_serializing_if = "Option::is_none")]
    pub version_major: Option<i32>,
    #[serde(rename = "versionMinor", skip_serializing_if = "Option::is_none")]
    pub version_minor: Option<i32>,
    #[serde(rename = "versionRev", skip_serializing_if = "Option::is_none")]
    pub version_rev: Option<i32>,
}

impl Status {
    pub fn new() -> Status {
        Status {
            address: None,
            clock: None,
            config: None,
            online: None,
            planet_world_id: None,
            planet_world_timestamp: None,
            public_identity: None,
            tcp_fallback_active: None,
            version: None,
            version_build: None,
            version_major: None,
            version_minor: None,
            version_rev: None,
        }
    }
}


