/*
 * ZeroTierOne Service API
 *
 * <p> This API controls the ZeroTier service that runs in the background on your computer. This is how zerotier-cli, and the macOS and Windows apps control the service. </p> <p> API requests must be authenticated via an authentication token. ZeroTier One saves this token in the authtoken.secret file in its working directory. This token may be supplied via the X-ZT1-Auth HTTP request header. </p> <p> For example: <code>curl -H \"X-ZT1-Auth: $TOKEN\" http://localhost:9993/status</code> </p> <p> The token can be found in: <ul> <li>Mac :: /Library/Application Support/ZeroTier/One</li> <li>Windows :: \\ProgramData\\ZeroTier\\One</li> <li>Linux :: /var/lib/zerotier-one</li> </ul> </p> 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkW {
    /// Let ZeroTier modify the system's DNS settings
    #[serde(rename = "allowDNS", skip_serializing_if = "Option::is_none")]
    pub allow_dns: Option<bool>,
    /// Let ZeroTier to modify the system's default route.
    #[serde(rename = "allowDefault", skip_serializing_if = "Option::is_none")]
    pub allow_default: Option<bool>,
    /// Let ZeroTier to manage IP addresses and Route assignments that aren't in private ranges (rfc1918).
    #[serde(rename = "allowGlobal", skip_serializing_if = "Option::is_none")]
    pub allow_global: Option<bool>,
    /// Let ZeroTier to manage IP addresses and Route assignments.
    #[serde(rename = "allowManaged", skip_serializing_if = "Option::is_none")]
    pub allow_managed: Option<bool>,
}

impl NetworkW {
    pub fn new() -> NetworkW {
        NetworkW {
            allow_dns: None,
            allow_default: None,
            allow_global: None,
            allow_managed: None,
        }
    }
}


