/*
 * ZeroTier Central API
 *
 * ZeroTier Central Network Management Portal API.<p>All API requests must have an API token header specified in the <code>Authorization: Bearer xxxxx</code> format.  You can generate your API key by logging into <a href=\"https://my.zerotier.com\">ZeroTier Central</a> and creating a token on the Account page.</p><p>eg. <code>curl -X GET -H \"Authorization: bearer xxxxx\" https://my.zerotier.com/api/v1/network</code></p>
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NetworkConfig {
    /// Network ID
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Time the network was created
    #[serde(rename = "creationTime", skip_serializing_if = "Option::is_none")]
    pub creation_time: Option<i64>,
    /// Array of network capabilities
    #[serde(rename = "capabilities", skip_serializing_if = "Option::is_none")]
    pub capabilities: Option<Vec<serde_json::Value>>,
    #[serde(rename = "dns", skip_serializing_if = "Option::is_none")]
    pub dns: Option<Box<crate::models::NetworkConfigDns>>,
    /// Enable broadcast packets on the network
    #[serde(rename = "enableBroadcast", skip_serializing_if = "Option::is_none")]
    pub enable_broadcast: Option<bool>,
    /// Range of IP addresses for the auto assign pool
    #[serde(rename = "ipAssignmentPools", skip_serializing_if = "Option::is_none")]
    pub ip_assignment_pools: Option<Vec<crate::models::IpRange>>,
    /// Time the network was last modified
    #[serde(rename = "lastModified", skip_serializing_if = "Option::is_none")]
    pub last_modified: Option<i64>,
    /// MTU to set on the client virtual network adapter
    #[serde(rename = "mtu", skip_serializing_if = "Option::is_none")]
    pub mtu: Option<i32>,
    /// Maximum number of recipients per multicast or broadcast. Warning - Setting this to 0 will disable IPv4 communication on your network!
    #[serde(rename = "multicastLimit", skip_serializing_if = "Option::is_none")]
    pub multicast_limit: Option<i32>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Whether or not the network is private.  If false, members will *NOT* need to be authorized to join.
    #[serde(rename = "private", skip_serializing_if = "Option::is_none")]
    pub private: Option<bool>,
    #[serde(rename = "routes", skip_serializing_if = "Option::is_none")]
    pub routes: Option<Vec<crate::models::Route>>,
    #[serde(rename = "rules", skip_serializing_if = "Option::is_none")]
    pub rules: Option<Vec<serde_json::Value>>,
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<serde_json::Value>>,
    #[serde(rename = "v4AssignMode", skip_serializing_if = "Option::is_none")]
    pub v4_assign_mode: Option<Box<crate::models::Ipv4AssignMode>>,
    #[serde(rename = "v6AssignMode", skip_serializing_if = "Option::is_none")]
    pub v6_assign_mode: Option<Box<crate::models::Ipv6AssignMode>>,
}

impl NetworkConfig {
    pub fn new() -> NetworkConfig {
        NetworkConfig {
            id: None,
            creation_time: None,
            capabilities: None,
            dns: None,
            enable_broadcast: None,
            ip_assignment_pools: None,
            last_modified: None,
            mtu: None,
            multicast_limit: None,
            name: None,
            private: None,
            routes: None,
            rules: None,
            tags: None,
            v4_assign_mode: None,
            v6_assign_mode: None,
        }
    }
}


