/*
 * ZeroTier Central API
 *
 * ZeroTier Central Network Management Portal API.<p>All API requests must have an API token header specified in the <code>Authorization: Bearer xxxxx</code> format.  You can generate your API key by logging into <a href=\"https://my.zerotier.com\">ZeroTier Central</a> and creating a token on the Account page.</p><p>eg. <code>curl -X GET -H \"Authorization: bearer xxxxx\" https://my.zerotier.com/api/v1/network</code></p>
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 */

/// Network : Network object



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Network {
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "clock", skip_serializing_if = "Option::is_none")]
    pub clock: Option<i64>,
    #[serde(rename = "config", skip_serializing_if = "Option::is_none")]
    pub config: Option<Box<crate::models::NetworkConfig>>,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "rulesSource", skip_serializing_if = "Option::is_none")]
    pub rules_source: Option<String>,
    #[serde(rename = "permissions", skip_serializing_if = "Option::is_none")]
    pub permissions: Option<::std::collections::HashMap<String, crate::models::Permissions>>,
    #[serde(rename = "ownerId", skip_serializing_if = "Option::is_none")]
    pub owner_id: Option<String>,
    #[serde(rename = "onlineMemberCount", skip_serializing_if = "Option::is_none")]
    pub online_member_count: Option<i32>,
    #[serde(rename = "authorizedMemberCount", skip_serializing_if = "Option::is_none")]
    pub authorized_member_count: Option<i32>,
    #[serde(rename = "totalMemberCount", skip_serializing_if = "Option::is_none")]
    pub total_member_count: Option<i32>,
    #[serde(rename = "capabilitiesByName", skip_serializing_if = "Option::is_none")]
    pub capabilities_by_name: Option<serde_json::Value>,
    #[serde(rename = "tagsByName", skip_serializing_if = "Option::is_none")]
    pub tags_by_name: Option<serde_json::Value>,
}

impl Network {
    /// Network object
    pub fn new() -> Network {
        Network {
            id: None,
            clock: None,
            config: None,
            description: None,
            rules_source: None,
            permissions: None,
            owner_id: None,
            online_member_count: None,
            authorized_member_count: None,
            total_member_count: None,
            capabilities_by_name: None,
            tags_by_name: None,
        }
    }
}


