/*
 * ZeroTier Central API
 *
 * ZeroTier Central Network Management Portal API.<p>All API requests must have an API token header specified in the <code>Authorization: Bearer xxxxx</code> format.  You can generate your API key by logging into <a href=\"https://my.zerotier.com\">ZeroTier Central</a> and creating a token on the Account page.</p><p>eg. <code>curl -X GET -H \"Authorization: bearer xxxxx\" https://my.zerotier.com/api/v1/network</code></p>
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AuthMethods {
    /// email address for built-in authentication
    #[serde(rename = "local", skip_serializing_if = "Option::is_none")]
    pub local: Option<String>,
    /// Google OIDC ID
    #[serde(rename = "google", skip_serializing_if = "Option::is_none")]
    pub google: Option<String>,
    /// Generic OIDC ID
    #[serde(rename = "oidc", skip_serializing_if = "Option::is_none")]
    pub oidc: Option<String>,
}

impl AuthMethods {
    pub fn new() -> AuthMethods {
        AuthMethods {
            local: None,
            google: None,
            oidc: None,
        }
    }
}


