
# This file was @generated by crate2nix 0.10.0 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? if buildRustCrate != null
    then lib.warn "crate2nix: Passing `buildRustCrate` as argument to Cargo.nix is deprecated. If you don't customize `buildRustCrate`, replace `callPackage ./Cargo.nix {}` by `import ./Cargo.nix { inherit pkgs; }`, and if you need to customize `buildRustCrate`, use `buildRustCrateForPkgs` instead." (_: buildRustCrate)
    else pkgs: pkgs.buildRustCrate
  # Deprecated
, buildRustCrate ? null
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? []
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? if builtins.pathExists ./crate-config.nix
    then pkgs.callPackage ./crate-config.nix {}
    else {}
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "zeronet_tracker";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "zeronet_tracker" = rec {
      packageId = "zeronet_tracker";
      build = internal.buildRustCrateWithFeatures {
        packageId = "zeronet_tracker";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "aead" = rec {
        crateName = "aead";
        version = "0.3.2";
        edition = "2018";
        sha256 = "0c8388alvivcj4qkxgh4s4l6fbczn3p8wc0pnar6crlfvcdmvjbz";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "alloc" ];
          "dev" = [ "blobby" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" ];
      };
      "aes" = rec {
        crateName = "aes";
        version = "0.6.0";
        edition = "2018";
        sha256 = "0q85mw70mgr4glza9y9lrs9nxfa1cdcqzfk6wx0smb3623pr2hw8";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "aes-soft";
            packageId = "aes-soft";
            target = { target, features }: (!((builtins.elem "aes" targetFeatures) && (builtins.elem "sse2" targetFeatures) && ((target."arch" == "x86_64") || (target."arch" == "x86"))));
          }
          {
            name = "aesni";
            packageId = "aesni";
            usesDefaultFeatures = false;
            target = { target, features }: ((builtins.elem "aes" targetFeatures) && (builtins.elem "sse2" targetFeatures) && ((target."arch" == "x86_64") || (target."arch" == "x86")));
          }
          {
            name = "cipher";
            packageId = "cipher";
          }
        ];
        devDependencies = [
          {
            name = "cipher";
            packageId = "cipher";
            features = [ "dev" ];
          }
        ];

      };
      "aes-gcm" = rec {
        crateName = "aes-gcm";
        version = "0.8.0";
        edition = "2018";
        sha256 = "1nl8iwlh209y1vj9n2lm1a70i69clvg2z6x69bi4dgdrpgxbay2j";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "aead";
            packageId = "aead";
            usesDefaultFeatures = false;
          }
          {
            name = "aes";
            packageId = "aes";
            optional = true;
          }
          {
            name = "cipher";
            packageId = "cipher";
          }
          {
            name = "ctr";
            packageId = "ctr";
          }
          {
            name = "ghash";
            packageId = "ghash";
            usesDefaultFeatures = false;
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "aead/alloc" ];
          "default" = [ "aes" "alloc" ];
          "heapless" = [ "aead/heapless" ];
          "std" = [ "aead/std" "alloc" ];
        };
        resolvedDefaultFeatures = [ "aes" "alloc" "default" ];
      };
      "aes-soft" = rec {
        crateName = "aes-soft";
        version = "0.6.4";
        edition = "2018";
        sha256 = "0wj0fi2pvmlw09yvb1aqf0mfkzrfxmjsf90finijh255ir4wf55y";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cipher";
            packageId = "cipher";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "cipher";
            packageId = "cipher";
            features = [ "dev" ];
          }
        ];
        features = {
        };
      };
      "aesni" = rec {
        crateName = "aesni";
        version = "0.10.0";
        edition = "2018";
        sha256 = "1kmh07fp9hbi1aa8dr2rybbgw8vqz6hjmk34c4w7sbscx7si2bpa";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cipher";
            packageId = "cipher";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "cipher";
            packageId = "cipher";
            features = [ "dev" ];
          }
        ];
        features = {
          "default" = [ "ctr" ];
        };
      };
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "0.7.18";
        edition = "2018";
        sha256 = "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "memchr/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "ansi_term" = rec {
        crateName = "ansi_term";
        version = "0.11.0";
        edition = "2015";
        sha256 = "16wpvrghvd0353584i1idnsgm0r3vchg8fyrm0x8ayv1rgvbljgf";
        authors = [
          "ogham@bsago.me"
          "Ryan Scheel (Havvy) <ryan.havvy@gmail.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."os" == "windows");
            features = [ "errhandlingapi" "consoleapi" "processenv" ];
          }
        ];

      };
      "atty" = rec {
        crateName = "atty";
        version = "0.2.14";
        edition = "2015";
        sha256 = "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr";
        authors = [
          "softprops <d.tangren@gmail.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (target."os" == "hermit");
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "consoleapi" "processenv" "minwinbase" "minwindef" "winbase" ];
          }
        ];

      };
      "autocfg" = rec {
        crateName = "autocfg";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "base64 0.13.0" = rec {
        crateName = "base64";
        version = "0.13.0";
        edition = "2018";
        sha256 = "1z82g23mbzjgijkpcrilc7nljpxpvpf7zxf6iyiapkgka2ngwkch";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "base64 0.9.3" = rec {
        crateName = "base64";
        version = "0.9.3";
        edition = "2015";
        sha256 = "0hs62r35bgxslawyrn1vp9rmvrkkm76fqv0vqcwd048vs876r7a8";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "safemem";
            packageId = "safemem";
          }
        ];

      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.2.1";
        edition = "2015";
        sha256 = "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "block-buffer" = rec {
        crateName = "block-buffer";
        version = "0.9.0";
        edition = "2018";
        sha256 = "1r4pf90s7d7lj1wdjhlnqa26vvbm6pnc33z138lxpnp9srpi2lj1";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];

      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "cfg-if 0.1.10" = rec {
        crateName = "cfg-if";
        version = "0.1.10";
        edition = "2018";
        sha256 = "08h80ihs74jcyp24cd75wwabygbbdgl05k6p5dmq8akbr78vv1a7";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "cfg-if 1.0.0" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "cipher" = rec {
        crateName = "cipher";
        version = "0.2.5";
        edition = "2018";
        sha256 = "00b8imbmdg7zdrbaczlivmdfdy09xldg95wl4iijl15xgjcfgy0j";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];
        features = {
          "dev" = [ "blobby" ];
        };
      };
      "clap" = rec {
        crateName = "clap";
        version = "2.33.3";
        edition = "2015";
        sha256 = "00i065a58987k1sbzqmlz721rw521zcg08jmsh40gi3khp3qmr9p";
        authors = [
          "Kevin K. <kbknapp@gmail.com>"
        ];
        dependencies = [
          {
            name = "ansi_term";
            packageId = "ansi_term";
            optional = true;
            target = { target, features }: (!(target."windows" or false));
          }
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "strsim";
            packageId = "strsim";
            optional = true;
          }
          {
            name = "textwrap";
            packageId = "textwrap";
          }
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
          {
            name = "vec_map";
            packageId = "vec_map";
            optional = true;
          }
        ];
        features = {
          "color" = [ "ansi_term" "atty" ];
          "default" = [ "suggestions" "color" "vec_map" ];
          "doc" = [ "yaml" ];
          "lints" = [ "clippy" ];
          "suggestions" = [ "strsim" ];
          "wrap_help" = [ "term_size" "textwrap/term_size" ];
          "yaml" = [ "yaml-rust" ];
        };
        resolvedDefaultFeatures = [ "ansi_term" "atty" "color" "default" "strsim" "suggestions" "vec_map" ];
      };
      "cookie" = rec {
        crateName = "cookie";
        version = "0.11.4";
        edition = "2018";
        sha256 = "0rhm5wxi8jaf4av9hsxxn50adh9mvw618k61maw1d9d4813h9xl0";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "aes-gcm";
            packageId = "aes-gcm";
            optional = true;
          }
          {
            name = "base64";
            packageId = "base64 0.13.0";
            optional = true;
          }
          {
            name = "hkdf";
            packageId = "hkdf";
            optional = true;
          }
          {
            name = "hmac";
            packageId = "hmac";
            optional = true;
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 2.1.0";
            optional = true;
          }
          {
            name = "rand";
            packageId = "rand 0.8.4";
            optional = true;
          }
          {
            name = "sha2";
            packageId = "sha2";
            optional = true;
          }
          {
            name = "time";
            packageId = "time";
          }
        ];
        features = {
          "key-expansion" = [ "sha2" "hkdf" ];
          "percent-encode" = [ "percent-encoding" ];
          "private" = [ "aes-gcm" "base64" "rand" "key-expansion" ];
          "secure" = [ "private" "signed" ];
          "signed" = [ "hmac" "sha2" "base64" "rand" "key-expansion" ];
        };
        resolvedDefaultFeatures = [ "aes-gcm" "base64" "hkdf" "hmac" "key-expansion" "percent-encode" "percent-encoding" "private" "rand" "secure" "sha2" "signed" ];
      };
      "cpufeatures" = rec {
        crateName = "cpufeatures";
        version = "0.1.5";
        edition = "2018";
        sha256 = "1vvid867wpnz5wzma3f4x2ijl83fgr6x1fc6shspzpf9ysb9djb6";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (stdenv.hostPlatform.config == "aarch64-apple-darwin");
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: ((target."arch" == "aarch64") && (target."os" == "linux"));
          }
        ];

      };
      "cpuid-bool" = rec {
        crateName = "cpuid-bool";
        version = "0.2.0";
        edition = "2018";
        sha256 = "1fpzag3g655p1lr08jgf5n89snjc2ycqx30mm0w3irc9fc3mvcnw";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "crypto-mac" = rec {
        crateName = "crypto-mac";
        version = "0.10.0";
        edition = "2018";
        sha256 = "19iyh7h9qaqrv29dhbd31rm6pq023ry78nw7jwr3qjy3l22zsms8";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "dev" = [ "blobby" ];
        };
      };
      "ctr" = rec {
        crateName = "ctr";
        version = "0.6.0";
        edition = "2018";
        sha256 = "0zvyf13675hrlc37myj97k5ng7m1mj3d9p4ic4yvyhvl9zak0jpv";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cipher";
            packageId = "cipher";
          }
        ];
        devDependencies = [
          {
            name = "cipher";
            packageId = "cipher";
            features = [ "dev" ];
          }
        ];

      };
      "devise" = rec {
        crateName = "devise";
        version = "0.2.0";
        edition = "2015";
        sha256 = "1lryvr39ia3rfswfnwn2zynsv2r8kj6gqqf0akcs0prws2i4pq3l";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "devise_codegen";
            packageId = "devise_codegen";
          }
          {
            name = "devise_core";
            packageId = "devise_core";
          }
        ];

      };
      "devise_codegen" = rec {
        crateName = "devise_codegen";
        version = "0.2.0";
        edition = "2015";
        sha256 = "1msmq0h19l03n9qmkxxi1a5h8904i8m623kdvjzak4ya51wynv06";
        procMacro = true;
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "devise_core";
            packageId = "devise_core";
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
        ];

      };
      "devise_core" = rec {
        crateName = "devise_core";
        version = "0.2.0";
        edition = "2015";
        sha256 = "11v4z5kljmpiyif3mmfnm3rl1lsqygjlfy2wll7frqxm4adwahfg";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            features = [ "nightly" ];
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
          {
            name = "syn";
            packageId = "syn 0.15.44";
            features = [ "full" "extra-traits" ];
          }
        ];

      };
      "digest" = rec {
        crateName = "digest";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0rmhvk33rgvd6ll71z8sng91a52rw14p0drjn1da0mqa138n1pfk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];
        features = {
          "dev" = [ "blobby" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "either" = rec {
        crateName = "either";
        version = "1.6.1";
        edition = "2015";
        sha256 = "0mwl9vngqf5jvrhmhn9x60kr5hivxyjxbmby2pybncxfqhf4z3g7";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "env_logger" = rec {
        crateName = "env_logger";
        version = "0.7.1";
        edition = "2018";
        sha256 = "0djx8h8xfib43g5w94r1m1mkky5spcw4wblzgnhiyg5vnfxknls4";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "humantime";
            packageId = "humantime";
            optional = true;
          }
          {
            name = "log";
            packageId = "log 0.4.14";
            features = [ "std" ];
          }
          {
            name = "regex";
            packageId = "regex";
            optional = true;
          }
          {
            name = "termcolor";
            packageId = "termcolor";
            optional = true;
          }
        ];
        features = {
          "default" = [ "termcolor" "atty" "humantime" "regex" ];
        };
        resolvedDefaultFeatures = [ "atty" "default" "humantime" "regex" "termcolor" ];
      };
      "filetime" = rec {
        crateName = "filetime";
        version = "0.2.14";
        edition = "2018";
        sha256 = "1s71cb7hzkk4ahc5j53w8933gnxv2giyj7v0za5hbbk37ahwyd0x";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "fileapi" "minwindef" "winbase" ];
          }
        ];

      };
      "fsevent" = rec {
        crateName = "fsevent";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1djxnc2fmv265xqf1iyfz56smh13v9r1p0w9125wjg6k3fyx3dss";
        authors = [
          "Pierre Baillet <pierre@baillet.name>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "fsevent-sys";
            packageId = "fsevent-sys";
          }
        ];

      };
      "fsevent-sys" = rec {
        crateName = "fsevent-sys";
        version = "2.0.1";
        edition = "2015";
        sha256 = "18246vxk7rqn52m0sfrhivxq802i34p2wqqx5zsa0pamjj5086zl";
        authors = [
          "Pierre Baillet <pierre@baillet.name>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "fuchsia-cprng" = rec {
        crateName = "fuchsia-cprng";
        version = "0.1.1";
        edition = "2018";
        sha256 = "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0";
        authors = [
          "Erick Tryzelaar <etryzelaar@google.com>"
        ];

      };
      "fuchsia-zircon" = rec {
        crateName = "fuchsia-zircon";
        version = "0.3.3";
        edition = "2015";
        sha256 = "10jxc5ks1x06gpd0xg51kcjrxr35nj6qhx2zlc5n7bmskv3675rf";
        authors = [
          "Raph Levien <raph@google.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "fuchsia-zircon-sys";
            packageId = "fuchsia-zircon-sys";
          }
        ];

      };
      "fuchsia-zircon-sys" = rec {
        crateName = "fuchsia-zircon-sys";
        version = "0.3.3";
        edition = "2015";
        sha256 = "19zp2085qsyq2bh1gvcxq1lb8w6v6jj9kbdkhpdjrl95fypakjix";
        authors = [
          "Raph Levien <raph@google.com>"
        ];

      };
      "futures" = rec {
        crateName = "futures";
        version = "0.3.15";
        edition = "2018";
        sha256 = "09zwmmfi8d1glhi0bz2didagjyqz3q9gxa7nq4vzmqns0fl46zhf";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-executor";
            packageId = "futures-executor";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" "futures-sink/alloc" "futures-channel/alloc" "futures-util/alloc" ];
          "async-await" = [ "futures-util/async-await" "futures-util/async-await-macro" ];
          "bilock" = [ "futures-util/bilock" ];
          "compat" = [ "std" "futures-util/compat" ];
          "default" = [ "std" "async-await" "executor" ];
          "executor" = [ "std" "futures-executor/std" ];
          "io-compat" = [ "compat" "futures-util/io-compat" ];
          "read-initializer" = [ "futures-io/read-initializer" "futures-util/read-initializer" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "futures-io/std" "futures-sink/std" "futures-util/std" "futures-util/io" "futures-util/channel" ];
          "thread-pool" = [ "executor" "futures-executor/thread-pool" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" "futures-channel/unstable" "futures-io/unstable" "futures-util/unstable" ];
          "write-all-vectored" = [ "futures-util/write-all-vectored" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "default" "executor" "futures-executor" "std" ];
      };
      "futures-channel" = rec {
        crateName = "futures-channel";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1qki53g079ymjkgdxg3rlh5yivys8qvdqhy18l2xz0m8565sd0p6";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" ];
          "default" = [ "std" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "futures-sink" "sink" "std" ];
      };
      "futures-core" = rec {
        crateName = "futures-core";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1lbrw5087ndaqvbjrckbz9ld4ya67k72d6w87c22d6m8v1jzf0h4";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "futures-executor" = rec {
        crateName = "futures-executor";
        version = "0.3.15";
        edition = "2018";
        sha256 = "0ydbmzg6ig9gankp2nspaq668r3ngzss4806dliygjgs16lsdnms";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "futures-core/std" "futures-task/std" "futures-util/std" ];
          "thread-pool" = [ "std" "num_cpus" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "futures-io" = rec {
        crateName = "futures-io";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1899vd5yri6zv88by53pzxb1h4x96mc42riziy6qyd1vzgg9ki5c";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "futures-macro" = rec {
        crateName = "futures-macro";
        version = "0.3.15";
        edition = "2018";
        sha256 = "08fixp6b34lr58cs85kacp3h599bi63njvfd03655pvc92c05i54";
        procMacro = true;
        authors = [
          "Taylor Cramer <cramertj@google.com>"
          "Taiki Endo <te316e89@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
          {
            name = "syn";
            packageId = "syn 1.0.73";
            features = [ "full" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];

      };
      "futures-sink" = rec {
        crateName = "futures-sink";
        version = "0.3.15";
        edition = "2018";
        sha256 = "10j21j3k358512qyglqpfyxj309kr6bcspj6izg6s3gzrv8flyx5";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "futures-task" = rec {
        crateName = "futures-task";
        version = "0.3.15";
        edition = "2018";
        sha256 = "1bixscylw61w61dizqxhrdlnb8mv7yg9h775pssxsk8szkwvw5la";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "futures-util" = rec {
        crateName = "futures-util";
        version = "0.3.15";
        edition = "2018";
        sha256 = "0rqr36zy4na270kn9fwk866adx1xkv1b49zxzm7zjavys8wc5dgy";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-macro";
            packageId = "futures-macro";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "pin-utils";
            packageId = "pin-utils";
          }
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
            optional = true;
          }
          {
            name = "proc-macro-nested";
            packageId = "proc-macro-nested";
            optional = true;
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" ];
          "async-await-macro" = [ "async-await" "futures-macro" "proc-macro-hack" "proc-macro-nested" ];
          "channel" = [ "std" "futures-channel" ];
          "compat" = [ "std" "futures_01" ];
          "default" = [ "std" "async-await" "async-await-macro" ];
          "io" = [ "std" "futures-io" "memchr" ];
          "io-compat" = [ "io" "compat" "tokio-io" ];
          "read-initializer" = [ "io" "futures-io/read-initializer" "futures-io/unstable" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "slab" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" ];
          "write-all-vectored" = [ "io" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "async-await-macro" "channel" "futures-channel" "futures-io" "futures-macro" "futures-sink" "io" "memchr" "proc-macro-hack" "proc-macro-nested" "sink" "slab" "std" ];
      };
      "generic-array" = rec {
        crateName = "generic-array";
        version = "0.14.4";
        edition = "2015";
        sha256 = "05qqwm9v5asbil9z28wjkmpfvs1c5c99n8n9gwxis3d3r3n6c52h";
        libName = "generic_array";
        authors = [
          "Bartłomiej Kamiński <fizyk20@gmail.com>"
          "Aaron Trent <novacrazy@gmail.com>"
        ];
        dependencies = [
          {
            name = "typenum";
            packageId = "typenum";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
        ];
        features = {
        };
      };
      "getrandom" = rec {
        crateName = "getrandom";
        version = "0.2.3";
        edition = "2018";
        sha256 = "0lr7mnkvnzdh1xxmwmhhbm4gwg29k3m2rzhpjmjm4k2jcfa9kkbz";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "js" = [ "wasm-bindgen" "js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "ghash" = rec {
        crateName = "ghash";
        version = "0.3.1";
        edition = "2018";
        sha256 = "0xd362xh17hadc2194dd6kjjq0ak1j4x7kkmfmpq9hw2s564wc4p";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
          {
            name = "polyval";
            packageId = "polyval";
            features = [ "mulx" ];
          }
        ];
        features = {
          "std" = [ "polyval/std" ];
        };
      };
      "glob" = rec {
        crateName = "glob";
        version = "0.3.0";
        edition = "2015";
        sha256 = "0x25wfr7vg3mzxc9x05dcphvd3nwlcmbnxrvwcvrrdwplcrrk4cv";
        authors = [
          "The Rust Project Developers"
        ];

      };
      "hashbrown" = rec {
        crateName = "hashbrown";
        version = "0.9.1";
        edition = "2018";
        sha256 = "016dsm9s4xmxlkw2jfikm54qlz6vyk0qr280gab7kzp342jf9byp";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        features = {
          "ahash-compile-time-rng" = [ "ahash/compile-time-rng" ];
          "default" = [ "ahash" "inline-more" ];
          "rustc-dep-of-std" = [ "nightly" "core" "compiler_builtins" "alloc" "rustc-internal-api" ];
        };
        resolvedDefaultFeatures = [ "raw" ];
      };
      "hermit-abi" = rec {
        crateName = "hermit-abi";
        version = "0.1.19";
        edition = "2018";
        sha256 = "0cxcm8093nf5fyn114w8vxbrbcyvv91d4015rdnlgfll7cs6gd32";
        authors = [
          "Stefan Lankes"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins/rustc-dep-of-std" "libc/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hkdf" = rec {
        crateName = "hkdf";
        version = "0.10.0";
        edition = "2018";
        sha256 = "0kwn3scjvv2x8zc6nz3wrnzxp9shpsdxnjqiyv2r65r3kiijzasi";
        libPath = "src/hkdf.rs";
        authors = [
          "vladikoff"
          "warner"
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "digest";
            packageId = "digest";
          }
          {
            name = "hmac";
            packageId = "hmac";
          }
        ];
        features = {
        };
      };
      "hmac" = rec {
        crateName = "hmac";
        version = "0.10.1";
        edition = "2018";
        sha256 = "058yxq54x7xn0gk2vy9bl51r32c9z7qlcl2b80bjh3lk3rmiqi61";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "crypto-mac";
            packageId = "crypto-mac";
          }
          {
            name = "digest";
            packageId = "digest";
          }
        ];
        devDependencies = [
          {
            name = "crypto-mac";
            packageId = "crypto-mac";
            features = [ "dev" ];
          }
        ];
        features = {
          "std" = [ "crypto-mac/std" ];
        };
      };
      "httparse" = rec {
        crateName = "httparse";
        version = "1.4.1";
        edition = "2015";
        sha256 = "0s2y7ki3sxyf1ynp0mm2k3mgafigy23d7g0rzci3rs9pdrhppa7k";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "humantime" = rec {
        crateName = "humantime";
        version = "1.3.0";
        edition = "2015";
        sha256 = "0krwgbf35pd46xvkqg14j070vircsndabahahlv3rwhflpy4q06z";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
        ];
        dependencies = [
          {
            name = "quick-error";
            packageId = "quick-error";
          }
        ];

      };
      "hyper" = rec {
        crateName = "hyper";
        version = "0.10.16";
        edition = "2015";
        sha256 = "0wwjh9p3mzvg3fss2lqz5r7ddcgl1fh9w6my2j69d6k0lbcm41ha";
        authors = [
          "Sean McArthur <sean.monstar@gmail.com>"
          "Jonathan Reem <jonathan.reem@gmail.com>"
        ];
        dependencies = [
          {
            name = "base64";
            packageId = "base64 0.9.3";
          }
          {
            name = "httparse";
            packageId = "httparse";
          }
          {
            name = "language-tags";
            packageId = "language-tags";
          }
          {
            name = "log";
            packageId = "log 0.3.9";
          }
          {
            name = "mime";
            packageId = "mime";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "time";
            packageId = "time";
          }
          {
            name = "traitobject";
            packageId = "traitobject";
          }
          {
            name = "typeable";
            packageId = "typeable";
          }
          {
            name = "unicase";
            packageId = "unicase";
          }
          {
            name = "url";
            packageId = "url";
          }
        ];
        features = {
        };
      };
      "i2p" = rec {
        crateName = "i2p";
        version = "0.0.1";
        edition = "2015";
        sha256 = "134b0sm9qgphr84am85d41z7rcgiw4bw3rh7vm9g1yrwr777vfi3";
        authors = [
          "Jack Grigg <str4d@i2pmail.org>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log 0.3.9";
          }
          {
            name = "nom";
            packageId = "nom";
          }
          {
            name = "rand";
            packageId = "rand 0.3.23";
          }
        ];

      };
      "idna" = rec {
        crateName = "idna";
        version = "0.1.5";
        edition = "2015";
        sha256 = "0kl4gs5kaydn4v07c6ka33spm9qdh2np0x7iw7g5zd8z1c7rxw1q";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];

      };
      "indexmap" = rec {
        crateName = "indexmap";
        version = "1.6.2";
        edition = "2018";
        sha256 = "1wxfh55zlrlpdxfcvvvj6wwc46f23cnb0j9q71190yl9pyh4aj42";
        authors = [
          "bluss"
          "Josh Stone <cuviper@gmail.com>"
        ];
        dependencies = [
          {
            name = "hashbrown";
            packageId = "hashbrown";
            usesDefaultFeatures = false;
            features = [ "raw" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "serde-1" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "inotify" = rec {
        crateName = "inotify";
        version = "0.7.1";
        edition = "2015";
        sha256 = "0byhq4x4b2rlbkmfrab5dni39wiq2ls1hv1nhggp7rla5inwc5j8";
        authors = [
          "Hanno Braun <mail@hannobraun.de>"
          "Félix Saparelli <me@passcod.name>"
          "Cristian Kubis <cristian.kubis@tsunix.de>"
          "Frank Denis <github@pureftpd.org>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "inotify-sys";
            packageId = "inotify-sys";
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        features = {
          "default" = [ "stream" ];
          "stream" = [ "futures" "mio" "tokio" "tokio-io" "tokio-reactor" ];
        };
      };
      "inotify-sys" = rec {
        crateName = "inotify-sys";
        version = "0.1.5";
        edition = "2015";
        sha256 = "1syhjgvkram88my04kv03s0zwa66mdwa5v7ddja3pzwvx2sh4p70";
        authors = [
          "Hanno Braun <hb@hannobraun.de>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "iovec" = rec {
        crateName = "iovec";
        version = "0.1.4";
        edition = "2015";
        sha256 = "0ph73qygwx8i0mblrf110cj59l00gkmsgrpzz1rm85syz5pymcxj";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
        ];

      };
      "itertools" = rec {
        crateName = "itertools";
        version = "0.10.1";
        edition = "2018";
        sha256 = "1bsyxnm20x05rwc5qskrqy4cfswrcadzlwc26dkqml6hz64vipb9";
        authors = [
          "bluss"
        ];
        dependencies = [
          {
            name = "either";
            packageId = "either";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "use_std" ];
          "use_std" = [ "use_alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "use_alloc" "use_std" ];
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "0.4.7";
        edition = "2015";
        sha256 = "0di7fggbknwfjcw8cgzm1dnm3ik32l2m1f7nmyh8ipmh45h069fx";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "kernel32-sys" = rec {
        crateName = "kernel32-sys";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1389av0601a9yz8dvx5zha9vmkd6ik7ax0idpb032d28555n41vm";
        libName = "kernel32";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
        ];
        buildDependencies = [
          {
            name = "winapi-build";
            packageId = "winapi-build";
          }
        ];

      };
      "koibumi-base32" = rec {
        crateName = "koibumi-base32";
        version = "0.0.2";
        edition = "2018";
        sha256 = "1frb232m6rw50ly8ijhsbllcqfif5kcma1l6hrgm5g22c3c3il94";
        authors = [
          "Kashiko Koibumi <kashiko@tuta.io>"
        ];
        dependencies = [
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
        ];

      };
      "language-tags" = rec {
        crateName = "language-tags";
        version = "0.2.2";
        edition = "2015";
        sha256 = "16hrjdpa827carq5x4b8zhas24d8kg4s16m6nmmn1kb7cr5qh7d9";
        authors = [
          "Pyfisch <pyfisch@gmail.com>"
        ];
        features = {
          "heap_size" = [ "heapsize" "heapsize_plugin" ];
        };
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        features = {
          "spin_no_std" = [ "spin" ];
        };
      };
      "lazycell" = rec {
        crateName = "lazycell";
        version = "1.3.0";
        edition = "2015";
        sha256 = "0m8gw7dn30i0zjjpjdyf6pc16c34nl71lpv461mix50x3p70h3c3";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Nikita Pekin <contact@nikitapek.in>"
        ];
        features = {
          "nightly-testing" = [ "clippy" "nightly" ];
        };
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.97";
        edition = "2015";
        sha256 = "1dlgdziv6nkabx287jjmghnlgc5dqv6fgpvh9n7ibpr0synsvf0j";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "log 0.3.9" = rec {
        crateName = "log";
        version = "0.3.9";
        edition = "2015";
        sha256 = "0jq23hhn5h35k7pa8r7wqnsywji6x3wn1q5q7lif5q536if8v7p1";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log 0.4.14";
          }
        ];
        features = {
          "default" = [ "use_std" ];
          "max_level_debug" = [ "log/max_level_debug" ];
          "max_level_error" = [ "log/max_level_error" ];
          "max_level_info" = [ "log/max_level_info" ];
          "max_level_off" = [ "log/max_level_off" ];
          "max_level_trace" = [ "log/max_level_trace" ];
          "max_level_warn" = [ "log/max_level_warn" ];
          "release_max_level_debug" = [ "log/release_max_level_debug" ];
          "release_max_level_error" = [ "log/release_max_level_error" ];
          "release_max_level_info" = [ "log/release_max_level_info" ];
          "release_max_level_off" = [ "log/release_max_level_off" ];
          "release_max_level_trace" = [ "log/release_max_level_trace" ];
          "release_max_level_warn" = [ "log/release_max_level_warn" ];
          "use_std" = [ "log/std" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" ];
      };
      "log 0.4.14" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "matches" = rec {
        crateName = "matches";
        version = "0.1.8";
        edition = "2015";
        sha256 = "020axl4q7rk9vz90phs7f8jas4imxal9y9kxl4z4v7a6719mrz3z";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];

      };
      "maud" = rec {
        crateName = "maud";
        version = "0.22.2";
        edition = "2018";
        sha256 = "1yk2a6gy6naq615qssy57yl18r4vvx4101y1cl1zh1hcif0881ys";
        authors = [
          "Chris Wong <lambda.fairy@gmail.com>"
        ];
        dependencies = [
          {
            name = "maud_htmlescape";
            packageId = "maud_htmlescape";
          }
          {
            name = "maud_macros";
            packageId = "maud_macros";
          }
          {
            name = "rocket";
            packageId = "rocket";
            optional = true;
          }
        ];
        features = {
          "actix-web" = [ "actix-web-dep" "futures-util" ];
        };
        resolvedDefaultFeatures = [ "default" "rocket" ];
      };
      "maud_htmlescape" = rec {
        crateName = "maud_htmlescape";
        version = "0.17.0";
        edition = "2015";
        sha256 = "1dxzakhgpgbr7yy7z8vmywbi77d3yrwqdvg1s4m30hpwryy8byyh";
        libPath = "lib.rs";
        authors = [
          "Chris Wong <lambda.fairy@gmail.com>"
        ];

      };
      "maud_macros" = rec {
        crateName = "maud_macros";
        version = "0.22.2";
        edition = "2018";
        sha256 = "07jvcn3d99xbplimb3la1f6xriz9fy2jrgfqlc3i8rylmdc0383k";
        procMacro = true;
        authors = [
          "Chris Wong <lambda.fairy@gmail.com>"
        ];
        dependencies = [
          {
            name = "maud_htmlescape";
            packageId = "maud_htmlescape";
          }
          {
            name = "proc-macro-error";
            packageId = "proc-macro-error";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
          {
            name = "syn";
            packageId = "syn 1.0.73";
          }
        ];

      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.0";
        edition = "2018";
        sha256 = "1p478fqf4nia2ma0kv4npb8x1hli0zz6k16517ikb51jkryx8sxi";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "mime" = rec {
        crateName = "mime";
        version = "0.2.6";
        edition = "2015";
        sha256 = "1q1s1ax1gaz8ld3513nvhidfwnik5asbs1ma3hp6inp5dn56nqms";
        authors = [
          "Sean McArthur <sean.monstar@gmail.com>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log 0.3.9";
          }
        ];
        features = {
          "heap_size" = [ "heapsize" ];
        };
      };
      "mio" = rec {
        crateName = "mio";
        version = "0.6.23";
        edition = "2015";
        sha256 = "1i2c1vl8lr45apkh8xbh9k56ihfsmqff5l7s2fya7whvp7sndzaa";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "fuchsia-zircon";
            packageId = "fuchsia-zircon";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "fuchsia-zircon-sys";
            packageId = "fuchsia-zircon-sys";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "iovec";
            packageId = "iovec";
          }
          {
            name = "kernel32-sys";
            packageId = "kernel32-sys";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "log";
            packageId = "log 0.4.14";
          }
          {
            name = "miow";
            packageId = "miow";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "net2";
            packageId = "net2";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
            target = { target, features }: (target."windows" or false);
          }
        ];
        features = {
          "default" = [ "with-deprecated" ];
        };
        resolvedDefaultFeatures = [ "default" "with-deprecated" ];
      };
      "mio-extras" = rec {
        crateName = "mio-extras";
        version = "2.0.6";
        edition = "2018";
        sha256 = "069gfhlv0wlwfx1k2sriwfws490kjp490rv2qivyfb01j3i3yh2j";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "David Hotham"
        ];
        dependencies = [
          {
            name = "lazycell";
            packageId = "lazycell";
          }
          {
            name = "log";
            packageId = "log 0.4.14";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "slab";
            packageId = "slab";
          }
        ];

      };
      "miow" = rec {
        crateName = "miow";
        version = "0.2.2";
        edition = "2015";
        sha256 = "0kcl8rnv0bhiarcdakik670w8fnxzlxhi1ys7152sck68510in7b";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "kernel32-sys";
            packageId = "kernel32-sys";
          }
          {
            name = "net2";
            packageId = "net2";
            usesDefaultFeatures = false;
          }
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
          {
            name = "ws2_32-sys";
            packageId = "ws2_32-sys";
          }
        ];

      };
      "net2" = rec {
        crateName = "net2";
        version = "0.2.37";
        edition = "2015";
        sha256 = "1bk8jp0i12gvhrlaqbfq19ancja70r1rg3sywbhjl0385g8k05ir";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: ((target."os" == "redox") || (target."unix" or false) || (target."os" == "wasi"));
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "handleapi" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
          }
        ];
        features = {
          "default" = [ "duration" ];
        };
        resolvedDefaultFeatures = [ "default" "duration" ];
      };
      "nom" = rec {
        crateName = "nom";
        version = "2.2.1";
        edition = "2015";
        sha256 = "1zv6ig7nw532rl4p35jsahglfhyyznjkblwa6si6c0plxhlsflfg";
        authors = [
          "contact@geoffroycouprie.com"
        ];
        features = {
          "default" = [ "stream" ];
          "regexp" = [ "regex" ];
          "regexp_macros" = [ "regexp" "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "default" "stream" ];
      };
      "notify" = rec {
        crateName = "notify";
        version = "4.0.17";
        edition = "2015";
        sha256 = "0msjyj1l30l12v6q9mjc1ascx7dwyz7z07sp7v9bz9yvag4ch0xf";
        authors = [
          "Félix Saparelli <me@passcod.name>"
          "Jorge Israel Peña <jorge.israel.p@gmail.com>"
          "Michael Maurizi <michael.maurizi@gmail.com>"
          "Pierre Baillet <oct@zoy.org>"
          "Joe Wilm <joe@jwilm.com>"
          "Daniel Faust <hessijames@gmail.com>"
          "Aron Heinecke <Ox0p54r36@t-online.de>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "filetime";
            packageId = "filetime";
          }
          {
            name = "fsevent";
            packageId = "fsevent";
            target = { target, features }: (target."os" == "macos");
          }
          {
            name = "fsevent-sys";
            packageId = "fsevent-sys";
            target = { target, features }: (target."os" == "macos");
          }
          {
            name = "inotify";
            packageId = "inotify";
            usesDefaultFeatures = false;
            target = { target, features }: (target."os" == "linux");
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "mio";
            packageId = "mio";
            target = { target, features }: (target."os" == "linux");
          }
          {
            name = "mio-extras";
            packageId = "mio-extras";
            target = { target, features }: (target."os" == "linux");
          }
          {
            name = "walkdir";
            packageId = "walkdir";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "fileapi" "handleapi" "ioapiset" "minwinbase" "synchapi" "winbase" "winnt" ];
          }
        ];
        features = {
        };
      };
      "num-traits" = rec {
        crateName = "num-traits";
        version = "0.2.14";
        edition = "2015";
        sha256 = "144j176s2p76azy2ngk2vkdzgwdc0bc8c93jhki8c9fsbknb2r4s";
        authors = [
          "The Rust Project Developers"
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "num_cpus" = rec {
        crateName = "num_cpus";
        version = "1.13.0";
        edition = "2015";
        sha256 = "1cv6yxhz2zbnwn8pn1yn8grg7zsnd523947fby41a737aqvryj85";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (((target."arch" == "x86_64") || (target."arch" == "aarch64")) && (target."os" == "hermit"));
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "opaque-debug" = rec {
        crateName = "opaque-debug";
        version = "0.3.0";
        edition = "2018";
        sha256 = "1m8kzi4nd6shdqimn0mgb24f0hxslhnqd1whakyq06wcqd086jk2";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "pear" = rec {
        crateName = "pear";
        version = "0.1.4";
        edition = "2015";
        sha256 = "12mb00ick6y1slbxk6r4i8qxdbq8km3bs4pygjv94xwnvc9g482k";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "pear_codegen";
            packageId = "pear_codegen";
          }
        ];

      };
      "pear_codegen" = rec {
        crateName = "pear_codegen";
        version = "0.1.4";
        edition = "2015";
        sha256 = "1jk8jxkgjd3pymldkckg2ligkpy4nnskgcj8qf3yzlf3zlvcihdz";
        procMacro = true;
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            features = [ "nightly" ];
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
          {
            name = "syn";
            packageId = "syn 0.15.44";
            features = [ "full" "extra-traits" "visit-mut" ];
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
          {
            name = "yansi";
            packageId = "yansi";
          }
        ];

      };
      "percent-encoding 1.0.1" = rec {
        crateName = "percent-encoding";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0cgq08v1fvr6bs5fvy390cz830lq4fak8havdasdacxcw790s09i";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "percent-encoding 2.1.0" = rec {
        crateName = "percent-encoding";
        version = "2.1.0";
        edition = "2015";
        sha256 = "0bp3zrsk3kr47fbpipyczidbbx4g54lzxdm77ni1i3qws10mdzfl";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "pin-project-lite" = rec {
        crateName = "pin-project-lite";
        version = "0.2.7";
        edition = "2018";
        sha256 = "0hwl8iyx3h9i3i3jr2vqj07nf4ay1v1w1ga29cbjmdd6d4fd2ccd";
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];

      };
      "pin-utils" = rec {
        crateName = "pin-utils";
        version = "0.1.0";
        edition = "2018";
        sha256 = "117ir7vslsl2z1a7qzhws4pd01cg2d3338c47swjyvqv2n60v1wb";
        authors = [
          "Josef Brandl <mail@josefbrandl.de>"
        ];

      };
      "polyval" = rec {
        crateName = "polyval";
        version = "0.4.5";
        edition = "2018";
        sha256 = "1kdpcjhc3666g8xaqichsyf6fhn8rry3z70dqhmvv6hb2jmc9g7f";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "cpuid-bool";
            packageId = "cpuid-bool";
            target = { target, features }: ((target."arch" == "x86_64") || (target."arch" == "x86"));
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
          {
            name = "universal-hash";
            packageId = "universal-hash";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "std" = [ "universal-hash/std" ];
        };
        resolvedDefaultFeatures = [ "mulx" ];
      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.10";
        edition = "2018";
        sha256 = "0ms8198kclg4h96ggbziixxmsdl847s648kmbx11zlmjsqjccx5c";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "pretty_env_logger" = rec {
        crateName = "pretty_env_logger";
        version = "0.4.0";
        edition = "2015";
        sha256 = "17gva1rlf9fhgr0jr19kv39f8bir3f4pa4jz02qbhl9qanwkcvcj";
        authors = [
          "Sean McArthur <sean@seanmonstar>"
        ];
        dependencies = [
          {
            name = "env_logger";
            packageId = "env_logger";
          }
          {
            name = "log";
            packageId = "log 0.4.14";
          }
        ];

      };
      "proc-macro-error" = rec {
        crateName = "proc-macro-error";
        version = "1.0.4";
        edition = "2018";
        sha256 = "1373bhxaf0pagd8zkyd03kkx6bchzf6g0dkwrwzsnal9z47lj9fs";
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro-error-attr";
            packageId = "proc-macro-error-attr";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
          {
            name = "syn";
            packageId = "syn 1.0.73";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
        ];
        features = {
          "default" = [ "syn-error" ];
          "syn-error" = [ "syn" ];
        };
        resolvedDefaultFeatures = [ "default" "syn" "syn-error" ];
      };
      "proc-macro-error-attr" = rec {
        crateName = "proc-macro-error-attr";
        version = "1.0.4";
        edition = "2018";
        sha256 = "0sgq6m5jfmasmwwy8x4mjygx5l7kp8s4j60bv25ckv2j1qc41gm1";
        procMacro = true;
        authors = [
          "CreepySkeleton <creepy-skeleton@yandex.ru>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
        ];

      };
      "proc-macro-hack" = rec {
        crateName = "proc-macro-hack";
        version = "0.5.19";
        edition = "2018";
        sha256 = "1rg0kzsj7lj00qj602d3h77spwfz48vixn1wbjp7a4yrq65w9w6v";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "proc-macro-nested" = rec {
        crateName = "proc-macro-nested";
        version = "0.1.7";
        edition = "2015";
        sha256 = "11hh1jynh62f3m1ii0f9gf1l3y0fhkwpmr40lz3704v848n1p25w";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "proc-macro2 0.4.30" = rec {
        crateName = "proc-macro2";
        version = "0.4.30";
        edition = "2015";
        sha256 = "0nd71fl24sys066jrha6j7i34nfkjv44yzw8yww9742wmc8j0gfg";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.1.0";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "nightly" "proc-macro" ];
      };
      "proc-macro2 1.0.27" = rec {
        crateName = "proc-macro2";
        version = "1.0.27";
        edition = "2018";
        sha256 = "0f3h0zl5w5090ajmmvpmhkpr4iwqnn5rip3afacabhc657vwmn7h";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.2.2";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quick-error" = rec {
        crateName = "quick-error";
        version = "1.2.3";
        edition = "2015";
        sha256 = "1q6za3v78hsspisc197bg3g7rpc989qycy8ypr8ap8igv10ikl51";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
          "Colin Kiegel <kiegel@gmx.de>"
        ];

      };
      "quote 0.6.13" = rec {
        crateName = "quote";
        version = "0.6.13";
        edition = "2015";
        sha256 = "1qgqq48jymp5h4y082aanf25hrw6bpb678xh3zw993qfhxmkpqkc";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quote 1.0.9" = rec {
        crateName = "quote";
        version = "1.0.9";
        edition = "2018";
        sha256 = "19rjmfqzk26rxbgxy5j2ckqc2v12sw2xw8l4gi8bzpn2bmsbkl63";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand 0.3.23" = rec {
        crateName = "rand";
        version = "0.3.23";
        edition = "2015";
        sha256 = "0v679h38pjjqj5h4md7v2slsvj6686qgcn7p9fbw3h43iwnk1b34";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "rand";
            packageId = "rand 0.4.6";
          }
        ];
        features = {
          "nightly" = [ "i128_support" ];
        };
      };
      "rand 0.4.6" = rec {
        crateName = "rand";
        version = "0.4.6";
        edition = "2015";
        sha256 = "14qjfv3gggzhnma20k0sc1jf8y6pplsaq7n1j9ls5c8kf2wl0a2m";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "fuchsia-cprng";
            packageId = "fuchsia-cprng";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "rdrand";
            packageId = "rdrand";
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "minwindef" "ntsecapi" "profileapi" "winnt" ];
          }
        ];
        features = {
          "default" = [ "std" ];
          "nightly" = [ "i128_support" ];
          "std" = [ "libc" ];
        };
        resolvedDefaultFeatures = [ "default" "libc" "std" ];
      };
      "rand 0.8.4" = rec {
        crateName = "rand";
        version = "0.8.4";
        edition = "2018";
        sha256 = "1n5wska2fbfj4dsfz8mc0pd0dgjlrb6c9anpk5mwym345rip6x9f";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (!(target."os" == "emscripten"));
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc";
            optional = true;
            target = { target, features }: (target."os" == "emscripten");
          }
        ];
        devDependencies = [
          {
            name = "rand_hc";
            packageId = "rand_hc";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" "std_rng" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "serde1" = [ "serde" "rand_core/serde1" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "std_rng" = [ "rand_chacha" "rand_hc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "libc" "rand_chacha" "rand_hc" "std" "std_rng" ];
      };
      "rand_chacha" = rec {
        crateName = "rand_chacha";
        version = "0.3.1";
        edition = "2018";
        sha256 = "123x2adin558xbhvqb8w4f6syjsdkmqff8cxwhmjacpsl1ihmhg6";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
        ];
        features = {
          "default" = [ "std" ];
          "serde1" = [ "serde" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core 0.3.1" = rec {
        crateName = "rand_core";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0jzdgszfa4bliigiy4hi66k7fs3gfwi2qxn8vik84ph77fwdwvvs";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "serde1" = [ "rand_core/serde1" ];
          "std" = [ "rand_core/std" ];
        };
      };
      "rand_core 0.4.2" = rec {
        crateName = "rand_core";
        version = "0.4.2";
        edition = "2015";
        sha256 = "1p09ynysrq1vcdlmcqnapq4qakl2yd1ng3kxh3qscpx09k2a6cww";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
          "std" = [ "alloc" ];
        };
      };
      "rand_core 0.6.3" = rec {
        crateName = "rand_core";
        version = "0.6.3";
        edition = "2018";
        sha256 = "1rxlxc3bpzgwphcg9c9yasvv9idipcg2z2y4j0vlb52jyl418kyk";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
          }
        ];
        features = {
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "rand_hc" = rec {
        crateName = "rand_hc";
        version = "0.3.1";
        edition = "2018";
        sha256 = "1rwpykyvhkxs4jvqdja3mzp9dqaqamzn113cxaigs9z2dmcry7nm";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.6.3";
          }
        ];

      };
      "rdrand" = rec {
        crateName = "rdrand";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1cjq0kwx1bk7jx3kzyciiish5gqsj7620dm43dc52sr8fzmm9037";
        authors = [
          "Simonas Kazlauskas <rdrand@kazlauskas.me>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "redox_syscall" = rec {
        crateName = "redox_syscall";
        version = "0.2.9";
        edition = "2018";
        sha256 = "1vpyfnfrw5ki262720yks8m7vn1a2mg89s4rqi5ir7izvyx9md2s";
        libName = "syscall";
        authors = [
          "Jeremy Soller <jackpot51@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
        ];

      };
      "regex" = rec {
        crateName = "regex";
        version = "1.5.4";
        edition = "2018";
        sha256 = "0qf479kjbmb582h4d1d6gfl75h0j8aq2nrdi5wg6zdcy6llqcynh";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-inline" "perf-literal" ];
          "perf-literal" = [ "aho-corasick" "memchr" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "aho-corasick" "default" "memchr" "perf" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "std" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.6.25";
        edition = "2018";
        sha256 = "16y87hz1bxmmz6kk360cxwfm3jnbsxb3x4zw9x1gzz7khic2i5zl";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
        resolvedDefaultFeatures = [ "default" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "rmp" = rec {
        crateName = "rmp";
        version = "0.8.10";
        edition = "2018";
        sha256 = "1mksma1b18yps1s64qx2f4bhg4z19wmfvbjx3zfxbi262kxfamag";
        authors = [
          "Evgeny Safronov <division494@gmail.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "num-traits";
            packageId = "num-traits";
          }
        ];

      };
      "rmp-serde" = rec {
        crateName = "rmp-serde";
        version = "0.15.5";
        edition = "2018";
        sha256 = "178f4qlicldm9iy74q4wdqldk5i11p1ad30wzs9avx04mpwwygkj";
        authors = [
          "Evgeny Safronov <division494@gmail.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "rmp";
            packageId = "rmp";
          }
          {
            name = "serde";
            packageId = "serde";
          }
        ];
        features = {
        };
      };
      "rmpv" = rec {
        crateName = "rmpv";
        version = "0.4.7";
        edition = "2018";
        sha256 = "1mczy1ffpnwnimsk277zxbqc69l3h9mmnj1n3q91cplm27z0lxkw";
        authors = [
          "Evgeny Safronov <division494@gmail.com>"
        ];
        dependencies = [
          {
            name = "num-traits";
            packageId = "num-traits";
          }
          {
            name = "rmp";
            packageId = "rmp";
          }
        ];
        features = {
          "with-serde" = [ "serde" "serde_bytes" ];
        };
      };
      "rocket" = rec {
        crateName = "rocket";
        version = "0.4.10";
        edition = "2015";
        sha256 = "0a5zj3fyh5b7v0s5n569ld2hqc0vddwkf7rqpv98pfvmvkgv2yja";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "atty";
            packageId = "atty";
          }
          {
            name = "base64";
            packageId = "base64 0.13.0";
          }
          {
            name = "log";
            packageId = "log 0.4.14";
          }
          {
            name = "memchr";
            packageId = "memchr";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "pear";
            packageId = "pear";
          }
          {
            name = "rocket_codegen";
            packageId = "rocket_codegen";
          }
          {
            name = "rocket_http";
            packageId = "rocket_http";
          }
          {
            name = "state";
            packageId = "state";
          }
          {
            name = "time";
            packageId = "time";
          }
          {
            name = "toml";
            packageId = "toml";
          }
          {
            name = "yansi";
            packageId = "yansi";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
          {
            name = "yansi";
            packageId = "yansi";
          }
        ];
        features = {
          "default" = [ "private-cookies" ];
          "private-cookies" = [ "rocket_http/private-cookies" ];
          "tls" = [ "rocket_http/tls" ];
        };
        resolvedDefaultFeatures = [ "default" "private-cookies" ];
      };
      "rocket_codegen" = rec {
        crateName = "rocket_codegen";
        version = "0.4.10";
        edition = "2015";
        sha256 = "17ygvdr8phk1raacw81dqbxg9zpp92wlza2d2x6l7kyjss3yca8p";
        procMacro = true;
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "devise";
            packageId = "devise";
          }
          {
            name = "glob";
            packageId = "glob";
          }
          {
            name = "indexmap";
            packageId = "indexmap";
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
          {
            name = "rocket_http";
            packageId = "rocket_http";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.9.3";
          }
          {
            name = "yansi";
            packageId = "yansi";
          }
        ];

      };
      "rocket_contrib" = rec {
        crateName = "rocket_contrib";
        version = "0.4.10";
        edition = "2015";
        sha256 = "16vdzwdn3rivj4zpq0jbc4cipplcinfrnv62g9ncwvdlrbf06qvb";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log 0.4.14";
          }
          {
            name = "notify";
            packageId = "notify";
          }
          {
            name = "rocket";
            packageId = "rocket";
            usesDefaultFeatures = false;
          }
          {
            name = "serde";
            packageId = "serde";
            optional = true;
          }
          {
            name = "serde_json";
            packageId = "serde_json";
            optional = true;
          }
        ];
        features = {
          "cypher_pool" = [ "databases" "rusted_cypher" "r2d2_cypher" ];
          "databases" = [ "r2d2" "rocket_contrib_codegen/database_attribute" ];
          "default" = [ "json" "serve" ];
          "diesel_mysql_pool" = [ "databases" "diesel/mysql" "diesel/r2d2" ];
          "diesel_postgres_pool" = [ "databases" "diesel/postgres" "diesel/r2d2" ];
          "diesel_sqlite_pool" = [ "databases" "diesel/sqlite" "diesel/r2d2" ];
          "handlebars_templates" = [ "handlebars" "templates" ];
          "helmet" = [ "time" ];
          "json" = [ "serde" "serde_json" ];
          "memcache_pool" = [ "databases" "memcache" "r2d2-memcache" ];
          "mongodb_pool" = [ "databases" "mongodb" "r2d2-mongodb" ];
          "msgpack" = [ "serde" "rmp-serde" ];
          "mysql_pool" = [ "databases" "mysql" "r2d2_mysql" ];
          "postgres_pool" = [ "databases" "postgres" "r2d2_postgres" ];
          "redis_pool" = [ "databases" "redis" "r2d2_redis" ];
          "sqlite_pool" = [ "databases" "rusqlite" "r2d2_sqlite" ];
          "templates" = [ "serde" "serde_json" "glob" ];
          "tera_templates" = [ "tera" "templates" ];
        };
        resolvedDefaultFeatures = [ "default" "json" "serde" "serde_json" "serve" ];
      };
      "rocket_http" = rec {
        crateName = "rocket_http";
        version = "0.4.10";
        edition = "2015";
        sha256 = "05q1xzv8177wg5ar2lvanlp1qibib6lmvzwllks1g64asgkfccb1";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        dependencies = [
          {
            name = "cookie";
            packageId = "cookie";
            features = [ "percent-encode" ];
          }
          {
            name = "hyper";
            packageId = "hyper";
            usesDefaultFeatures = false;
          }
          {
            name = "indexmap";
            packageId = "indexmap";
            features = [ "std" ];
          }
          {
            name = "pear";
            packageId = "pear";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 1.0.1";
          }
          {
            name = "smallvec";
            packageId = "smallvec";
          }
          {
            name = "state";
            packageId = "state";
          }
          {
            name = "time";
            packageId = "time";
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.1.0";
          }
        ];
        features = {
          "private-cookies" = [ "cookie/secure" ];
          "tls" = [ "rustls" "hyper-sync-rustls" ];
        };
        resolvedDefaultFeatures = [ "default" "private-cookies" ];
      };
      "ryu" = rec {
        crateName = "ryu";
        version = "1.0.5";
        edition = "2018";
        sha256 = "0vpqv1dj7fksa6hm3zpk5rbsjs0ifbfy7xwzsyyil0rx37a03lvi";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
        };
      };
      "safemem" = rec {
        crateName = "safemem";
        version = "0.3.3";
        edition = "2015";
        sha256 = "0wp0d2b2284lw11xhybhaszsczpbq1jbdklkxgifldcknmy3nw7g";
        authors = [
          "Austin Bonander <austin.bonander@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "same-file" = rec {
        crateName = "same-file";
        version = "1.0.6";
        edition = "2018";
        sha256 = "00h5j1w87dmhnvbv9l8bic3y7xxsnjmssvifw2ayvgx9mb1ivz4k";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "serde" = rec {
        crateName = "serde";
        version = "1.0.126";
        edition = "2015";
        sha256 = "00vdk7y3j8h2xv28a2i2ad1d19g5iwrdknbq8yp79v6axamhaxgc";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
        ];
        features = {
          "default" = [ "std" ];
          "derive" = [ "serde_derive" ];
        };
        resolvedDefaultFeatures = [ "default" "derive" "serde_derive" "std" ];
      };
      "serde_bytes" = rec {
        crateName = "serde_bytes";
        version = "0.11.5";
        edition = "2018";
        sha256 = "1fcb6sw8wkrj4ylm118wkb31hw124nkjnqyhbgqnd8w85zfhgbhn";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "serde";
            packageId = "serde";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "serde/alloc" ];
          "default" = [ "std" ];
          "std" = [ "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "serde_derive" = rec {
        crateName = "serde_derive";
        version = "1.0.126";
        edition = "2015";
        sha256 = "0hsdh39qj0g187nwndfzg67q4qajbm5g6x0fr5xarblmk2y7sfln";
        procMacro = true;
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
          {
            name = "syn";
            packageId = "syn 1.0.73";
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "serde_json" = rec {
        crateName = "serde_json";
        version = "1.0.64";
        edition = "2018";
        sha256 = "0y9gk3yikncrc0zajmwc0pidr7zfwafawb4gidf6mqyskzf9g7kr";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "itoa";
            packageId = "itoa";
            usesDefaultFeatures = false;
          }
          {
            name = "ryu";
            packageId = "ryu";
          }
          {
            name = "serde";
            packageId = "serde";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "serde/alloc" ];
          "default" = [ "std" ];
          "preserve_order" = [ "indexmap" ];
          "std" = [ "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "sha2" = rec {
        crateName = "sha2";
        version = "0.9.5";
        edition = "2018";
        sha256 = "04lzf4swq6cijvxnc6facr3g72h5v7a5z8lz3xrkf8gxa9bswqmk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-buffer";
            packageId = "block-buffer";
          }
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "cpufeatures";
            packageId = "cpufeatures";
            target = { target, features }: (stdenv.hostPlatform.config == "aarch64-apple-darwin");
          }
          {
            name = "cpufeatures";
            packageId = "cpufeatures";
            target = { target, features }: ((target."arch" == "aarch64") && (target."os" == "linux"));
          }
          {
            name = "cpufeatures";
            packageId = "cpufeatures";
            target = { target, features }: ((target."arch" == "x86") || (target."arch" == "x86_64"));
          }
          {
            name = "digest";
            packageId = "digest";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "asm" = [ "sha2-asm" ];
          "asm-aarch64" = [ "asm" ];
          "default" = [ "std" ];
          "std" = [ "digest/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "slab" = rec {
        crateName = "slab";
        version = "0.4.3";
        edition = "2015";
        sha256 = "09v57dmy9gnfcj3c6gywp7wi09zywxf0ppj07w02hfvy38ysqwzi";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "smallvec" = rec {
        crateName = "smallvec";
        version = "1.6.1";
        edition = "2018";
        sha256 = "0kk08axr0ybfbjzk65a41k84mb6sfhyajmfndaka9igkx34kf3zy";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
        };
      };
      "state" = rec {
        crateName = "state";
        version = "0.4.2";
        edition = "2015";
        sha256 = "10v4k9bgjryc9m40c8nnhyrby2ngkhpx841p3k4halgxlp8af59h";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];
        features = {
          "tls" = [ "lazy_static" ];
        };
      };
      "strsim" = rec {
        crateName = "strsim";
        version = "0.8.0";
        edition = "2015";
        sha256 = "0sjsm7hrvjdifz661pjxq5w4hf190hx53fra8dfvamacvff139cf";
        authors = [
          "Danny Guo <dannyguo91@gmail.com>"
        ];

      };
      "subtle" = rec {
        crateName = "subtle";
        version = "2.4.0";
        edition = "2015";
        sha256 = "1hipji54nipkya6szyk9kl7nz07qli570b1isklz78dda44dm08y";
        authors = [
          "Isis Lovecruft <isis@patternsinthevoid.net>"
          "Henry de Valence <hdevalence@hdevalence.ca>"
        ];
        features = {
          "default" = [ "std" "i128" ];
        };
      };
      "syn 0.15.44" = rec {
        crateName = "syn";
        version = "0.15.44";
        edition = "2015";
        sha256 = "1id5g6x6zihv3j7hwrw3m1jp636bg8dpi671r7zy3jvpkavb794w";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.1.0";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "extra-traits" "full" "parsing" "printing" "proc-macro" "quote" "visit-mut" ];
      };
      "syn 1.0.73" = rec {
        crateName = "syn";
        version = "1.0.73";
        edition = "2018";
        sha256 = "1ixw4lscc7009ibaic8g5bvnc94hdcr62ksjk3jjl38363zqj57p";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.2.2";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "full" "parsing" "printing" "proc-macro" "quote" ];
      };
      "termcolor" = rec {
        crateName = "termcolor";
        version = "1.1.2";
        edition = "2018";
        sha256 = "1x65i1ny4m6z1by62ra6wdcrd557p2ysm866x0pg60zby2cxizid";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "textwrap" = rec {
        crateName = "textwrap";
        version = "0.11.0";
        edition = "2015";
        sha256 = "0q5hky03ik3y50s9sz25r438bc4nwhqc6dqwynv4wylc807n29nk";
        authors = [
          "Martin Geisler <martin@geisler.net>"
        ];
        dependencies = [
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
        ];

      };
      "thiserror" = rec {
        crateName = "thiserror";
        version = "1.0.25";
        edition = "2018";
        sha256 = "1ip9j8riar3xffp261yls4phpasz768xhnafxdz4qlargx2pcvzs";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "thiserror-impl";
            packageId = "thiserror-impl";
          }
        ];

      };
      "thiserror-impl" = rec {
        crateName = "thiserror-impl";
        version = "1.0.25";
        edition = "2018";
        sha256 = "139i3bxidyncjd1sphkn4c577nkba8lzmphhr9gb26xz1y67cdla";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.27";
          }
          {
            name = "quote";
            packageId = "quote 1.0.9";
          }
          {
            name = "syn";
            packageId = "syn 1.0.73";
          }
        ];

      };
      "time" = rec {
        crateName = "time";
        version = "0.1.43";
        edition = "2015";
        sha256 = "0f14wrgxj7ya2v4msg5mni7046bsm2angm7cn3pd3yv04gpm12na";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "minwinbase" "minwindef" "ntdef" "profileapi" "sysinfoapi" "timezoneapi" ];
          }
        ];
        devDependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            features = [ "std" "processthreadsapi" "winbase" ];
          }
        ];

      };
      "tinyvec" = rec {
        crateName = "tinyvec";
        version = "1.2.0";
        edition = "2018";
        sha256 = "0hn3fkpb9nca9nf9znz2dxlp4ccv37hnbh67aczpzpmpbgq20ljv";
        authors = [
          "Lokathor <zefria@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec_macros";
            packageId = "tinyvec_macros";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "tinyvec_macros" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "tinyvec_macros" ];
      };
      "tinyvec_macros" = rec {
        crateName = "tinyvec_macros";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0p5zvgbas5nh403fbxica819mf3g83n8g2hzpfazfr56w6klv9yd";
        authors = [
          "Soveu <marx.tomasz@gmail.com>"
        ];

      };
      "tokio" = rec {
        crateName = "tokio";
        version = "1.7.1";
        edition = "2018";
        sha256 = "18jw744lajnn82xbharaq522llw6py1zwm6wlpvikfwk881fvcjz";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "full" = [ "fs" "io-util" "io-std" "macros" "net" "parking_lot" "process" "rt" "rt-multi-thread" "signal" "sync" "time" ];
          "io-util" = [ "memchr" "bytes" ];
          "macros" = [ "tokio-macros" ];
          "net" = [ "libc" "mio/os-poll" "mio/os-util" "mio/tcp" "mio/udp" "mio/uds" "winapi/namedpipeapi" ];
          "process" = [ "bytes" "once_cell" "libc" "mio/os-poll" "mio/os-util" "mio/uds" "signal-hook-registry" "winapi/threadpoollegacyapiset" ];
          "rt-multi-thread" = [ "num_cpus" "rt" ];
          "signal" = [ "once_cell" "libc" "mio/os-poll" "mio/uds" "mio/os-util" "signal-hook-registry" "winapi/consoleapi" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "toml" = rec {
        crateName = "toml";
        version = "0.4.10";
        edition = "2015";
        sha256 = "07qilkzinn8z13vq2sss65n2lza7wrmqpvkbclw919m3f7y691km";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "serde";
            packageId = "serde";
          }
        ];

      };
      "tor" = rec {
        crateName = "tor";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0vvd00scyf7i34qifbmrcjahd909srr3j1pqkljld65nn3p1p1ki";
        authors = [
          "Sahithyen Kanaganayagam <mail@sahithyen.com>"
        ];

      };
      "traitobject" = rec {
        crateName = "traitobject";
        version = "0.1.0";
        edition = "2015";
        sha256 = "0yb0n8822mr59j200fyr2fxgzzgqljyxflx9y8bdy3rlaqngilgg";
        authors = [
          "Jonathan Reem <jonathan.reem@gmail.com>"
        ];

      };
      "typeable" = rec {
        crateName = "typeable";
        version = "0.1.2";
        edition = "2015";
        sha256 = "11w8dywgnm32hb291izjvh4zjd037ccnkk77ahk63l913zwzc40l";
        authors = [
          "Jonathan Reem <jonathan.reem@gmail.com>"
        ];

      };
      "typenum" = rec {
        crateName = "typenum";
        version = "1.13.0";
        edition = "2018";
        sha256 = "01lbbspn4080yg8wp6y7q3xcqih1c1dmkkx4pwax4z1a9436k7w7";
        build = "build/main.rs";
        authors = [
          "Paho Lurie-Gregg <paho@paholg.com>"
          "Andre Bogus <bogusandre@gmail.com>"
        ];
        features = {
        };
      };
      "unicase" = rec {
        crateName = "unicase";
        version = "1.4.2";
        edition = "2015";
        sha256 = "0cwazh4qsmm9msckjk86zc1z35xg7hjxjykrgjalzdv367w6aivz";
        authors = [
          "Sean McArthur <sean.monstar@gmail.com>"
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check 0.1.5";
          }
        ];
        features = {
          "heap_size" = [ "heapsize" "heapsize_plugin" ];
        };
      };
      "unicode-bidi" = rec {
        crateName = "unicode-bidi";
        version = "0.3.5";
        edition = "2018";
        sha256 = "1q07h5kp9jszwf0bkrpa1v5wmv04dv920x3w2xy6pjdikchbxf7f";
        libName = "unicode_bidi";
        authors = [
          "The Servo Project Developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
        ];
        features = {
          "flame_it" = [ "flame" "flamer" ];
          "with_serde" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-normalization" = rec {
        crateName = "unicode-normalization";
        version = "0.1.19";
        edition = "2018";
        sha256 = "1yabhmg8zlcksda3ajly9hpbzqgbhknxwch8dwkfkaa1569r0ifm";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec";
            packageId = "tinyvec";
            features = [ "alloc" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-width" = rec {
        crateName = "unicode-width";
        version = "0.1.8";
        edition = "2015";
        sha256 = "1qxizyi6xbcqyi4z79p523ywvmgsfcgfqb3zv3c8i6x1jcc5jdwk";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "std" "core" "compiler_builtins" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-xid 0.1.0" = rec {
        crateName = "unicode-xid";
        version = "0.1.0";
        edition = "2015";
        sha256 = "1z57lqh4s18rr4x0j4fw4fmp9hf9346h0kmdgqsqx0fhjr3k0wpw";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-xid 0.2.2" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "universal-hash" = rec {
        crateName = "universal-hash";
        version = "0.4.0";
        edition = "2018";
        sha256 = "00hljq64l0p68yrncvyww4cdgkzpzl49vrlnj57kwblkak3b49l3";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
        };
      };
      "url" = rec {
        crateName = "url";
        version = "1.7.2";
        edition = "2015";
        sha256 = "0nim1c90mxpi9wgdw2xh8dqd72vlklwlzam436akcrhjac6pqknx";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "idna";
            packageId = "idna";
          }
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 1.0.1";
          }
        ];
        features = {
          "heap_size" = [ "heapsize" ];
          "query_encoding" = [ "encoding" ];
        };
      };
      "vec_map" = rec {
        crateName = "vec_map";
        version = "0.8.2";
        edition = "2015";
        sha256 = "1481w9g1dw9rxp3l6snkdqihzyrd2f8vispzqmwjwsdyhw8xzggi";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Jorge Aparicio <japaricious@gmail.com>"
          "Alexis Beingessner <a.beingessner@gmail.com>"
          "Brian Anderson <>"
          "tbu- <>"
          "Manish Goregaokar <>"
          "Aaron Turon <aturon@mozilla.com>"
          "Adolfo Ochagavía <>"
          "Niko Matsakis <>"
          "Steven Fackler <>"
          "Chase Southwood <csouth3@illinois.edu>"
          "Eduard Burtescu <>"
          "Florian Wilkens <>"
          "Félix Raimundo <>"
          "Tibor Benke <>"
          "Markus Siemens <markus@m-siemens.de>"
          "Josh Branchaud <jbranchaud@gmail.com>"
          "Huon Wilson <dbau.pp@gmail.com>"
          "Corey Farwell <coref@rwell.org>"
          "Aaron Liblong <>"
          "Nick Cameron <nrc@ncameron.org>"
          "Patrick Walton <pcwalton@mimiga.net>"
          "Felix S Klock II <>"
          "Andrew Paseltiner <apaseltiner@gmail.com>"
          "Sean McArthur <sean.monstar@gmail.com>"
          "Vadim Petrochenkov <>"
        ];
        features = {
          "eders" = [ "serde" ];
        };
      };
      "version_check 0.1.5" = rec {
        crateName = "version_check";
        version = "0.1.5";
        edition = "2015";
        sha256 = "1pf91pvj8n6akh7w6j5ypka6aqz08b3qpzgs0ak2kjf4frkiljwi";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "version_check 0.9.3" = rec {
        crateName = "version_check";
        version = "0.9.3";
        edition = "2015";
        sha256 = "1zmkcgj2m0pq0l4wnhrp1wl1lygf7x2h5p7pvjwc4719lnlxrv2z";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "walkdir" = rec {
        crateName = "walkdir";
        version = "2.3.2";
        edition = "2018";
        sha256 = "0mnszy33685v8y9js8mw6x2p3iddqs8vfj7n2dhqddnlbirz5340";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "same-file";
            packageId = "same-file";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "winnt" ];
          }
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "wasi" = rec {
        crateName = "wasi";
        version = "0.10.2+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "1ii7nff4y1mpcrxzzvbpgxm7a1nn3szjf1n21jnx37c2g6dbsvzx";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "winapi 0.2.8" = rec {
        crateName = "winapi";
        version = "0.2.8";
        edition = "2015";
        sha256 = "0yh816lh6lf56dpsgxy189c2ai1z3j8mw9si6izqb6wsjkbcjz8n";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi 0.3.9" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "consoleapi" "errhandlingapi" "fileapi" "handleapi" "ioapiset" "minwinbase" "minwindef" "ntdef" "ntsecapi" "processenv" "profileapi" "std" "synchapi" "sysinfoapi" "timezoneapi" "winbase" "wincon" "winerror" "winnt" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
      };
      "winapi-build" = rec {
        crateName = "winapi-build";
        version = "0.1.1";
        edition = "2015";
        sha256 = "1g4rqsgjky0a7530qajn2bbfcrl2v0zb39idgdws9b1l7gp5wc9d";
        libName = "build";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0y71bp7f6d536czj40dhqk0d55wfbbwqfp2ymqf1an5ibgl6rv3h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "consoleapi" "errhandlingapi" "fileapi" "minwindef" "processenv" "winbase" "wincon" "winerror" "winnt" ];
          }
        ];

      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "ws2_32-sys" = rec {
        crateName = "ws2_32-sys";
        version = "0.2.1";
        edition = "2015";
        sha256 = "0ppscg5qfqaw0gzwv2a4nhn5bn01ff9iwn6ysqnzm4n8s3myz76m";
        libName = "ws2_32";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
        ];
        buildDependencies = [
          {
            name = "winapi-build";
            packageId = "winapi-build";
          }
        ];

      };
      "yansi" = rec {
        crateName = "yansi";
        version = "0.5.0";
        edition = "2015";
        sha256 = "0wdx8syhc61lphmgw5cw1vq73isi4szjqriz1k07z19r3r59ziwz";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "zeronet_protocol" = rec {
        crateName = "zeronet_protocol";
        version = "0.1.7";
        edition = "2018";
        sha256 = "0kzbj70axxqv6x255jn9fil09q92gw9v390kc7q3hqv551mcrbv0";
        authors = [
          "Ansho Rei <anshorei@protonmail.com>"
        ];
        dependencies = [
          {
            name = "base64";
            packageId = "base64 0.13.0";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "i2p";
            packageId = "i2p";
            optional = true;
          }
          {
            name = "itertools";
            packageId = "itertools";
          }
          {
            name = "koibumi-base32";
            packageId = "koibumi-base32";
          }
          {
            name = "rmp";
            packageId = "rmp";
          }
          {
            name = "rmp-serde";
            packageId = "rmp-serde";
          }
          {
            name = "rmpv";
            packageId = "rmpv";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
          {
            name = "serde_bytes";
            packageId = "serde_bytes";
          }
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "thiserror";
            packageId = "thiserror";
          }
          {
            name = "tokio";
            packageId = "tokio";
          }
          {
            name = "tor";
            packageId = "tor";
            optional = true;
          }
        ];

        resolvedDefaultFeatures = [ "i2p" "tor" ];
      };
      "zeronet_tracker" = rec {
        crateName = "zeronet_tracker";
        version = "0.1.10";
        edition = "2018";
        crateBin = [
          { name = "zeronet_tracker"; path = "src/main.rs"; }
        ];
        src = lib.cleanSourceWith { filter = sourceFilter;  src = ./.; };
        authors = [
          "Ansho Rei <anshorei@protonmail.com>"
        ];
        dependencies = [
          {
            name = "base64";
            packageId = "base64 0.13.0";
          }
          {
            name = "clap";
            packageId = "clap";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log 0.4.14";
          }
          {
            name = "maud";
            packageId = "maud";
            optional = true;
            features = [ "rocket" ];
          }
          {
            name = "pretty_env_logger";
            packageId = "pretty_env_logger";
          }
          {
            name = "rocket";
            packageId = "rocket";
            optional = true;
          }
          {
            name = "rocket_contrib";
            packageId = "rocket_contrib";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_bytes";
            packageId = "serde_bytes";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "zeronet_protocol";
            packageId = "zeronet_protocol";
          }
        ];
        features = {
          "i2p" = [ "zeronet_protocol/i2p" ];
          "server" = [ "maud" "rocket" ];
          "tor" = [ "zeronet_protocol/tor" ];
        };
        resolvedDefaultFeatures = [ "i2p" "maud" "rocket" "server" "tor" ];
      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
     This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
     of crate given as the second argument.

     testCrateFlags: list of flags to pass to the test exectuable
     testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs, testPreRun, testPostRun }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    assert builtins.typeOf testPreRun == "string";
    assert builtins.typeOf testPostRun == "string";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
          # If the user hasn't set any pre/post commands, we don't want to
          # insert empty lines. This means that any existing users of crate2nix
          # don't get a spurious rebuild unless they set these explicitly.
          testCommand = pkgs.lib.concatStringsSep "\n"
            (pkgs.lib.filter (s: s != "") [
              testPreRun
              "$f $testCrateFlags 2>&1 | tee -a $out"
              testPostRun
            ]);
        in
        pkgs.runCommand "run-tests-${testCrate.name}"
          {
            inherit testCrateFlags;
            buildInputs = testInputs;
          } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            ${testCommand}
          done
        '';
    in
    pkgs.runCommand "${crate.name}-linked"
      {
        inherit (crate) outputs crateName;
        passthru = (crate.passthru or { }) // {
          inherit test;
        };
      } ''
      echo tested by ${test}
      ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
    '';

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateForPkgsFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
      # Any command to run immediatelly before a test is executed.
    , testPreRun ? ""
      # Any command run immediatelly after a test is executed.
    , testPostRun ? ""
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        , testPreRun
        , testPostRun
        }:
        let
          buildRustCrateForPkgsFuncOverriden =
            if buildRustCrateForPkgsFunc != null
            then buildRustCrateForPkgsFunc
            else
              (
                if crateOverrides == pkgs.defaultCrateOverrides
                then buildRustCrateForPkgs
                else
                  pkgs: (buildRustCrateForPkgs pkgs).override {
                    defaultCrateOverrides = crateOverrides;
                  }
              );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.crates.${packageId};
          testDrv = builtTestRustCrates.crates.${packageId};
          derivation =
            if runTests then
              crateWithTest
                {
                  crate = drv;
                  testCrate = testDrv;
                  inherit testCrateFlags testInputs testPreRun testPostRun;
                }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs testPreRun testPostRun; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
     for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateForPkgsFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
        mkBuiltByPackageIdByPkgs = pkgs:
          let
            self = {
              crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
              build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
            };
          in
          self;
        buildByPackageIdForPkgsImpl = self: pkgs: packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  # proc_macro crates must be compiled for the build architecture
                  if crateConfigs.${depPackageId}.procMacro or false
                  then self.build.crates.${depPackageId}
                  else self.crates.${depPackageId};
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  self.build.crates.${depPackageId};
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = crateConfigs."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateForPkgsFunc pkgs
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageIdByPkgs;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { buildByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: buildByPackageId dependency.packageId;
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
     be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateForPkgsFunc = _: lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateForPkgsFunc = _: crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
     features.

     This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

     If multiple paths to a dependency enable different features, the
     corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        enabledFeatures = enableFeatures (crateConfig.dependencies or [ ]) expandedFeatures;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures enabledFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = enabledFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else
                  mergePackageFeatures {
                    features = combinedFeatures;
                    featuresByPackageId = cache;
                    inherit crateConfigs packageId target runTests rootPackageId;
                  }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ enabledFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = { name, rename ? null, ... }: feature:
    let
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    (rename == null && feature == name)
    || (rename != null && rename == feature)
    || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
     rules in featureMap.

     featureMap is an attribute set which maps feature names to lists of further
     feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /* This function adds optional dependencies as features if they are enabled
     indirectly by dependency features. This function mimics Cargo's behavior
     described in a note at:
     https://doc.rust-lang.org/nightly/cargo/reference/features.html#dependency-features
  */
  enableFeatures = dependencies: features:
    assert (builtins.isList features);
    assert (builtins.isList dependencies);
    let
      additionalFeatures = lib.concatMap
        (
          dependency:
            assert (builtins.isAttrs dependency);
            let
              enabled = builtins.any (doesFeatureEnableDependency dependency) features;
            in
            if (dependency.optional or false) && enabled then [ dependency.name ] else [ ]
        )
        dependencies;
    in
    sortedUnique (features ++ additionalFeatures);

  /*
     Returns the actual features for the given dependency.

     features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #
  };
}

