use reqwest::{
    header::{HeaderMap, HeaderValue},
    Client,
};

const PEOPLE: [&'static str; 50] = [
    "l3gacyb3ta",
    "sarthaktexas",
    "tetraoxygen",
    "aidenybai",
    "willdoescode",
    "Hugoyhu",
    "anirudhb",
    "abbyfischler",
    "benaubin",
    "ClaireBookworm",
    "jasonappah",
    "gleich",
    "nunu2021",
    "DamianRMusk",
    "sporeball",
    "eilla1",
    "rpalakkal",
    "lavanya-sharma",
    "thatrobotdev",
    "bykevinyang",
    "quackduck",
    "mfarberbrodsky",
    "bashbaugh",
    "merlin04",
    "cole-wilson",
    "YodaLightsabr",
    "kognise",
    "neelr",
    "LinusS1",
    "yeetyah1030",
    "profsucrose",
    "bellesea",
    "kunalbotla",
    "bjmoonn",
    "rbccawang",
    "hogrider321",
    "arianna-m",
    "Robertrover811",
    "pranavnt",
    "rishadjhangiani",
    "swarnya246",
    "rishiosaur",
    "drakontas",
    "zachlatta",
    "maxwofford",
    "MatthewStanciu",
    "christinaasquith",
    "leomcelroy",
    "zfogg",
    "sampoder",
];

#[tokio::main]
async fn main() {
    let token = if let Some(x) = std::env::args().nth(1) {
        x
    } else {
        println!("Please use github token as program argument");
        std::process::exit(1);
    };

    let mut headers = HeaderMap::new();
    headers.insert(
        reqwest::header::AUTHORIZATION,
        HeaderValue::from_str(format!("token {}", token).as_str()).unwrap(),
    );
    headers.insert(
        reqwest::header::USER_AGENT,
        HeaderValue::from_str("terminal").unwrap(),
    );

    headers.insert(
        reqwest::header::ACCEPT,
        HeaderValue::from_str("application/vnd.github.v3+json").unwrap(),
    );

    let tasks: Vec<_> = PEOPLE
        .iter()
        .map(&|person| {
            let headers = headers.clone();
            tokio::spawn(async move {
                let client = Client::builder().default_headers(headers).build().unwrap();
                client
                    .put(format!("https://api.github.com/user/following/{}", person))
                    .send()
                    .await
            })
        })
        .collect();

    let mut items = vec![];

    for task in tasks {
        items.push(task.await.unwrap());
    }

    for (index, item) in items.iter().enumerate() {
        match item {
            Ok(_) => println!("Followed: {}", PEOPLE[index]),
            Err(e) => println!("Error: {}", e),
        }
    }
}
