#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5793
#define LARGE_STATE_COUNT 1261
#define SYMBOL_COUNT 333
#define ALIAS_COUNT 6
#define TOKEN_COUNT 150
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 36
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 180

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_BANG = 19,
  anon_sym_else = 20,
  anon_sym_if = 21,
  anon_sym_switch = 22,
  anon_sym_for = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_await = 26,
  anon_sym_in = 27,
  anon_sym_of = 28,
  anon_sym_while = 29,
  anon_sym_do = 30,
  anon_sym_try = 31,
  anon_sym_with = 32,
  anon_sym_break = 33,
  anon_sym_continue = 34,
  anon_sym_debugger = 35,
  anon_sym_return = 36,
  anon_sym_throw = 37,
  anon_sym_SEMI = 38,
  anon_sym_COLON = 39,
  anon_sym_case = 40,
  anon_sym_catch = 41,
  anon_sym_finally = 42,
  anon_sym_yield = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  anon_sym_SLASH = 48,
  anon_sym_DOT = 49,
  anon_sym_class = 50,
  anon_sym_async = 51,
  anon_sym_function = 52,
  anon_sym_EQ_GT = 53,
  anon_sym_QMARK_DOT = 54,
  anon_sym_new = 55,
  anon_sym_PLUS_EQ = 56,
  anon_sym_DASH_EQ = 57,
  anon_sym_STAR_EQ = 58,
  anon_sym_SLASH_EQ = 59,
  anon_sym_PERCENT_EQ = 60,
  anon_sym_CARET_EQ = 61,
  anon_sym_AMP_EQ = 62,
  anon_sym_PIPE_EQ = 63,
  anon_sym_GT_GT_EQ = 64,
  anon_sym_GT_GT_GT_EQ = 65,
  anon_sym_LT_LT_EQ = 66,
  anon_sym_STAR_STAR_EQ = 67,
  anon_sym_AMP_AMP_EQ = 68,
  anon_sym_PIPE_PIPE_EQ = 69,
  anon_sym_QMARK_QMARK_EQ = 70,
  anon_sym_DOT_DOT_DOT = 71,
  anon_sym_QMARK = 72,
  anon_sym_AMP_AMP = 73,
  anon_sym_PIPE_PIPE = 74,
  anon_sym_GT_GT = 75,
  anon_sym_GT_GT_GT = 76,
  anon_sym_LT_LT = 77,
  anon_sym_AMP = 78,
  anon_sym_CARET = 79,
  anon_sym_PIPE = 80,
  anon_sym_PLUS = 81,
  anon_sym_DASH = 82,
  anon_sym_PERCENT = 83,
  anon_sym_STAR_STAR = 84,
  anon_sym_LT_EQ = 85,
  anon_sym_EQ_EQ = 86,
  anon_sym_EQ_EQ_EQ = 87,
  anon_sym_BANG_EQ = 88,
  anon_sym_BANG_EQ_EQ = 89,
  anon_sym_GT_EQ = 90,
  anon_sym_QMARK_QMARK = 91,
  anon_sym_instanceof = 92,
  anon_sym_TILDE = 93,
  anon_sym_void = 94,
  anon_sym_delete = 95,
  anon_sym_PLUS_PLUS = 96,
  anon_sym_DASH_DASH = 97,
  anon_sym_DQUOTE = 98,
  aux_sym_string_token1 = 99,
  anon_sym_SQUOTE = 100,
  aux_sym_string_token2 = 101,
  sym_escape_sequence = 102,
  sym_comment = 103,
  anon_sym_BQUOTE = 104,
  anon_sym_DOLLAR_LBRACE = 105,
  anon_sym_SLASH2 = 106,
  sym_regex_pattern = 107,
  sym_regex_flags = 108,
  sym_number = 109,
  anon_sym_target = 110,
  sym_this = 111,
  sym_super = 112,
  sym_true = 113,
  sym_false = 114,
  sym_null = 115,
  sym_undefined = 116,
  anon_sym_AT = 117,
  anon_sym_declare = 118,
  anon_sym_static = 119,
  anon_sym_readonly = 120,
  anon_sym_abstract = 121,
  anon_sym_get = 122,
  anon_sym_set = 123,
  anon_sym_public = 124,
  anon_sym_private = 125,
  anon_sym_protected = 126,
  anon_sym_module = 127,
  anon_sym_any = 128,
  anon_sym_number = 129,
  anon_sym_boolean = 130,
  anon_sym_string = 131,
  anon_sym_symbol = 132,
  anon_sym_require = 133,
  anon_sym_implements = 134,
  anon_sym_global = 135,
  anon_sym_interface = 136,
  anon_sym_extends = 137,
  anon_sym_enum = 138,
  anon_sym_DASH_QMARK_COLON = 139,
  anon_sym_QMARK_COLON = 140,
  anon_sym_asserts = 141,
  anon_sym_infer = 142,
  anon_sym_is = 143,
  anon_sym_keyof = 144,
  anon_sym_LBRACE_PIPE = 145,
  anon_sym_PIPE_RBRACE = 146,
  sym__automatic_semicolon = 147,
  sym__template_chars = 148,
  sym__function_signature_automatic_semicolon = 149,
  sym_program = 150,
  sym_export_statement = 151,
  sym_export_clause = 152,
  sym__import_export_specifier = 153,
  sym_declaration = 154,
  sym_import = 155,
  sym_import_statement = 156,
  sym_import_clause = 157,
  sym__from_clause = 158,
  sym_namespace_import = 159,
  sym_named_imports = 160,
  sym_expression_statement = 161,
  sym_variable_declaration = 162,
  sym_lexical_declaration = 163,
  sym_variable_declarator = 164,
  sym_statement_block = 165,
  sym_else_clause = 166,
  sym_if_statement = 167,
  sym_switch_statement = 168,
  sym_for_statement = 169,
  sym_for_in_statement = 170,
  sym__for_header = 171,
  sym_while_statement = 172,
  sym_do_statement = 173,
  sym_try_statement = 174,
  sym_with_statement = 175,
  sym_break_statement = 176,
  sym_continue_statement = 177,
  sym_debugger_statement = 178,
  sym_return_statement = 179,
  sym_throw_statement = 180,
  sym_empty_statement = 181,
  sym_labeled_statement = 182,
  sym_switch_body = 183,
  sym_switch_case = 184,
  sym_switch_default = 185,
  sym_catch_clause = 186,
  sym_finally_clause = 187,
  sym_parenthesized_expression = 188,
  sym_expression = 189,
  sym_primary_expression = 190,
  sym_yield_expression = 191,
  sym_object = 192,
  sym_object_pattern = 193,
  sym_assignment_pattern = 194,
  sym_object_assignment_pattern = 195,
  sym_array = 196,
  sym_array_pattern = 197,
  sym_nested_identifier = 198,
  sym_class = 199,
  sym_class_declaration = 200,
  sym_class_heritage = 201,
  sym_function = 202,
  sym_function_declaration = 203,
  sym_generator_function = 204,
  sym_generator_function_declaration = 205,
  sym_arrow_function = 206,
  sym__call_signature = 207,
  sym__formal_parameter = 208,
  sym_call_expression = 209,
  sym_new_expression = 210,
  sym_await_expression = 211,
  sym_member_expression = 212,
  sym_subscript_expression = 213,
  sym_assignment_expression = 214,
  sym__augmented_assignment_lhs = 215,
  sym_augmented_assignment_expression = 216,
  sym__initializer = 217,
  sym__destructuring_pattern = 218,
  sym_spread_element = 219,
  sym_ternary_expression = 220,
  sym_binary_expression = 221,
  sym_unary_expression = 222,
  sym_update_expression = 223,
  sym_sequence_expression = 224,
  sym_string = 225,
  sym_template_string = 226,
  sym_template_substitution = 227,
  sym_regex = 228,
  sym_meta_property = 229,
  sym_arguments = 230,
  sym_decorator = 231,
  sym_decorator_member_expression = 232,
  sym_decorator_call_expression = 233,
  sym_class_body = 234,
  sym_public_field_definition = 235,
  sym_formal_parameters = 236,
  sym_pattern = 237,
  sym_rest_pattern = 238,
  sym_method_definition = 239,
  sym_pair = 240,
  sym_pair_pattern = 241,
  sym__property_name = 242,
  sym_computed_property_name = 243,
  sym_non_null_expression = 244,
  sym_method_signature = 245,
  sym_abstract_method_signature = 246,
  sym_function_signature = 247,
  sym_type_assertion = 248,
  sym_as_expression = 249,
  sym_import_require_clause = 250,
  sym_implements_clause = 251,
  sym_ambient_declaration = 252,
  sym_abstract_class_declaration = 253,
  sym_module = 254,
  sym_internal_module = 255,
  sym__module = 256,
  sym_import_alias = 257,
  sym_nested_type_identifier = 258,
  sym_interface_declaration = 259,
  sym_extends_clause = 260,
  sym_enum_declaration = 261,
  sym_enum_body = 262,
  sym_enum_assignment = 263,
  sym_type_alias_declaration = 264,
  sym_accessibility_modifier = 265,
  sym_required_parameter = 266,
  sym_optional_parameter = 267,
  sym__parameter_name = 268,
  sym_omitting_type_annotation = 269,
  sym_opting_type_annotation = 270,
  sym_type_annotation = 271,
  sym_asserts = 272,
  sym__type = 273,
  sym_tuple_parameter = 274,
  sym_optional_tuple_parameter = 275,
  sym_optional_type = 276,
  sym_rest_type = 277,
  sym__tuple_type_member = 278,
  sym_constructor_type = 279,
  sym__primary_type = 280,
  sym_infer_type = 281,
  sym_conditional_type = 282,
  sym_generic_type = 283,
  sym_type_predicate = 284,
  sym_type_predicate_annotation = 285,
  sym_type_query = 286,
  sym_index_type_query = 287,
  sym_lookup_type = 288,
  sym_mapped_type_clause = 289,
  sym_literal_type = 290,
  sym__number = 291,
  sym_existential_type = 292,
  sym_flow_maybe_type = 293,
  sym_parenthesized_type = 294,
  sym_predefined_type = 295,
  sym_type_arguments = 296,
  sym_object_type = 297,
  sym_call_signature = 298,
  sym_property_signature = 299,
  sym_type_parameters = 300,
  sym_type_parameter = 301,
  sym_default_type = 302,
  sym_constraint = 303,
  sym_construct_signature = 304,
  sym_index_signature = 305,
  sym_array_type = 306,
  sym_tuple_type = 307,
  sym_readonly_type = 308,
  sym_union_type = 309,
  sym_intersection_type = 310,
  sym_function_type = 311,
  aux_sym_program_repeat1 = 312,
  aux_sym_export_statement_repeat1 = 313,
  aux_sym_export_clause_repeat1 = 314,
  aux_sym_named_imports_repeat1 = 315,
  aux_sym_variable_declaration_repeat1 = 316,
  aux_sym_switch_body_repeat1 = 317,
  aux_sym_object_repeat1 = 318,
  aux_sym_object_pattern_repeat1 = 319,
  aux_sym_array_repeat1 = 320,
  aux_sym_array_pattern_repeat1 = 321,
  aux_sym_string_repeat1 = 322,
  aux_sym_string_repeat2 = 323,
  aux_sym_template_string_repeat1 = 324,
  aux_sym_class_body_repeat1 = 325,
  aux_sym_formal_parameters_repeat1 = 326,
  aux_sym_implements_clause_repeat1 = 327,
  aux_sym_extends_clause_repeat1 = 328,
  aux_sym_enum_body_repeat1 = 329,
  aux_sym_object_type_repeat1 = 330,
  aux_sym_type_parameters_repeat1 = 331,
  aux_sym_tuple_type_repeat1 = 332,
  alias_sym_import_specifier = 333,
  alias_sym_property_identifier = 334,
  alias_sym_shorthand_property_identifier = 335,
  alias_sym_shorthand_property_identifier_pattern = 336,
  alias_sym_statement_identifier = 337,
  alias_sym_type_identifier = 338,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_declare] = "declare",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_abstract] = "abstract",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_require] = "require",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_extends] = "extends",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_clause] = "extends_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym_asserts] = "asserts",
  [sym__type] = "_type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_clause] = sym_extends_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym_asserts] = sym_asserts,
  [sym__type] = sym__type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_constructor = 8,
  field_declaration = 9,
  field_decorator = 10,
  field_finalizer = 11,
  field_flags = 12,
  field_function = 13,
  field_handler = 14,
  field_increment = 15,
  field_index = 16,
  field_initializer = 17,
  field_key = 18,
  field_label = 19,
  field_left = 20,
  field_module = 21,
  field_name = 22,
  field_object = 23,
  field_operator = 24,
  field_parameter = 25,
  field_parameters = 26,
  field_pattern = 27,
  field_property = 28,
  field_return_type = 29,
  field_right = 30,
  field_sign = 31,
  field_source = 32,
  field_type = 33,
  field_type_arguments = 34,
  field_type_parameters = 35,
  field_value = 36,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 2},
  [19] = {.index = 23, .length = 1},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 3},
  [31] = {.index = 42, .length = 2},
  [32] = {.index = 44, .length = 2},
  [33] = {.index = 46, .length = 2},
  [34] = {.index = 48, .length = 2},
  [35] = {.index = 50, .length = 2},
  [36] = {.index = 52, .length = 1},
  [37] = {.index = 53, .length = 3},
  [39] = {.index = 56, .length = 1},
  [40] = {.index = 57, .length = 2},
  [41] = {.index = 59, .length = 1},
  [42] = {.index = 60, .length = 2},
  [43] = {.index = 62, .length = 4},
  [44] = {.index = 66, .length = 2},
  [45] = {.index = 68, .length = 2},
  [46] = {.index = 24, .length = 2},
  [47] = {.index = 27, .length = 2},
  [48] = {.index = 57, .length = 2},
  [49] = {.index = 70, .length = 3},
  [50] = {.index = 73, .length = 2},
  [51] = {.index = 75, .length = 3},
  [52] = {.index = 78, .length = 2},
  [53] = {.index = 80, .length = 4},
  [54] = {.index = 84, .length = 3},
  [55] = {.index = 87, .length = 2},
  [56] = {.index = 89, .length = 2},
  [57] = {.index = 91, .length = 1},
  [58] = {.index = 92, .length = 1},
  [59] = {.index = 93, .length = 1},
  [60] = {.index = 94, .length = 1},
  [61] = {.index = 95, .length = 2},
  [62] = {.index = 24, .length = 2},
  [63] = {.index = 97, .length = 2},
  [64] = {.index = 99, .length = 5},
  [65] = {.index = 95, .length = 2},
  [66] = {.index = 104, .length = 1},
  [67] = {.index = 105, .length = 2},
  [68] = {.index = 107, .length = 3},
  [69] = {.index = 110, .length = 2},
  [70] = {.index = 112, .length = 3},
  [71] = {.index = 115, .length = 3},
  [72] = {.index = 118, .length = 2},
  [73] = {.index = 120, .length = 3},
  [74] = {.index = 123, .length = 4},
  [75] = {.index = 127, .length = 2},
  [76] = {.index = 129, .length = 2},
  [77] = {.index = 131, .length = 2},
  [78] = {.index = 133, .length = 3},
  [79] = {.index = 136, .length = 2},
  [80] = {.index = 138, .length = 2},
  [81] = {.index = 140, .length = 4},
  [82] = {.index = 138, .length = 2},
  [83] = {.index = 144, .length = 4},
  [84] = {.index = 148, .length = 4},
  [85] = {.index = 152, .length = 5},
  [86] = {.index = 157, .length = 3},
  [87] = {.index = 110, .length = 2},
  [88] = {.index = 160, .length = 2},
  [89] = {.index = 162, .length = 3},
  [90] = {.index = 165, .length = 2},
  [91] = {.index = 167, .length = 3},
  [92] = {.index = 170, .length = 2},
  [93] = {.index = 172, .length = 3},
  [94] = {.index = 175, .length = 2},
  [95] = {.index = 177, .length = 2},
  [96] = {.index = 179, .length = 5},
  [97] = {.index = 184, .length = 1},
  [98] = {.index = 185, .length = 2},
  [99] = {.index = 187, .length = 2},
  [100] = {.index = 189, .length = 1},
  [101] = {.index = 190, .length = 2},
  [102] = {.index = 192, .length = 4},
  [103] = {.index = 196, .length = 2},
  [104] = {.index = 198, .length = 2},
  [105] = {.index = 200, .length = 3},
  [106] = {.index = 203, .length = 4},
  [107] = {.index = 207, .length = 4},
  [108] = {.index = 211, .length = 5},
  [109] = {.index = 216, .length = 2},
  [110] = {.index = 218, .length = 3},
  [111] = {.index = 221, .length = 1},
  [112] = {.index = 222, .length = 2},
  [113] = {.index = 224, .length = 3},
  [114] = {.index = 227, .length = 2},
  [115] = {.index = 229, .length = 3},
  [116] = {.index = 232, .length = 4},
  [117] = {.index = 236, .length = 3},
  [118] = {.index = 239, .length = 3},
  [119] = {.index = 242, .length = 2},
  [120] = {.index = 244, .length = 3},
  [121] = {.index = 247, .length = 5},
  [122] = {.index = 252, .length = 2},
  [123] = {.index = 252, .length = 2},
  [124] = {.index = 254, .length = 3},
  [125] = {.index = 257, .length = 4},
  [126] = {.index = 261, .length = 2},
  [127] = {.index = 263, .length = 2},
  [128] = {.index = 265, .length = 1},
  [129] = {.index = 266, .length = 2},
  [130] = {.index = 268, .length = 2},
  [131] = {.index = 270, .length = 3},
  [132] = {.index = 273, .length = 3},
  [133] = {.index = 276, .length = 5},
  [134] = {.index = 281, .length = 3},
  [135] = {.index = 284, .length = 4},
  [136] = {.index = 288, .length = 3},
  [137] = {.index = 291, .length = 4},
  [138] = {.index = 295, .length = 5},
  [139] = {.index = 300, .length = 2},
  [140] = {.index = 302, .length = 4},
  [141] = {.index = 306, .length = 2},
  [142] = {.index = 308, .length = 4},
  [143] = {.index = 312, .length = 4},
  [144] = {.index = 316, .length = 2},
  [145] = {.index = 318, .length = 2},
  [146] = {.index = 320, .length = 2},
  [147] = {.index = 322, .length = 2},
  [148] = {.index = 324, .length = 3},
  [149] = {.index = 327, .length = 3},
  [150] = {.index = 330, .length = 1},
  [152] = {.index = 331, .length = 4},
  [153] = {.index = 335, .length = 5},
  [154] = {.index = 340, .length = 5},
  [155] = {.index = 345, .length = 3},
  [157] = {.index = 348, .length = 1},
  [158] = {.index = 349, .length = 4},
  [159] = {.index = 353, .length = 4},
  [160] = {.index = 357, .length = 2},
  [161] = {.index = 359, .length = 4},
  [162] = {.index = 363, .length = 2},
  [163] = {.index = 365, .length = 3},
  [164] = {.index = 368, .length = 3},
  [165] = {.index = 371, .length = 2},
  [166] = {.index = 373, .length = 2},
  [167] = {.index = 375, .length = 5},
  [168] = {.index = 380, .length = 5},
  [169] = {.index = 385, .length = 4},
  [171] = {.index = 389, .length = 4},
  [172] = {.index = 393, .length = 3},
  [173] = {.index = 396, .length = 2},
  [174] = {.index = 398, .length = 2},
  [175] = {.index = 400, .length = 3},
  [176] = {.index = 403, .length = 5},
  [177] = {.index = 348, .length = 1},
  [178] = {.index = 408, .length = 4},
  [179] = {.index = 412, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_decorator, 0, .inherited = true},
  [9] =
    {field_body, 1},
  [10] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [12] =
    {field_constructor, 1},
  [13] =
    {field_argument, 0},
    {field_operator, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_parameters, 0},
    {field_return_type, 1},
  [19] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [21] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [23] =
    {field_declaration, 2},
  [24] =
    {field_left, 0},
    {field_right, 2},
  [26] =
    {field_label, 0},
  [27] =
    {field_body, 2},
    {field_parameter, 0},
  [29] =
    {field_body, 1},
    {field_name, 0},
  [31] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [33] =
    {field_name, 0},
    {field_type, 1},
  [35] =
    {field_condition, 1},
    {field_consequence, 2},
  [37] =
    {field_body, 2},
    {field_value, 1},
  [39] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [42] =
    {field_decorator, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [44] =
    {field_body, 2},
    {field_condition, 1},
  [46] =
    {field_body, 1},
    {field_handler, 2},
  [48] =
    {field_body, 1},
    {field_finalizer, 2},
  [50] =
    {field_body, 2},
    {field_object, 1},
  [52] =
    {field_label, 1},
  [53] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [56] =
    {field_pattern, 1},
  [57] =
    {field_body, 2},
    {field_name, 1},
  [59] =
    {field_body, 2},
  [60] =
    {field_body, 2},
    {field_type_parameters, 1},
  [62] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [66] =
    {field_arguments, 2},
    {field_constructor, 1},
  [68] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [70] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [73] =
    {field_object, 0},
    {field_property, 2},
  [75] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [78] =
    {field_arguments, 2},
    {field_function, 0},
  [80] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [84] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [87] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [89] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [91] =
    {field_source, 1},
  [92] =
    {field_source, 2, .inherited = true},
  [93] =
    {field_value, 2},
  [94] =
    {field_name, 1},
  [95] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [97] =
    {field_key, 0},
    {field_value, 2},
  [99] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [104] =
    {field_value, 1},
  [105] =
    {field_name, 0},
    {field_type, 2},
  [107] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [110] =
    {field_body, 3},
    {field_name, 2},
  [112] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [115] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [118] =
    {field_decorator, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [120] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [123] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [127] =
    {field_module, 0},
    {field_name, 2},
  [129] =
    {field_flags, 3},
    {field_pattern, 1},
  [131] =
    {field_body, 3},
    {field_name, 1},
  [133] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [136] =
    {field_body, 3},
    {field_type_parameters, 1},
  [138] =
    {field_body, 3},
    {field_parameter, 1},
  [140] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [144] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [148] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [152] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [157] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [160] =
    {field_index, 2},
    {field_object, 0},
  [162] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [165] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [167] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [170] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [172] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [175] =
    {field_alias, 2},
    {field_name, 0},
  [177] =
    {field_name, 1},
    {field_value, 3},
  [179] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [184] =
    {field_source, 3, .inherited = true},
  [185] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3, .inherited = true},
  [187] =
    {field_body, 1},
    {field_condition, 3},
  [189] =
    {field_name, 2},
  [190] =
    {field_name, 1},
    {field_type, 2},
  [192] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [196] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [198] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [200] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [203] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [207] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [211] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [216] =
    {field_body, 4},
    {field_name, 2},
  [218] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [221] =
    {field_value, 1, .inherited = true},
  [222] =
    {field_index, 3},
    {field_object, 0},
  [224] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [227] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [229] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [232] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [236] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [239] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [242] =
    {field_alias, 3},
    {field_name, 1},
  [244] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [247] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [252] =
    {field_left, 1},
    {field_right, 3},
  [254] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [257] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [261] =
    {field_name, 2},
    {field_type, 3},
  [263] =
    {field_name, 1},
    {field_type, 3},
  [265] =
    {field_name, 3},
  [266] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [268] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [270] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [273] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [276] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [281] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [284] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [288] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [291] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [295] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [300] =
    {field_left, 2},
    {field_right, 4},
  [302] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [306] =
    {field_body, 4},
    {field_parameter, 2},
  [308] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [312] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [316] =
    {field_name, 2},
    {field_type, 4},
  [318] =
    {field_name, 3},
    {field_type, 4},
  [320] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [322] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [324] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [327] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [330] =
    {field_name, 4},
  [331] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [335] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [340] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [345] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [348] =
    {field_sign, 0},
  [349] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [353] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [357] =
    {field_name, 3},
    {field_type, 5},
  [359] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [363] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [365] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [368] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [371] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [373] =
    {field_name, 4},
    {field_type, 5},
  [375] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [380] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [385] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [389] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [393] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [396] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [398] =
    {field_name, 4},
    {field_type, 6},
  [400] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [403] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [408] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [412] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [20] = {
    [0] = sym_identifier,
  },
  [21] = {
    [0] = alias_sym_statement_identifier,
  },
  [22] = {
    [0] = sym_identifier,
  },
  [24] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [25] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [36] = {
    [1] = alias_sym_statement_identifier,
  },
  [38] = {
    [1] = alias_sym_type_identifier,
  },
  [40] = {
    [1] = alias_sym_type_identifier,
  },
  [50] = {
    [2] = alias_sym_property_identifier,
  },
  [62] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [65] = {
    [1] = alias_sym_import_specifier,
  },
  [75] = {
    [2] = alias_sym_type_identifier,
  },
  [77] = {
    [1] = alias_sym_type_identifier,
  },
  [78] = {
    [1] = alias_sym_type_identifier,
  },
  [80] = {
    [1] = sym_identifier,
  },
  [87] = {
    [2] = alias_sym_type_identifier,
  },
  [91] = {
    [2] = alias_sym_type_identifier,
  },
  [95] = {
    [1] = alias_sym_type_identifier,
  },
  [105] = {
    [1] = alias_sym_type_identifier,
  },
  [109] = {
    [2] = alias_sym_type_identifier,
  },
  [110] = {
    [2] = alias_sym_type_identifier,
  },
  [115] = {
    [2] = alias_sym_type_identifier,
  },
  [116] = {
    [2] = alias_sym_type_identifier,
  },
  [118] = {
    [3] = alias_sym_type_identifier,
  },
  [120] = {
    [1] = alias_sym_type_identifier,
  },
  [122] = {
    [1] = sym_identifier,
  },
  [134] = {
    [2] = alias_sym_type_identifier,
  },
  [135] = {
    [2] = alias_sym_type_identifier,
  },
  [136] = {
    [3] = alias_sym_type_identifier,
  },
  [137] = {
    [3] = alias_sym_type_identifier,
  },
  [151] = {
    [3] = alias_sym_property_identifier,
  },
  [152] = {
    [3] = alias_sym_type_identifier,
  },
  [156] = {
    [1] = sym_identifier,
  },
  [170] = {
    [2] = sym_identifier,
  },
  [177] = {
    [3] = sym_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '{' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '~' || (c < 8288
      ? (c < 8203
        ? c == 160
        : c <= 8203)
      : (c <= 8288 || c == 65279))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '|' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(147);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(141);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(198);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(184);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '%') ADVANCE(147);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(141);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(144);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '%') ADVANCE(147);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(141);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(144);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < ')' || ';' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(198);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(137);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(137);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(26);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(26);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(66);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(134);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(198);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(142);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '%' &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(142);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '%' &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(142);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(198);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(166);
      if (lookahead != 0) ADVANCE(167);
      END_STATE();
    case 15:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == '?') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == '?') ADVANCE(25);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(180);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(179);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(115);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(23)
      END_STATE();
    case 24:
      if (lookahead == ':') ADVANCE(200);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(201);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 27:
      if (lookahead == '?') ADVANCE(24);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == ']') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(182);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 34:
      if (lookahead == '{') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '}') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '}') ADVANCE(203);
      END_STATE();
    case 39:
      if (lookahead == '}') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 41:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(190);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(191);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(198);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(175);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 60:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 61:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(185);
      END_STATE();
    case 62:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(197);
      if (lookahead == '%') ADVANCE(147);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(141);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(117);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(75);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(198);
      END_STATE();
    case 63:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '%') ADVANCE(146);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(91);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(137);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(63)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(198);
      END_STATE();
    case 64:
      if (eof) ADVANCE(65);
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '"') ADVANCE(161);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '\'') ADVANCE(168);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(140);
      if (lookahead == ',') ADVANCE(76);
      if (lookahead == '-') ADVANCE(143);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(188);
      if (lookahead == ':') ADVANCE(83);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '@') ADVANCE(199);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '`') ADVANCE(181);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(77);
      if (lookahead == '~') ADVANCE(158);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(64)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(198);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(149);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(148);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(98);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(98);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(202);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(127);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(155);
      if (lookahead == '>') ADVANCE(123);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(155);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(180);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(180);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(22);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == '?') ADVANCE(157);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(99);
      if (lookahead == '?') ADVANCE(156);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(119);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(107);
      if (lookahead == '|') ADVANCE(122);
      if (lookahead == '}') ADVANCE(203);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(121);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(121);
      if (lookahead == '}') ADVANCE(203);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(203);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(159);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(159);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(160);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(160);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '?') ADVANCE(24);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(165);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(167);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(167);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\n') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(174);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(198);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(175);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(177);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(180);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(184);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(30);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(198);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '0') ADVANCE(193);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(42);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(49);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(187);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (lookahead == '_') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(187);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (lookahead == '_') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '{') ADVANCE(182);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(53);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 't') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      if (lookahead == 'w') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'r') ADVANCE(64);
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'i') ADVANCE(70);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(79);
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(83);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'l') ADVANCE(86);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(89);
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(98);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(99);
      if (lookahead == 's') ADVANCE(100);
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(102);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 49:
      if (lookahead == 'd') ADVANCE(104);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(105);
      END_STATE();
    case 51:
      if (lookahead == 'w') ADVANCE(106);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(108);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 55:
      if (lookahead == 'b') ADVANCE(111);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'q') ADVANCE(113);
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(120);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(122);
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(124);
      if (lookahead == 'y') ADVANCE(125);
      END_STATE();
    case 65:
      if (lookahead == 'p') ADVANCE(126);
      END_STATE();
    case 66:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 77:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(140);
      END_STATE();
    case 81:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(142);
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(144);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 88:
      if (lookahead == 'm') ADVANCE(149);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(153);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 94:
      if (lookahead == 'm') ADVANCE(154);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 97:
      if (lookahead == 'b') ADVANCE(156);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 102:
      if (lookahead == 'o') ADVANCE(162);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(163);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 108:
      if (lookahead == 'b') ADVANCE(166);
      END_STATE();
    case 109:
      if (lookahead == 'v') ADVANCE(167);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(170);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 114:
      if (lookahead == 'u') ADVANCE(172);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 120:
      if (lookahead == 'b') ADVANCE(177);
      END_STATE();
    case 121:
      if (lookahead == 'g') ADVANCE(178);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 123:
      if (lookahead == 'o') ADVANCE(180);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 129:
      if (lookahead == 'd') ADVANCE(184);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 131:
      if (lookahead == 'h') ADVANCE(186);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 135:
      if (lookahead == 'c') ADVANCE(190);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 138:
      if (lookahead == 'k') ADVANCE(193);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 140:
      if (lookahead == 'h') ADVANCE(194);
      END_STATE();
    case 141:
      if (lookahead == 's') ADVANCE(195);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 144:
      if (lookahead == 'g') ADVANCE(198);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 146:
      if (lookahead == 'u') ADVANCE(200);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(207);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 162:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(216);
      END_STATE();
    case 167:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 169:
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(220);
      END_STATE();
    case 171:
      if (lookahead == 'i') ADVANCE(221);
      END_STATE();
    case 172:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 173:
      if (lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 174:
      if (lookahead == 'n') ADVANCE(224);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(227);
      END_STATE();
    case 178:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 180:
      if (lookahead == 'w') ADVANCE(229);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 183:
      if (lookahead == 'f') ADVANCE(231);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(233);
      END_STATE();
    case 188:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 198:
      if (lookahead == 'g') ADVANCE(238);
      END_STATE();
    case 199:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 200:
      if (lookahead == 'l') ADVANCE(240);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 203:
      if (lookahead == 'd') ADVANCE(243);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 205:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(245);
      END_STATE();
    case 207:
      if (lookahead == 'l') ADVANCE(246);
      END_STATE();
    case 208:
      if (lookahead == 'm') ADVANCE(247);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(249);
      END_STATE();
    case 212:
      if (lookahead == 'f') ADVANCE(250);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 215:
      if (lookahead == 'p') ADVANCE(252);
      END_STATE();
    case 216:
      if (lookahead == 'r') ADVANCE(253);
      END_STATE();
    case 217:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 218:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 219:
      if (lookahead == 'c') ADVANCE(256);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 221:
      if (lookahead == 'r') ADVANCE(258);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 223:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 224:
      if (lookahead == 'g') ADVANCE(261);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 226:
      if (lookahead == 'h') ADVANCE(262);
      END_STATE();
    case 227:
      if (lookahead == 'l') ADVANCE(263);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 230:
      if (lookahead == 'f') ADVANCE(265);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 234:
      if (lookahead == 'c') ADVANCE(267);
      END_STATE();
    case 235:
      if (lookahead == 's') ADVANCE(268);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 237:
      if (lookahead == 'u') ADVANCE(270);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 240:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(274);
      END_STATE();
    case 244:
      if (lookahead == 'y') ADVANCE(275);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(276);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(278);
      END_STATE();
    case 250:
      if (lookahead == 'a') ADVANCE(279);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 252:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 255:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 257:
      if (lookahead == 'l') ADVANCE(283);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(286);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 271:
      if (lookahead == 'r') ADVANCE(288);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 276:
      if (lookahead == 'n') ADVANCE(289);
      END_STATE();
    case 277:
      if (lookahead == 'n') ADVANCE(290);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(292);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(293);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 283:
      if (lookahead == 'y') ADVANCE(295);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(297);
      END_STATE();
    case 291:
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(301);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 296:
      if (lookahead == 'd') ADVANCE(302);
      END_STATE();
    case 297:
      if (lookahead == 's') ADVANCE(303);
      END_STATE();
    case 298:
      if (lookahead == 'f') ADVANCE(304);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 64},
  [2] = {.lex_state = 64},
  [3] = {.lex_state = 64},
  [4] = {.lex_state = 64},
  [5] = {.lex_state = 64},
  [6] = {.lex_state = 64},
  [7] = {.lex_state = 64},
  [8] = {.lex_state = 64},
  [9] = {.lex_state = 64},
  [10] = {.lex_state = 64},
  [11] = {.lex_state = 64},
  [12] = {.lex_state = 64},
  [13] = {.lex_state = 64},
  [14] = {.lex_state = 64},
  [15] = {.lex_state = 64},
  [16] = {.lex_state = 64},
  [17] = {.lex_state = 64},
  [18] = {.lex_state = 64},
  [19] = {.lex_state = 64},
  [20] = {.lex_state = 64},
  [21] = {.lex_state = 64},
  [22] = {.lex_state = 64},
  [23] = {.lex_state = 64},
  [24] = {.lex_state = 64},
  [25] = {.lex_state = 64},
  [26] = {.lex_state = 64},
  [27] = {.lex_state = 64},
  [28] = {.lex_state = 64},
  [29] = {.lex_state = 64},
  [30] = {.lex_state = 64},
  [31] = {.lex_state = 64},
  [32] = {.lex_state = 64},
  [33] = {.lex_state = 64},
  [34] = {.lex_state = 64},
  [35] = {.lex_state = 64},
  [36] = {.lex_state = 64},
  [37] = {.lex_state = 64},
  [38] = {.lex_state = 64},
  [39] = {.lex_state = 64},
  [40] = {.lex_state = 64},
  [41] = {.lex_state = 64},
  [42] = {.lex_state = 64},
  [43] = {.lex_state = 64},
  [44] = {.lex_state = 64},
  [45] = {.lex_state = 64},
  [46] = {.lex_state = 64},
  [47] = {.lex_state = 64},
  [48] = {.lex_state = 64},
  [49] = {.lex_state = 64},
  [50] = {.lex_state = 64},
  [51] = {.lex_state = 64},
  [52] = {.lex_state = 64},
  [53] = {.lex_state = 64},
  [54] = {.lex_state = 10},
  [55] = {.lex_state = 10},
  [56] = {.lex_state = 10},
  [57] = {.lex_state = 10},
  [58] = {.lex_state = 10},
  [59] = {.lex_state = 10},
  [60] = {.lex_state = 10},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 10},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 10},
  [73] = {.lex_state = 10},
  [74] = {.lex_state = 10},
  [75] = {.lex_state = 10},
  [76] = {.lex_state = 10},
  [77] = {.lex_state = 10},
  [78] = {.lex_state = 10},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 10},
  [81] = {.lex_state = 10},
  [82] = {.lex_state = 10},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 10},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 10},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 63, .external_lex_state = 2},
  [94] = {.lex_state = 10},
  [95] = {.lex_state = 10},
  [96] = {.lex_state = 10},
  [97] = {.lex_state = 10},
  [98] = {.lex_state = 63, .external_lex_state = 3},
  [99] = {.lex_state = 10},
  [100] = {.lex_state = 10},
  [101] = {.lex_state = 63, .external_lex_state = 4},
  [102] = {.lex_state = 63, .external_lex_state = 3},
  [103] = {.lex_state = 2, .external_lex_state = 3},
  [104] = {.lex_state = 63, .external_lex_state = 2},
  [105] = {.lex_state = 63, .external_lex_state = 3},
  [106] = {.lex_state = 63, .external_lex_state = 4},
  [107] = {.lex_state = 63, .external_lex_state = 2},
  [108] = {.lex_state = 4, .external_lex_state = 3},
  [109] = {.lex_state = 63, .external_lex_state = 3},
  [110] = {.lex_state = 63, .external_lex_state = 3},
  [111] = {.lex_state = 63, .external_lex_state = 2},
  [112] = {.lex_state = 63, .external_lex_state = 3},
  [113] = {.lex_state = 63, .external_lex_state = 3},
  [114] = {.lex_state = 63, .external_lex_state = 3},
  [115] = {.lex_state = 4, .external_lex_state = 3},
  [116] = {.lex_state = 63, .external_lex_state = 3},
  [117] = {.lex_state = 63, .external_lex_state = 2},
  [118] = {.lex_state = 63, .external_lex_state = 3},
  [119] = {.lex_state = 63, .external_lex_state = 3},
  [120] = {.lex_state = 64},
  [121] = {.lex_state = 64},
  [122] = {.lex_state = 64},
  [123] = {.lex_state = 64},
  [124] = {.lex_state = 64},
  [125] = {.lex_state = 64},
  [126] = {.lex_state = 2, .external_lex_state = 2},
  [127] = {.lex_state = 2, .external_lex_state = 3},
  [128] = {.lex_state = 2, .external_lex_state = 4},
  [129] = {.lex_state = 2, .external_lex_state = 3},
  [130] = {.lex_state = 2, .external_lex_state = 2},
  [131] = {.lex_state = 2, .external_lex_state = 2},
  [132] = {.lex_state = 2, .external_lex_state = 4},
  [133] = {.lex_state = 63, .external_lex_state = 2},
  [134] = {.lex_state = 2, .external_lex_state = 2},
  [135] = {.lex_state = 2, .external_lex_state = 3},
  [136] = {.lex_state = 2, .external_lex_state = 3},
  [137] = {.lex_state = 63, .external_lex_state = 2},
  [138] = {.lex_state = 63, .external_lex_state = 2},
  [139] = {.lex_state = 2, .external_lex_state = 3},
  [140] = {.lex_state = 63, .external_lex_state = 2},
  [141] = {.lex_state = 63, .external_lex_state = 2},
  [142] = {.lex_state = 63, .external_lex_state = 2},
  [143] = {.lex_state = 63, .external_lex_state = 2},
  [144] = {.lex_state = 63, .external_lex_state = 2},
  [145] = {.lex_state = 2, .external_lex_state = 3},
  [146] = {.lex_state = 2, .external_lex_state = 3},
  [147] = {.lex_state = 2, .external_lex_state = 3},
  [148] = {.lex_state = 2, .external_lex_state = 3},
  [149] = {.lex_state = 63, .external_lex_state = 2},
  [150] = {.lex_state = 2, .external_lex_state = 3},
  [151] = {.lex_state = 63, .external_lex_state = 2},
  [152] = {.lex_state = 63, .external_lex_state = 2},
  [153] = {.lex_state = 63, .external_lex_state = 2},
  [154] = {.lex_state = 63, .external_lex_state = 2},
  [155] = {.lex_state = 63, .external_lex_state = 2},
  [156] = {.lex_state = 63, .external_lex_state = 2},
  [157] = {.lex_state = 63, .external_lex_state = 2},
  [158] = {.lex_state = 63, .external_lex_state = 2},
  [159] = {.lex_state = 63, .external_lex_state = 2},
  [160] = {.lex_state = 63, .external_lex_state = 2},
  [161] = {.lex_state = 63, .external_lex_state = 2},
  [162] = {.lex_state = 63, .external_lex_state = 2},
  [163] = {.lex_state = 63, .external_lex_state = 2},
  [164] = {.lex_state = 2, .external_lex_state = 2},
  [165] = {.lex_state = 63, .external_lex_state = 2},
  [166] = {.lex_state = 63, .external_lex_state = 2},
  [167] = {.lex_state = 2, .external_lex_state = 3},
  [168] = {.lex_state = 63, .external_lex_state = 2},
  [169] = {.lex_state = 63, .external_lex_state = 2},
  [170] = {.lex_state = 63, .external_lex_state = 2},
  [171] = {.lex_state = 2, .external_lex_state = 3},
  [172] = {.lex_state = 64},
  [173] = {.lex_state = 2, .external_lex_state = 3},
  [174] = {.lex_state = 64},
  [175] = {.lex_state = 64},
  [176] = {.lex_state = 2, .external_lex_state = 3},
  [177] = {.lex_state = 2, .external_lex_state = 3},
  [178] = {.lex_state = 2, .external_lex_state = 3},
  [179] = {.lex_state = 64},
  [180] = {.lex_state = 64},
  [181] = {.lex_state = 64},
  [182] = {.lex_state = 64},
  [183] = {.lex_state = 64},
  [184] = {.lex_state = 64},
  [185] = {.lex_state = 64},
  [186] = {.lex_state = 64},
  [187] = {.lex_state = 64},
  [188] = {.lex_state = 64},
  [189] = {.lex_state = 64},
  [190] = {.lex_state = 64},
  [191] = {.lex_state = 64},
  [192] = {.lex_state = 64},
  [193] = {.lex_state = 64},
  [194] = {.lex_state = 64, .external_lex_state = 5},
  [195] = {.lex_state = 64},
  [196] = {.lex_state = 64},
  [197] = {.lex_state = 64},
  [198] = {.lex_state = 64},
  [199] = {.lex_state = 64},
  [200] = {.lex_state = 64},
  [201] = {.lex_state = 64},
  [202] = {.lex_state = 64},
  [203] = {.lex_state = 64},
  [204] = {.lex_state = 64},
  [205] = {.lex_state = 64},
  [206] = {.lex_state = 64},
  [207] = {.lex_state = 64},
  [208] = {.lex_state = 64},
  [209] = {.lex_state = 64},
  [210] = {.lex_state = 64},
  [211] = {.lex_state = 64},
  [212] = {.lex_state = 64},
  [213] = {.lex_state = 64},
  [214] = {.lex_state = 64},
  [215] = {.lex_state = 64},
  [216] = {.lex_state = 64},
  [217] = {.lex_state = 64},
  [218] = {.lex_state = 64},
  [219] = {.lex_state = 64},
  [220] = {.lex_state = 64},
  [221] = {.lex_state = 64},
  [222] = {.lex_state = 64},
  [223] = {.lex_state = 64},
  [224] = {.lex_state = 64},
  [225] = {.lex_state = 64},
  [226] = {.lex_state = 3, .external_lex_state = 2},
  [227] = {.lex_state = 3, .external_lex_state = 2},
  [228] = {.lex_state = 3, .external_lex_state = 2},
  [229] = {.lex_state = 64},
  [230] = {.lex_state = 3, .external_lex_state = 2},
  [231] = {.lex_state = 64},
  [232] = {.lex_state = 3, .external_lex_state = 2},
  [233] = {.lex_state = 3, .external_lex_state = 2},
  [234] = {.lex_state = 3, .external_lex_state = 2},
  [235] = {.lex_state = 64},
  [236] = {.lex_state = 64},
  [237] = {.lex_state = 64},
  [238] = {.lex_state = 64},
  [239] = {.lex_state = 64},
  [240] = {.lex_state = 64},
  [241] = {.lex_state = 64},
  [242] = {.lex_state = 64, .external_lex_state = 5},
  [243] = {.lex_state = 64},
  [244] = {.lex_state = 64},
  [245] = {.lex_state = 64},
  [246] = {.lex_state = 64},
  [247] = {.lex_state = 64},
  [248] = {.lex_state = 64},
  [249] = {.lex_state = 64},
  [250] = {.lex_state = 64},
  [251] = {.lex_state = 64},
  [252] = {.lex_state = 64},
  [253] = {.lex_state = 64},
  [254] = {.lex_state = 64},
  [255] = {.lex_state = 64},
  [256] = {.lex_state = 64},
  [257] = {.lex_state = 64},
  [258] = {.lex_state = 64},
  [259] = {.lex_state = 64},
  [260] = {.lex_state = 64},
  [261] = {.lex_state = 64},
  [262] = {.lex_state = 64},
  [263] = {.lex_state = 64},
  [264] = {.lex_state = 64},
  [265] = {.lex_state = 64},
  [266] = {.lex_state = 64},
  [267] = {.lex_state = 64},
  [268] = {.lex_state = 64},
  [269] = {.lex_state = 64},
  [270] = {.lex_state = 64},
  [271] = {.lex_state = 64},
  [272] = {.lex_state = 64},
  [273] = {.lex_state = 64},
  [274] = {.lex_state = 64},
  [275] = {.lex_state = 64},
  [276] = {.lex_state = 64},
  [277] = {.lex_state = 64},
  [278] = {.lex_state = 64},
  [279] = {.lex_state = 64},
  [280] = {.lex_state = 64},
  [281] = {.lex_state = 64},
  [282] = {.lex_state = 64},
  [283] = {.lex_state = 64},
  [284] = {.lex_state = 64},
  [285] = {.lex_state = 64},
  [286] = {.lex_state = 64},
  [287] = {.lex_state = 64},
  [288] = {.lex_state = 64},
  [289] = {.lex_state = 64},
  [290] = {.lex_state = 64},
  [291] = {.lex_state = 64},
  [292] = {.lex_state = 2, .external_lex_state = 2},
  [293] = {.lex_state = 2, .external_lex_state = 2},
  [294] = {.lex_state = 2, .external_lex_state = 2},
  [295] = {.lex_state = 2, .external_lex_state = 2},
  [296] = {.lex_state = 64},
  [297] = {.lex_state = 64},
  [298] = {.lex_state = 2, .external_lex_state = 2},
  [299] = {.lex_state = 2, .external_lex_state = 2},
  [300] = {.lex_state = 2, .external_lex_state = 2},
  [301] = {.lex_state = 64},
  [302] = {.lex_state = 64},
  [303] = {.lex_state = 64},
  [304] = {.lex_state = 64},
  [305] = {.lex_state = 64},
  [306] = {.lex_state = 64},
  [307] = {.lex_state = 64},
  [308] = {.lex_state = 64},
  [309] = {.lex_state = 64},
  [310] = {.lex_state = 64},
  [311] = {.lex_state = 64},
  [312] = {.lex_state = 64},
  [313] = {.lex_state = 64},
  [314] = {.lex_state = 64},
  [315] = {.lex_state = 64},
  [316] = {.lex_state = 64},
  [317] = {.lex_state = 64},
  [318] = {.lex_state = 64},
  [319] = {.lex_state = 64},
  [320] = {.lex_state = 64},
  [321] = {.lex_state = 64},
  [322] = {.lex_state = 64},
  [323] = {.lex_state = 64},
  [324] = {.lex_state = 64},
  [325] = {.lex_state = 64},
  [326] = {.lex_state = 64},
  [327] = {.lex_state = 64},
  [328] = {.lex_state = 64},
  [329] = {.lex_state = 64},
  [330] = {.lex_state = 64},
  [331] = {.lex_state = 64},
  [332] = {.lex_state = 64},
  [333] = {.lex_state = 64},
  [334] = {.lex_state = 64},
  [335] = {.lex_state = 64},
  [336] = {.lex_state = 64},
  [337] = {.lex_state = 64},
  [338] = {.lex_state = 64},
  [339] = {.lex_state = 64},
  [340] = {.lex_state = 64},
  [341] = {.lex_state = 64},
  [342] = {.lex_state = 64},
  [343] = {.lex_state = 64},
  [344] = {.lex_state = 64},
  [345] = {.lex_state = 64},
  [346] = {.lex_state = 64},
  [347] = {.lex_state = 64},
  [348] = {.lex_state = 64},
  [349] = {.lex_state = 64},
  [350] = {.lex_state = 64},
  [351] = {.lex_state = 64},
  [352] = {.lex_state = 64},
  [353] = {.lex_state = 64},
  [354] = {.lex_state = 64},
  [355] = {.lex_state = 64},
  [356] = {.lex_state = 64},
  [357] = {.lex_state = 64},
  [358] = {.lex_state = 64},
  [359] = {.lex_state = 64},
  [360] = {.lex_state = 64},
  [361] = {.lex_state = 64},
  [362] = {.lex_state = 64},
  [363] = {.lex_state = 64},
  [364] = {.lex_state = 64},
  [365] = {.lex_state = 64},
  [366] = {.lex_state = 3, .external_lex_state = 2},
  [367] = {.lex_state = 64},
  [368] = {.lex_state = 64},
  [369] = {.lex_state = 64},
  [370] = {.lex_state = 64},
  [371] = {.lex_state = 64},
  [372] = {.lex_state = 64},
  [373] = {.lex_state = 64},
  [374] = {.lex_state = 64},
  [375] = {.lex_state = 64},
  [376] = {.lex_state = 64},
  [377] = {.lex_state = 64},
  [378] = {.lex_state = 64},
  [379] = {.lex_state = 64},
  [380] = {.lex_state = 64},
  [381] = {.lex_state = 64},
  [382] = {.lex_state = 64},
  [383] = {.lex_state = 64},
  [384] = {.lex_state = 64},
  [385] = {.lex_state = 64},
  [386] = {.lex_state = 64},
  [387] = {.lex_state = 64},
  [388] = {.lex_state = 64},
  [389] = {.lex_state = 64},
  [390] = {.lex_state = 64},
  [391] = {.lex_state = 3, .external_lex_state = 2},
  [392] = {.lex_state = 64},
  [393] = {.lex_state = 64},
  [394] = {.lex_state = 64},
  [395] = {.lex_state = 64},
  [396] = {.lex_state = 64},
  [397] = {.lex_state = 64},
  [398] = {.lex_state = 64},
  [399] = {.lex_state = 64},
  [400] = {.lex_state = 64},
  [401] = {.lex_state = 64},
  [402] = {.lex_state = 64},
  [403] = {.lex_state = 64},
  [404] = {.lex_state = 64},
  [405] = {.lex_state = 64},
  [406] = {.lex_state = 64},
  [407] = {.lex_state = 64},
  [408] = {.lex_state = 64},
  [409] = {.lex_state = 64},
  [410] = {.lex_state = 64},
  [411] = {.lex_state = 64},
  [412] = {.lex_state = 64},
  [413] = {.lex_state = 64},
  [414] = {.lex_state = 64},
  [415] = {.lex_state = 64},
  [416] = {.lex_state = 64},
  [417] = {.lex_state = 64},
  [418] = {.lex_state = 64},
  [419] = {.lex_state = 64},
  [420] = {.lex_state = 64},
  [421] = {.lex_state = 64},
  [422] = {.lex_state = 64},
  [423] = {.lex_state = 64},
  [424] = {.lex_state = 64},
  [425] = {.lex_state = 64},
  [426] = {.lex_state = 64},
  [427] = {.lex_state = 64},
  [428] = {.lex_state = 64},
  [429] = {.lex_state = 64},
  [430] = {.lex_state = 64},
  [431] = {.lex_state = 64},
  [432] = {.lex_state = 64},
  [433] = {.lex_state = 64},
  [434] = {.lex_state = 64},
  [435] = {.lex_state = 64},
  [436] = {.lex_state = 64},
  [437] = {.lex_state = 64},
  [438] = {.lex_state = 64},
  [439] = {.lex_state = 64},
  [440] = {.lex_state = 64},
  [441] = {.lex_state = 64},
  [442] = {.lex_state = 64},
  [443] = {.lex_state = 64},
  [444] = {.lex_state = 64},
  [445] = {.lex_state = 64},
  [446] = {.lex_state = 64},
  [447] = {.lex_state = 64},
  [448] = {.lex_state = 64},
  [449] = {.lex_state = 64},
  [450] = {.lex_state = 64},
  [451] = {.lex_state = 64},
  [452] = {.lex_state = 64},
  [453] = {.lex_state = 64},
  [454] = {.lex_state = 64},
  [455] = {.lex_state = 64},
  [456] = {.lex_state = 64},
  [457] = {.lex_state = 64},
  [458] = {.lex_state = 64},
  [459] = {.lex_state = 64},
  [460] = {.lex_state = 64},
  [461] = {.lex_state = 64},
  [462] = {.lex_state = 64},
  [463] = {.lex_state = 64},
  [464] = {.lex_state = 64},
  [465] = {.lex_state = 64},
  [466] = {.lex_state = 64},
  [467] = {.lex_state = 64},
  [468] = {.lex_state = 64},
  [469] = {.lex_state = 64},
  [470] = {.lex_state = 64},
  [471] = {.lex_state = 64},
  [472] = {.lex_state = 64},
  [473] = {.lex_state = 64},
  [474] = {.lex_state = 64},
  [475] = {.lex_state = 64},
  [476] = {.lex_state = 64},
  [477] = {.lex_state = 64},
  [478] = {.lex_state = 64},
  [479] = {.lex_state = 64},
  [480] = {.lex_state = 64},
  [481] = {.lex_state = 64},
  [482] = {.lex_state = 64},
  [483] = {.lex_state = 64},
  [484] = {.lex_state = 64},
  [485] = {.lex_state = 64},
  [486] = {.lex_state = 64},
  [487] = {.lex_state = 64},
  [488] = {.lex_state = 64},
  [489] = {.lex_state = 64},
  [490] = {.lex_state = 64},
  [491] = {.lex_state = 64},
  [492] = {.lex_state = 64},
  [493] = {.lex_state = 64},
  [494] = {.lex_state = 64},
  [495] = {.lex_state = 64},
  [496] = {.lex_state = 64},
  [497] = {.lex_state = 64},
  [498] = {.lex_state = 64},
  [499] = {.lex_state = 64},
  [500] = {.lex_state = 64},
  [501] = {.lex_state = 64},
  [502] = {.lex_state = 64},
  [503] = {.lex_state = 64},
  [504] = {.lex_state = 64},
  [505] = {.lex_state = 64},
  [506] = {.lex_state = 64},
  [507] = {.lex_state = 64},
  [508] = {.lex_state = 64},
  [509] = {.lex_state = 64},
  [510] = {.lex_state = 64},
  [511] = {.lex_state = 64},
  [512] = {.lex_state = 64},
  [513] = {.lex_state = 64},
  [514] = {.lex_state = 64},
  [515] = {.lex_state = 64},
  [516] = {.lex_state = 64},
  [517] = {.lex_state = 64},
  [518] = {.lex_state = 64},
  [519] = {.lex_state = 64},
  [520] = {.lex_state = 64},
  [521] = {.lex_state = 64},
  [522] = {.lex_state = 64},
  [523] = {.lex_state = 64},
  [524] = {.lex_state = 64},
  [525] = {.lex_state = 64},
  [526] = {.lex_state = 64},
  [527] = {.lex_state = 64},
  [528] = {.lex_state = 64},
  [529] = {.lex_state = 64},
  [530] = {.lex_state = 64},
  [531] = {.lex_state = 64},
  [532] = {.lex_state = 64},
  [533] = {.lex_state = 64},
  [534] = {.lex_state = 64},
  [535] = {.lex_state = 64},
  [536] = {.lex_state = 64},
  [537] = {.lex_state = 64},
  [538] = {.lex_state = 64},
  [539] = {.lex_state = 64},
  [540] = {.lex_state = 64},
  [541] = {.lex_state = 64},
  [542] = {.lex_state = 64},
  [543] = {.lex_state = 64},
  [544] = {.lex_state = 64},
  [545] = {.lex_state = 64},
  [546] = {.lex_state = 64},
  [547] = {.lex_state = 64},
  [548] = {.lex_state = 64},
  [549] = {.lex_state = 64},
  [550] = {.lex_state = 64},
  [551] = {.lex_state = 64},
  [552] = {.lex_state = 64},
  [553] = {.lex_state = 64},
  [554] = {.lex_state = 64},
  [555] = {.lex_state = 64},
  [556] = {.lex_state = 64},
  [557] = {.lex_state = 64},
  [558] = {.lex_state = 64},
  [559] = {.lex_state = 64},
  [560] = {.lex_state = 64},
  [561] = {.lex_state = 64},
  [562] = {.lex_state = 64},
  [563] = {.lex_state = 64},
  [564] = {.lex_state = 64},
  [565] = {.lex_state = 64},
  [566] = {.lex_state = 64},
  [567] = {.lex_state = 64},
  [568] = {.lex_state = 64},
  [569] = {.lex_state = 64},
  [570] = {.lex_state = 64},
  [571] = {.lex_state = 64},
  [572] = {.lex_state = 64},
  [573] = {.lex_state = 64},
  [574] = {.lex_state = 64},
  [575] = {.lex_state = 64},
  [576] = {.lex_state = 64},
  [577] = {.lex_state = 64},
  [578] = {.lex_state = 64},
  [579] = {.lex_state = 64},
  [580] = {.lex_state = 64},
  [581] = {.lex_state = 64},
  [582] = {.lex_state = 64},
  [583] = {.lex_state = 64},
  [584] = {.lex_state = 64},
  [585] = {.lex_state = 64},
  [586] = {.lex_state = 64},
  [587] = {.lex_state = 64},
  [588] = {.lex_state = 64},
  [589] = {.lex_state = 64},
  [590] = {.lex_state = 64},
  [591] = {.lex_state = 64},
  [592] = {.lex_state = 64},
  [593] = {.lex_state = 64},
  [594] = {.lex_state = 64},
  [595] = {.lex_state = 64},
  [596] = {.lex_state = 64},
  [597] = {.lex_state = 64},
  [598] = {.lex_state = 64},
  [599] = {.lex_state = 64},
  [600] = {.lex_state = 64},
  [601] = {.lex_state = 64},
  [602] = {.lex_state = 64},
  [603] = {.lex_state = 64},
  [604] = {.lex_state = 64},
  [605] = {.lex_state = 64},
  [606] = {.lex_state = 64},
  [607] = {.lex_state = 64},
  [608] = {.lex_state = 64},
  [609] = {.lex_state = 64},
  [610] = {.lex_state = 64},
  [611] = {.lex_state = 64},
  [612] = {.lex_state = 64},
  [613] = {.lex_state = 64},
  [614] = {.lex_state = 64},
  [615] = {.lex_state = 64},
  [616] = {.lex_state = 64},
  [617] = {.lex_state = 64},
  [618] = {.lex_state = 64},
  [619] = {.lex_state = 64},
  [620] = {.lex_state = 64},
  [621] = {.lex_state = 64},
  [622] = {.lex_state = 64},
  [623] = {.lex_state = 64},
  [624] = {.lex_state = 64},
  [625] = {.lex_state = 64},
  [626] = {.lex_state = 64},
  [627] = {.lex_state = 64},
  [628] = {.lex_state = 64},
  [629] = {.lex_state = 64},
  [630] = {.lex_state = 64},
  [631] = {.lex_state = 64},
  [632] = {.lex_state = 64},
  [633] = {.lex_state = 64},
  [634] = {.lex_state = 64},
  [635] = {.lex_state = 64},
  [636] = {.lex_state = 64},
  [637] = {.lex_state = 64},
  [638] = {.lex_state = 64},
  [639] = {.lex_state = 64},
  [640] = {.lex_state = 64},
  [641] = {.lex_state = 64},
  [642] = {.lex_state = 64},
  [643] = {.lex_state = 64},
  [644] = {.lex_state = 64},
  [645] = {.lex_state = 64},
  [646] = {.lex_state = 64},
  [647] = {.lex_state = 64},
  [648] = {.lex_state = 64},
  [649] = {.lex_state = 64},
  [650] = {.lex_state = 64},
  [651] = {.lex_state = 64},
  [652] = {.lex_state = 64},
  [653] = {.lex_state = 64},
  [654] = {.lex_state = 64},
  [655] = {.lex_state = 64},
  [656] = {.lex_state = 64},
  [657] = {.lex_state = 64},
  [658] = {.lex_state = 64},
  [659] = {.lex_state = 64},
  [660] = {.lex_state = 64},
  [661] = {.lex_state = 64},
  [662] = {.lex_state = 64},
  [663] = {.lex_state = 64},
  [664] = {.lex_state = 64},
  [665] = {.lex_state = 64},
  [666] = {.lex_state = 64},
  [667] = {.lex_state = 64},
  [668] = {.lex_state = 64},
  [669] = {.lex_state = 64},
  [670] = {.lex_state = 64},
  [671] = {.lex_state = 64},
  [672] = {.lex_state = 64},
  [673] = {.lex_state = 64},
  [674] = {.lex_state = 64},
  [675] = {.lex_state = 64},
  [676] = {.lex_state = 64},
  [677] = {.lex_state = 64},
  [678] = {.lex_state = 64},
  [679] = {.lex_state = 64},
  [680] = {.lex_state = 64},
  [681] = {.lex_state = 64},
  [682] = {.lex_state = 64},
  [683] = {.lex_state = 64},
  [684] = {.lex_state = 64},
  [685] = {.lex_state = 64},
  [686] = {.lex_state = 64},
  [687] = {.lex_state = 64},
  [688] = {.lex_state = 64},
  [689] = {.lex_state = 64},
  [690] = {.lex_state = 64},
  [691] = {.lex_state = 64},
  [692] = {.lex_state = 64},
  [693] = {.lex_state = 64},
  [694] = {.lex_state = 64},
  [695] = {.lex_state = 64},
  [696] = {.lex_state = 64},
  [697] = {.lex_state = 64},
  [698] = {.lex_state = 64},
  [699] = {.lex_state = 64},
  [700] = {.lex_state = 64},
  [701] = {.lex_state = 64},
  [702] = {.lex_state = 64},
  [703] = {.lex_state = 64},
  [704] = {.lex_state = 64},
  [705] = {.lex_state = 64},
  [706] = {.lex_state = 64},
  [707] = {.lex_state = 64},
  [708] = {.lex_state = 64},
  [709] = {.lex_state = 64},
  [710] = {.lex_state = 64},
  [711] = {.lex_state = 64},
  [712] = {.lex_state = 64},
  [713] = {.lex_state = 64},
  [714] = {.lex_state = 64},
  [715] = {.lex_state = 64},
  [716] = {.lex_state = 64},
  [717] = {.lex_state = 64},
  [718] = {.lex_state = 64},
  [719] = {.lex_state = 64},
  [720] = {.lex_state = 64},
  [721] = {.lex_state = 64},
  [722] = {.lex_state = 64},
  [723] = {.lex_state = 64},
  [724] = {.lex_state = 64},
  [725] = {.lex_state = 64},
  [726] = {.lex_state = 64},
  [727] = {.lex_state = 64},
  [728] = {.lex_state = 64},
  [729] = {.lex_state = 64},
  [730] = {.lex_state = 64},
  [731] = {.lex_state = 64},
  [732] = {.lex_state = 64},
  [733] = {.lex_state = 64},
  [734] = {.lex_state = 64},
  [735] = {.lex_state = 64},
  [736] = {.lex_state = 64},
  [737] = {.lex_state = 64},
  [738] = {.lex_state = 64},
  [739] = {.lex_state = 64},
  [740] = {.lex_state = 64},
  [741] = {.lex_state = 64},
  [742] = {.lex_state = 64},
  [743] = {.lex_state = 64},
  [744] = {.lex_state = 64},
  [745] = {.lex_state = 64},
  [746] = {.lex_state = 64},
  [747] = {.lex_state = 64},
  [748] = {.lex_state = 64},
  [749] = {.lex_state = 64},
  [750] = {.lex_state = 64},
  [751] = {.lex_state = 64},
  [752] = {.lex_state = 64},
  [753] = {.lex_state = 64},
  [754] = {.lex_state = 64},
  [755] = {.lex_state = 64},
  [756] = {.lex_state = 64},
  [757] = {.lex_state = 64},
  [758] = {.lex_state = 64},
  [759] = {.lex_state = 64},
  [760] = {.lex_state = 64},
  [761] = {.lex_state = 64},
  [762] = {.lex_state = 64},
  [763] = {.lex_state = 64},
  [764] = {.lex_state = 64},
  [765] = {.lex_state = 64},
  [766] = {.lex_state = 64},
  [767] = {.lex_state = 64},
  [768] = {.lex_state = 64},
  [769] = {.lex_state = 64},
  [770] = {.lex_state = 64},
  [771] = {.lex_state = 64},
  [772] = {.lex_state = 64},
  [773] = {.lex_state = 64},
  [774] = {.lex_state = 64},
  [775] = {.lex_state = 64},
  [776] = {.lex_state = 64},
  [777] = {.lex_state = 64},
  [778] = {.lex_state = 64},
  [779] = {.lex_state = 64},
  [780] = {.lex_state = 64},
  [781] = {.lex_state = 64},
  [782] = {.lex_state = 64},
  [783] = {.lex_state = 64},
  [784] = {.lex_state = 64},
  [785] = {.lex_state = 64},
  [786] = {.lex_state = 64},
  [787] = {.lex_state = 64},
  [788] = {.lex_state = 64},
  [789] = {.lex_state = 64},
  [790] = {.lex_state = 64},
  [791] = {.lex_state = 64},
  [792] = {.lex_state = 64},
  [793] = {.lex_state = 64},
  [794] = {.lex_state = 64},
  [795] = {.lex_state = 64},
  [796] = {.lex_state = 64},
  [797] = {.lex_state = 64},
  [798] = {.lex_state = 64},
  [799] = {.lex_state = 64},
  [800] = {.lex_state = 64},
  [801] = {.lex_state = 64},
  [802] = {.lex_state = 64},
  [803] = {.lex_state = 64},
  [804] = {.lex_state = 64},
  [805] = {.lex_state = 64},
  [806] = {.lex_state = 64},
  [807] = {.lex_state = 64},
  [808] = {.lex_state = 64},
  [809] = {.lex_state = 64},
  [810] = {.lex_state = 64},
  [811] = {.lex_state = 64},
  [812] = {.lex_state = 64},
  [813] = {.lex_state = 64},
  [814] = {.lex_state = 64},
  [815] = {.lex_state = 64},
  [816] = {.lex_state = 64},
  [817] = {.lex_state = 64},
  [818] = {.lex_state = 64},
  [819] = {.lex_state = 64},
  [820] = {.lex_state = 64},
  [821] = {.lex_state = 64},
  [822] = {.lex_state = 64},
  [823] = {.lex_state = 64},
  [824] = {.lex_state = 64},
  [825] = {.lex_state = 64},
  [826] = {.lex_state = 64},
  [827] = {.lex_state = 64},
  [828] = {.lex_state = 64},
  [829] = {.lex_state = 64},
  [830] = {.lex_state = 64},
  [831] = {.lex_state = 64},
  [832] = {.lex_state = 64},
  [833] = {.lex_state = 64},
  [834] = {.lex_state = 64},
  [835] = {.lex_state = 64},
  [836] = {.lex_state = 64},
  [837] = {.lex_state = 64},
  [838] = {.lex_state = 64},
  [839] = {.lex_state = 64},
  [840] = {.lex_state = 64},
  [841] = {.lex_state = 64},
  [842] = {.lex_state = 64},
  [843] = {.lex_state = 64},
  [844] = {.lex_state = 64},
  [845] = {.lex_state = 64},
  [846] = {.lex_state = 64},
  [847] = {.lex_state = 64},
  [848] = {.lex_state = 64},
  [849] = {.lex_state = 64},
  [850] = {.lex_state = 64},
  [851] = {.lex_state = 64},
  [852] = {.lex_state = 64},
  [853] = {.lex_state = 64},
  [854] = {.lex_state = 64},
  [855] = {.lex_state = 64},
  [856] = {.lex_state = 64},
  [857] = {.lex_state = 64},
  [858] = {.lex_state = 64},
  [859] = {.lex_state = 64},
  [860] = {.lex_state = 64},
  [861] = {.lex_state = 64},
  [862] = {.lex_state = 64},
  [863] = {.lex_state = 64},
  [864] = {.lex_state = 64},
  [865] = {.lex_state = 64},
  [866] = {.lex_state = 64},
  [867] = {.lex_state = 64},
  [868] = {.lex_state = 64},
  [869] = {.lex_state = 64},
  [870] = {.lex_state = 64},
  [871] = {.lex_state = 64},
  [872] = {.lex_state = 64},
  [873] = {.lex_state = 64},
  [874] = {.lex_state = 64},
  [875] = {.lex_state = 64},
  [876] = {.lex_state = 64},
  [877] = {.lex_state = 64},
  [878] = {.lex_state = 64},
  [879] = {.lex_state = 64},
  [880] = {.lex_state = 64},
  [881] = {.lex_state = 64},
  [882] = {.lex_state = 64},
  [883] = {.lex_state = 64},
  [884] = {.lex_state = 64},
  [885] = {.lex_state = 64},
  [886] = {.lex_state = 64},
  [887] = {.lex_state = 64},
  [888] = {.lex_state = 64},
  [889] = {.lex_state = 64},
  [890] = {.lex_state = 64},
  [891] = {.lex_state = 64},
  [892] = {.lex_state = 64},
  [893] = {.lex_state = 64},
  [894] = {.lex_state = 64},
  [895] = {.lex_state = 64},
  [896] = {.lex_state = 64},
  [897] = {.lex_state = 64},
  [898] = {.lex_state = 64},
  [899] = {.lex_state = 64},
  [900] = {.lex_state = 64},
  [901] = {.lex_state = 64},
  [902] = {.lex_state = 64},
  [903] = {.lex_state = 64},
  [904] = {.lex_state = 64},
  [905] = {.lex_state = 64},
  [906] = {.lex_state = 64},
  [907] = {.lex_state = 64},
  [908] = {.lex_state = 64},
  [909] = {.lex_state = 64},
  [910] = {.lex_state = 64},
  [911] = {.lex_state = 64},
  [912] = {.lex_state = 2, .external_lex_state = 2},
  [913] = {.lex_state = 2, .external_lex_state = 2},
  [914] = {.lex_state = 2, .external_lex_state = 2},
  [915] = {.lex_state = 2, .external_lex_state = 2},
  [916] = {.lex_state = 2, .external_lex_state = 2},
  [917] = {.lex_state = 2, .external_lex_state = 2},
  [918] = {.lex_state = 2, .external_lex_state = 2},
  [919] = {.lex_state = 2, .external_lex_state = 2},
  [920] = {.lex_state = 2, .external_lex_state = 2},
  [921] = {.lex_state = 2, .external_lex_state = 2},
  [922] = {.lex_state = 2, .external_lex_state = 2},
  [923] = {.lex_state = 64},
  [924] = {.lex_state = 64},
  [925] = {.lex_state = 64},
  [926] = {.lex_state = 64},
  [927] = {.lex_state = 64},
  [928] = {.lex_state = 64},
  [929] = {.lex_state = 64},
  [930] = {.lex_state = 2, .external_lex_state = 2},
  [931] = {.lex_state = 2, .external_lex_state = 2},
  [932] = {.lex_state = 2, .external_lex_state = 2},
  [933] = {.lex_state = 2, .external_lex_state = 2},
  [934] = {.lex_state = 2, .external_lex_state = 2},
  [935] = {.lex_state = 2, .external_lex_state = 2},
  [936] = {.lex_state = 2, .external_lex_state = 2},
  [937] = {.lex_state = 2, .external_lex_state = 2},
  [938] = {.lex_state = 2, .external_lex_state = 2},
  [939] = {.lex_state = 2, .external_lex_state = 2},
  [940] = {.lex_state = 2, .external_lex_state = 2},
  [941] = {.lex_state = 2, .external_lex_state = 2},
  [942] = {.lex_state = 2, .external_lex_state = 2},
  [943] = {.lex_state = 2, .external_lex_state = 2},
  [944] = {.lex_state = 2, .external_lex_state = 2},
  [945] = {.lex_state = 2, .external_lex_state = 2},
  [946] = {.lex_state = 2, .external_lex_state = 2},
  [947] = {.lex_state = 2, .external_lex_state = 2},
  [948] = {.lex_state = 2, .external_lex_state = 2},
  [949] = {.lex_state = 2, .external_lex_state = 2},
  [950] = {.lex_state = 2, .external_lex_state = 2},
  [951] = {.lex_state = 11},
  [952] = {.lex_state = 11},
  [953] = {.lex_state = 11},
  [954] = {.lex_state = 11},
  [955] = {.lex_state = 11},
  [956] = {.lex_state = 11},
  [957] = {.lex_state = 11},
  [958] = {.lex_state = 11},
  [959] = {.lex_state = 11},
  [960] = {.lex_state = 11},
  [961] = {.lex_state = 11},
  [962] = {.lex_state = 3, .external_lex_state = 2},
  [963] = {.lex_state = 3, .external_lex_state = 3},
  [964] = {.lex_state = 3, .external_lex_state = 2},
  [965] = {.lex_state = 3, .external_lex_state = 3},
  [966] = {.lex_state = 3, .external_lex_state = 3},
  [967] = {.lex_state = 2, .external_lex_state = 2},
  [968] = {.lex_state = 3, .external_lex_state = 4},
  [969] = {.lex_state = 2, .external_lex_state = 2},
  [970] = {.lex_state = 2, .external_lex_state = 2},
  [971] = {.lex_state = 2, .external_lex_state = 2},
  [972] = {.lex_state = 2, .external_lex_state = 2},
  [973] = {.lex_state = 2, .external_lex_state = 2},
  [974] = {.lex_state = 2, .external_lex_state = 2},
  [975] = {.lex_state = 2, .external_lex_state = 2},
  [976] = {.lex_state = 2, .external_lex_state = 3},
  [977] = {.lex_state = 3, .external_lex_state = 4},
  [978] = {.lex_state = 3, .external_lex_state = 4},
  [979] = {.lex_state = 2, .external_lex_state = 3},
  [980] = {.lex_state = 3, .external_lex_state = 3},
  [981] = {.lex_state = 2, .external_lex_state = 3},
  [982] = {.lex_state = 3, .external_lex_state = 4},
  [983] = {.lex_state = 3, .external_lex_state = 4},
  [984] = {.lex_state = 2, .external_lex_state = 2},
  [985] = {.lex_state = 2, .external_lex_state = 2},
  [986] = {.lex_state = 2, .external_lex_state = 2},
  [987] = {.lex_state = 2, .external_lex_state = 2},
  [988] = {.lex_state = 3, .external_lex_state = 3},
  [989] = {.lex_state = 2, .external_lex_state = 3},
  [990] = {.lex_state = 2, .external_lex_state = 2},
  [991] = {.lex_state = 2, .external_lex_state = 3},
  [992] = {.lex_state = 3, .external_lex_state = 3},
  [993] = {.lex_state = 2, .external_lex_state = 3},
  [994] = {.lex_state = 2, .external_lex_state = 2},
  [995] = {.lex_state = 2, .external_lex_state = 2},
  [996] = {.lex_state = 3, .external_lex_state = 3},
  [997] = {.lex_state = 3, .external_lex_state = 3},
  [998] = {.lex_state = 2, .external_lex_state = 2},
  [999] = {.lex_state = 2, .external_lex_state = 2},
  [1000] = {.lex_state = 3, .external_lex_state = 3},
  [1001] = {.lex_state = 2, .external_lex_state = 2},
  [1002] = {.lex_state = 3, .external_lex_state = 3},
  [1003] = {.lex_state = 64, .external_lex_state = 5},
  [1004] = {.lex_state = 2, .external_lex_state = 3},
  [1005] = {.lex_state = 2, .external_lex_state = 3},
  [1006] = {.lex_state = 2, .external_lex_state = 3},
  [1007] = {.lex_state = 64, .external_lex_state = 5},
  [1008] = {.lex_state = 2, .external_lex_state = 3},
  [1009] = {.lex_state = 2, .external_lex_state = 2},
  [1010] = {.lex_state = 2, .external_lex_state = 3},
  [1011] = {.lex_state = 2, .external_lex_state = 3},
  [1012] = {.lex_state = 2, .external_lex_state = 3},
  [1013] = {.lex_state = 2, .external_lex_state = 2},
  [1014] = {.lex_state = 2, .external_lex_state = 3},
  [1015] = {.lex_state = 11},
  [1016] = {.lex_state = 64},
  [1017] = {.lex_state = 3, .external_lex_state = 3},
  [1018] = {.lex_state = 2, .external_lex_state = 3},
  [1019] = {.lex_state = 2, .external_lex_state = 2},
  [1020] = {.lex_state = 2, .external_lex_state = 3},
  [1021] = {.lex_state = 2, .external_lex_state = 3},
  [1022] = {.lex_state = 64, .external_lex_state = 5},
  [1023] = {.lex_state = 2, .external_lex_state = 3},
  [1024] = {.lex_state = 3, .external_lex_state = 3},
  [1025] = {.lex_state = 2, .external_lex_state = 2},
  [1026] = {.lex_state = 2, .external_lex_state = 2},
  [1027] = {.lex_state = 2, .external_lex_state = 2},
  [1028] = {.lex_state = 2, .external_lex_state = 3},
  [1029] = {.lex_state = 64},
  [1030] = {.lex_state = 64, .external_lex_state = 5},
  [1031] = {.lex_state = 2, .external_lex_state = 3},
  [1032] = {.lex_state = 64, .external_lex_state = 5},
  [1033] = {.lex_state = 2, .external_lex_state = 3},
  [1034] = {.lex_state = 2, .external_lex_state = 2},
  [1035] = {.lex_state = 64, .external_lex_state = 5},
  [1036] = {.lex_state = 2, .external_lex_state = 3},
  [1037] = {.lex_state = 64},
  [1038] = {.lex_state = 64, .external_lex_state = 5},
  [1039] = {.lex_state = 2, .external_lex_state = 3},
  [1040] = {.lex_state = 64, .external_lex_state = 5},
  [1041] = {.lex_state = 2, .external_lex_state = 3},
  [1042] = {.lex_state = 64},
  [1043] = {.lex_state = 2, .external_lex_state = 3},
  [1044] = {.lex_state = 2, .external_lex_state = 3},
  [1045] = {.lex_state = 64},
  [1046] = {.lex_state = 2, .external_lex_state = 3},
  [1047] = {.lex_state = 2, .external_lex_state = 3},
  [1048] = {.lex_state = 2, .external_lex_state = 3},
  [1049] = {.lex_state = 2, .external_lex_state = 3},
  [1050] = {.lex_state = 64, .external_lex_state = 5},
  [1051] = {.lex_state = 64, .external_lex_state = 5},
  [1052] = {.lex_state = 64},
  [1053] = {.lex_state = 64, .external_lex_state = 5},
  [1054] = {.lex_state = 64, .external_lex_state = 5},
  [1055] = {.lex_state = 64, .external_lex_state = 5},
  [1056] = {.lex_state = 64, .external_lex_state = 5},
  [1057] = {.lex_state = 64, .external_lex_state = 5},
  [1058] = {.lex_state = 64, .external_lex_state = 5},
  [1059] = {.lex_state = 64},
  [1060] = {.lex_state = 64, .external_lex_state = 5},
  [1061] = {.lex_state = 64},
  [1062] = {.lex_state = 64, .external_lex_state = 5},
  [1063] = {.lex_state = 64},
  [1064] = {.lex_state = 64},
  [1065] = {.lex_state = 64, .external_lex_state = 5},
  [1066] = {.lex_state = 64, .external_lex_state = 5},
  [1067] = {.lex_state = 64},
  [1068] = {.lex_state = 64},
  [1069] = {.lex_state = 64},
  [1070] = {.lex_state = 64},
  [1071] = {.lex_state = 64},
  [1072] = {.lex_state = 64},
  [1073] = {.lex_state = 64},
  [1074] = {.lex_state = 64},
  [1075] = {.lex_state = 64},
  [1076] = {.lex_state = 64},
  [1077] = {.lex_state = 64},
  [1078] = {.lex_state = 64},
  [1079] = {.lex_state = 64},
  [1080] = {.lex_state = 64},
  [1081] = {.lex_state = 64},
  [1082] = {.lex_state = 64},
  [1083] = {.lex_state = 64},
  [1084] = {.lex_state = 64},
  [1085] = {.lex_state = 64},
  [1086] = {.lex_state = 64},
  [1087] = {.lex_state = 64},
  [1088] = {.lex_state = 64},
  [1089] = {.lex_state = 64},
  [1090] = {.lex_state = 64},
  [1091] = {.lex_state = 64},
  [1092] = {.lex_state = 64},
  [1093] = {.lex_state = 64},
  [1094] = {.lex_state = 64},
  [1095] = {.lex_state = 64},
  [1096] = {.lex_state = 64},
  [1097] = {.lex_state = 64},
  [1098] = {.lex_state = 64},
  [1099] = {.lex_state = 64},
  [1100] = {.lex_state = 64},
  [1101] = {.lex_state = 64},
  [1102] = {.lex_state = 64},
  [1103] = {.lex_state = 64},
  [1104] = {.lex_state = 64},
  [1105] = {.lex_state = 11},
  [1106] = {.lex_state = 64},
  [1107] = {.lex_state = 64},
  [1108] = {.lex_state = 64},
  [1109] = {.lex_state = 64},
  [1110] = {.lex_state = 64},
  [1111] = {.lex_state = 64},
  [1112] = {.lex_state = 64},
  [1113] = {.lex_state = 64},
  [1114] = {.lex_state = 64},
  [1115] = {.lex_state = 64},
  [1116] = {.lex_state = 64},
  [1117] = {.lex_state = 64},
  [1118] = {.lex_state = 64},
  [1119] = {.lex_state = 64},
  [1120] = {.lex_state = 64},
  [1121] = {.lex_state = 64},
  [1122] = {.lex_state = 64},
  [1123] = {.lex_state = 64},
  [1124] = {.lex_state = 64},
  [1125] = {.lex_state = 64},
  [1126] = {.lex_state = 64},
  [1127] = {.lex_state = 64},
  [1128] = {.lex_state = 64},
  [1129] = {.lex_state = 64},
  [1130] = {.lex_state = 64},
  [1131] = {.lex_state = 64},
  [1132] = {.lex_state = 64},
  [1133] = {.lex_state = 64},
  [1134] = {.lex_state = 64},
  [1135] = {.lex_state = 64},
  [1136] = {.lex_state = 64},
  [1137] = {.lex_state = 64},
  [1138] = {.lex_state = 64},
  [1139] = {.lex_state = 64},
  [1140] = {.lex_state = 64},
  [1141] = {.lex_state = 64},
  [1142] = {.lex_state = 64},
  [1143] = {.lex_state = 64},
  [1144] = {.lex_state = 64},
  [1145] = {.lex_state = 64},
  [1146] = {.lex_state = 64},
  [1147] = {.lex_state = 64},
  [1148] = {.lex_state = 64},
  [1149] = {.lex_state = 64},
  [1150] = {.lex_state = 64},
  [1151] = {.lex_state = 64},
  [1152] = {.lex_state = 64},
  [1153] = {.lex_state = 64},
  [1154] = {.lex_state = 64},
  [1155] = {.lex_state = 64},
  [1156] = {.lex_state = 64},
  [1157] = {.lex_state = 64},
  [1158] = {.lex_state = 64},
  [1159] = {.lex_state = 64},
  [1160] = {.lex_state = 64},
  [1161] = {.lex_state = 64},
  [1162] = {.lex_state = 64},
  [1163] = {.lex_state = 64},
  [1164] = {.lex_state = 64},
  [1165] = {.lex_state = 64},
  [1166] = {.lex_state = 64},
  [1167] = {.lex_state = 64},
  [1168] = {.lex_state = 64},
  [1169] = {.lex_state = 64},
  [1170] = {.lex_state = 64},
  [1171] = {.lex_state = 64},
  [1172] = {.lex_state = 64},
  [1173] = {.lex_state = 64},
  [1174] = {.lex_state = 64},
  [1175] = {.lex_state = 64},
  [1176] = {.lex_state = 64},
  [1177] = {.lex_state = 64},
  [1178] = {.lex_state = 64},
  [1179] = {.lex_state = 64},
  [1180] = {.lex_state = 64},
  [1181] = {.lex_state = 64},
  [1182] = {.lex_state = 64},
  [1183] = {.lex_state = 64},
  [1184] = {.lex_state = 64},
  [1185] = {.lex_state = 64},
  [1186] = {.lex_state = 64},
  [1187] = {.lex_state = 64},
  [1188] = {.lex_state = 64},
  [1189] = {.lex_state = 64},
  [1190] = {.lex_state = 64},
  [1191] = {.lex_state = 64},
  [1192] = {.lex_state = 64},
  [1193] = {.lex_state = 64},
  [1194] = {.lex_state = 64},
  [1195] = {.lex_state = 64},
  [1196] = {.lex_state = 64},
  [1197] = {.lex_state = 64},
  [1198] = {.lex_state = 64},
  [1199] = {.lex_state = 64},
  [1200] = {.lex_state = 64},
  [1201] = {.lex_state = 64},
  [1202] = {.lex_state = 64},
  [1203] = {.lex_state = 64},
  [1204] = {.lex_state = 64},
  [1205] = {.lex_state = 64},
  [1206] = {.lex_state = 64},
  [1207] = {.lex_state = 64},
  [1208] = {.lex_state = 64},
  [1209] = {.lex_state = 64},
  [1210] = {.lex_state = 64},
  [1211] = {.lex_state = 64},
  [1212] = {.lex_state = 64},
  [1213] = {.lex_state = 64},
  [1214] = {.lex_state = 64},
  [1215] = {.lex_state = 64},
  [1216] = {.lex_state = 64},
  [1217] = {.lex_state = 2, .external_lex_state = 2},
  [1218] = {.lex_state = 2, .external_lex_state = 2},
  [1219] = {.lex_state = 3, .external_lex_state = 2},
  [1220] = {.lex_state = 2, .external_lex_state = 2},
  [1221] = {.lex_state = 2, .external_lex_state = 2},
  [1222] = {.lex_state = 2, .external_lex_state = 2},
  [1223] = {.lex_state = 11},
  [1224] = {.lex_state = 2, .external_lex_state = 2},
  [1225] = {.lex_state = 2, .external_lex_state = 2},
  [1226] = {.lex_state = 2, .external_lex_state = 2},
  [1227] = {.lex_state = 2, .external_lex_state = 2},
  [1228] = {.lex_state = 11},
  [1229] = {.lex_state = 3, .external_lex_state = 3},
  [1230] = {.lex_state = 2, .external_lex_state = 2},
  [1231] = {.lex_state = 11},
  [1232] = {.lex_state = 2, .external_lex_state = 2},
  [1233] = {.lex_state = 11},
  [1234] = {.lex_state = 3, .external_lex_state = 3},
  [1235] = {.lex_state = 11},
  [1236] = {.lex_state = 2, .external_lex_state = 2},
  [1237] = {.lex_state = 3, .external_lex_state = 2},
  [1238] = {.lex_state = 2, .external_lex_state = 2},
  [1239] = {.lex_state = 11},
  [1240] = {.lex_state = 2, .external_lex_state = 2},
  [1241] = {.lex_state = 11},
  [1242] = {.lex_state = 11},
  [1243] = {.lex_state = 3, .external_lex_state = 4},
  [1244] = {.lex_state = 11},
  [1245] = {.lex_state = 11},
  [1246] = {.lex_state = 11},
  [1247] = {.lex_state = 2, .external_lex_state = 2},
  [1248] = {.lex_state = 2, .external_lex_state = 3},
  [1249] = {.lex_state = 11},
  [1250] = {.lex_state = 11},
  [1251] = {.lex_state = 3, .external_lex_state = 4},
  [1252] = {.lex_state = 11},
  [1253] = {.lex_state = 11},
  [1254] = {.lex_state = 11},
  [1255] = {.lex_state = 11},
  [1256] = {.lex_state = 11},
  [1257] = {.lex_state = 11},
  [1258] = {.lex_state = 11},
  [1259] = {.lex_state = 11},
  [1260] = {.lex_state = 3, .external_lex_state = 4},
  [1261] = {.lex_state = 2, .external_lex_state = 2},
  [1262] = {.lex_state = 3, .external_lex_state = 4},
  [1263] = {.lex_state = 2, .external_lex_state = 3},
  [1264] = {.lex_state = 2, .external_lex_state = 3},
  [1265] = {.lex_state = 3, .external_lex_state = 3},
  [1266] = {.lex_state = 11},
  [1267] = {.lex_state = 3, .external_lex_state = 4},
  [1268] = {.lex_state = 2, .external_lex_state = 2},
  [1269] = {.lex_state = 3, .external_lex_state = 3},
  [1270] = {.lex_state = 2, .external_lex_state = 2},
  [1271] = {.lex_state = 64},
  [1272] = {.lex_state = 3, .external_lex_state = 3},
  [1273] = {.lex_state = 2, .external_lex_state = 3},
  [1274] = {.lex_state = 2, .external_lex_state = 2},
  [1275] = {.lex_state = 2, .external_lex_state = 2},
  [1276] = {.lex_state = 64},
  [1277] = {.lex_state = 2, .external_lex_state = 3},
  [1278] = {.lex_state = 3, .external_lex_state = 3},
  [1279] = {.lex_state = 2, .external_lex_state = 2},
  [1280] = {.lex_state = 2, .external_lex_state = 3},
  [1281] = {.lex_state = 64},
  [1282] = {.lex_state = 2, .external_lex_state = 2},
  [1283] = {.lex_state = 3, .external_lex_state = 3},
  [1284] = {.lex_state = 2, .external_lex_state = 2},
  [1285] = {.lex_state = 2, .external_lex_state = 2},
  [1286] = {.lex_state = 3, .external_lex_state = 3},
  [1287] = {.lex_state = 2, .external_lex_state = 2},
  [1288] = {.lex_state = 2, .external_lex_state = 2},
  [1289] = {.lex_state = 2, .external_lex_state = 2},
  [1290] = {.lex_state = 2, .external_lex_state = 3},
  [1291] = {.lex_state = 2, .external_lex_state = 2},
  [1292] = {.lex_state = 13},
  [1293] = {.lex_state = 3, .external_lex_state = 3},
  [1294] = {.lex_state = 13},
  [1295] = {.lex_state = 13},
  [1296] = {.lex_state = 13},
  [1297] = {.lex_state = 2, .external_lex_state = 3},
  [1298] = {.lex_state = 13},
  [1299] = {.lex_state = 13},
  [1300] = {.lex_state = 2, .external_lex_state = 3},
  [1301] = {.lex_state = 3, .external_lex_state = 3},
  [1302] = {.lex_state = 13},
  [1303] = {.lex_state = 3, .external_lex_state = 3},
  [1304] = {.lex_state = 13},
  [1305] = {.lex_state = 13},
  [1306] = {.lex_state = 13},
  [1307] = {.lex_state = 2, .external_lex_state = 3},
  [1308] = {.lex_state = 13},
  [1309] = {.lex_state = 2, .external_lex_state = 3},
  [1310] = {.lex_state = 13},
  [1311] = {.lex_state = 2, .external_lex_state = 3},
  [1312] = {.lex_state = 13},
  [1313] = {.lex_state = 3, .external_lex_state = 3},
  [1314] = {.lex_state = 3, .external_lex_state = 3},
  [1315] = {.lex_state = 13},
  [1316] = {.lex_state = 2, .external_lex_state = 3},
  [1317] = {.lex_state = 3, .external_lex_state = 3},
  [1318] = {.lex_state = 13},
  [1319] = {.lex_state = 13},
  [1320] = {.lex_state = 13},
  [1321] = {.lex_state = 13},
  [1322] = {.lex_state = 2, .external_lex_state = 3},
  [1323] = {.lex_state = 13},
  [1324] = {.lex_state = 2, .external_lex_state = 2},
  [1325] = {.lex_state = 13},
  [1326] = {.lex_state = 3, .external_lex_state = 3},
  [1327] = {.lex_state = 3, .external_lex_state = 3},
  [1328] = {.lex_state = 3, .external_lex_state = 3},
  [1329] = {.lex_state = 2, .external_lex_state = 2},
  [1330] = {.lex_state = 3, .external_lex_state = 3},
  [1331] = {.lex_state = 2, .external_lex_state = 3},
  [1332] = {.lex_state = 11},
  [1333] = {.lex_state = 2, .external_lex_state = 3},
  [1334] = {.lex_state = 2, .external_lex_state = 3},
  [1335] = {.lex_state = 2, .external_lex_state = 3},
  [1336] = {.lex_state = 2, .external_lex_state = 2},
  [1337] = {.lex_state = 3, .external_lex_state = 2},
  [1338] = {.lex_state = 2, .external_lex_state = 3},
  [1339] = {.lex_state = 2, .external_lex_state = 2},
  [1340] = {.lex_state = 3, .external_lex_state = 3},
  [1341] = {.lex_state = 3, .external_lex_state = 2},
  [1342] = {.lex_state = 2, .external_lex_state = 2},
  [1343] = {.lex_state = 2, .external_lex_state = 2},
  [1344] = {.lex_state = 2, .external_lex_state = 2},
  [1345] = {.lex_state = 3, .external_lex_state = 3},
  [1346] = {.lex_state = 3, .external_lex_state = 2},
  [1347] = {.lex_state = 2, .external_lex_state = 3},
  [1348] = {.lex_state = 2, .external_lex_state = 2},
  [1349] = {.lex_state = 2, .external_lex_state = 2},
  [1350] = {.lex_state = 2, .external_lex_state = 3},
  [1351] = {.lex_state = 2, .external_lex_state = 3},
  [1352] = {.lex_state = 2, .external_lex_state = 2},
  [1353] = {.lex_state = 2, .external_lex_state = 2},
  [1354] = {.lex_state = 2, .external_lex_state = 2},
  [1355] = {.lex_state = 2, .external_lex_state = 2},
  [1356] = {.lex_state = 2, .external_lex_state = 3},
  [1357] = {.lex_state = 2, .external_lex_state = 3},
  [1358] = {.lex_state = 3, .external_lex_state = 2},
  [1359] = {.lex_state = 2, .external_lex_state = 2},
  [1360] = {.lex_state = 2, .external_lex_state = 3},
  [1361] = {.lex_state = 3, .external_lex_state = 4},
  [1362] = {.lex_state = 11},
  [1363] = {.lex_state = 3, .external_lex_state = 3},
  [1364] = {.lex_state = 2, .external_lex_state = 3},
  [1365] = {.lex_state = 2, .external_lex_state = 2},
  [1366] = {.lex_state = 2, .external_lex_state = 2},
  [1367] = {.lex_state = 2, .external_lex_state = 2},
  [1368] = {.lex_state = 3, .external_lex_state = 3},
  [1369] = {.lex_state = 3, .external_lex_state = 2},
  [1370] = {.lex_state = 2, .external_lex_state = 2},
  [1371] = {.lex_state = 3, .external_lex_state = 4},
  [1372] = {.lex_state = 3, .external_lex_state = 2},
  [1373] = {.lex_state = 3, .external_lex_state = 2},
  [1374] = {.lex_state = 11},
  [1375] = {.lex_state = 3, .external_lex_state = 4},
  [1376] = {.lex_state = 3, .external_lex_state = 2},
  [1377] = {.lex_state = 3, .external_lex_state = 2},
  [1378] = {.lex_state = 2, .external_lex_state = 3},
  [1379] = {.lex_state = 3, .external_lex_state = 2},
  [1380] = {.lex_state = 3, .external_lex_state = 2},
  [1381] = {.lex_state = 3, .external_lex_state = 3},
  [1382] = {.lex_state = 2, .external_lex_state = 3},
  [1383] = {.lex_state = 2, .external_lex_state = 2},
  [1384] = {.lex_state = 2, .external_lex_state = 3},
  [1385] = {.lex_state = 2, .external_lex_state = 3},
  [1386] = {.lex_state = 2, .external_lex_state = 2},
  [1387] = {.lex_state = 11},
  [1388] = {.lex_state = 2, .external_lex_state = 2},
  [1389] = {.lex_state = 2, .external_lex_state = 2},
  [1390] = {.lex_state = 2, .external_lex_state = 2},
  [1391] = {.lex_state = 2, .external_lex_state = 3},
  [1392] = {.lex_state = 2, .external_lex_state = 2},
  [1393] = {.lex_state = 2, .external_lex_state = 2},
  [1394] = {.lex_state = 3, .external_lex_state = 3},
  [1395] = {.lex_state = 3, .external_lex_state = 4},
  [1396] = {.lex_state = 3, .external_lex_state = 2},
  [1397] = {.lex_state = 3, .external_lex_state = 3},
  [1398] = {.lex_state = 2, .external_lex_state = 2},
  [1399] = {.lex_state = 2, .external_lex_state = 2},
  [1400] = {.lex_state = 2, .external_lex_state = 3},
  [1401] = {.lex_state = 3, .external_lex_state = 2},
  [1402] = {.lex_state = 3, .external_lex_state = 4},
  [1403] = {.lex_state = 3, .external_lex_state = 2},
  [1404] = {.lex_state = 3, .external_lex_state = 2},
  [1405] = {.lex_state = 2, .external_lex_state = 2},
  [1406] = {.lex_state = 2, .external_lex_state = 2},
  [1407] = {.lex_state = 11},
  [1408] = {.lex_state = 3, .external_lex_state = 3},
  [1409] = {.lex_state = 2, .external_lex_state = 2},
  [1410] = {.lex_state = 3, .external_lex_state = 4},
  [1411] = {.lex_state = 3, .external_lex_state = 2},
  [1412] = {.lex_state = 3, .external_lex_state = 4},
  [1413] = {.lex_state = 3, .external_lex_state = 3},
  [1414] = {.lex_state = 3, .external_lex_state = 3},
  [1415] = {.lex_state = 11},
  [1416] = {.lex_state = 11},
  [1417] = {.lex_state = 11},
  [1418] = {.lex_state = 11},
  [1419] = {.lex_state = 3, .external_lex_state = 4},
  [1420] = {.lex_state = 11},
  [1421] = {.lex_state = 2, .external_lex_state = 3},
  [1422] = {.lex_state = 11},
  [1423] = {.lex_state = 2, .external_lex_state = 3},
  [1424] = {.lex_state = 2, .external_lex_state = 3},
  [1425] = {.lex_state = 11},
  [1426] = {.lex_state = 11},
  [1427] = {.lex_state = 11},
  [1428] = {.lex_state = 3, .external_lex_state = 4},
  [1429] = {.lex_state = 2, .external_lex_state = 2},
  [1430] = {.lex_state = 3, .external_lex_state = 4},
  [1431] = {.lex_state = 3, .external_lex_state = 4},
  [1432] = {.lex_state = 11},
  [1433] = {.lex_state = 2, .external_lex_state = 2},
  [1434] = {.lex_state = 3, .external_lex_state = 2},
  [1435] = {.lex_state = 11},
  [1436] = {.lex_state = 11},
  [1437] = {.lex_state = 11},
  [1438] = {.lex_state = 3, .external_lex_state = 3},
  [1439] = {.lex_state = 2, .external_lex_state = 2},
  [1440] = {.lex_state = 11},
  [1441] = {.lex_state = 11},
  [1442] = {.lex_state = 11},
  [1443] = {.lex_state = 11},
  [1444] = {.lex_state = 3, .external_lex_state = 4},
  [1445] = {.lex_state = 3, .external_lex_state = 4},
  [1446] = {.lex_state = 3, .external_lex_state = 4},
  [1447] = {.lex_state = 11},
  [1448] = {.lex_state = 11},
  [1449] = {.lex_state = 11},
  [1450] = {.lex_state = 3, .external_lex_state = 4},
  [1451] = {.lex_state = 11},
  [1452] = {.lex_state = 11},
  [1453] = {.lex_state = 2, .external_lex_state = 3},
  [1454] = {.lex_state = 2, .external_lex_state = 2},
  [1455] = {.lex_state = 3, .external_lex_state = 4},
  [1456] = {.lex_state = 11},
  [1457] = {.lex_state = 11},
  [1458] = {.lex_state = 11},
  [1459] = {.lex_state = 3, .external_lex_state = 3},
  [1460] = {.lex_state = 11},
  [1461] = {.lex_state = 3, .external_lex_state = 4},
  [1462] = {.lex_state = 11},
  [1463] = {.lex_state = 3, .external_lex_state = 3},
  [1464] = {.lex_state = 2, .external_lex_state = 3},
  [1465] = {.lex_state = 2, .external_lex_state = 2},
  [1466] = {.lex_state = 3, .external_lex_state = 3},
  [1467] = {.lex_state = 2, .external_lex_state = 3},
  [1468] = {.lex_state = 2, .external_lex_state = 3},
  [1469] = {.lex_state = 11},
  [1470] = {.lex_state = 11},
  [1471] = {.lex_state = 11},
  [1472] = {.lex_state = 11},
  [1473] = {.lex_state = 11},
  [1474] = {.lex_state = 11},
  [1475] = {.lex_state = 11},
  [1476] = {.lex_state = 11},
  [1477] = {.lex_state = 11},
  [1478] = {.lex_state = 3, .external_lex_state = 3},
  [1479] = {.lex_state = 2, .external_lex_state = 2},
  [1480] = {.lex_state = 3, .external_lex_state = 4},
  [1481] = {.lex_state = 3, .external_lex_state = 4},
  [1482] = {.lex_state = 2, .external_lex_state = 3},
  [1483] = {.lex_state = 11},
  [1484] = {.lex_state = 11},
  [1485] = {.lex_state = 11},
  [1486] = {.lex_state = 11},
  [1487] = {.lex_state = 11},
  [1488] = {.lex_state = 11},
  [1489] = {.lex_state = 11},
  [1490] = {.lex_state = 2, .external_lex_state = 2},
  [1491] = {.lex_state = 11},
  [1492] = {.lex_state = 11},
  [1493] = {.lex_state = 11},
  [1494] = {.lex_state = 3, .external_lex_state = 4},
  [1495] = {.lex_state = 2, .external_lex_state = 3},
  [1496] = {.lex_state = 3, .external_lex_state = 4},
  [1497] = {.lex_state = 3, .external_lex_state = 4},
  [1498] = {.lex_state = 13},
  [1499] = {.lex_state = 3, .external_lex_state = 3},
  [1500] = {.lex_state = 11},
  [1501] = {.lex_state = 3, .external_lex_state = 3},
  [1502] = {.lex_state = 11},
  [1503] = {.lex_state = 2, .external_lex_state = 2},
  [1504] = {.lex_state = 3, .external_lex_state = 4},
  [1505] = {.lex_state = 2, .external_lex_state = 2},
  [1506] = {.lex_state = 3, .external_lex_state = 4},
  [1507] = {.lex_state = 11},
  [1508] = {.lex_state = 11},
  [1509] = {.lex_state = 11},
  [1510] = {.lex_state = 11},
  [1511] = {.lex_state = 2, .external_lex_state = 2},
  [1512] = {.lex_state = 2, .external_lex_state = 3},
  [1513] = {.lex_state = 11},
  [1514] = {.lex_state = 11},
  [1515] = {.lex_state = 11},
  [1516] = {.lex_state = 11},
  [1517] = {.lex_state = 11},
  [1518] = {.lex_state = 2, .external_lex_state = 3},
  [1519] = {.lex_state = 11},
  [1520] = {.lex_state = 11},
  [1521] = {.lex_state = 3, .external_lex_state = 4},
  [1522] = {.lex_state = 11},
  [1523] = {.lex_state = 11},
  [1524] = {.lex_state = 11},
  [1525] = {.lex_state = 11},
  [1526] = {.lex_state = 11},
  [1527] = {.lex_state = 3, .external_lex_state = 4},
  [1528] = {.lex_state = 11},
  [1529] = {.lex_state = 11},
  [1530] = {.lex_state = 11},
  [1531] = {.lex_state = 11},
  [1532] = {.lex_state = 3, .external_lex_state = 3},
  [1533] = {.lex_state = 13},
  [1534] = {.lex_state = 13},
  [1535] = {.lex_state = 2, .external_lex_state = 3},
  [1536] = {.lex_state = 2, .external_lex_state = 3},
  [1537] = {.lex_state = 11},
  [1538] = {.lex_state = 11},
  [1539] = {.lex_state = 2, .external_lex_state = 2},
  [1540] = {.lex_state = 2, .external_lex_state = 3},
  [1541] = {.lex_state = 3, .external_lex_state = 3},
  [1542] = {.lex_state = 11},
  [1543] = {.lex_state = 2, .external_lex_state = 2},
  [1544] = {.lex_state = 11},
  [1545] = {.lex_state = 2, .external_lex_state = 2},
  [1546] = {.lex_state = 11},
  [1547] = {.lex_state = 11},
  [1548] = {.lex_state = 11},
  [1549] = {.lex_state = 3, .external_lex_state = 3},
  [1550] = {.lex_state = 11},
  [1551] = {.lex_state = 13},
  [1552] = {.lex_state = 11},
  [1553] = {.lex_state = 11},
  [1554] = {.lex_state = 11},
  [1555] = {.lex_state = 2, .external_lex_state = 3},
  [1556] = {.lex_state = 2, .external_lex_state = 2},
  [1557] = {.lex_state = 11},
  [1558] = {.lex_state = 11},
  [1559] = {.lex_state = 11},
  [1560] = {.lex_state = 11},
  [1561] = {.lex_state = 11},
  [1562] = {.lex_state = 11},
  [1563] = {.lex_state = 13},
  [1564] = {.lex_state = 11},
  [1565] = {.lex_state = 11},
  [1566] = {.lex_state = 2, .external_lex_state = 3},
  [1567] = {.lex_state = 11},
  [1568] = {.lex_state = 11},
  [1569] = {.lex_state = 11},
  [1570] = {.lex_state = 13},
  [1571] = {.lex_state = 2, .external_lex_state = 2},
  [1572] = {.lex_state = 3, .external_lex_state = 4},
  [1573] = {.lex_state = 11},
  [1574] = {.lex_state = 3, .external_lex_state = 3},
  [1575] = {.lex_state = 11},
  [1576] = {.lex_state = 11},
  [1577] = {.lex_state = 2, .external_lex_state = 2},
  [1578] = {.lex_state = 11},
  [1579] = {.lex_state = 11},
  [1580] = {.lex_state = 11},
  [1581] = {.lex_state = 11},
  [1582] = {.lex_state = 11},
  [1583] = {.lex_state = 11},
  [1584] = {.lex_state = 11},
  [1585] = {.lex_state = 3, .external_lex_state = 3},
  [1586] = {.lex_state = 2, .external_lex_state = 2},
  [1587] = {.lex_state = 2, .external_lex_state = 2},
  [1588] = {.lex_state = 11},
  [1589] = {.lex_state = 11},
  [1590] = {.lex_state = 11},
  [1591] = {.lex_state = 11},
  [1592] = {.lex_state = 11},
  [1593] = {.lex_state = 11},
  [1594] = {.lex_state = 11},
  [1595] = {.lex_state = 11},
  [1596] = {.lex_state = 3, .external_lex_state = 3},
  [1597] = {.lex_state = 11},
  [1598] = {.lex_state = 11},
  [1599] = {.lex_state = 11},
  [1600] = {.lex_state = 11},
  [1601] = {.lex_state = 11},
  [1602] = {.lex_state = 11},
  [1603] = {.lex_state = 11},
  [1604] = {.lex_state = 11},
  [1605] = {.lex_state = 11},
  [1606] = {.lex_state = 11},
  [1607] = {.lex_state = 11},
  [1608] = {.lex_state = 11},
  [1609] = {.lex_state = 11},
  [1610] = {.lex_state = 11},
  [1611] = {.lex_state = 11},
  [1612] = {.lex_state = 2, .external_lex_state = 2},
  [1613] = {.lex_state = 11},
  [1614] = {.lex_state = 11},
  [1615] = {.lex_state = 11},
  [1616] = {.lex_state = 11},
  [1617] = {.lex_state = 11},
  [1618] = {.lex_state = 11},
  [1619] = {.lex_state = 11},
  [1620] = {.lex_state = 11},
  [1621] = {.lex_state = 11},
  [1622] = {.lex_state = 11},
  [1623] = {.lex_state = 2, .external_lex_state = 3},
  [1624] = {.lex_state = 11},
  [1625] = {.lex_state = 11},
  [1626] = {.lex_state = 11},
  [1627] = {.lex_state = 11},
  [1628] = {.lex_state = 11},
  [1629] = {.lex_state = 11},
  [1630] = {.lex_state = 11},
  [1631] = {.lex_state = 11},
  [1632] = {.lex_state = 11},
  [1633] = {.lex_state = 2, .external_lex_state = 2},
  [1634] = {.lex_state = 11},
  [1635] = {.lex_state = 3, .external_lex_state = 3},
  [1636] = {.lex_state = 11},
  [1637] = {.lex_state = 11},
  [1638] = {.lex_state = 2, .external_lex_state = 2},
  [1639] = {.lex_state = 2, .external_lex_state = 3},
  [1640] = {.lex_state = 11},
  [1641] = {.lex_state = 11},
  [1642] = {.lex_state = 11},
  [1643] = {.lex_state = 11},
  [1644] = {.lex_state = 11},
  [1645] = {.lex_state = 11},
  [1646] = {.lex_state = 11},
  [1647] = {.lex_state = 11},
  [1648] = {.lex_state = 11},
  [1649] = {.lex_state = 11},
  [1650] = {.lex_state = 11},
  [1651] = {.lex_state = 11},
  [1652] = {.lex_state = 11},
  [1653] = {.lex_state = 11},
  [1654] = {.lex_state = 11},
  [1655] = {.lex_state = 11},
  [1656] = {.lex_state = 11},
  [1657] = {.lex_state = 11},
  [1658] = {.lex_state = 11},
  [1659] = {.lex_state = 11},
  [1660] = {.lex_state = 11},
  [1661] = {.lex_state = 2, .external_lex_state = 2},
  [1662] = {.lex_state = 2, .external_lex_state = 2},
  [1663] = {.lex_state = 2, .external_lex_state = 2},
  [1664] = {.lex_state = 11},
  [1665] = {.lex_state = 11},
  [1666] = {.lex_state = 11},
  [1667] = {.lex_state = 11},
  [1668] = {.lex_state = 11},
  [1669] = {.lex_state = 11},
  [1670] = {.lex_state = 11},
  [1671] = {.lex_state = 11},
  [1672] = {.lex_state = 11},
  [1673] = {.lex_state = 11},
  [1674] = {.lex_state = 11},
  [1675] = {.lex_state = 3, .external_lex_state = 3},
  [1676] = {.lex_state = 11},
  [1677] = {.lex_state = 11},
  [1678] = {.lex_state = 11},
  [1679] = {.lex_state = 11},
  [1680] = {.lex_state = 11},
  [1681] = {.lex_state = 11},
  [1682] = {.lex_state = 11},
  [1683] = {.lex_state = 11},
  [1684] = {.lex_state = 3, .external_lex_state = 3},
  [1685] = {.lex_state = 11},
  [1686] = {.lex_state = 11},
  [1687] = {.lex_state = 11},
  [1688] = {.lex_state = 2, .external_lex_state = 2},
  [1689] = {.lex_state = 11},
  [1690] = {.lex_state = 11},
  [1691] = {.lex_state = 11},
  [1692] = {.lex_state = 11},
  [1693] = {.lex_state = 11},
  [1694] = {.lex_state = 2, .external_lex_state = 2},
  [1695] = {.lex_state = 11},
  [1696] = {.lex_state = 11},
  [1697] = {.lex_state = 11},
  [1698] = {.lex_state = 2, .external_lex_state = 2},
  [1699] = {.lex_state = 11},
  [1700] = {.lex_state = 11},
  [1701] = {.lex_state = 11},
  [1702] = {.lex_state = 11},
  [1703] = {.lex_state = 11},
  [1704] = {.lex_state = 11},
  [1705] = {.lex_state = 11},
  [1706] = {.lex_state = 11},
  [1707] = {.lex_state = 11},
  [1708] = {.lex_state = 11},
  [1709] = {.lex_state = 11},
  [1710] = {.lex_state = 11},
  [1711] = {.lex_state = 11},
  [1712] = {.lex_state = 11},
  [1713] = {.lex_state = 11},
  [1714] = {.lex_state = 11},
  [1715] = {.lex_state = 3, .external_lex_state = 3},
  [1716] = {.lex_state = 11},
  [1717] = {.lex_state = 11},
  [1718] = {.lex_state = 11},
  [1719] = {.lex_state = 11},
  [1720] = {.lex_state = 2, .external_lex_state = 3},
  [1721] = {.lex_state = 11},
  [1722] = {.lex_state = 11},
  [1723] = {.lex_state = 11},
  [1724] = {.lex_state = 11},
  [1725] = {.lex_state = 3, .external_lex_state = 3},
  [1726] = {.lex_state = 11},
  [1727] = {.lex_state = 11},
  [1728] = {.lex_state = 2, .external_lex_state = 3},
  [1729] = {.lex_state = 2, .external_lex_state = 3},
  [1730] = {.lex_state = 2, .external_lex_state = 3},
  [1731] = {.lex_state = 11},
  [1732] = {.lex_state = 11},
  [1733] = {.lex_state = 2, .external_lex_state = 2},
  [1734] = {.lex_state = 2, .external_lex_state = 2},
  [1735] = {.lex_state = 2, .external_lex_state = 2},
  [1736] = {.lex_state = 11},
  [1737] = {.lex_state = 11},
  [1738] = {.lex_state = 11},
  [1739] = {.lex_state = 11},
  [1740] = {.lex_state = 11},
  [1741] = {.lex_state = 11},
  [1742] = {.lex_state = 11},
  [1743] = {.lex_state = 11},
  [1744] = {.lex_state = 11},
  [1745] = {.lex_state = 11},
  [1746] = {.lex_state = 2, .external_lex_state = 3},
  [1747] = {.lex_state = 11},
  [1748] = {.lex_state = 2, .external_lex_state = 2},
  [1749] = {.lex_state = 11},
  [1750] = {.lex_state = 11},
  [1751] = {.lex_state = 3, .external_lex_state = 3},
  [1752] = {.lex_state = 11},
  [1753] = {.lex_state = 11},
  [1754] = {.lex_state = 2, .external_lex_state = 2},
  [1755] = {.lex_state = 11},
  [1756] = {.lex_state = 11},
  [1757] = {.lex_state = 11},
  [1758] = {.lex_state = 11},
  [1759] = {.lex_state = 11},
  [1760] = {.lex_state = 11},
  [1761] = {.lex_state = 11},
  [1762] = {.lex_state = 2, .external_lex_state = 2},
  [1763] = {.lex_state = 11},
  [1764] = {.lex_state = 11},
  [1765] = {.lex_state = 11},
  [1766] = {.lex_state = 11},
  [1767] = {.lex_state = 11},
  [1768] = {.lex_state = 11},
  [1769] = {.lex_state = 11},
  [1770] = {.lex_state = 11},
  [1771] = {.lex_state = 3, .external_lex_state = 3},
  [1772] = {.lex_state = 11},
  [1773] = {.lex_state = 11},
  [1774] = {.lex_state = 11},
  [1775] = {.lex_state = 11},
  [1776] = {.lex_state = 11},
  [1777] = {.lex_state = 11},
  [1778] = {.lex_state = 11},
  [1779] = {.lex_state = 11},
  [1780] = {.lex_state = 11},
  [1781] = {.lex_state = 11},
  [1782] = {.lex_state = 11},
  [1783] = {.lex_state = 11},
  [1784] = {.lex_state = 11},
  [1785] = {.lex_state = 11},
  [1786] = {.lex_state = 11},
  [1787] = {.lex_state = 11},
  [1788] = {.lex_state = 11},
  [1789] = {.lex_state = 11},
  [1790] = {.lex_state = 2, .external_lex_state = 3},
  [1791] = {.lex_state = 11},
  [1792] = {.lex_state = 11},
  [1793] = {.lex_state = 11},
  [1794] = {.lex_state = 11},
  [1795] = {.lex_state = 11},
  [1796] = {.lex_state = 11},
  [1797] = {.lex_state = 11},
  [1798] = {.lex_state = 11},
  [1799] = {.lex_state = 11},
  [1800] = {.lex_state = 11},
  [1801] = {.lex_state = 11},
  [1802] = {.lex_state = 11},
  [1803] = {.lex_state = 2, .external_lex_state = 2},
  [1804] = {.lex_state = 11},
  [1805] = {.lex_state = 11},
  [1806] = {.lex_state = 2, .external_lex_state = 3},
  [1807] = {.lex_state = 11},
  [1808] = {.lex_state = 11},
  [1809] = {.lex_state = 2, .external_lex_state = 2},
  [1810] = {.lex_state = 3, .external_lex_state = 3},
  [1811] = {.lex_state = 11},
  [1812] = {.lex_state = 11},
  [1813] = {.lex_state = 11},
  [1814] = {.lex_state = 11},
  [1815] = {.lex_state = 11},
  [1816] = {.lex_state = 11},
  [1817] = {.lex_state = 11},
  [1818] = {.lex_state = 11},
  [1819] = {.lex_state = 11},
  [1820] = {.lex_state = 11},
  [1821] = {.lex_state = 11},
  [1822] = {.lex_state = 11},
  [1823] = {.lex_state = 11},
  [1824] = {.lex_state = 11},
  [1825] = {.lex_state = 11},
  [1826] = {.lex_state = 11},
  [1827] = {.lex_state = 11},
  [1828] = {.lex_state = 11},
  [1829] = {.lex_state = 11},
  [1830] = {.lex_state = 11},
  [1831] = {.lex_state = 11},
  [1832] = {.lex_state = 11},
  [1833] = {.lex_state = 11},
  [1834] = {.lex_state = 11},
  [1835] = {.lex_state = 11},
  [1836] = {.lex_state = 11},
  [1837] = {.lex_state = 2, .external_lex_state = 3},
  [1838] = {.lex_state = 11},
  [1839] = {.lex_state = 11},
  [1840] = {.lex_state = 11},
  [1841] = {.lex_state = 11},
  [1842] = {.lex_state = 11},
  [1843] = {.lex_state = 11},
  [1844] = {.lex_state = 11},
  [1845] = {.lex_state = 11},
  [1846] = {.lex_state = 11},
  [1847] = {.lex_state = 11},
  [1848] = {.lex_state = 11},
  [1849] = {.lex_state = 11},
  [1850] = {.lex_state = 11},
  [1851] = {.lex_state = 11},
  [1852] = {.lex_state = 11},
  [1853] = {.lex_state = 2, .external_lex_state = 2},
  [1854] = {.lex_state = 2, .external_lex_state = 3},
  [1855] = {.lex_state = 11},
  [1856] = {.lex_state = 11},
  [1857] = {.lex_state = 11},
  [1858] = {.lex_state = 11},
  [1859] = {.lex_state = 11},
  [1860] = {.lex_state = 11},
  [1861] = {.lex_state = 3, .external_lex_state = 3},
  [1862] = {.lex_state = 11},
  [1863] = {.lex_state = 2, .external_lex_state = 3},
  [1864] = {.lex_state = 11},
  [1865] = {.lex_state = 11},
  [1866] = {.lex_state = 11},
  [1867] = {.lex_state = 11},
  [1868] = {.lex_state = 11},
  [1869] = {.lex_state = 11},
  [1870] = {.lex_state = 11},
  [1871] = {.lex_state = 11},
  [1872] = {.lex_state = 11},
  [1873] = {.lex_state = 11},
  [1874] = {.lex_state = 11},
  [1875] = {.lex_state = 11},
  [1876] = {.lex_state = 11},
  [1877] = {.lex_state = 11},
  [1878] = {.lex_state = 11},
  [1879] = {.lex_state = 11},
  [1880] = {.lex_state = 11},
  [1881] = {.lex_state = 3, .external_lex_state = 3},
  [1882] = {.lex_state = 11},
  [1883] = {.lex_state = 11},
  [1884] = {.lex_state = 11},
  [1885] = {.lex_state = 11},
  [1886] = {.lex_state = 11},
  [1887] = {.lex_state = 11},
  [1888] = {.lex_state = 11},
  [1889] = {.lex_state = 11},
  [1890] = {.lex_state = 11},
  [1891] = {.lex_state = 11},
  [1892] = {.lex_state = 11},
  [1893] = {.lex_state = 11},
  [1894] = {.lex_state = 11},
  [1895] = {.lex_state = 11},
  [1896] = {.lex_state = 11},
  [1897] = {.lex_state = 11},
  [1898] = {.lex_state = 11},
  [1899] = {.lex_state = 11},
  [1900] = {.lex_state = 2, .external_lex_state = 3},
  [1901] = {.lex_state = 11},
  [1902] = {.lex_state = 11},
  [1903] = {.lex_state = 11},
  [1904] = {.lex_state = 11},
  [1905] = {.lex_state = 11},
  [1906] = {.lex_state = 11},
  [1907] = {.lex_state = 11},
  [1908] = {.lex_state = 11},
  [1909] = {.lex_state = 11},
  [1910] = {.lex_state = 11},
  [1911] = {.lex_state = 11},
  [1912] = {.lex_state = 11},
  [1913] = {.lex_state = 11},
  [1914] = {.lex_state = 2, .external_lex_state = 3},
  [1915] = {.lex_state = 11},
  [1916] = {.lex_state = 11},
  [1917] = {.lex_state = 11},
  [1918] = {.lex_state = 11},
  [1919] = {.lex_state = 11},
  [1920] = {.lex_state = 11},
  [1921] = {.lex_state = 11},
  [1922] = {.lex_state = 11},
  [1923] = {.lex_state = 11},
  [1924] = {.lex_state = 11},
  [1925] = {.lex_state = 2, .external_lex_state = 3},
  [1926] = {.lex_state = 2, .external_lex_state = 2},
  [1927] = {.lex_state = 11},
  [1928] = {.lex_state = 11},
  [1929] = {.lex_state = 11},
  [1930] = {.lex_state = 11},
  [1931] = {.lex_state = 11},
  [1932] = {.lex_state = 11},
  [1933] = {.lex_state = 11},
  [1934] = {.lex_state = 11},
  [1935] = {.lex_state = 11},
  [1936] = {.lex_state = 11},
  [1937] = {.lex_state = 11},
  [1938] = {.lex_state = 11},
  [1939] = {.lex_state = 11},
  [1940] = {.lex_state = 11},
  [1941] = {.lex_state = 11},
  [1942] = {.lex_state = 11},
  [1943] = {.lex_state = 11},
  [1944] = {.lex_state = 11},
  [1945] = {.lex_state = 11},
  [1946] = {.lex_state = 11},
  [1947] = {.lex_state = 2, .external_lex_state = 3},
  [1948] = {.lex_state = 11},
  [1949] = {.lex_state = 11},
  [1950] = {.lex_state = 11},
  [1951] = {.lex_state = 11},
  [1952] = {.lex_state = 11},
  [1953] = {.lex_state = 11},
  [1954] = {.lex_state = 11},
  [1955] = {.lex_state = 11},
  [1956] = {.lex_state = 2, .external_lex_state = 2},
  [1957] = {.lex_state = 11},
  [1958] = {.lex_state = 11},
  [1959] = {.lex_state = 11},
  [1960] = {.lex_state = 11},
  [1961] = {.lex_state = 11},
  [1962] = {.lex_state = 2, .external_lex_state = 3},
  [1963] = {.lex_state = 11},
  [1964] = {.lex_state = 11},
  [1965] = {.lex_state = 2, .external_lex_state = 2},
  [1966] = {.lex_state = 11},
  [1967] = {.lex_state = 11},
  [1968] = {.lex_state = 11},
  [1969] = {.lex_state = 11},
  [1970] = {.lex_state = 11},
  [1971] = {.lex_state = 11},
  [1972] = {.lex_state = 11},
  [1973] = {.lex_state = 11},
  [1974] = {.lex_state = 2, .external_lex_state = 2},
  [1975] = {.lex_state = 3, .external_lex_state = 3},
  [1976] = {.lex_state = 11},
  [1977] = {.lex_state = 11},
  [1978] = {.lex_state = 11},
  [1979] = {.lex_state = 11},
  [1980] = {.lex_state = 11},
  [1981] = {.lex_state = 11},
  [1982] = {.lex_state = 11},
  [1983] = {.lex_state = 11},
  [1984] = {.lex_state = 11},
  [1985] = {.lex_state = 11},
  [1986] = {.lex_state = 11},
  [1987] = {.lex_state = 11},
  [1988] = {.lex_state = 11},
  [1989] = {.lex_state = 11},
  [1990] = {.lex_state = 11},
  [1991] = {.lex_state = 11},
  [1992] = {.lex_state = 2, .external_lex_state = 3},
  [1993] = {.lex_state = 11},
  [1994] = {.lex_state = 11},
  [1995] = {.lex_state = 11},
  [1996] = {.lex_state = 11},
  [1997] = {.lex_state = 11},
  [1998] = {.lex_state = 11},
  [1999] = {.lex_state = 11},
  [2000] = {.lex_state = 11},
  [2001] = {.lex_state = 11},
  [2002] = {.lex_state = 11},
  [2003] = {.lex_state = 11},
  [2004] = {.lex_state = 3, .external_lex_state = 3},
  [2005] = {.lex_state = 2, .external_lex_state = 3},
  [2006] = {.lex_state = 2, .external_lex_state = 3},
  [2007] = {.lex_state = 2, .external_lex_state = 2},
  [2008] = {.lex_state = 2, .external_lex_state = 3},
  [2009] = {.lex_state = 2, .external_lex_state = 2},
  [2010] = {.lex_state = 2, .external_lex_state = 3},
  [2011] = {.lex_state = 2, .external_lex_state = 3},
  [2012] = {.lex_state = 3, .external_lex_state = 3},
  [2013] = {.lex_state = 2, .external_lex_state = 3},
  [2014] = {.lex_state = 2, .external_lex_state = 3},
  [2015] = {.lex_state = 2, .external_lex_state = 2},
  [2016] = {.lex_state = 2, .external_lex_state = 3},
  [2017] = {.lex_state = 2, .external_lex_state = 3},
  [2018] = {.lex_state = 2, .external_lex_state = 3},
  [2019] = {.lex_state = 2, .external_lex_state = 2},
  [2020] = {.lex_state = 3, .external_lex_state = 3},
  [2021] = {.lex_state = 2, .external_lex_state = 3},
  [2022] = {.lex_state = 2, .external_lex_state = 3},
  [2023] = {.lex_state = 2, .external_lex_state = 3},
  [2024] = {.lex_state = 2, .external_lex_state = 3},
  [2025] = {.lex_state = 2, .external_lex_state = 3},
  [2026] = {.lex_state = 2, .external_lex_state = 3},
  [2027] = {.lex_state = 2, .external_lex_state = 3},
  [2028] = {.lex_state = 2, .external_lex_state = 3},
  [2029] = {.lex_state = 2, .external_lex_state = 3},
  [2030] = {.lex_state = 2, .external_lex_state = 3},
  [2031] = {.lex_state = 2, .external_lex_state = 3},
  [2032] = {.lex_state = 2, .external_lex_state = 3},
  [2033] = {.lex_state = 2, .external_lex_state = 3},
  [2034] = {.lex_state = 2, .external_lex_state = 2},
  [2035] = {.lex_state = 2, .external_lex_state = 2},
  [2036] = {.lex_state = 2, .external_lex_state = 3},
  [2037] = {.lex_state = 2, .external_lex_state = 3},
  [2038] = {.lex_state = 2, .external_lex_state = 3},
  [2039] = {.lex_state = 2, .external_lex_state = 3},
  [2040] = {.lex_state = 3, .external_lex_state = 3},
  [2041] = {.lex_state = 2, .external_lex_state = 3},
  [2042] = {.lex_state = 2, .external_lex_state = 2},
  [2043] = {.lex_state = 2, .external_lex_state = 3},
  [2044] = {.lex_state = 2, .external_lex_state = 2},
  [2045] = {.lex_state = 2, .external_lex_state = 2},
  [2046] = {.lex_state = 3, .external_lex_state = 3},
  [2047] = {.lex_state = 2, .external_lex_state = 3},
  [2048] = {.lex_state = 2, .external_lex_state = 3},
  [2049] = {.lex_state = 2, .external_lex_state = 3},
  [2050] = {.lex_state = 2, .external_lex_state = 3},
  [2051] = {.lex_state = 2, .external_lex_state = 3},
  [2052] = {.lex_state = 2, .external_lex_state = 3},
  [2053] = {.lex_state = 2, .external_lex_state = 3},
  [2054] = {.lex_state = 3, .external_lex_state = 3},
  [2055] = {.lex_state = 2, .external_lex_state = 2},
  [2056] = {.lex_state = 2, .external_lex_state = 3},
  [2057] = {.lex_state = 2, .external_lex_state = 3},
  [2058] = {.lex_state = 2, .external_lex_state = 3},
  [2059] = {.lex_state = 2, .external_lex_state = 3},
  [2060] = {.lex_state = 2, .external_lex_state = 3},
  [2061] = {.lex_state = 2, .external_lex_state = 3},
  [2062] = {.lex_state = 2, .external_lex_state = 3},
  [2063] = {.lex_state = 2, .external_lex_state = 3},
  [2064] = {.lex_state = 2, .external_lex_state = 3},
  [2065] = {.lex_state = 2, .external_lex_state = 3},
  [2066] = {.lex_state = 2, .external_lex_state = 2},
  [2067] = {.lex_state = 13},
  [2068] = {.lex_state = 2, .external_lex_state = 3},
  [2069] = {.lex_state = 2, .external_lex_state = 3},
  [2070] = {.lex_state = 2, .external_lex_state = 3},
  [2071] = {.lex_state = 2, .external_lex_state = 3},
  [2072] = {.lex_state = 2, .external_lex_state = 3},
  [2073] = {.lex_state = 2, .external_lex_state = 2},
  [2074] = {.lex_state = 2, .external_lex_state = 2},
  [2075] = {.lex_state = 2, .external_lex_state = 3},
  [2076] = {.lex_state = 2, .external_lex_state = 3},
  [2077] = {.lex_state = 2, .external_lex_state = 2},
  [2078] = {.lex_state = 2, .external_lex_state = 3},
  [2079] = {.lex_state = 2, .external_lex_state = 3},
  [2080] = {.lex_state = 2, .external_lex_state = 3},
  [2081] = {.lex_state = 2, .external_lex_state = 3},
  [2082] = {.lex_state = 2, .external_lex_state = 3},
  [2083] = {.lex_state = 2, .external_lex_state = 3},
  [2084] = {.lex_state = 2, .external_lex_state = 3},
  [2085] = {.lex_state = 13},
  [2086] = {.lex_state = 2, .external_lex_state = 3},
  [2087] = {.lex_state = 2, .external_lex_state = 3},
  [2088] = {.lex_state = 2, .external_lex_state = 3},
  [2089] = {.lex_state = 2, .external_lex_state = 3},
  [2090] = {.lex_state = 2, .external_lex_state = 3},
  [2091] = {.lex_state = 2, .external_lex_state = 3},
  [2092] = {.lex_state = 2, .external_lex_state = 3},
  [2093] = {.lex_state = 2, .external_lex_state = 3},
  [2094] = {.lex_state = 2, .external_lex_state = 3},
  [2095] = {.lex_state = 2, .external_lex_state = 3},
  [2096] = {.lex_state = 2, .external_lex_state = 3},
  [2097] = {.lex_state = 2, .external_lex_state = 3},
  [2098] = {.lex_state = 2, .external_lex_state = 3},
  [2099] = {.lex_state = 2, .external_lex_state = 3},
  [2100] = {.lex_state = 2, .external_lex_state = 3},
  [2101] = {.lex_state = 2, .external_lex_state = 3},
  [2102] = {.lex_state = 2, .external_lex_state = 3},
  [2103] = {.lex_state = 2, .external_lex_state = 3},
  [2104] = {.lex_state = 2, .external_lex_state = 3},
  [2105] = {.lex_state = 64, .external_lex_state = 5},
  [2106] = {.lex_state = 64, .external_lex_state = 5},
  [2107] = {.lex_state = 64, .external_lex_state = 5},
  [2108] = {.lex_state = 64, .external_lex_state = 5},
  [2109] = {.lex_state = 64, .external_lex_state = 5},
  [2110] = {.lex_state = 64, .external_lex_state = 5},
  [2111] = {.lex_state = 64, .external_lex_state = 5},
  [2112] = {.lex_state = 64, .external_lex_state = 5},
  [2113] = {.lex_state = 64, .external_lex_state = 5},
  [2114] = {.lex_state = 63, .external_lex_state = 2},
  [2115] = {.lex_state = 11},
  [2116] = {.lex_state = 11},
  [2117] = {.lex_state = 11},
  [2118] = {.lex_state = 11},
  [2119] = {.lex_state = 11},
  [2120] = {.lex_state = 64, .external_lex_state = 5},
  [2121] = {.lex_state = 11},
  [2122] = {.lex_state = 11},
  [2123] = {.lex_state = 64, .external_lex_state = 5},
  [2124] = {.lex_state = 64, .external_lex_state = 5},
  [2125] = {.lex_state = 64, .external_lex_state = 5},
  [2126] = {.lex_state = 63, .external_lex_state = 3},
  [2127] = {.lex_state = 11},
  [2128] = {.lex_state = 11},
  [2129] = {.lex_state = 11},
  [2130] = {.lex_state = 63, .external_lex_state = 2},
  [2131] = {.lex_state = 11},
  [2132] = {.lex_state = 11},
  [2133] = {.lex_state = 63, .external_lex_state = 3},
  [2134] = {.lex_state = 11},
  [2135] = {.lex_state = 11},
  [2136] = {.lex_state = 11},
  [2137] = {.lex_state = 11},
  [2138] = {.lex_state = 11},
  [2139] = {.lex_state = 63, .external_lex_state = 2},
  [2140] = {.lex_state = 11},
  [2141] = {.lex_state = 63, .external_lex_state = 2},
  [2142] = {.lex_state = 11},
  [2143] = {.lex_state = 63, .external_lex_state = 3},
  [2144] = {.lex_state = 63, .external_lex_state = 3},
  [2145] = {.lex_state = 11},
  [2146] = {.lex_state = 63, .external_lex_state = 3},
  [2147] = {.lex_state = 11},
  [2148] = {.lex_state = 11},
  [2149] = {.lex_state = 11},
  [2150] = {.lex_state = 63, .external_lex_state = 2},
  [2151] = {.lex_state = 11},
  [2152] = {.lex_state = 63, .external_lex_state = 2},
  [2153] = {.lex_state = 63, .external_lex_state = 3},
  [2154] = {.lex_state = 11},
  [2155] = {.lex_state = 11},
  [2156] = {.lex_state = 63, .external_lex_state = 2},
  [2157] = {.lex_state = 11},
  [2158] = {.lex_state = 63, .external_lex_state = 2},
  [2159] = {.lex_state = 11},
  [2160] = {.lex_state = 63, .external_lex_state = 3},
  [2161] = {.lex_state = 63, .external_lex_state = 2},
  [2162] = {.lex_state = 63, .external_lex_state = 3},
  [2163] = {.lex_state = 63, .external_lex_state = 3},
  [2164] = {.lex_state = 63, .external_lex_state = 3},
  [2165] = {.lex_state = 63, .external_lex_state = 3},
  [2166] = {.lex_state = 63, .external_lex_state = 3},
  [2167] = {.lex_state = 63, .external_lex_state = 3},
  [2168] = {.lex_state = 63, .external_lex_state = 3},
  [2169] = {.lex_state = 63, .external_lex_state = 3},
  [2170] = {.lex_state = 63, .external_lex_state = 3},
  [2171] = {.lex_state = 63, .external_lex_state = 3},
  [2172] = {.lex_state = 63, .external_lex_state = 3},
  [2173] = {.lex_state = 63, .external_lex_state = 3},
  [2174] = {.lex_state = 63, .external_lex_state = 3},
  [2175] = {.lex_state = 63, .external_lex_state = 3},
  [2176] = {.lex_state = 63, .external_lex_state = 3},
  [2177] = {.lex_state = 63, .external_lex_state = 3},
  [2178] = {.lex_state = 63, .external_lex_state = 3},
  [2179] = {.lex_state = 63, .external_lex_state = 2},
  [2180] = {.lex_state = 63, .external_lex_state = 2},
  [2181] = {.lex_state = 5, .external_lex_state = 3},
  [2182] = {.lex_state = 63, .external_lex_state = 3},
  [2183] = {.lex_state = 63, .external_lex_state = 3},
  [2184] = {.lex_state = 63, .external_lex_state = 3},
  [2185] = {.lex_state = 63, .external_lex_state = 3},
  [2186] = {.lex_state = 63, .external_lex_state = 3},
  [2187] = {.lex_state = 63, .external_lex_state = 3},
  [2188] = {.lex_state = 63, .external_lex_state = 3},
  [2189] = {.lex_state = 63, .external_lex_state = 2},
  [2190] = {.lex_state = 63, .external_lex_state = 3},
  [2191] = {.lex_state = 63, .external_lex_state = 3},
  [2192] = {.lex_state = 63, .external_lex_state = 3},
  [2193] = {.lex_state = 63, .external_lex_state = 3},
  [2194] = {.lex_state = 63, .external_lex_state = 3},
  [2195] = {.lex_state = 63, .external_lex_state = 3},
  [2196] = {.lex_state = 63, .external_lex_state = 3},
  [2197] = {.lex_state = 63, .external_lex_state = 3},
  [2198] = {.lex_state = 63, .external_lex_state = 3},
  [2199] = {.lex_state = 63, .external_lex_state = 3},
  [2200] = {.lex_state = 63, .external_lex_state = 3},
  [2201] = {.lex_state = 63, .external_lex_state = 3},
  [2202] = {.lex_state = 63, .external_lex_state = 3},
  [2203] = {.lex_state = 63, .external_lex_state = 3},
  [2204] = {.lex_state = 63, .external_lex_state = 3},
  [2205] = {.lex_state = 63, .external_lex_state = 3},
  [2206] = {.lex_state = 63, .external_lex_state = 3},
  [2207] = {.lex_state = 63, .external_lex_state = 3},
  [2208] = {.lex_state = 63, .external_lex_state = 3},
  [2209] = {.lex_state = 63, .external_lex_state = 3},
  [2210] = {.lex_state = 63, .external_lex_state = 3},
  [2211] = {.lex_state = 63, .external_lex_state = 3},
  [2212] = {.lex_state = 63, .external_lex_state = 3},
  [2213] = {.lex_state = 63, .external_lex_state = 3},
  [2214] = {.lex_state = 63, .external_lex_state = 3},
  [2215] = {.lex_state = 63, .external_lex_state = 3},
  [2216] = {.lex_state = 63, .external_lex_state = 3},
  [2217] = {.lex_state = 63, .external_lex_state = 3},
  [2218] = {.lex_state = 63, .external_lex_state = 3},
  [2219] = {.lex_state = 63, .external_lex_state = 3},
  [2220] = {.lex_state = 63, .external_lex_state = 3},
  [2221] = {.lex_state = 63, .external_lex_state = 3},
  [2222] = {.lex_state = 63, .external_lex_state = 3},
  [2223] = {.lex_state = 63, .external_lex_state = 3},
  [2224] = {.lex_state = 63, .external_lex_state = 3},
  [2225] = {.lex_state = 63, .external_lex_state = 3},
  [2226] = {.lex_state = 63, .external_lex_state = 3},
  [2227] = {.lex_state = 63, .external_lex_state = 3},
  [2228] = {.lex_state = 63, .external_lex_state = 3},
  [2229] = {.lex_state = 63, .external_lex_state = 3},
  [2230] = {.lex_state = 63, .external_lex_state = 3},
  [2231] = {.lex_state = 63, .external_lex_state = 3},
  [2232] = {.lex_state = 63, .external_lex_state = 3},
  [2233] = {.lex_state = 63, .external_lex_state = 3},
  [2234] = {.lex_state = 63, .external_lex_state = 3},
  [2235] = {.lex_state = 63, .external_lex_state = 3},
  [2236] = {.lex_state = 63, .external_lex_state = 3},
  [2237] = {.lex_state = 63, .external_lex_state = 3},
  [2238] = {.lex_state = 63, .external_lex_state = 3},
  [2239] = {.lex_state = 63, .external_lex_state = 2},
  [2240] = {.lex_state = 63, .external_lex_state = 3},
  [2241] = {.lex_state = 63, .external_lex_state = 2},
  [2242] = {.lex_state = 63, .external_lex_state = 3},
  [2243] = {.lex_state = 63, .external_lex_state = 3},
  [2244] = {.lex_state = 63, .external_lex_state = 3},
  [2245] = {.lex_state = 63, .external_lex_state = 3},
  [2246] = {.lex_state = 63, .external_lex_state = 2},
  [2247] = {.lex_state = 63, .external_lex_state = 3},
  [2248] = {.lex_state = 63, .external_lex_state = 3},
  [2249] = {.lex_state = 63, .external_lex_state = 3},
  [2250] = {.lex_state = 63, .external_lex_state = 3},
  [2251] = {.lex_state = 63, .external_lex_state = 3},
  [2252] = {.lex_state = 63, .external_lex_state = 3},
  [2253] = {.lex_state = 63, .external_lex_state = 3},
  [2254] = {.lex_state = 63, .external_lex_state = 3},
  [2255] = {.lex_state = 63, .external_lex_state = 2},
  [2256] = {.lex_state = 63, .external_lex_state = 2},
  [2257] = {.lex_state = 63, .external_lex_state = 2},
  [2258] = {.lex_state = 63, .external_lex_state = 3},
  [2259] = {.lex_state = 63, .external_lex_state = 3},
  [2260] = {.lex_state = 63, .external_lex_state = 3},
  [2261] = {.lex_state = 63, .external_lex_state = 3},
  [2262] = {.lex_state = 63, .external_lex_state = 3},
  [2263] = {.lex_state = 63, .external_lex_state = 3},
  [2264] = {.lex_state = 63, .external_lex_state = 2},
  [2265] = {.lex_state = 63, .external_lex_state = 3},
  [2266] = {.lex_state = 63, .external_lex_state = 3},
  [2267] = {.lex_state = 63, .external_lex_state = 3},
  [2268] = {.lex_state = 63, .external_lex_state = 3},
  [2269] = {.lex_state = 63, .external_lex_state = 3},
  [2270] = {.lex_state = 63, .external_lex_state = 3},
  [2271] = {.lex_state = 63, .external_lex_state = 3},
  [2272] = {.lex_state = 63, .external_lex_state = 3},
  [2273] = {.lex_state = 63, .external_lex_state = 3},
  [2274] = {.lex_state = 63, .external_lex_state = 3},
  [2275] = {.lex_state = 63, .external_lex_state = 2},
  [2276] = {.lex_state = 63, .external_lex_state = 3},
  [2277] = {.lex_state = 63, .external_lex_state = 3},
  [2278] = {.lex_state = 63, .external_lex_state = 3},
  [2279] = {.lex_state = 63, .external_lex_state = 2},
  [2280] = {.lex_state = 63, .external_lex_state = 3},
  [2281] = {.lex_state = 63, .external_lex_state = 3},
  [2282] = {.lex_state = 63, .external_lex_state = 3},
  [2283] = {.lex_state = 63, .external_lex_state = 2},
  [2284] = {.lex_state = 63, .external_lex_state = 2},
  [2285] = {.lex_state = 63, .external_lex_state = 2},
  [2286] = {.lex_state = 63, .external_lex_state = 2},
  [2287] = {.lex_state = 63, .external_lex_state = 2},
  [2288] = {.lex_state = 63, .external_lex_state = 2},
  [2289] = {.lex_state = 63, .external_lex_state = 2},
  [2290] = {.lex_state = 63, .external_lex_state = 2},
  [2291] = {.lex_state = 63, .external_lex_state = 2},
  [2292] = {.lex_state = 63, .external_lex_state = 3},
  [2293] = {.lex_state = 63, .external_lex_state = 3},
  [2294] = {.lex_state = 63, .external_lex_state = 2},
  [2295] = {.lex_state = 63, .external_lex_state = 3},
  [2296] = {.lex_state = 63, .external_lex_state = 2},
  [2297] = {.lex_state = 63, .external_lex_state = 2},
  [2298] = {.lex_state = 63, .external_lex_state = 2},
  [2299] = {.lex_state = 63, .external_lex_state = 2},
  [2300] = {.lex_state = 63, .external_lex_state = 3},
  [2301] = {.lex_state = 63, .external_lex_state = 3},
  [2302] = {.lex_state = 63, .external_lex_state = 2},
  [2303] = {.lex_state = 63, .external_lex_state = 2},
  [2304] = {.lex_state = 63, .external_lex_state = 3},
  [2305] = {.lex_state = 63, .external_lex_state = 3},
  [2306] = {.lex_state = 63, .external_lex_state = 3},
  [2307] = {.lex_state = 63, .external_lex_state = 3},
  [2308] = {.lex_state = 63, .external_lex_state = 2},
  [2309] = {.lex_state = 63, .external_lex_state = 2},
  [2310] = {.lex_state = 63, .external_lex_state = 3},
  [2311] = {.lex_state = 63, .external_lex_state = 3},
  [2312] = {.lex_state = 63, .external_lex_state = 3},
  [2313] = {.lex_state = 63, .external_lex_state = 3},
  [2314] = {.lex_state = 63, .external_lex_state = 3},
  [2315] = {.lex_state = 63, .external_lex_state = 3},
  [2316] = {.lex_state = 63, .external_lex_state = 3},
  [2317] = {.lex_state = 63, .external_lex_state = 3},
  [2318] = {.lex_state = 63, .external_lex_state = 3},
  [2319] = {.lex_state = 63, .external_lex_state = 3},
  [2320] = {.lex_state = 63, .external_lex_state = 2},
  [2321] = {.lex_state = 63, .external_lex_state = 3},
  [2322] = {.lex_state = 63, .external_lex_state = 3},
  [2323] = {.lex_state = 63, .external_lex_state = 3},
  [2324] = {.lex_state = 63, .external_lex_state = 2},
  [2325] = {.lex_state = 63, .external_lex_state = 3},
  [2326] = {.lex_state = 63, .external_lex_state = 2},
  [2327] = {.lex_state = 63, .external_lex_state = 2},
  [2328] = {.lex_state = 63, .external_lex_state = 3},
  [2329] = {.lex_state = 63, .external_lex_state = 4},
  [2330] = {.lex_state = 11},
  [2331] = {.lex_state = 11},
  [2332] = {.lex_state = 63, .external_lex_state = 4},
  [2333] = {.lex_state = 63, .external_lex_state = 4},
  [2334] = {.lex_state = 63, .external_lex_state = 4},
  [2335] = {.lex_state = 63, .external_lex_state = 4},
  [2336] = {.lex_state = 63, .external_lex_state = 4},
  [2337] = {.lex_state = 63, .external_lex_state = 4},
  [2338] = {.lex_state = 63, .external_lex_state = 4},
  [2339] = {.lex_state = 63, .external_lex_state = 3},
  [2340] = {.lex_state = 5, .external_lex_state = 2},
  [2341] = {.lex_state = 63, .external_lex_state = 2},
  [2342] = {.lex_state = 11},
  [2343] = {.lex_state = 63, .external_lex_state = 2},
  [2344] = {.lex_state = 63, .external_lex_state = 2},
  [2345] = {.lex_state = 63, .external_lex_state = 4},
  [2346] = {.lex_state = 63, .external_lex_state = 4},
  [2347] = {.lex_state = 63, .external_lex_state = 4},
  [2348] = {.lex_state = 63, .external_lex_state = 4},
  [2349] = {.lex_state = 63, .external_lex_state = 4},
  [2350] = {.lex_state = 63, .external_lex_state = 3},
  [2351] = {.lex_state = 11},
  [2352] = {.lex_state = 63, .external_lex_state = 4},
  [2353] = {.lex_state = 63, .external_lex_state = 4},
  [2354] = {.lex_state = 63, .external_lex_state = 4},
  [2355] = {.lex_state = 63, .external_lex_state = 4},
  [2356] = {.lex_state = 11},
  [2357] = {.lex_state = 11},
  [2358] = {.lex_state = 63, .external_lex_state = 3},
  [2359] = {.lex_state = 63, .external_lex_state = 3},
  [2360] = {.lex_state = 63, .external_lex_state = 3},
  [2361] = {.lex_state = 63, .external_lex_state = 4},
  [2362] = {.lex_state = 11},
  [2363] = {.lex_state = 63, .external_lex_state = 4},
  [2364] = {.lex_state = 63, .external_lex_state = 4},
  [2365] = {.lex_state = 63, .external_lex_state = 4},
  [2366] = {.lex_state = 63, .external_lex_state = 2},
  [2367] = {.lex_state = 11},
  [2368] = {.lex_state = 63, .external_lex_state = 3},
  [2369] = {.lex_state = 63, .external_lex_state = 4},
  [2370] = {.lex_state = 63, .external_lex_state = 4},
  [2371] = {.lex_state = 63, .external_lex_state = 4},
  [2372] = {.lex_state = 63, .external_lex_state = 4},
  [2373] = {.lex_state = 63, .external_lex_state = 2},
  [2374] = {.lex_state = 63, .external_lex_state = 2},
  [2375] = {.lex_state = 63, .external_lex_state = 2},
  [2376] = {.lex_state = 63, .external_lex_state = 2},
  [2377] = {.lex_state = 63, .external_lex_state = 2},
  [2378] = {.lex_state = 63, .external_lex_state = 3},
  [2379] = {.lex_state = 63, .external_lex_state = 3},
  [2380] = {.lex_state = 63, .external_lex_state = 2},
  [2381] = {.lex_state = 63, .external_lex_state = 2},
  [2382] = {.lex_state = 64},
  [2383] = {.lex_state = 63, .external_lex_state = 2},
  [2384] = {.lex_state = 63, .external_lex_state = 2},
  [2385] = {.lex_state = 63, .external_lex_state = 2},
  [2386] = {.lex_state = 63, .external_lex_state = 2},
  [2387] = {.lex_state = 63, .external_lex_state = 2},
  [2388] = {.lex_state = 63, .external_lex_state = 4},
  [2389] = {.lex_state = 63, .external_lex_state = 2},
  [2390] = {.lex_state = 63, .external_lex_state = 4},
  [2391] = {.lex_state = 63, .external_lex_state = 2},
  [2392] = {.lex_state = 63, .external_lex_state = 2},
  [2393] = {.lex_state = 63, .external_lex_state = 2},
  [2394] = {.lex_state = 63, .external_lex_state = 2},
  [2395] = {.lex_state = 63, .external_lex_state = 2},
  [2396] = {.lex_state = 63, .external_lex_state = 2},
  [2397] = {.lex_state = 63, .external_lex_state = 2},
  [2398] = {.lex_state = 63, .external_lex_state = 2},
  [2399] = {.lex_state = 63, .external_lex_state = 2},
  [2400] = {.lex_state = 64},
  [2401] = {.lex_state = 63, .external_lex_state = 2},
  [2402] = {.lex_state = 63, .external_lex_state = 2},
  [2403] = {.lex_state = 63, .external_lex_state = 2},
  [2404] = {.lex_state = 63, .external_lex_state = 2},
  [2405] = {.lex_state = 63, .external_lex_state = 2},
  [2406] = {.lex_state = 63, .external_lex_state = 2},
  [2407] = {.lex_state = 63, .external_lex_state = 2},
  [2408] = {.lex_state = 63, .external_lex_state = 2},
  [2409] = {.lex_state = 63, .external_lex_state = 2},
  [2410] = {.lex_state = 64},
  [2411] = {.lex_state = 63, .external_lex_state = 4},
  [2412] = {.lex_state = 63, .external_lex_state = 2},
  [2413] = {.lex_state = 63, .external_lex_state = 2},
  [2414] = {.lex_state = 63, .external_lex_state = 4},
  [2415] = {.lex_state = 63, .external_lex_state = 4},
  [2416] = {.lex_state = 63, .external_lex_state = 4},
  [2417] = {.lex_state = 63, .external_lex_state = 2},
  [2418] = {.lex_state = 63, .external_lex_state = 4},
  [2419] = {.lex_state = 63, .external_lex_state = 4},
  [2420] = {.lex_state = 63, .external_lex_state = 2},
  [2421] = {.lex_state = 63, .external_lex_state = 2},
  [2422] = {.lex_state = 63, .external_lex_state = 2},
  [2423] = {.lex_state = 63, .external_lex_state = 2},
  [2424] = {.lex_state = 63, .external_lex_state = 2},
  [2425] = {.lex_state = 63, .external_lex_state = 2},
  [2426] = {.lex_state = 63, .external_lex_state = 2},
  [2427] = {.lex_state = 63, .external_lex_state = 2},
  [2428] = {.lex_state = 63, .external_lex_state = 4},
  [2429] = {.lex_state = 63, .external_lex_state = 4},
  [2430] = {.lex_state = 63, .external_lex_state = 4},
  [2431] = {.lex_state = 63, .external_lex_state = 4},
  [2432] = {.lex_state = 63, .external_lex_state = 4},
  [2433] = {.lex_state = 63, .external_lex_state = 4},
  [2434] = {.lex_state = 63, .external_lex_state = 4},
  [2435] = {.lex_state = 63, .external_lex_state = 2},
  [2436] = {.lex_state = 63, .external_lex_state = 3},
  [2437] = {.lex_state = 63, .external_lex_state = 2},
  [2438] = {.lex_state = 63, .external_lex_state = 4},
  [2439] = {.lex_state = 64},
  [2440] = {.lex_state = 63, .external_lex_state = 2},
  [2441] = {.lex_state = 63, .external_lex_state = 2},
  [2442] = {.lex_state = 63, .external_lex_state = 2},
  [2443] = {.lex_state = 63, .external_lex_state = 3},
  [2444] = {.lex_state = 63, .external_lex_state = 3},
  [2445] = {.lex_state = 63, .external_lex_state = 3},
  [2446] = {.lex_state = 63, .external_lex_state = 3},
  [2447] = {.lex_state = 63, .external_lex_state = 2},
  [2448] = {.lex_state = 63, .external_lex_state = 2},
  [2449] = {.lex_state = 63, .external_lex_state = 2},
  [2450] = {.lex_state = 63, .external_lex_state = 2},
  [2451] = {.lex_state = 63, .external_lex_state = 2},
  [2452] = {.lex_state = 63, .external_lex_state = 2},
  [2453] = {.lex_state = 63, .external_lex_state = 4},
  [2454] = {.lex_state = 63, .external_lex_state = 4},
  [2455] = {.lex_state = 63, .external_lex_state = 4},
  [2456] = {.lex_state = 63, .external_lex_state = 3},
  [2457] = {.lex_state = 63, .external_lex_state = 2},
  [2458] = {.lex_state = 63, .external_lex_state = 2},
  [2459] = {.lex_state = 63, .external_lex_state = 2},
  [2460] = {.lex_state = 64},
  [2461] = {.lex_state = 63, .external_lex_state = 2},
  [2462] = {.lex_state = 63, .external_lex_state = 3},
  [2463] = {.lex_state = 63, .external_lex_state = 3},
  [2464] = {.lex_state = 63, .external_lex_state = 3},
  [2465] = {.lex_state = 63, .external_lex_state = 2},
  [2466] = {.lex_state = 63, .external_lex_state = 4},
  [2467] = {.lex_state = 63, .external_lex_state = 3},
  [2468] = {.lex_state = 63, .external_lex_state = 2},
  [2469] = {.lex_state = 63, .external_lex_state = 3},
  [2470] = {.lex_state = 63, .external_lex_state = 4},
  [2471] = {.lex_state = 63, .external_lex_state = 2},
  [2472] = {.lex_state = 63, .external_lex_state = 3},
  [2473] = {.lex_state = 63, .external_lex_state = 2},
  [2474] = {.lex_state = 63, .external_lex_state = 2},
  [2475] = {.lex_state = 63, .external_lex_state = 2},
  [2476] = {.lex_state = 63, .external_lex_state = 2},
  [2477] = {.lex_state = 63, .external_lex_state = 2},
  [2478] = {.lex_state = 63, .external_lex_state = 2},
  [2479] = {.lex_state = 63, .external_lex_state = 2},
  [2480] = {.lex_state = 63, .external_lex_state = 2},
  [2481] = {.lex_state = 63, .external_lex_state = 2},
  [2482] = {.lex_state = 63, .external_lex_state = 2},
  [2483] = {.lex_state = 63, .external_lex_state = 2},
  [2484] = {.lex_state = 63, .external_lex_state = 2},
  [2485] = {.lex_state = 63, .external_lex_state = 2},
  [2486] = {.lex_state = 63, .external_lex_state = 2},
  [2487] = {.lex_state = 63, .external_lex_state = 3},
  [2488] = {.lex_state = 63, .external_lex_state = 3},
  [2489] = {.lex_state = 63, .external_lex_state = 2},
  [2490] = {.lex_state = 63, .external_lex_state = 2},
  [2491] = {.lex_state = 63, .external_lex_state = 2},
  [2492] = {.lex_state = 63, .external_lex_state = 2},
  [2493] = {.lex_state = 63, .external_lex_state = 3},
  [2494] = {.lex_state = 63, .external_lex_state = 3},
  [2495] = {.lex_state = 63, .external_lex_state = 2},
  [2496] = {.lex_state = 63, .external_lex_state = 2},
  [2497] = {.lex_state = 63, .external_lex_state = 3},
  [2498] = {.lex_state = 63, .external_lex_state = 3},
  [2499] = {.lex_state = 63, .external_lex_state = 3},
  [2500] = {.lex_state = 63, .external_lex_state = 3},
  [2501] = {.lex_state = 63, .external_lex_state = 2},
  [2502] = {.lex_state = 63, .external_lex_state = 2},
  [2503] = {.lex_state = 63, .external_lex_state = 2},
  [2504] = {.lex_state = 63, .external_lex_state = 2},
  [2505] = {.lex_state = 63, .external_lex_state = 2},
  [2506] = {.lex_state = 63, .external_lex_state = 2},
  [2507] = {.lex_state = 63, .external_lex_state = 2},
  [2508] = {.lex_state = 63, .external_lex_state = 2},
  [2509] = {.lex_state = 63, .external_lex_state = 2},
  [2510] = {.lex_state = 63, .external_lex_state = 2},
  [2511] = {.lex_state = 63, .external_lex_state = 2},
  [2512] = {.lex_state = 63, .external_lex_state = 2},
  [2513] = {.lex_state = 63, .external_lex_state = 2},
  [2514] = {.lex_state = 63, .external_lex_state = 2},
  [2515] = {.lex_state = 63, .external_lex_state = 2},
  [2516] = {.lex_state = 63, .external_lex_state = 2},
  [2517] = {.lex_state = 63, .external_lex_state = 2},
  [2518] = {.lex_state = 64},
  [2519] = {.lex_state = 63, .external_lex_state = 2},
  [2520] = {.lex_state = 63, .external_lex_state = 2},
  [2521] = {.lex_state = 63, .external_lex_state = 2},
  [2522] = {.lex_state = 63, .external_lex_state = 2},
  [2523] = {.lex_state = 63, .external_lex_state = 2},
  [2524] = {.lex_state = 63, .external_lex_state = 2},
  [2525] = {.lex_state = 63, .external_lex_state = 2},
  [2526] = {.lex_state = 63, .external_lex_state = 4},
  [2527] = {.lex_state = 63, .external_lex_state = 4},
  [2528] = {.lex_state = 63, .external_lex_state = 2},
  [2529] = {.lex_state = 63, .external_lex_state = 4},
  [2530] = {.lex_state = 63, .external_lex_state = 4},
  [2531] = {.lex_state = 63, .external_lex_state = 4},
  [2532] = {.lex_state = 63, .external_lex_state = 4},
  [2533] = {.lex_state = 63, .external_lex_state = 2},
  [2534] = {.lex_state = 63, .external_lex_state = 2},
  [2535] = {.lex_state = 63, .external_lex_state = 2},
  [2536] = {.lex_state = 63, .external_lex_state = 3},
  [2537] = {.lex_state = 63, .external_lex_state = 2},
  [2538] = {.lex_state = 63, .external_lex_state = 2},
  [2539] = {.lex_state = 63, .external_lex_state = 2},
  [2540] = {.lex_state = 63, .external_lex_state = 2},
  [2541] = {.lex_state = 64},
  [2542] = {.lex_state = 63, .external_lex_state = 3},
  [2543] = {.lex_state = 63, .external_lex_state = 2},
  [2544] = {.lex_state = 63, .external_lex_state = 2},
  [2545] = {.lex_state = 63, .external_lex_state = 2},
  [2546] = {.lex_state = 63, .external_lex_state = 2},
  [2547] = {.lex_state = 63, .external_lex_state = 2},
  [2548] = {.lex_state = 63, .external_lex_state = 2},
  [2549] = {.lex_state = 64},
  [2550] = {.lex_state = 64},
  [2551] = {.lex_state = 63, .external_lex_state = 3},
  [2552] = {.lex_state = 63, .external_lex_state = 2},
  [2553] = {.lex_state = 63, .external_lex_state = 3},
  [2554] = {.lex_state = 64},
  [2555] = {.lex_state = 63, .external_lex_state = 2},
  [2556] = {.lex_state = 63, .external_lex_state = 2},
  [2557] = {.lex_state = 63, .external_lex_state = 2},
  [2558] = {.lex_state = 63, .external_lex_state = 2},
  [2559] = {.lex_state = 63, .external_lex_state = 2},
  [2560] = {.lex_state = 63, .external_lex_state = 2},
  [2561] = {.lex_state = 63, .external_lex_state = 2},
  [2562] = {.lex_state = 64},
  [2563] = {.lex_state = 63, .external_lex_state = 2},
  [2564] = {.lex_state = 63, .external_lex_state = 3},
  [2565] = {.lex_state = 63, .external_lex_state = 3},
  [2566] = {.lex_state = 63, .external_lex_state = 3},
  [2567] = {.lex_state = 63, .external_lex_state = 3},
  [2568] = {.lex_state = 63, .external_lex_state = 3},
  [2569] = {.lex_state = 63, .external_lex_state = 3},
  [2570] = {.lex_state = 4, .external_lex_state = 3},
  [2571] = {.lex_state = 63, .external_lex_state = 4},
  [2572] = {.lex_state = 4, .external_lex_state = 3},
  [2573] = {.lex_state = 63, .external_lex_state = 2},
  [2574] = {.lex_state = 63, .external_lex_state = 2},
  [2575] = {.lex_state = 63, .external_lex_state = 3},
  [2576] = {.lex_state = 63, .external_lex_state = 2},
  [2577] = {.lex_state = 63, .external_lex_state = 2},
  [2578] = {.lex_state = 63, .external_lex_state = 4},
  [2579] = {.lex_state = 63, .external_lex_state = 4},
  [2580] = {.lex_state = 63, .external_lex_state = 3},
  [2581] = {.lex_state = 63, .external_lex_state = 4},
  [2582] = {.lex_state = 63, .external_lex_state = 3},
  [2583] = {.lex_state = 63, .external_lex_state = 3},
  [2584] = {.lex_state = 63, .external_lex_state = 3},
  [2585] = {.lex_state = 63, .external_lex_state = 3},
  [2586] = {.lex_state = 63, .external_lex_state = 3},
  [2587] = {.lex_state = 63, .external_lex_state = 3},
  [2588] = {.lex_state = 63, .external_lex_state = 3},
  [2589] = {.lex_state = 63, .external_lex_state = 2},
  [2590] = {.lex_state = 63, .external_lex_state = 3},
  [2591] = {.lex_state = 63, .external_lex_state = 2},
  [2592] = {.lex_state = 63, .external_lex_state = 3},
  [2593] = {.lex_state = 63, .external_lex_state = 2},
  [2594] = {.lex_state = 63, .external_lex_state = 3},
  [2595] = {.lex_state = 63, .external_lex_state = 2},
  [2596] = {.lex_state = 4, .external_lex_state = 3},
  [2597] = {.lex_state = 4, .external_lex_state = 3},
  [2598] = {.lex_state = 63, .external_lex_state = 2},
  [2599] = {.lex_state = 63, .external_lex_state = 3},
  [2600] = {.lex_state = 63, .external_lex_state = 4},
  [2601] = {.lex_state = 63, .external_lex_state = 2},
  [2602] = {.lex_state = 63, .external_lex_state = 3},
  [2603] = {.lex_state = 63, .external_lex_state = 4},
  [2604] = {.lex_state = 63, .external_lex_state = 3},
  [2605] = {.lex_state = 63, .external_lex_state = 2},
  [2606] = {.lex_state = 4, .external_lex_state = 3},
  [2607] = {.lex_state = 4, .external_lex_state = 3},
  [2608] = {.lex_state = 4, .external_lex_state = 3},
  [2609] = {.lex_state = 4, .external_lex_state = 3},
  [2610] = {.lex_state = 4, .external_lex_state = 3},
  [2611] = {.lex_state = 63, .external_lex_state = 4},
  [2612] = {.lex_state = 63, .external_lex_state = 3},
  [2613] = {.lex_state = 4, .external_lex_state = 3},
  [2614] = {.lex_state = 4, .external_lex_state = 3},
  [2615] = {.lex_state = 4, .external_lex_state = 3},
  [2616] = {.lex_state = 63, .external_lex_state = 2},
  [2617] = {.lex_state = 4, .external_lex_state = 3},
  [2618] = {.lex_state = 63, .external_lex_state = 3},
  [2619] = {.lex_state = 4, .external_lex_state = 3},
  [2620] = {.lex_state = 63, .external_lex_state = 3},
  [2621] = {.lex_state = 63, .external_lex_state = 3},
  [2622] = {.lex_state = 63, .external_lex_state = 3},
  [2623] = {.lex_state = 4, .external_lex_state = 3},
  [2624] = {.lex_state = 4, .external_lex_state = 3},
  [2625] = {.lex_state = 4, .external_lex_state = 3},
  [2626] = {.lex_state = 63, .external_lex_state = 2},
  [2627] = {.lex_state = 63, .external_lex_state = 2},
  [2628] = {.lex_state = 4, .external_lex_state = 3},
  [2629] = {.lex_state = 63, .external_lex_state = 2},
  [2630] = {.lex_state = 5, .external_lex_state = 4},
  [2631] = {.lex_state = 4, .external_lex_state = 3},
  [2632] = {.lex_state = 4, .external_lex_state = 3},
  [2633] = {.lex_state = 4, .external_lex_state = 3},
  [2634] = {.lex_state = 4, .external_lex_state = 3},
  [2635] = {.lex_state = 63, .external_lex_state = 3},
  [2636] = {.lex_state = 4, .external_lex_state = 3},
  [2637] = {.lex_state = 4, .external_lex_state = 3},
  [2638] = {.lex_state = 63, .external_lex_state = 3},
  [2639] = {.lex_state = 63, .external_lex_state = 3},
  [2640] = {.lex_state = 4, .external_lex_state = 3},
  [2641] = {.lex_state = 4, .external_lex_state = 3},
  [2642] = {.lex_state = 63, .external_lex_state = 3},
  [2643] = {.lex_state = 63, .external_lex_state = 2},
  [2644] = {.lex_state = 63, .external_lex_state = 3},
  [2645] = {.lex_state = 63, .external_lex_state = 3},
  [2646] = {.lex_state = 63, .external_lex_state = 3},
  [2647] = {.lex_state = 63, .external_lex_state = 3},
  [2648] = {.lex_state = 63, .external_lex_state = 3},
  [2649] = {.lex_state = 63, .external_lex_state = 3},
  [2650] = {.lex_state = 63, .external_lex_state = 3},
  [2651] = {.lex_state = 63, .external_lex_state = 3},
  [2652] = {.lex_state = 63, .external_lex_state = 3},
  [2653] = {.lex_state = 63, .external_lex_state = 3},
  [2654] = {.lex_state = 63, .external_lex_state = 3},
  [2655] = {.lex_state = 63, .external_lex_state = 3},
  [2656] = {.lex_state = 63, .external_lex_state = 3},
  [2657] = {.lex_state = 63, .external_lex_state = 3},
  [2658] = {.lex_state = 63, .external_lex_state = 3},
  [2659] = {.lex_state = 63, .external_lex_state = 3},
  [2660] = {.lex_state = 63, .external_lex_state = 3},
  [2661] = {.lex_state = 63, .external_lex_state = 3},
  [2662] = {.lex_state = 63, .external_lex_state = 3},
  [2663] = {.lex_state = 63, .external_lex_state = 3},
  [2664] = {.lex_state = 63, .external_lex_state = 3},
  [2665] = {.lex_state = 63, .external_lex_state = 3},
  [2666] = {.lex_state = 63, .external_lex_state = 3},
  [2667] = {.lex_state = 63, .external_lex_state = 3},
  [2668] = {.lex_state = 63, .external_lex_state = 3},
  [2669] = {.lex_state = 63, .external_lex_state = 3},
  [2670] = {.lex_state = 63, .external_lex_state = 2},
  [2671] = {.lex_state = 63, .external_lex_state = 2},
  [2672] = {.lex_state = 63, .external_lex_state = 3},
  [2673] = {.lex_state = 63, .external_lex_state = 3},
  [2674] = {.lex_state = 63, .external_lex_state = 3},
  [2675] = {.lex_state = 63, .external_lex_state = 3},
  [2676] = {.lex_state = 63, .external_lex_state = 3},
  [2677] = {.lex_state = 63, .external_lex_state = 2},
  [2678] = {.lex_state = 63, .external_lex_state = 3},
  [2679] = {.lex_state = 63, .external_lex_state = 3},
  [2680] = {.lex_state = 63, .external_lex_state = 3},
  [2681] = {.lex_state = 63, .external_lex_state = 3},
  [2682] = {.lex_state = 63, .external_lex_state = 3},
  [2683] = {.lex_state = 63, .external_lex_state = 4},
  [2684] = {.lex_state = 63, .external_lex_state = 3},
  [2685] = {.lex_state = 63, .external_lex_state = 3},
  [2686] = {.lex_state = 63, .external_lex_state = 2},
  [2687] = {.lex_state = 63, .external_lex_state = 3},
  [2688] = {.lex_state = 63, .external_lex_state = 2},
  [2689] = {.lex_state = 63, .external_lex_state = 3},
  [2690] = {.lex_state = 63, .external_lex_state = 3},
  [2691] = {.lex_state = 63, .external_lex_state = 3},
  [2692] = {.lex_state = 63, .external_lex_state = 3},
  [2693] = {.lex_state = 63, .external_lex_state = 3},
  [2694] = {.lex_state = 63, .external_lex_state = 2},
  [2695] = {.lex_state = 63, .external_lex_state = 2},
  [2696] = {.lex_state = 63, .external_lex_state = 3},
  [2697] = {.lex_state = 63, .external_lex_state = 3},
  [2698] = {.lex_state = 63, .external_lex_state = 2},
  [2699] = {.lex_state = 63, .external_lex_state = 3},
  [2700] = {.lex_state = 63, .external_lex_state = 3},
  [2701] = {.lex_state = 63, .external_lex_state = 3},
  [2702] = {.lex_state = 63, .external_lex_state = 3},
  [2703] = {.lex_state = 63, .external_lex_state = 2},
  [2704] = {.lex_state = 63, .external_lex_state = 2},
  [2705] = {.lex_state = 63, .external_lex_state = 3},
  [2706] = {.lex_state = 63, .external_lex_state = 3},
  [2707] = {.lex_state = 63, .external_lex_state = 3},
  [2708] = {.lex_state = 63, .external_lex_state = 2},
  [2709] = {.lex_state = 63, .external_lex_state = 2},
  [2710] = {.lex_state = 63, .external_lex_state = 3},
  [2711] = {.lex_state = 63, .external_lex_state = 2},
  [2712] = {.lex_state = 63, .external_lex_state = 3},
  [2713] = {.lex_state = 63, .external_lex_state = 4},
  [2714] = {.lex_state = 63, .external_lex_state = 4},
  [2715] = {.lex_state = 63, .external_lex_state = 4},
  [2716] = {.lex_state = 63, .external_lex_state = 4},
  [2717] = {.lex_state = 63, .external_lex_state = 3},
  [2718] = {.lex_state = 63, .external_lex_state = 2},
  [2719] = {.lex_state = 63, .external_lex_state = 2},
  [2720] = {.lex_state = 63, .external_lex_state = 3},
  [2721] = {.lex_state = 63, .external_lex_state = 3},
  [2722] = {.lex_state = 63, .external_lex_state = 2},
  [2723] = {.lex_state = 63, .external_lex_state = 2},
  [2724] = {.lex_state = 63, .external_lex_state = 2},
  [2725] = {.lex_state = 63, .external_lex_state = 4},
  [2726] = {.lex_state = 63, .external_lex_state = 4},
  [2727] = {.lex_state = 63, .external_lex_state = 2},
  [2728] = {.lex_state = 63, .external_lex_state = 4},
  [2729] = {.lex_state = 63, .external_lex_state = 3},
  [2730] = {.lex_state = 63, .external_lex_state = 3},
  [2731] = {.lex_state = 63, .external_lex_state = 3},
  [2732] = {.lex_state = 63, .external_lex_state = 3},
  [2733] = {.lex_state = 63, .external_lex_state = 3},
  [2734] = {.lex_state = 63, .external_lex_state = 3},
  [2735] = {.lex_state = 63, .external_lex_state = 3},
  [2736] = {.lex_state = 63, .external_lex_state = 2},
  [2737] = {.lex_state = 63, .external_lex_state = 3},
  [2738] = {.lex_state = 63, .external_lex_state = 3},
  [2739] = {.lex_state = 63, .external_lex_state = 2},
  [2740] = {.lex_state = 63, .external_lex_state = 3},
  [2741] = {.lex_state = 63, .external_lex_state = 3},
  [2742] = {.lex_state = 63, .external_lex_state = 2},
  [2743] = {.lex_state = 63, .external_lex_state = 2},
  [2744] = {.lex_state = 63, .external_lex_state = 4},
  [2745] = {.lex_state = 63, .external_lex_state = 4},
  [2746] = {.lex_state = 63, .external_lex_state = 3},
  [2747] = {.lex_state = 63, .external_lex_state = 3},
  [2748] = {.lex_state = 4, .external_lex_state = 3},
  [2749] = {.lex_state = 63, .external_lex_state = 2},
  [2750] = {.lex_state = 63, .external_lex_state = 3},
  [2751] = {.lex_state = 63, .external_lex_state = 4},
  [2752] = {.lex_state = 63, .external_lex_state = 4},
  [2753] = {.lex_state = 63, .external_lex_state = 4},
  [2754] = {.lex_state = 63, .external_lex_state = 4},
  [2755] = {.lex_state = 63, .external_lex_state = 4},
  [2756] = {.lex_state = 63, .external_lex_state = 4},
  [2757] = {.lex_state = 63, .external_lex_state = 4},
  [2758] = {.lex_state = 63, .external_lex_state = 4},
  [2759] = {.lex_state = 63, .external_lex_state = 3},
  [2760] = {.lex_state = 63, .external_lex_state = 4},
  [2761] = {.lex_state = 63, .external_lex_state = 4},
  [2762] = {.lex_state = 63, .external_lex_state = 4},
  [2763] = {.lex_state = 4, .external_lex_state = 3},
  [2764] = {.lex_state = 63, .external_lex_state = 4},
  [2765] = {.lex_state = 63, .external_lex_state = 3},
  [2766] = {.lex_state = 4, .external_lex_state = 3},
  [2767] = {.lex_state = 63, .external_lex_state = 2},
  [2768] = {.lex_state = 63, .external_lex_state = 4},
  [2769] = {.lex_state = 4, .external_lex_state = 3},
  [2770] = {.lex_state = 63, .external_lex_state = 4},
  [2771] = {.lex_state = 63, .external_lex_state = 4},
  [2772] = {.lex_state = 63, .external_lex_state = 4},
  [2773] = {.lex_state = 63, .external_lex_state = 3},
  [2774] = {.lex_state = 4, .external_lex_state = 3},
  [2775] = {.lex_state = 63, .external_lex_state = 4},
  [2776] = {.lex_state = 63, .external_lex_state = 3},
  [2777] = {.lex_state = 63, .external_lex_state = 3},
  [2778] = {.lex_state = 63, .external_lex_state = 4},
  [2779] = {.lex_state = 63, .external_lex_state = 3},
  [2780] = {.lex_state = 63, .external_lex_state = 4},
  [2781] = {.lex_state = 63, .external_lex_state = 4},
  [2782] = {.lex_state = 63, .external_lex_state = 4},
  [2783] = {.lex_state = 63, .external_lex_state = 4},
  [2784] = {.lex_state = 63, .external_lex_state = 4},
  [2785] = {.lex_state = 4, .external_lex_state = 3},
  [2786] = {.lex_state = 63, .external_lex_state = 4},
  [2787] = {.lex_state = 4, .external_lex_state = 3},
  [2788] = {.lex_state = 4, .external_lex_state = 3},
  [2789] = {.lex_state = 63, .external_lex_state = 4},
  [2790] = {.lex_state = 4, .external_lex_state = 3},
  [2791] = {.lex_state = 4, .external_lex_state = 3},
  [2792] = {.lex_state = 4, .external_lex_state = 3},
  [2793] = {.lex_state = 4, .external_lex_state = 3},
  [2794] = {.lex_state = 4, .external_lex_state = 3},
  [2795] = {.lex_state = 4, .external_lex_state = 3},
  [2796] = {.lex_state = 4, .external_lex_state = 3},
  [2797] = {.lex_state = 63, .external_lex_state = 4},
  [2798] = {.lex_state = 5, .external_lex_state = 3},
  [2799] = {.lex_state = 63, .external_lex_state = 4},
  [2800] = {.lex_state = 63, .external_lex_state = 3},
  [2801] = {.lex_state = 63, .external_lex_state = 4},
  [2802] = {.lex_state = 4, .external_lex_state = 3},
  [2803] = {.lex_state = 4, .external_lex_state = 3},
  [2804] = {.lex_state = 63, .external_lex_state = 4},
  [2805] = {.lex_state = 63, .external_lex_state = 4},
  [2806] = {.lex_state = 63, .external_lex_state = 4},
  [2807] = {.lex_state = 63, .external_lex_state = 3},
  [2808] = {.lex_state = 63, .external_lex_state = 4},
  [2809] = {.lex_state = 63, .external_lex_state = 4},
  [2810] = {.lex_state = 63, .external_lex_state = 4},
  [2811] = {.lex_state = 63, .external_lex_state = 4},
  [2812] = {.lex_state = 63, .external_lex_state = 4},
  [2813] = {.lex_state = 63, .external_lex_state = 4},
  [2814] = {.lex_state = 4, .external_lex_state = 3},
  [2815] = {.lex_state = 63, .external_lex_state = 4},
  [2816] = {.lex_state = 63, .external_lex_state = 4},
  [2817] = {.lex_state = 4, .external_lex_state = 3},
  [2818] = {.lex_state = 63, .external_lex_state = 4},
  [2819] = {.lex_state = 4, .external_lex_state = 3},
  [2820] = {.lex_state = 63, .external_lex_state = 4},
  [2821] = {.lex_state = 63, .external_lex_state = 4},
  [2822] = {.lex_state = 63, .external_lex_state = 4},
  [2823] = {.lex_state = 63, .external_lex_state = 4},
  [2824] = {.lex_state = 63, .external_lex_state = 4},
  [2825] = {.lex_state = 63, .external_lex_state = 4},
  [2826] = {.lex_state = 63, .external_lex_state = 4},
  [2827] = {.lex_state = 63, .external_lex_state = 4},
  [2828] = {.lex_state = 63, .external_lex_state = 4},
  [2829] = {.lex_state = 63, .external_lex_state = 4},
  [2830] = {.lex_state = 63, .external_lex_state = 2},
  [2831] = {.lex_state = 63, .external_lex_state = 4},
  [2832] = {.lex_state = 63, .external_lex_state = 2},
  [2833] = {.lex_state = 63, .external_lex_state = 2},
  [2834] = {.lex_state = 4, .external_lex_state = 3},
  [2835] = {.lex_state = 63, .external_lex_state = 2},
  [2836] = {.lex_state = 63, .external_lex_state = 2},
  [2837] = {.lex_state = 63, .external_lex_state = 2},
  [2838] = {.lex_state = 63, .external_lex_state = 4},
  [2839] = {.lex_state = 63, .external_lex_state = 4},
  [2840] = {.lex_state = 63, .external_lex_state = 4},
  [2841] = {.lex_state = 63, .external_lex_state = 4},
  [2842] = {.lex_state = 63, .external_lex_state = 4},
  [2843] = {.lex_state = 63, .external_lex_state = 4},
  [2844] = {.lex_state = 63, .external_lex_state = 4},
  [2845] = {.lex_state = 63, .external_lex_state = 2},
  [2846] = {.lex_state = 63, .external_lex_state = 4},
  [2847] = {.lex_state = 63, .external_lex_state = 2},
  [2848] = {.lex_state = 63, .external_lex_state = 2},
  [2849] = {.lex_state = 63, .external_lex_state = 2},
  [2850] = {.lex_state = 63, .external_lex_state = 2},
  [2851] = {.lex_state = 63, .external_lex_state = 2},
  [2852] = {.lex_state = 63, .external_lex_state = 2},
  [2853] = {.lex_state = 63, .external_lex_state = 2},
  [2854] = {.lex_state = 63, .external_lex_state = 4},
  [2855] = {.lex_state = 63, .external_lex_state = 2},
  [2856] = {.lex_state = 63, .external_lex_state = 4},
  [2857] = {.lex_state = 63, .external_lex_state = 3},
  [2858] = {.lex_state = 63, .external_lex_state = 2},
  [2859] = {.lex_state = 63, .external_lex_state = 2},
  [2860] = {.lex_state = 63, .external_lex_state = 2},
  [2861] = {.lex_state = 63, .external_lex_state = 4},
  [2862] = {.lex_state = 63, .external_lex_state = 2},
  [2863] = {.lex_state = 63, .external_lex_state = 2},
  [2864] = {.lex_state = 63, .external_lex_state = 3},
  [2865] = {.lex_state = 63, .external_lex_state = 2},
  [2866] = {.lex_state = 63, .external_lex_state = 2},
  [2867] = {.lex_state = 4, .external_lex_state = 3},
  [2868] = {.lex_state = 4, .external_lex_state = 3},
  [2869] = {.lex_state = 4, .external_lex_state = 3},
  [2870] = {.lex_state = 4, .external_lex_state = 3},
  [2871] = {.lex_state = 4, .external_lex_state = 3},
  [2872] = {.lex_state = 4, .external_lex_state = 3},
  [2873] = {.lex_state = 63, .external_lex_state = 3},
  [2874] = {.lex_state = 63, .external_lex_state = 3},
  [2875] = {.lex_state = 4, .external_lex_state = 2},
  [2876] = {.lex_state = 63, .external_lex_state = 3},
  [2877] = {.lex_state = 63, .external_lex_state = 3},
  [2878] = {.lex_state = 63, .external_lex_state = 4},
  [2879] = {.lex_state = 63, .external_lex_state = 3},
  [2880] = {.lex_state = 63, .external_lex_state = 3},
  [2881] = {.lex_state = 63, .external_lex_state = 3},
  [2882] = {.lex_state = 63, .external_lex_state = 3},
  [2883] = {.lex_state = 63, .external_lex_state = 4},
  [2884] = {.lex_state = 63, .external_lex_state = 3},
  [2885] = {.lex_state = 63, .external_lex_state = 4},
  [2886] = {.lex_state = 63, .external_lex_state = 3},
  [2887] = {.lex_state = 63, .external_lex_state = 3},
  [2888] = {.lex_state = 63, .external_lex_state = 3},
  [2889] = {.lex_state = 63, .external_lex_state = 3},
  [2890] = {.lex_state = 63, .external_lex_state = 4},
  [2891] = {.lex_state = 63, .external_lex_state = 3},
  [2892] = {.lex_state = 63, .external_lex_state = 3},
  [2893] = {.lex_state = 63, .external_lex_state = 4},
  [2894] = {.lex_state = 63, .external_lex_state = 3},
  [2895] = {.lex_state = 63, .external_lex_state = 3},
  [2896] = {.lex_state = 63, .external_lex_state = 3},
  [2897] = {.lex_state = 63, .external_lex_state = 4},
  [2898] = {.lex_state = 63, .external_lex_state = 3},
  [2899] = {.lex_state = 63, .external_lex_state = 3},
  [2900] = {.lex_state = 63, .external_lex_state = 3},
  [2901] = {.lex_state = 63, .external_lex_state = 3},
  [2902] = {.lex_state = 63, .external_lex_state = 3},
  [2903] = {.lex_state = 63, .external_lex_state = 3},
  [2904] = {.lex_state = 63, .external_lex_state = 3},
  [2905] = {.lex_state = 63, .external_lex_state = 2},
  [2906] = {.lex_state = 63, .external_lex_state = 2},
  [2907] = {.lex_state = 63, .external_lex_state = 3},
  [2908] = {.lex_state = 63, .external_lex_state = 4},
  [2909] = {.lex_state = 63, .external_lex_state = 3},
  [2910] = {.lex_state = 63, .external_lex_state = 3},
  [2911] = {.lex_state = 63, .external_lex_state = 3},
  [2912] = {.lex_state = 63, .external_lex_state = 3},
  [2913] = {.lex_state = 63, .external_lex_state = 3},
  [2914] = {.lex_state = 63, .external_lex_state = 3},
  [2915] = {.lex_state = 63, .external_lex_state = 3},
  [2916] = {.lex_state = 63, .external_lex_state = 4},
  [2917] = {.lex_state = 63, .external_lex_state = 2},
  [2918] = {.lex_state = 63, .external_lex_state = 2},
  [2919] = {.lex_state = 63, .external_lex_state = 3},
  [2920] = {.lex_state = 63, .external_lex_state = 3},
  [2921] = {.lex_state = 63, .external_lex_state = 3},
  [2922] = {.lex_state = 63, .external_lex_state = 4},
  [2923] = {.lex_state = 63, .external_lex_state = 4},
  [2924] = {.lex_state = 63, .external_lex_state = 3},
  [2925] = {.lex_state = 63, .external_lex_state = 3},
  [2926] = {.lex_state = 63, .external_lex_state = 3},
  [2927] = {.lex_state = 4, .external_lex_state = 3},
  [2928] = {.lex_state = 63, .external_lex_state = 3},
  [2929] = {.lex_state = 63, .external_lex_state = 3},
  [2930] = {.lex_state = 63, .external_lex_state = 3},
  [2931] = {.lex_state = 63, .external_lex_state = 2},
  [2932] = {.lex_state = 63, .external_lex_state = 3},
  [2933] = {.lex_state = 63, .external_lex_state = 4},
  [2934] = {.lex_state = 63, .external_lex_state = 3},
  [2935] = {.lex_state = 63, .external_lex_state = 4},
  [2936] = {.lex_state = 63, .external_lex_state = 3},
  [2937] = {.lex_state = 63, .external_lex_state = 3},
  [2938] = {.lex_state = 63, .external_lex_state = 4},
  [2939] = {.lex_state = 63, .external_lex_state = 3},
  [2940] = {.lex_state = 63, .external_lex_state = 4},
  [2941] = {.lex_state = 63, .external_lex_state = 4},
  [2942] = {.lex_state = 63, .external_lex_state = 4},
  [2943] = {.lex_state = 63, .external_lex_state = 4},
  [2944] = {.lex_state = 63, .external_lex_state = 4},
  [2945] = {.lex_state = 63, .external_lex_state = 4},
  [2946] = {.lex_state = 63, .external_lex_state = 4},
  [2947] = {.lex_state = 63, .external_lex_state = 4},
  [2948] = {.lex_state = 63, .external_lex_state = 4},
  [2949] = {.lex_state = 63, .external_lex_state = 4},
  [2950] = {.lex_state = 63, .external_lex_state = 4},
  [2951] = {.lex_state = 63, .external_lex_state = 4},
  [2952] = {.lex_state = 63, .external_lex_state = 4},
  [2953] = {.lex_state = 63, .external_lex_state = 2},
  [2954] = {.lex_state = 63, .external_lex_state = 4},
  [2955] = {.lex_state = 63, .external_lex_state = 4},
  [2956] = {.lex_state = 63, .external_lex_state = 4},
  [2957] = {.lex_state = 63, .external_lex_state = 4},
  [2958] = {.lex_state = 63, .external_lex_state = 4},
  [2959] = {.lex_state = 63, .external_lex_state = 3},
  [2960] = {.lex_state = 63, .external_lex_state = 4},
  [2961] = {.lex_state = 63, .external_lex_state = 4},
  [2962] = {.lex_state = 63, .external_lex_state = 4},
  [2963] = {.lex_state = 63, .external_lex_state = 4},
  [2964] = {.lex_state = 63, .external_lex_state = 4},
  [2965] = {.lex_state = 63, .external_lex_state = 4},
  [2966] = {.lex_state = 63, .external_lex_state = 2},
  [2967] = {.lex_state = 63, .external_lex_state = 4},
  [2968] = {.lex_state = 63, .external_lex_state = 4},
  [2969] = {.lex_state = 63, .external_lex_state = 4},
  [2970] = {.lex_state = 63, .external_lex_state = 4},
  [2971] = {.lex_state = 63, .external_lex_state = 4},
  [2972] = {.lex_state = 63, .external_lex_state = 2},
  [2973] = {.lex_state = 63, .external_lex_state = 2},
  [2974] = {.lex_state = 63, .external_lex_state = 4},
  [2975] = {.lex_state = 63, .external_lex_state = 4},
  [2976] = {.lex_state = 63, .external_lex_state = 4},
  [2977] = {.lex_state = 63, .external_lex_state = 4},
  [2978] = {.lex_state = 64},
  [2979] = {.lex_state = 63, .external_lex_state = 4},
  [2980] = {.lex_state = 63, .external_lex_state = 4},
  [2981] = {.lex_state = 63, .external_lex_state = 4},
  [2982] = {.lex_state = 63, .external_lex_state = 4},
  [2983] = {.lex_state = 63, .external_lex_state = 2},
  [2984] = {.lex_state = 63, .external_lex_state = 3},
  [2985] = {.lex_state = 63, .external_lex_state = 4},
  [2986] = {.lex_state = 63, .external_lex_state = 2},
  [2987] = {.lex_state = 63, .external_lex_state = 4},
  [2988] = {.lex_state = 63, .external_lex_state = 2},
  [2989] = {.lex_state = 63, .external_lex_state = 3},
  [2990] = {.lex_state = 63, .external_lex_state = 3},
  [2991] = {.lex_state = 63, .external_lex_state = 2},
  [2992] = {.lex_state = 63, .external_lex_state = 3},
  [2993] = {.lex_state = 63, .external_lex_state = 3},
  [2994] = {.lex_state = 63, .external_lex_state = 3},
  [2995] = {.lex_state = 63, .external_lex_state = 2},
  [2996] = {.lex_state = 63, .external_lex_state = 2},
  [2997] = {.lex_state = 4, .external_lex_state = 3},
  [2998] = {.lex_state = 63, .external_lex_state = 2},
  [2999] = {.lex_state = 63, .external_lex_state = 2},
  [3000] = {.lex_state = 63, .external_lex_state = 2},
  [3001] = {.lex_state = 63, .external_lex_state = 2},
  [3002] = {.lex_state = 63, .external_lex_state = 2},
  [3003] = {.lex_state = 63, .external_lex_state = 2},
  [3004] = {.lex_state = 63, .external_lex_state = 2},
  [3005] = {.lex_state = 63, .external_lex_state = 2},
  [3006] = {.lex_state = 63, .external_lex_state = 2},
  [3007] = {.lex_state = 63, .external_lex_state = 2},
  [3008] = {.lex_state = 63, .external_lex_state = 2},
  [3009] = {.lex_state = 63, .external_lex_state = 2},
  [3010] = {.lex_state = 63, .external_lex_state = 2},
  [3011] = {.lex_state = 63, .external_lex_state = 2},
  [3012] = {.lex_state = 63, .external_lex_state = 2},
  [3013] = {.lex_state = 63, .external_lex_state = 2},
  [3014] = {.lex_state = 63, .external_lex_state = 2},
  [3015] = {.lex_state = 63, .external_lex_state = 3},
  [3016] = {.lex_state = 63, .external_lex_state = 2},
  [3017] = {.lex_state = 63, .external_lex_state = 2},
  [3018] = {.lex_state = 4, .external_lex_state = 3},
  [3019] = {.lex_state = 63, .external_lex_state = 2},
  [3020] = {.lex_state = 63, .external_lex_state = 2},
  [3021] = {.lex_state = 63, .external_lex_state = 2},
  [3022] = {.lex_state = 63, .external_lex_state = 3},
  [3023] = {.lex_state = 63, .external_lex_state = 3},
  [3024] = {.lex_state = 63, .external_lex_state = 3},
  [3025] = {.lex_state = 63, .external_lex_state = 3},
  [3026] = {.lex_state = 63, .external_lex_state = 3},
  [3027] = {.lex_state = 63, .external_lex_state = 3},
  [3028] = {.lex_state = 63, .external_lex_state = 3},
  [3029] = {.lex_state = 63, .external_lex_state = 2},
  [3030] = {.lex_state = 63, .external_lex_state = 3},
  [3031] = {.lex_state = 4, .external_lex_state = 3},
  [3032] = {.lex_state = 63, .external_lex_state = 2},
  [3033] = {.lex_state = 63, .external_lex_state = 2},
  [3034] = {.lex_state = 63, .external_lex_state = 2},
  [3035] = {.lex_state = 63, .external_lex_state = 2},
  [3036] = {.lex_state = 63, .external_lex_state = 2},
  [3037] = {.lex_state = 63, .external_lex_state = 2},
  [3038] = {.lex_state = 63, .external_lex_state = 3},
  [3039] = {.lex_state = 63, .external_lex_state = 2},
  [3040] = {.lex_state = 63, .external_lex_state = 2},
  [3041] = {.lex_state = 63, .external_lex_state = 3},
  [3042] = {.lex_state = 4, .external_lex_state = 3},
  [3043] = {.lex_state = 63, .external_lex_state = 4},
  [3044] = {.lex_state = 4, .external_lex_state = 3},
  [3045] = {.lex_state = 63, .external_lex_state = 3},
  [3046] = {.lex_state = 63, .external_lex_state = 3},
  [3047] = {.lex_state = 4, .external_lex_state = 3},
  [3048] = {.lex_state = 63, .external_lex_state = 2},
  [3049] = {.lex_state = 63, .external_lex_state = 2},
  [3050] = {.lex_state = 4, .external_lex_state = 3},
  [3051] = {.lex_state = 4, .external_lex_state = 3},
  [3052] = {.lex_state = 63, .external_lex_state = 3},
  [3053] = {.lex_state = 63, .external_lex_state = 2},
  [3054] = {.lex_state = 63, .external_lex_state = 2},
  [3055] = {.lex_state = 63, .external_lex_state = 2},
  [3056] = {.lex_state = 63, .external_lex_state = 3},
  [3057] = {.lex_state = 63, .external_lex_state = 2},
  [3058] = {.lex_state = 63, .external_lex_state = 2},
  [3059] = {.lex_state = 63, .external_lex_state = 2},
  [3060] = {.lex_state = 63, .external_lex_state = 3},
  [3061] = {.lex_state = 63, .external_lex_state = 2},
  [3062] = {.lex_state = 63, .external_lex_state = 3},
  [3063] = {.lex_state = 63, .external_lex_state = 2},
  [3064] = {.lex_state = 63, .external_lex_state = 2},
  [3065] = {.lex_state = 63, .external_lex_state = 2},
  [3066] = {.lex_state = 63, .external_lex_state = 3},
  [3067] = {.lex_state = 63, .external_lex_state = 3},
  [3068] = {.lex_state = 63, .external_lex_state = 2},
  [3069] = {.lex_state = 63, .external_lex_state = 3},
  [3070] = {.lex_state = 63, .external_lex_state = 2},
  [3071] = {.lex_state = 63, .external_lex_state = 3},
  [3072] = {.lex_state = 63, .external_lex_state = 2},
  [3073] = {.lex_state = 63, .external_lex_state = 3},
  [3074] = {.lex_state = 63, .external_lex_state = 2},
  [3075] = {.lex_state = 63, .external_lex_state = 2},
  [3076] = {.lex_state = 63, .external_lex_state = 2},
  [3077] = {.lex_state = 63, .external_lex_state = 3},
  [3078] = {.lex_state = 63, .external_lex_state = 2},
  [3079] = {.lex_state = 63, .external_lex_state = 3},
  [3080] = {.lex_state = 63, .external_lex_state = 3},
  [3081] = {.lex_state = 7, .external_lex_state = 3},
  [3082] = {.lex_state = 63, .external_lex_state = 2},
  [3083] = {.lex_state = 63, .external_lex_state = 2},
  [3084] = {.lex_state = 63, .external_lex_state = 3},
  [3085] = {.lex_state = 63, .external_lex_state = 4},
  [3086] = {.lex_state = 63, .external_lex_state = 2},
  [3087] = {.lex_state = 63, .external_lex_state = 2},
  [3088] = {.lex_state = 63, .external_lex_state = 3},
  [3089] = {.lex_state = 63, .external_lex_state = 3},
  [3090] = {.lex_state = 63, .external_lex_state = 3},
  [3091] = {.lex_state = 63, .external_lex_state = 2},
  [3092] = {.lex_state = 63, .external_lex_state = 2},
  [3093] = {.lex_state = 63, .external_lex_state = 2},
  [3094] = {.lex_state = 63, .external_lex_state = 3},
  [3095] = {.lex_state = 63, .external_lex_state = 2},
  [3096] = {.lex_state = 63, .external_lex_state = 2},
  [3097] = {.lex_state = 63, .external_lex_state = 3},
  [3098] = {.lex_state = 63, .external_lex_state = 3},
  [3099] = {.lex_state = 63, .external_lex_state = 3},
  [3100] = {.lex_state = 63, .external_lex_state = 3},
  [3101] = {.lex_state = 63, .external_lex_state = 3},
  [3102] = {.lex_state = 63, .external_lex_state = 3},
  [3103] = {.lex_state = 63, .external_lex_state = 2},
  [3104] = {.lex_state = 63, .external_lex_state = 3},
  [3105] = {.lex_state = 63, .external_lex_state = 3},
  [3106] = {.lex_state = 63, .external_lex_state = 2},
  [3107] = {.lex_state = 63, .external_lex_state = 3},
  [3108] = {.lex_state = 63, .external_lex_state = 4},
  [3109] = {.lex_state = 63, .external_lex_state = 3},
  [3110] = {.lex_state = 63, .external_lex_state = 3},
  [3111] = {.lex_state = 63, .external_lex_state = 3},
  [3112] = {.lex_state = 63, .external_lex_state = 3},
  [3113] = {.lex_state = 63, .external_lex_state = 3},
  [3114] = {.lex_state = 63, .external_lex_state = 3},
  [3115] = {.lex_state = 63, .external_lex_state = 3},
  [3116] = {.lex_state = 5, .external_lex_state = 2},
  [3117] = {.lex_state = 63, .external_lex_state = 3},
  [3118] = {.lex_state = 63, .external_lex_state = 3},
  [3119] = {.lex_state = 63, .external_lex_state = 3},
  [3120] = {.lex_state = 63, .external_lex_state = 2},
  [3121] = {.lex_state = 63, .external_lex_state = 3},
  [3122] = {.lex_state = 4, .external_lex_state = 3},
  [3123] = {.lex_state = 63, .external_lex_state = 3},
  [3124] = {.lex_state = 63, .external_lex_state = 3},
  [3125] = {.lex_state = 63, .external_lex_state = 3},
  [3126] = {.lex_state = 63, .external_lex_state = 3},
  [3127] = {.lex_state = 63, .external_lex_state = 3},
  [3128] = {.lex_state = 63, .external_lex_state = 3},
  [3129] = {.lex_state = 63, .external_lex_state = 3},
  [3130] = {.lex_state = 63, .external_lex_state = 3},
  [3131] = {.lex_state = 63, .external_lex_state = 3},
  [3132] = {.lex_state = 63, .external_lex_state = 3},
  [3133] = {.lex_state = 63, .external_lex_state = 3},
  [3134] = {.lex_state = 63, .external_lex_state = 3},
  [3135] = {.lex_state = 63, .external_lex_state = 3},
  [3136] = {.lex_state = 63, .external_lex_state = 3},
  [3137] = {.lex_state = 63, .external_lex_state = 4},
  [3138] = {.lex_state = 63, .external_lex_state = 3},
  [3139] = {.lex_state = 63, .external_lex_state = 3},
  [3140] = {.lex_state = 63, .external_lex_state = 3},
  [3141] = {.lex_state = 63, .external_lex_state = 3},
  [3142] = {.lex_state = 63, .external_lex_state = 4},
  [3143] = {.lex_state = 63, .external_lex_state = 3},
  [3144] = {.lex_state = 63, .external_lex_state = 3},
  [3145] = {.lex_state = 63, .external_lex_state = 3},
  [3146] = {.lex_state = 63, .external_lex_state = 3},
  [3147] = {.lex_state = 63, .external_lex_state = 3},
  [3148] = {.lex_state = 63, .external_lex_state = 3},
  [3149] = {.lex_state = 63, .external_lex_state = 3},
  [3150] = {.lex_state = 63, .external_lex_state = 3},
  [3151] = {.lex_state = 63, .external_lex_state = 3},
  [3152] = {.lex_state = 63, .external_lex_state = 3},
  [3153] = {.lex_state = 63, .external_lex_state = 2},
  [3154] = {.lex_state = 63, .external_lex_state = 4},
  [3155] = {.lex_state = 63, .external_lex_state = 2},
  [3156] = {.lex_state = 5, .external_lex_state = 3},
  [3157] = {.lex_state = 63, .external_lex_state = 3},
  [3158] = {.lex_state = 63, .external_lex_state = 4},
  [3159] = {.lex_state = 63, .external_lex_state = 2},
  [3160] = {.lex_state = 63, .external_lex_state = 2},
  [3161] = {.lex_state = 4, .external_lex_state = 2},
  [3162] = {.lex_state = 63, .external_lex_state = 2},
  [3163] = {.lex_state = 63, .external_lex_state = 2},
  [3164] = {.lex_state = 63, .external_lex_state = 2},
  [3165] = {.lex_state = 63, .external_lex_state = 4},
  [3166] = {.lex_state = 4, .external_lex_state = 3},
  [3167] = {.lex_state = 63, .external_lex_state = 2},
  [3168] = {.lex_state = 63, .external_lex_state = 2},
  [3169] = {.lex_state = 63, .external_lex_state = 2},
  [3170] = {.lex_state = 63, .external_lex_state = 4},
  [3171] = {.lex_state = 63, .external_lex_state = 2},
  [3172] = {.lex_state = 63, .external_lex_state = 2},
  [3173] = {.lex_state = 4, .external_lex_state = 3},
  [3174] = {.lex_state = 4, .external_lex_state = 3},
  [3175] = {.lex_state = 4, .external_lex_state = 3},
  [3176] = {.lex_state = 63, .external_lex_state = 2},
  [3177] = {.lex_state = 63, .external_lex_state = 2},
  [3178] = {.lex_state = 63, .external_lex_state = 2},
  [3179] = {.lex_state = 4, .external_lex_state = 2},
  [3180] = {.lex_state = 63, .external_lex_state = 2},
  [3181] = {.lex_state = 63, .external_lex_state = 3},
  [3182] = {.lex_state = 4, .external_lex_state = 3},
  [3183] = {.lex_state = 4, .external_lex_state = 3},
  [3184] = {.lex_state = 63, .external_lex_state = 3},
  [3185] = {.lex_state = 63, .external_lex_state = 3},
  [3186] = {.lex_state = 63, .external_lex_state = 3},
  [3187] = {.lex_state = 4, .external_lex_state = 3},
  [3188] = {.lex_state = 63, .external_lex_state = 3},
  [3189] = {.lex_state = 63, .external_lex_state = 3},
  [3190] = {.lex_state = 63, .external_lex_state = 3},
  [3191] = {.lex_state = 63, .external_lex_state = 3},
  [3192] = {.lex_state = 63, .external_lex_state = 3},
  [3193] = {.lex_state = 63, .external_lex_state = 3},
  [3194] = {.lex_state = 4, .external_lex_state = 3},
  [3195] = {.lex_state = 63, .external_lex_state = 3},
  [3196] = {.lex_state = 63, .external_lex_state = 3},
  [3197] = {.lex_state = 4, .external_lex_state = 3},
  [3198] = {.lex_state = 64, .external_lex_state = 5},
  [3199] = {.lex_state = 64, .external_lex_state = 5},
  [3200] = {.lex_state = 63, .external_lex_state = 3},
  [3201] = {.lex_state = 4, .external_lex_state = 3},
  [3202] = {.lex_state = 64, .external_lex_state = 5},
  [3203] = {.lex_state = 64, .external_lex_state = 5},
  [3204] = {.lex_state = 64, .external_lex_state = 5},
  [3205] = {.lex_state = 4, .external_lex_state = 3},
  [3206] = {.lex_state = 63, .external_lex_state = 3},
  [3207] = {.lex_state = 63, .external_lex_state = 3},
  [3208] = {.lex_state = 64, .external_lex_state = 5},
  [3209] = {.lex_state = 63, .external_lex_state = 3},
  [3210] = {.lex_state = 4, .external_lex_state = 3},
  [3211] = {.lex_state = 4, .external_lex_state = 3},
  [3212] = {.lex_state = 11},
  [3213] = {.lex_state = 63, .external_lex_state = 3},
  [3214] = {.lex_state = 63, .external_lex_state = 3},
  [3215] = {.lex_state = 63, .external_lex_state = 3},
  [3216] = {.lex_state = 4, .external_lex_state = 3},
  [3217] = {.lex_state = 4, .external_lex_state = 3},
  [3218] = {.lex_state = 4, .external_lex_state = 3},
  [3219] = {.lex_state = 63, .external_lex_state = 3},
  [3220] = {.lex_state = 4, .external_lex_state = 3},
  [3221] = {.lex_state = 63, .external_lex_state = 3},
  [3222] = {.lex_state = 63, .external_lex_state = 3},
  [3223] = {.lex_state = 63, .external_lex_state = 3},
  [3224] = {.lex_state = 11},
  [3225] = {.lex_state = 63, .external_lex_state = 3},
  [3226] = {.lex_state = 11},
  [3227] = {.lex_state = 63, .external_lex_state = 3},
  [3228] = {.lex_state = 63, .external_lex_state = 3},
  [3229] = {.lex_state = 4, .external_lex_state = 3},
  [3230] = {.lex_state = 63, .external_lex_state = 3},
  [3231] = {.lex_state = 63, .external_lex_state = 3},
  [3232] = {.lex_state = 4, .external_lex_state = 3},
  [3233] = {.lex_state = 63, .external_lex_state = 3},
  [3234] = {.lex_state = 4, .external_lex_state = 3},
  [3235] = {.lex_state = 63, .external_lex_state = 2},
  [3236] = {.lex_state = 4, .external_lex_state = 3},
  [3237] = {.lex_state = 4, .external_lex_state = 3},
  [3238] = {.lex_state = 63, .external_lex_state = 3},
  [3239] = {.lex_state = 63, .external_lex_state = 3},
  [3240] = {.lex_state = 4, .external_lex_state = 3},
  [3241] = {.lex_state = 63, .external_lex_state = 3},
  [3242] = {.lex_state = 64, .external_lex_state = 5},
  [3243] = {.lex_state = 4, .external_lex_state = 3},
  [3244] = {.lex_state = 64, .external_lex_state = 5},
  [3245] = {.lex_state = 4, .external_lex_state = 3},
  [3246] = {.lex_state = 63, .external_lex_state = 3},
  [3247] = {.lex_state = 4, .external_lex_state = 3},
  [3248] = {.lex_state = 4, .external_lex_state = 3},
  [3249] = {.lex_state = 64, .external_lex_state = 5},
  [3250] = {.lex_state = 4, .external_lex_state = 3},
  [3251] = {.lex_state = 63, .external_lex_state = 3},
  [3252] = {.lex_state = 64, .external_lex_state = 5},
  [3253] = {.lex_state = 4, .external_lex_state = 3},
  [3254] = {.lex_state = 63, .external_lex_state = 2},
  [3255] = {.lex_state = 63, .external_lex_state = 3},
  [3256] = {.lex_state = 4, .external_lex_state = 3},
  [3257] = {.lex_state = 4, .external_lex_state = 3},
  [3258] = {.lex_state = 4, .external_lex_state = 3},
  [3259] = {.lex_state = 64, .external_lex_state = 5},
  [3260] = {.lex_state = 4, .external_lex_state = 3},
  [3261] = {.lex_state = 4, .external_lex_state = 3},
  [3262] = {.lex_state = 63, .external_lex_state = 3},
  [3263] = {.lex_state = 11},
  [3264] = {.lex_state = 4, .external_lex_state = 3},
  [3265] = {.lex_state = 4, .external_lex_state = 3},
  [3266] = {.lex_state = 64, .external_lex_state = 5},
  [3267] = {.lex_state = 64, .external_lex_state = 5},
  [3268] = {.lex_state = 64, .external_lex_state = 5},
  [3269] = {.lex_state = 4, .external_lex_state = 3},
  [3270] = {.lex_state = 63, .external_lex_state = 3},
  [3271] = {.lex_state = 63, .external_lex_state = 2},
  [3272] = {.lex_state = 63, .external_lex_state = 2},
  [3273] = {.lex_state = 63, .external_lex_state = 3},
  [3274] = {.lex_state = 63, .external_lex_state = 3},
  [3275] = {.lex_state = 63, .external_lex_state = 3},
  [3276] = {.lex_state = 11},
  [3277] = {.lex_state = 63, .external_lex_state = 3},
  [3278] = {.lex_state = 4, .external_lex_state = 3},
  [3279] = {.lex_state = 63, .external_lex_state = 3},
  [3280] = {.lex_state = 63, .external_lex_state = 3},
  [3281] = {.lex_state = 63, .external_lex_state = 3},
  [3282] = {.lex_state = 4, .external_lex_state = 3},
  [3283] = {.lex_state = 4, .external_lex_state = 3},
  [3284] = {.lex_state = 63, .external_lex_state = 3},
  [3285] = {.lex_state = 7, .external_lex_state = 3},
  [3286] = {.lex_state = 11},
  [3287] = {.lex_state = 11},
  [3288] = {.lex_state = 63, .external_lex_state = 3},
  [3289] = {.lex_state = 63, .external_lex_state = 3},
  [3290] = {.lex_state = 63, .external_lex_state = 3},
  [3291] = {.lex_state = 4, .external_lex_state = 3},
  [3292] = {.lex_state = 63, .external_lex_state = 3},
  [3293] = {.lex_state = 63, .external_lex_state = 3},
  [3294] = {.lex_state = 63, .external_lex_state = 3},
  [3295] = {.lex_state = 4, .external_lex_state = 3},
  [3296] = {.lex_state = 63, .external_lex_state = 3},
  [3297] = {.lex_state = 63, .external_lex_state = 3},
  [3298] = {.lex_state = 63, .external_lex_state = 3},
  [3299] = {.lex_state = 63, .external_lex_state = 3},
  [3300] = {.lex_state = 4, .external_lex_state = 3},
  [3301] = {.lex_state = 11},
  [3302] = {.lex_state = 64, .external_lex_state = 5},
  [3303] = {.lex_state = 64, .external_lex_state = 5},
  [3304] = {.lex_state = 63, .external_lex_state = 3},
  [3305] = {.lex_state = 4, .external_lex_state = 3},
  [3306] = {.lex_state = 63, .external_lex_state = 3},
  [3307] = {.lex_state = 64, .external_lex_state = 5},
  [3308] = {.lex_state = 63, .external_lex_state = 3},
  [3309] = {.lex_state = 4, .external_lex_state = 3},
  [3310] = {.lex_state = 4, .external_lex_state = 3},
  [3311] = {.lex_state = 63, .external_lex_state = 3},
  [3312] = {.lex_state = 4, .external_lex_state = 3},
  [3313] = {.lex_state = 4, .external_lex_state = 3},
  [3314] = {.lex_state = 4, .external_lex_state = 3},
  [3315] = {.lex_state = 63, .external_lex_state = 3},
  [3316] = {.lex_state = 4, .external_lex_state = 3},
  [3317] = {.lex_state = 4, .external_lex_state = 3},
  [3318] = {.lex_state = 11},
  [3319] = {.lex_state = 63, .external_lex_state = 3},
  [3320] = {.lex_state = 11},
  [3321] = {.lex_state = 4, .external_lex_state = 3},
  [3322] = {.lex_state = 63, .external_lex_state = 2},
  [3323] = {.lex_state = 63, .external_lex_state = 3},
  [3324] = {.lex_state = 63, .external_lex_state = 3},
  [3325] = {.lex_state = 63, .external_lex_state = 3},
  [3326] = {.lex_state = 4, .external_lex_state = 3},
  [3327] = {.lex_state = 4, .external_lex_state = 3},
  [3328] = {.lex_state = 63, .external_lex_state = 3},
  [3329] = {.lex_state = 63, .external_lex_state = 3},
  [3330] = {.lex_state = 63, .external_lex_state = 3},
  [3331] = {.lex_state = 4, .external_lex_state = 3},
  [3332] = {.lex_state = 4, .external_lex_state = 3},
  [3333] = {.lex_state = 4, .external_lex_state = 3},
  [3334] = {.lex_state = 63, .external_lex_state = 3},
  [3335] = {.lex_state = 63, .external_lex_state = 3},
  [3336] = {.lex_state = 4, .external_lex_state = 3},
  [3337] = {.lex_state = 4, .external_lex_state = 3},
  [3338] = {.lex_state = 4, .external_lex_state = 3},
  [3339] = {.lex_state = 63, .external_lex_state = 3},
  [3340] = {.lex_state = 63, .external_lex_state = 3},
  [3341] = {.lex_state = 63, .external_lex_state = 3},
  [3342] = {.lex_state = 4, .external_lex_state = 3},
  [3343] = {.lex_state = 4, .external_lex_state = 3},
  [3344] = {.lex_state = 63, .external_lex_state = 2},
  [3345] = {.lex_state = 63, .external_lex_state = 3},
  [3346] = {.lex_state = 4, .external_lex_state = 3},
  [3347] = {.lex_state = 64, .external_lex_state = 5},
  [3348] = {.lex_state = 4, .external_lex_state = 3},
  [3349] = {.lex_state = 4, .external_lex_state = 3},
  [3350] = {.lex_state = 4, .external_lex_state = 3},
  [3351] = {.lex_state = 4, .external_lex_state = 3},
  [3352] = {.lex_state = 4, .external_lex_state = 3},
  [3353] = {.lex_state = 4, .external_lex_state = 3},
  [3354] = {.lex_state = 4, .external_lex_state = 3},
  [3355] = {.lex_state = 63, .external_lex_state = 2},
  [3356] = {.lex_state = 63, .external_lex_state = 3},
  [3357] = {.lex_state = 63, .external_lex_state = 3},
  [3358] = {.lex_state = 4, .external_lex_state = 3},
  [3359] = {.lex_state = 4, .external_lex_state = 3},
  [3360] = {.lex_state = 63, .external_lex_state = 3},
  [3361] = {.lex_state = 64, .external_lex_state = 5},
  [3362] = {.lex_state = 4, .external_lex_state = 3},
  [3363] = {.lex_state = 4, .external_lex_state = 3},
  [3364] = {.lex_state = 4, .external_lex_state = 3},
  [3365] = {.lex_state = 4, .external_lex_state = 3},
  [3366] = {.lex_state = 4, .external_lex_state = 3},
  [3367] = {.lex_state = 4, .external_lex_state = 3},
  [3368] = {.lex_state = 11},
  [3369] = {.lex_state = 4, .external_lex_state = 3},
  [3370] = {.lex_state = 64, .external_lex_state = 5},
  [3371] = {.lex_state = 4, .external_lex_state = 3},
  [3372] = {.lex_state = 63, .external_lex_state = 3},
  [3373] = {.lex_state = 4, .external_lex_state = 3},
  [3374] = {.lex_state = 63, .external_lex_state = 3},
  [3375] = {.lex_state = 64, .external_lex_state = 5},
  [3376] = {.lex_state = 63, .external_lex_state = 3},
  [3377] = {.lex_state = 4, .external_lex_state = 3},
  [3378] = {.lex_state = 4, .external_lex_state = 3},
  [3379] = {.lex_state = 63, .external_lex_state = 3},
  [3380] = {.lex_state = 63, .external_lex_state = 3},
  [3381] = {.lex_state = 4, .external_lex_state = 3},
  [3382] = {.lex_state = 63, .external_lex_state = 3},
  [3383] = {.lex_state = 11},
  [3384] = {.lex_state = 4, .external_lex_state = 3},
  [3385] = {.lex_state = 63, .external_lex_state = 3},
  [3386] = {.lex_state = 4, .external_lex_state = 3},
  [3387] = {.lex_state = 4, .external_lex_state = 3},
  [3388] = {.lex_state = 63, .external_lex_state = 3},
  [3389] = {.lex_state = 63, .external_lex_state = 3},
  [3390] = {.lex_state = 63, .external_lex_state = 3},
  [3391] = {.lex_state = 4, .external_lex_state = 3},
  [3392] = {.lex_state = 4, .external_lex_state = 3},
  [3393] = {.lex_state = 11},
  [3394] = {.lex_state = 4, .external_lex_state = 3},
  [3395] = {.lex_state = 4, .external_lex_state = 3},
  [3396] = {.lex_state = 4, .external_lex_state = 3},
  [3397] = {.lex_state = 4, .external_lex_state = 3},
  [3398] = {.lex_state = 63, .external_lex_state = 3},
  [3399] = {.lex_state = 63, .external_lex_state = 3},
  [3400] = {.lex_state = 63, .external_lex_state = 3},
  [3401] = {.lex_state = 63, .external_lex_state = 3},
  [3402] = {.lex_state = 63, .external_lex_state = 3},
  [3403] = {.lex_state = 4, .external_lex_state = 3},
  [3404] = {.lex_state = 63, .external_lex_state = 3},
  [3405] = {.lex_state = 64, .external_lex_state = 5},
  [3406] = {.lex_state = 63, .external_lex_state = 3},
  [3407] = {.lex_state = 63, .external_lex_state = 3},
  [3408] = {.lex_state = 4, .external_lex_state = 3},
  [3409] = {.lex_state = 63, .external_lex_state = 3},
  [3410] = {.lex_state = 64, .external_lex_state = 5},
  [3411] = {.lex_state = 5, .external_lex_state = 3},
  [3412] = {.lex_state = 4, .external_lex_state = 3},
  [3413] = {.lex_state = 4, .external_lex_state = 3},
  [3414] = {.lex_state = 64, .external_lex_state = 5},
  [3415] = {.lex_state = 4, .external_lex_state = 3},
  [3416] = {.lex_state = 4, .external_lex_state = 3},
  [3417] = {.lex_state = 11},
  [3418] = {.lex_state = 4, .external_lex_state = 3},
  [3419] = {.lex_state = 4, .external_lex_state = 3},
  [3420] = {.lex_state = 63, .external_lex_state = 3},
  [3421] = {.lex_state = 63, .external_lex_state = 3},
  [3422] = {.lex_state = 63, .external_lex_state = 3},
  [3423] = {.lex_state = 4, .external_lex_state = 3},
  [3424] = {.lex_state = 4, .external_lex_state = 3},
  [3425] = {.lex_state = 4, .external_lex_state = 3},
  [3426] = {.lex_state = 63, .external_lex_state = 3},
  [3427] = {.lex_state = 11},
  [3428] = {.lex_state = 4, .external_lex_state = 3},
  [3429] = {.lex_state = 4, .external_lex_state = 3},
  [3430] = {.lex_state = 63, .external_lex_state = 3},
  [3431] = {.lex_state = 4, .external_lex_state = 3},
  [3432] = {.lex_state = 64, .external_lex_state = 5},
  [3433] = {.lex_state = 63, .external_lex_state = 3},
  [3434] = {.lex_state = 63, .external_lex_state = 3},
  [3435] = {.lex_state = 63, .external_lex_state = 3},
  [3436] = {.lex_state = 63, .external_lex_state = 3},
  [3437] = {.lex_state = 64, .external_lex_state = 5},
  [3438] = {.lex_state = 64, .external_lex_state = 5},
  [3439] = {.lex_state = 63, .external_lex_state = 3},
  [3440] = {.lex_state = 4, .external_lex_state = 3},
  [3441] = {.lex_state = 4, .external_lex_state = 3},
  [3442] = {.lex_state = 63, .external_lex_state = 3},
  [3443] = {.lex_state = 63, .external_lex_state = 3},
  [3444] = {.lex_state = 63, .external_lex_state = 3},
  [3445] = {.lex_state = 63, .external_lex_state = 3},
  [3446] = {.lex_state = 63, .external_lex_state = 3},
  [3447] = {.lex_state = 4, .external_lex_state = 3},
  [3448] = {.lex_state = 63, .external_lex_state = 3},
  [3449] = {.lex_state = 63, .external_lex_state = 3},
  [3450] = {.lex_state = 4, .external_lex_state = 3},
  [3451] = {.lex_state = 4, .external_lex_state = 3},
  [3452] = {.lex_state = 63, .external_lex_state = 3},
  [3453] = {.lex_state = 4, .external_lex_state = 3},
  [3454] = {.lex_state = 63, .external_lex_state = 3},
  [3455] = {.lex_state = 4, .external_lex_state = 3},
  [3456] = {.lex_state = 4, .external_lex_state = 3},
  [3457] = {.lex_state = 4, .external_lex_state = 3},
  [3458] = {.lex_state = 63, .external_lex_state = 3},
  [3459] = {.lex_state = 63, .external_lex_state = 3},
  [3460] = {.lex_state = 63, .external_lex_state = 3},
  [3461] = {.lex_state = 4, .external_lex_state = 3},
  [3462] = {.lex_state = 63, .external_lex_state = 3},
  [3463] = {.lex_state = 64, .external_lex_state = 5},
  [3464] = {.lex_state = 63, .external_lex_state = 3},
  [3465] = {.lex_state = 63, .external_lex_state = 3},
  [3466] = {.lex_state = 64, .external_lex_state = 5},
  [3467] = {.lex_state = 63, .external_lex_state = 2},
  [3468] = {.lex_state = 63, .external_lex_state = 3},
  [3469] = {.lex_state = 63, .external_lex_state = 3},
  [3470] = {.lex_state = 64, .external_lex_state = 5},
  [3471] = {.lex_state = 63, .external_lex_state = 3},
  [3472] = {.lex_state = 64, .external_lex_state = 5},
  [3473] = {.lex_state = 64, .external_lex_state = 5},
  [3474] = {.lex_state = 63, .external_lex_state = 3},
  [3475] = {.lex_state = 63, .external_lex_state = 3},
  [3476] = {.lex_state = 63, .external_lex_state = 3},
  [3477] = {.lex_state = 63, .external_lex_state = 3},
  [3478] = {.lex_state = 64, .external_lex_state = 5},
  [3479] = {.lex_state = 63, .external_lex_state = 2},
  [3480] = {.lex_state = 63, .external_lex_state = 2},
  [3481] = {.lex_state = 63, .external_lex_state = 3},
  [3482] = {.lex_state = 63, .external_lex_state = 3},
  [3483] = {.lex_state = 63, .external_lex_state = 2},
  [3484] = {.lex_state = 64, .external_lex_state = 5},
  [3485] = {.lex_state = 63, .external_lex_state = 3},
  [3486] = {.lex_state = 63, .external_lex_state = 3},
  [3487] = {.lex_state = 63, .external_lex_state = 3},
  [3488] = {.lex_state = 63, .external_lex_state = 2},
  [3489] = {.lex_state = 63, .external_lex_state = 3},
  [3490] = {.lex_state = 63, .external_lex_state = 3},
  [3491] = {.lex_state = 63, .external_lex_state = 3},
  [3492] = {.lex_state = 64, .external_lex_state = 5},
  [3493] = {.lex_state = 63, .external_lex_state = 2},
  [3494] = {.lex_state = 64, .external_lex_state = 5},
  [3495] = {.lex_state = 64, .external_lex_state = 5},
  [3496] = {.lex_state = 63, .external_lex_state = 2},
  [3497] = {.lex_state = 63, .external_lex_state = 3},
  [3498] = {.lex_state = 63, .external_lex_state = 3},
  [3499] = {.lex_state = 64, .external_lex_state = 5},
  [3500] = {.lex_state = 64, .external_lex_state = 5},
  [3501] = {.lex_state = 63, .external_lex_state = 3},
  [3502] = {.lex_state = 63, .external_lex_state = 2},
  [3503] = {.lex_state = 63, .external_lex_state = 2},
  [3504] = {.lex_state = 63, .external_lex_state = 3},
  [3505] = {.lex_state = 63, .external_lex_state = 3},
  [3506] = {.lex_state = 63, .external_lex_state = 3},
  [3507] = {.lex_state = 63, .external_lex_state = 3},
  [3508] = {.lex_state = 63, .external_lex_state = 2},
  [3509] = {.lex_state = 64, .external_lex_state = 5},
  [3510] = {.lex_state = 63, .external_lex_state = 3},
  [3511] = {.lex_state = 64, .external_lex_state = 5},
  [3512] = {.lex_state = 63, .external_lex_state = 3},
  [3513] = {.lex_state = 63, .external_lex_state = 3},
  [3514] = {.lex_state = 64},
  [3515] = {.lex_state = 64},
  [3516] = {.lex_state = 63, .external_lex_state = 3},
  [3517] = {.lex_state = 64},
  [3518] = {.lex_state = 64},
  [3519] = {.lex_state = 63, .external_lex_state = 3},
  [3520] = {.lex_state = 63, .external_lex_state = 3},
  [3521] = {.lex_state = 64, .external_lex_state = 5},
  [3522] = {.lex_state = 64, .external_lex_state = 5},
  [3523] = {.lex_state = 64, .external_lex_state = 5},
  [3524] = {.lex_state = 64},
  [3525] = {.lex_state = 63, .external_lex_state = 3},
  [3526] = {.lex_state = 63, .external_lex_state = 3},
  [3527] = {.lex_state = 63, .external_lex_state = 3},
  [3528] = {.lex_state = 64},
  [3529] = {.lex_state = 63, .external_lex_state = 3},
  [3530] = {.lex_state = 64, .external_lex_state = 5},
  [3531] = {.lex_state = 64, .external_lex_state = 5},
  [3532] = {.lex_state = 64},
  [3533] = {.lex_state = 64, .external_lex_state = 5},
  [3534] = {.lex_state = 63, .external_lex_state = 3},
  [3535] = {.lex_state = 63, .external_lex_state = 3},
  [3536] = {.lex_state = 63, .external_lex_state = 3},
  [3537] = {.lex_state = 64},
  [3538] = {.lex_state = 63, .external_lex_state = 3},
  [3539] = {.lex_state = 64},
  [3540] = {.lex_state = 64, .external_lex_state = 5},
  [3541] = {.lex_state = 63, .external_lex_state = 3},
  [3542] = {.lex_state = 63, .external_lex_state = 3},
  [3543] = {.lex_state = 63, .external_lex_state = 3},
  [3544] = {.lex_state = 64},
  [3545] = {.lex_state = 64},
  [3546] = {.lex_state = 63, .external_lex_state = 3},
  [3547] = {.lex_state = 64, .external_lex_state = 5},
  [3548] = {.lex_state = 63, .external_lex_state = 3},
  [3549] = {.lex_state = 64, .external_lex_state = 5},
  [3550] = {.lex_state = 64},
  [3551] = {.lex_state = 64, .external_lex_state = 5},
  [3552] = {.lex_state = 64, .external_lex_state = 5},
  [3553] = {.lex_state = 64, .external_lex_state = 5},
  [3554] = {.lex_state = 64, .external_lex_state = 5},
  [3555] = {.lex_state = 64},
  [3556] = {.lex_state = 64, .external_lex_state = 5},
  [3557] = {.lex_state = 64, .external_lex_state = 5},
  [3558] = {.lex_state = 64, .external_lex_state = 5},
  [3559] = {.lex_state = 64, .external_lex_state = 5},
  [3560] = {.lex_state = 64},
  [3561] = {.lex_state = 64, .external_lex_state = 5},
  [3562] = {.lex_state = 64},
  [3563] = {.lex_state = 64},
  [3564] = {.lex_state = 64},
  [3565] = {.lex_state = 64, .external_lex_state = 5},
  [3566] = {.lex_state = 64, .external_lex_state = 5},
  [3567] = {.lex_state = 64},
  [3568] = {.lex_state = 64, .external_lex_state = 5},
  [3569] = {.lex_state = 64},
  [3570] = {.lex_state = 64},
  [3571] = {.lex_state = 64},
  [3572] = {.lex_state = 64, .external_lex_state = 5},
  [3573] = {.lex_state = 64, .external_lex_state = 5},
  [3574] = {.lex_state = 64},
  [3575] = {.lex_state = 64},
  [3576] = {.lex_state = 64},
  [3577] = {.lex_state = 64, .external_lex_state = 5},
  [3578] = {.lex_state = 64, .external_lex_state = 5},
  [3579] = {.lex_state = 64},
  [3580] = {.lex_state = 64},
  [3581] = {.lex_state = 64},
  [3582] = {.lex_state = 64},
  [3583] = {.lex_state = 64, .external_lex_state = 5},
  [3584] = {.lex_state = 64, .external_lex_state = 5},
  [3585] = {.lex_state = 64, .external_lex_state = 5},
  [3586] = {.lex_state = 64},
  [3587] = {.lex_state = 64, .external_lex_state = 5},
  [3588] = {.lex_state = 64, .external_lex_state = 5},
  [3589] = {.lex_state = 64},
  [3590] = {.lex_state = 64},
  [3591] = {.lex_state = 64},
  [3592] = {.lex_state = 64, .external_lex_state = 5},
  [3593] = {.lex_state = 64, .external_lex_state = 5},
  [3594] = {.lex_state = 64},
  [3595] = {.lex_state = 64},
  [3596] = {.lex_state = 64},
  [3597] = {.lex_state = 64, .external_lex_state = 5},
  [3598] = {.lex_state = 64, .external_lex_state = 5},
  [3599] = {.lex_state = 64, .external_lex_state = 5},
  [3600] = {.lex_state = 64},
  [3601] = {.lex_state = 64, .external_lex_state = 5},
  [3602] = {.lex_state = 64, .external_lex_state = 5},
  [3603] = {.lex_state = 64},
  [3604] = {.lex_state = 64, .external_lex_state = 5},
  [3605] = {.lex_state = 64, .external_lex_state = 5},
  [3606] = {.lex_state = 64},
  [3607] = {.lex_state = 64},
  [3608] = {.lex_state = 64},
  [3609] = {.lex_state = 64, .external_lex_state = 5},
  [3610] = {.lex_state = 64, .external_lex_state = 5},
  [3611] = {.lex_state = 64, .external_lex_state = 5},
  [3612] = {.lex_state = 64},
  [3613] = {.lex_state = 64},
  [3614] = {.lex_state = 64},
  [3615] = {.lex_state = 64},
  [3616] = {.lex_state = 64},
  [3617] = {.lex_state = 64, .external_lex_state = 5},
  [3618] = {.lex_state = 64},
  [3619] = {.lex_state = 64},
  [3620] = {.lex_state = 64},
  [3621] = {.lex_state = 64},
  [3622] = {.lex_state = 64, .external_lex_state = 5},
  [3623] = {.lex_state = 64},
  [3624] = {.lex_state = 64, .external_lex_state = 5},
  [3625] = {.lex_state = 64, .external_lex_state = 5},
  [3626] = {.lex_state = 64, .external_lex_state = 5},
  [3627] = {.lex_state = 64, .external_lex_state = 5},
  [3628] = {.lex_state = 64, .external_lex_state = 5},
  [3629] = {.lex_state = 64, .external_lex_state = 5},
  [3630] = {.lex_state = 64, .external_lex_state = 5},
  [3631] = {.lex_state = 64, .external_lex_state = 5},
  [3632] = {.lex_state = 64},
  [3633] = {.lex_state = 64},
  [3634] = {.lex_state = 64, .external_lex_state = 5},
  [3635] = {.lex_state = 64},
  [3636] = {.lex_state = 64, .external_lex_state = 5},
  [3637] = {.lex_state = 64, .external_lex_state = 5},
  [3638] = {.lex_state = 13},
  [3639] = {.lex_state = 64},
  [3640] = {.lex_state = 64, .external_lex_state = 5},
  [3641] = {.lex_state = 64, .external_lex_state = 5},
  [3642] = {.lex_state = 64, .external_lex_state = 5},
  [3643] = {.lex_state = 64},
  [3644] = {.lex_state = 64},
  [3645] = {.lex_state = 64},
  [3646] = {.lex_state = 64, .external_lex_state = 5},
  [3647] = {.lex_state = 64},
  [3648] = {.lex_state = 64, .external_lex_state = 5},
  [3649] = {.lex_state = 64},
  [3650] = {.lex_state = 64, .external_lex_state = 5},
  [3651] = {.lex_state = 64, .external_lex_state = 5},
  [3652] = {.lex_state = 13},
  [3653] = {.lex_state = 64},
  [3654] = {.lex_state = 64},
  [3655] = {.lex_state = 64, .external_lex_state = 5},
  [3656] = {.lex_state = 64},
  [3657] = {.lex_state = 64},
  [3658] = {.lex_state = 64, .external_lex_state = 5},
  [3659] = {.lex_state = 64},
  [3660] = {.lex_state = 64},
  [3661] = {.lex_state = 64},
  [3662] = {.lex_state = 64},
  [3663] = {.lex_state = 64},
  [3664] = {.lex_state = 64},
  [3665] = {.lex_state = 64, .external_lex_state = 5},
  [3666] = {.lex_state = 64},
  [3667] = {.lex_state = 64},
  [3668] = {.lex_state = 64},
  [3669] = {.lex_state = 64, .external_lex_state = 5},
  [3670] = {.lex_state = 64},
  [3671] = {.lex_state = 64},
  [3672] = {.lex_state = 64},
  [3673] = {.lex_state = 64},
  [3674] = {.lex_state = 64},
  [3675] = {.lex_state = 64},
  [3676] = {.lex_state = 64},
  [3677] = {.lex_state = 64},
  [3678] = {.lex_state = 64},
  [3679] = {.lex_state = 64},
  [3680] = {.lex_state = 64},
  [3681] = {.lex_state = 64},
  [3682] = {.lex_state = 64},
  [3683] = {.lex_state = 64},
  [3684] = {.lex_state = 64},
  [3685] = {.lex_state = 13},
  [3686] = {.lex_state = 13},
  [3687] = {.lex_state = 64},
  [3688] = {.lex_state = 13},
  [3689] = {.lex_state = 13},
  [3690] = {.lex_state = 13},
  [3691] = {.lex_state = 64},
  [3692] = {.lex_state = 64},
  [3693] = {.lex_state = 64},
  [3694] = {.lex_state = 11, .external_lex_state = 5},
  [3695] = {.lex_state = 64},
  [3696] = {.lex_state = 64},
  [3697] = {.lex_state = 11, .external_lex_state = 5},
  [3698] = {.lex_state = 11, .external_lex_state = 5},
  [3699] = {.lex_state = 11, .external_lex_state = 5},
  [3700] = {.lex_state = 11, .external_lex_state = 5},
  [3701] = {.lex_state = 11, .external_lex_state = 5},
  [3702] = {.lex_state = 64},
  [3703] = {.lex_state = 11, .external_lex_state = 5},
  [3704] = {.lex_state = 11, .external_lex_state = 5},
  [3705] = {.lex_state = 11, .external_lex_state = 5},
  [3706] = {.lex_state = 64},
  [3707] = {.lex_state = 11, .external_lex_state = 5},
  [3708] = {.lex_state = 11, .external_lex_state = 5},
  [3709] = {.lex_state = 11, .external_lex_state = 5},
  [3710] = {.lex_state = 64},
  [3711] = {.lex_state = 11, .external_lex_state = 5},
  [3712] = {.lex_state = 64},
  [3713] = {.lex_state = 64},
  [3714] = {.lex_state = 11, .external_lex_state = 5},
  [3715] = {.lex_state = 11, .external_lex_state = 5},
  [3716] = {.lex_state = 11, .external_lex_state = 5},
  [3717] = {.lex_state = 11, .external_lex_state = 5},
  [3718] = {.lex_state = 11, .external_lex_state = 5},
  [3719] = {.lex_state = 64},
  [3720] = {.lex_state = 11, .external_lex_state = 5},
  [3721] = {.lex_state = 11, .external_lex_state = 5},
  [3722] = {.lex_state = 11, .external_lex_state = 5},
  [3723] = {.lex_state = 11, .external_lex_state = 5},
  [3724] = {.lex_state = 64},
  [3725] = {.lex_state = 64},
  [3726] = {.lex_state = 11, .external_lex_state = 5},
  [3727] = {.lex_state = 64},
  [3728] = {.lex_state = 64},
  [3729] = {.lex_state = 64},
  [3730] = {.lex_state = 64},
  [3731] = {.lex_state = 64},
  [3732] = {.lex_state = 64},
  [3733] = {.lex_state = 64},
  [3734] = {.lex_state = 64},
  [3735] = {.lex_state = 64},
  [3736] = {.lex_state = 64},
  [3737] = {.lex_state = 64},
  [3738] = {.lex_state = 64},
  [3739] = {.lex_state = 64},
  [3740] = {.lex_state = 64},
  [3741] = {.lex_state = 64},
  [3742] = {.lex_state = 64},
  [3743] = {.lex_state = 64},
  [3744] = {.lex_state = 64},
  [3745] = {.lex_state = 64},
  [3746] = {.lex_state = 64},
  [3747] = {.lex_state = 64},
  [3748] = {.lex_state = 64},
  [3749] = {.lex_state = 64},
  [3750] = {.lex_state = 64},
  [3751] = {.lex_state = 64},
  [3752] = {.lex_state = 64},
  [3753] = {.lex_state = 11},
  [3754] = {.lex_state = 64},
  [3755] = {.lex_state = 64},
  [3756] = {.lex_state = 64},
  [3757] = {.lex_state = 64},
  [3758] = {.lex_state = 64},
  [3759] = {.lex_state = 64},
  [3760] = {.lex_state = 64},
  [3761] = {.lex_state = 64},
  [3762] = {.lex_state = 64},
  [3763] = {.lex_state = 64},
  [3764] = {.lex_state = 64},
  [3765] = {.lex_state = 64},
  [3766] = {.lex_state = 64},
  [3767] = {.lex_state = 64},
  [3768] = {.lex_state = 64},
  [3769] = {.lex_state = 64},
  [3770] = {.lex_state = 64},
  [3771] = {.lex_state = 64},
  [3772] = {.lex_state = 64},
  [3773] = {.lex_state = 64},
  [3774] = {.lex_state = 64},
  [3775] = {.lex_state = 64},
  [3776] = {.lex_state = 64},
  [3777] = {.lex_state = 64},
  [3778] = {.lex_state = 64},
  [3779] = {.lex_state = 64},
  [3780] = {.lex_state = 64},
  [3781] = {.lex_state = 64},
  [3782] = {.lex_state = 64},
  [3783] = {.lex_state = 64},
  [3784] = {.lex_state = 64},
  [3785] = {.lex_state = 64},
  [3786] = {.lex_state = 64},
  [3787] = {.lex_state = 64},
  [3788] = {.lex_state = 64},
  [3789] = {.lex_state = 64},
  [3790] = {.lex_state = 64},
  [3791] = {.lex_state = 64},
  [3792] = {.lex_state = 64},
  [3793] = {.lex_state = 64},
  [3794] = {.lex_state = 64, .external_lex_state = 5},
  [3795] = {.lex_state = 64, .external_lex_state = 5},
  [3796] = {.lex_state = 64},
  [3797] = {.lex_state = 2},
  [3798] = {.lex_state = 2},
  [3799] = {.lex_state = 2},
  [3800] = {.lex_state = 2},
  [3801] = {.lex_state = 2},
  [3802] = {.lex_state = 2},
  [3803] = {.lex_state = 2},
  [3804] = {.lex_state = 2},
  [3805] = {.lex_state = 2},
  [3806] = {.lex_state = 2},
  [3807] = {.lex_state = 2},
  [3808] = {.lex_state = 2},
  [3809] = {.lex_state = 2},
  [3810] = {.lex_state = 2},
  [3811] = {.lex_state = 2},
  [3812] = {.lex_state = 2},
  [3813] = {.lex_state = 64},
  [3814] = {.lex_state = 2},
  [3815] = {.lex_state = 2},
  [3816] = {.lex_state = 2},
  [3817] = {.lex_state = 2},
  [3818] = {.lex_state = 64, .external_lex_state = 5},
  [3819] = {.lex_state = 64, .external_lex_state = 5},
  [3820] = {.lex_state = 64},
  [3821] = {.lex_state = 64},
  [3822] = {.lex_state = 64, .external_lex_state = 5},
  [3823] = {.lex_state = 64, .external_lex_state = 5},
  [3824] = {.lex_state = 64, .external_lex_state = 5},
  [3825] = {.lex_state = 64, .external_lex_state = 5},
  [3826] = {.lex_state = 64, .external_lex_state = 5},
  [3827] = {.lex_state = 64, .external_lex_state = 5},
  [3828] = {.lex_state = 64, .external_lex_state = 5},
  [3829] = {.lex_state = 64},
  [3830] = {.lex_state = 64},
  [3831] = {.lex_state = 64},
  [3832] = {.lex_state = 64},
  [3833] = {.lex_state = 64},
  [3834] = {.lex_state = 64},
  [3835] = {.lex_state = 64},
  [3836] = {.lex_state = 64, .external_lex_state = 5},
  [3837] = {.lex_state = 64, .external_lex_state = 5},
  [3838] = {.lex_state = 64, .external_lex_state = 5},
  [3839] = {.lex_state = 64, .external_lex_state = 5},
  [3840] = {.lex_state = 64},
  [3841] = {.lex_state = 64},
  [3842] = {.lex_state = 64},
  [3843] = {.lex_state = 64, .external_lex_state = 5},
  [3844] = {.lex_state = 64},
  [3845] = {.lex_state = 64},
  [3846] = {.lex_state = 64},
  [3847] = {.lex_state = 64, .external_lex_state = 5},
  [3848] = {.lex_state = 64},
  [3849] = {.lex_state = 64, .external_lex_state = 5},
  [3850] = {.lex_state = 64},
  [3851] = {.lex_state = 64},
  [3852] = {.lex_state = 64},
  [3853] = {.lex_state = 64},
  [3854] = {.lex_state = 64},
  [3855] = {.lex_state = 64, .external_lex_state = 5},
  [3856] = {.lex_state = 64},
  [3857] = {.lex_state = 64},
  [3858] = {.lex_state = 64},
  [3859] = {.lex_state = 64, .external_lex_state = 5},
  [3860] = {.lex_state = 64},
  [3861] = {.lex_state = 64},
  [3862] = {.lex_state = 64},
  [3863] = {.lex_state = 64, .external_lex_state = 5},
  [3864] = {.lex_state = 64},
  [3865] = {.lex_state = 64, .external_lex_state = 5},
  [3866] = {.lex_state = 64, .external_lex_state = 5},
  [3867] = {.lex_state = 64, .external_lex_state = 5},
  [3868] = {.lex_state = 64, .external_lex_state = 5},
  [3869] = {.lex_state = 64, .external_lex_state = 5},
  [3870] = {.lex_state = 64, .external_lex_state = 5},
  [3871] = {.lex_state = 64, .external_lex_state = 5},
  [3872] = {.lex_state = 64, .external_lex_state = 5},
  [3873] = {.lex_state = 64, .external_lex_state = 5},
  [3874] = {.lex_state = 64, .external_lex_state = 5},
  [3875] = {.lex_state = 64, .external_lex_state = 5},
  [3876] = {.lex_state = 64, .external_lex_state = 6},
  [3877] = {.lex_state = 64, .external_lex_state = 5},
  [3878] = {.lex_state = 64, .external_lex_state = 5},
  [3879] = {.lex_state = 64, .external_lex_state = 5},
  [3880] = {.lex_state = 64, .external_lex_state = 5},
  [3881] = {.lex_state = 64, .external_lex_state = 5},
  [3882] = {.lex_state = 64},
  [3883] = {.lex_state = 64, .external_lex_state = 5},
  [3884] = {.lex_state = 64},
  [3885] = {.lex_state = 64, .external_lex_state = 5},
  [3886] = {.lex_state = 64, .external_lex_state = 5},
  [3887] = {.lex_state = 64, .external_lex_state = 5},
  [3888] = {.lex_state = 64, .external_lex_state = 5},
  [3889] = {.lex_state = 64, .external_lex_state = 5},
  [3890] = {.lex_state = 64, .external_lex_state = 5},
  [3891] = {.lex_state = 64, .external_lex_state = 5},
  [3892] = {.lex_state = 64, .external_lex_state = 5},
  [3893] = {.lex_state = 64, .external_lex_state = 5},
  [3894] = {.lex_state = 64, .external_lex_state = 5},
  [3895] = {.lex_state = 64, .external_lex_state = 5},
  [3896] = {.lex_state = 64, .external_lex_state = 5},
  [3897] = {.lex_state = 64, .external_lex_state = 5},
  [3898] = {.lex_state = 64, .external_lex_state = 5},
  [3899] = {.lex_state = 64},
  [3900] = {.lex_state = 64, .external_lex_state = 5},
  [3901] = {.lex_state = 64, .external_lex_state = 5},
  [3902] = {.lex_state = 64},
  [3903] = {.lex_state = 64, .external_lex_state = 5},
  [3904] = {.lex_state = 64},
  [3905] = {.lex_state = 64, .external_lex_state = 5},
  [3906] = {.lex_state = 64, .external_lex_state = 5},
  [3907] = {.lex_state = 64, .external_lex_state = 5},
  [3908] = {.lex_state = 64, .external_lex_state = 5},
  [3909] = {.lex_state = 64, .external_lex_state = 5},
  [3910] = {.lex_state = 64, .external_lex_state = 6},
  [3911] = {.lex_state = 64, .external_lex_state = 5},
  [3912] = {.lex_state = 64, .external_lex_state = 5},
  [3913] = {.lex_state = 64, .external_lex_state = 5},
  [3914] = {.lex_state = 64, .external_lex_state = 5},
  [3915] = {.lex_state = 64, .external_lex_state = 5},
  [3916] = {.lex_state = 64},
  [3917] = {.lex_state = 64, .external_lex_state = 5},
  [3918] = {.lex_state = 64, .external_lex_state = 5},
  [3919] = {.lex_state = 64, .external_lex_state = 5},
  [3920] = {.lex_state = 64, .external_lex_state = 5},
  [3921] = {.lex_state = 64, .external_lex_state = 5},
  [3922] = {.lex_state = 64},
  [3923] = {.lex_state = 64, .external_lex_state = 5},
  [3924] = {.lex_state = 64},
  [3925] = {.lex_state = 64, .external_lex_state = 5},
  [3926] = {.lex_state = 64, .external_lex_state = 5},
  [3927] = {.lex_state = 64, .external_lex_state = 5},
  [3928] = {.lex_state = 64, .external_lex_state = 5},
  [3929] = {.lex_state = 64, .external_lex_state = 5},
  [3930] = {.lex_state = 64, .external_lex_state = 5},
  [3931] = {.lex_state = 64, .external_lex_state = 5},
  [3932] = {.lex_state = 64, .external_lex_state = 5},
  [3933] = {.lex_state = 64, .external_lex_state = 5},
  [3934] = {.lex_state = 64, .external_lex_state = 5},
  [3935] = {.lex_state = 64, .external_lex_state = 5},
  [3936] = {.lex_state = 64, .external_lex_state = 5},
  [3937] = {.lex_state = 64, .external_lex_state = 5},
  [3938] = {.lex_state = 64, .external_lex_state = 5},
  [3939] = {.lex_state = 64, .external_lex_state = 5},
  [3940] = {.lex_state = 64},
  [3941] = {.lex_state = 64},
  [3942] = {.lex_state = 64},
  [3943] = {.lex_state = 64},
  [3944] = {.lex_state = 64},
  [3945] = {.lex_state = 64},
  [3946] = {.lex_state = 64, .external_lex_state = 5},
  [3947] = {.lex_state = 64, .external_lex_state = 5},
  [3948] = {.lex_state = 64, .external_lex_state = 5},
  [3949] = {.lex_state = 64},
  [3950] = {.lex_state = 64, .external_lex_state = 6},
  [3951] = {.lex_state = 64, .external_lex_state = 5},
  [3952] = {.lex_state = 64, .external_lex_state = 5},
  [3953] = {.lex_state = 64},
  [3954] = {.lex_state = 64, .external_lex_state = 5},
  [3955] = {.lex_state = 64},
  [3956] = {.lex_state = 64},
  [3957] = {.lex_state = 64},
  [3958] = {.lex_state = 64, .external_lex_state = 5},
  [3959] = {.lex_state = 64, .external_lex_state = 5},
  [3960] = {.lex_state = 64},
  [3961] = {.lex_state = 64},
  [3962] = {.lex_state = 64},
  [3963] = {.lex_state = 64, .external_lex_state = 5},
  [3964] = {.lex_state = 64, .external_lex_state = 6},
  [3965] = {.lex_state = 64, .external_lex_state = 5},
  [3966] = {.lex_state = 64, .external_lex_state = 5},
  [3967] = {.lex_state = 64},
  [3968] = {.lex_state = 64},
  [3969] = {.lex_state = 64},
  [3970] = {.lex_state = 64, .external_lex_state = 5},
  [3971] = {.lex_state = 64},
  [3972] = {.lex_state = 64},
  [3973] = {.lex_state = 64},
  [3974] = {.lex_state = 64},
  [3975] = {.lex_state = 64},
  [3976] = {.lex_state = 64},
  [3977] = {.lex_state = 64, .external_lex_state = 5},
  [3978] = {.lex_state = 64},
  [3979] = {.lex_state = 64},
  [3980] = {.lex_state = 64},
  [3981] = {.lex_state = 64},
  [3982] = {.lex_state = 64},
  [3983] = {.lex_state = 64},
  [3984] = {.lex_state = 64, .external_lex_state = 5},
  [3985] = {.lex_state = 64},
  [3986] = {.lex_state = 64, .external_lex_state = 5},
  [3987] = {.lex_state = 64},
  [3988] = {.lex_state = 64},
  [3989] = {.lex_state = 64},
  [3990] = {.lex_state = 64, .external_lex_state = 5},
  [3991] = {.lex_state = 64, .external_lex_state = 5},
  [3992] = {.lex_state = 64},
  [3993] = {.lex_state = 64},
  [3994] = {.lex_state = 64},
  [3995] = {.lex_state = 64},
  [3996] = {.lex_state = 64},
  [3997] = {.lex_state = 64},
  [3998] = {.lex_state = 64},
  [3999] = {.lex_state = 64},
  [4000] = {.lex_state = 64},
  [4001] = {.lex_state = 64},
  [4002] = {.lex_state = 64},
  [4003] = {.lex_state = 64},
  [4004] = {.lex_state = 64},
  [4005] = {.lex_state = 64},
  [4006] = {.lex_state = 64},
  [4007] = {.lex_state = 64},
  [4008] = {.lex_state = 64},
  [4009] = {.lex_state = 64},
  [4010] = {.lex_state = 64},
  [4011] = {.lex_state = 64},
  [4012] = {.lex_state = 64},
  [4013] = {.lex_state = 64, .external_lex_state = 5},
  [4014] = {.lex_state = 64},
  [4015] = {.lex_state = 64},
  [4016] = {.lex_state = 64},
  [4017] = {.lex_state = 64, .external_lex_state = 6},
  [4018] = {.lex_state = 64, .external_lex_state = 5},
  [4019] = {.lex_state = 64},
  [4020] = {.lex_state = 64},
  [4021] = {.lex_state = 64},
  [4022] = {.lex_state = 64},
  [4023] = {.lex_state = 64},
  [4024] = {.lex_state = 64},
  [4025] = {.lex_state = 64, .external_lex_state = 5},
  [4026] = {.lex_state = 64, .external_lex_state = 5},
  [4027] = {.lex_state = 64},
  [4028] = {.lex_state = 64},
  [4029] = {.lex_state = 64},
  [4030] = {.lex_state = 64},
  [4031] = {.lex_state = 64},
  [4032] = {.lex_state = 64, .external_lex_state = 6},
  [4033] = {.lex_state = 64, .external_lex_state = 6},
  [4034] = {.lex_state = 64},
  [4035] = {.lex_state = 64, .external_lex_state = 6},
  [4036] = {.lex_state = 64, .external_lex_state = 5},
  [4037] = {.lex_state = 64},
  [4038] = {.lex_state = 64, .external_lex_state = 5},
  [4039] = {.lex_state = 64, .external_lex_state = 6},
  [4040] = {.lex_state = 64},
  [4041] = {.lex_state = 64, .external_lex_state = 5},
  [4042] = {.lex_state = 64, .external_lex_state = 5},
  [4043] = {.lex_state = 64, .external_lex_state = 6},
  [4044] = {.lex_state = 64, .external_lex_state = 5},
  [4045] = {.lex_state = 64, .external_lex_state = 5},
  [4046] = {.lex_state = 64},
  [4047] = {.lex_state = 64, .external_lex_state = 5},
  [4048] = {.lex_state = 64, .external_lex_state = 6},
  [4049] = {.lex_state = 64, .external_lex_state = 6},
  [4050] = {.lex_state = 64, .external_lex_state = 6},
  [4051] = {.lex_state = 64, .external_lex_state = 6},
  [4052] = {.lex_state = 64, .external_lex_state = 6},
  [4053] = {.lex_state = 64, .external_lex_state = 6},
  [4054] = {.lex_state = 64, .external_lex_state = 5},
  [4055] = {.lex_state = 64, .external_lex_state = 5},
  [4056] = {.lex_state = 64, .external_lex_state = 6},
  [4057] = {.lex_state = 64},
  [4058] = {.lex_state = 64, .external_lex_state = 6},
  [4059] = {.lex_state = 64, .external_lex_state = 6},
  [4060] = {.lex_state = 64, .external_lex_state = 6},
  [4061] = {.lex_state = 64, .external_lex_state = 6},
  [4062] = {.lex_state = 64, .external_lex_state = 5},
  [4063] = {.lex_state = 64, .external_lex_state = 6},
  [4064] = {.lex_state = 64, .external_lex_state = 6},
  [4065] = {.lex_state = 64, .external_lex_state = 6},
  [4066] = {.lex_state = 64, .external_lex_state = 6},
  [4067] = {.lex_state = 64, .external_lex_state = 6},
  [4068] = {.lex_state = 64},
  [4069] = {.lex_state = 64, .external_lex_state = 6},
  [4070] = {.lex_state = 64, .external_lex_state = 6},
  [4071] = {.lex_state = 64},
  [4072] = {.lex_state = 64, .external_lex_state = 6},
  [4073] = {.lex_state = 64, .external_lex_state = 6},
  [4074] = {.lex_state = 64, .external_lex_state = 6},
  [4075] = {.lex_state = 64, .external_lex_state = 6},
  [4076] = {.lex_state = 64, .external_lex_state = 6},
  [4077] = {.lex_state = 64, .external_lex_state = 6},
  [4078] = {.lex_state = 64, .external_lex_state = 6},
  [4079] = {.lex_state = 64, .external_lex_state = 6},
  [4080] = {.lex_state = 64, .external_lex_state = 6},
  [4081] = {.lex_state = 64, .external_lex_state = 6},
  [4082] = {.lex_state = 64, .external_lex_state = 5},
  [4083] = {.lex_state = 64, .external_lex_state = 6},
  [4084] = {.lex_state = 64, .external_lex_state = 6},
  [4085] = {.lex_state = 64, .external_lex_state = 6},
  [4086] = {.lex_state = 64, .external_lex_state = 6},
  [4087] = {.lex_state = 64, .external_lex_state = 6},
  [4088] = {.lex_state = 64},
  [4089] = {.lex_state = 64, .external_lex_state = 6},
  [4090] = {.lex_state = 64, .external_lex_state = 6},
  [4091] = {.lex_state = 64, .external_lex_state = 6},
  [4092] = {.lex_state = 64, .external_lex_state = 6},
  [4093] = {.lex_state = 64, .external_lex_state = 6},
  [4094] = {.lex_state = 64, .external_lex_state = 6},
  [4095] = {.lex_state = 64, .external_lex_state = 6},
  [4096] = {.lex_state = 64, .external_lex_state = 5},
  [4097] = {.lex_state = 64},
  [4098] = {.lex_state = 64, .external_lex_state = 5},
  [4099] = {.lex_state = 64, .external_lex_state = 5},
  [4100] = {.lex_state = 64, .external_lex_state = 5},
  [4101] = {.lex_state = 64},
  [4102] = {.lex_state = 64},
  [4103] = {.lex_state = 0, .external_lex_state = 5},
  [4104] = {.lex_state = 64},
  [4105] = {.lex_state = 64},
  [4106] = {.lex_state = 64, .external_lex_state = 6},
  [4107] = {.lex_state = 64},
  [4108] = {.lex_state = 64, .external_lex_state = 5},
  [4109] = {.lex_state = 64, .external_lex_state = 5},
  [4110] = {.lex_state = 64, .external_lex_state = 5},
  [4111] = {.lex_state = 64},
  [4112] = {.lex_state = 64},
  [4113] = {.lex_state = 64},
  [4114] = {.lex_state = 64},
  [4115] = {.lex_state = 64},
  [4116] = {.lex_state = 64, .external_lex_state = 5},
  [4117] = {.lex_state = 64},
  [4118] = {.lex_state = 64},
  [4119] = {.lex_state = 64},
  [4120] = {.lex_state = 64},
  [4121] = {.lex_state = 64},
  [4122] = {.lex_state = 64},
  [4123] = {.lex_state = 0, .external_lex_state = 5},
  [4124] = {.lex_state = 64},
  [4125] = {.lex_state = 0, .external_lex_state = 5},
  [4126] = {.lex_state = 64, .external_lex_state = 5},
  [4127] = {.lex_state = 64, .external_lex_state = 5},
  [4128] = {.lex_state = 64},
  [4129] = {.lex_state = 64},
  [4130] = {.lex_state = 64},
  [4131] = {.lex_state = 64},
  [4132] = {.lex_state = 64},
  [4133] = {.lex_state = 64},
  [4134] = {.lex_state = 64},
  [4135] = {.lex_state = 64},
  [4136] = {.lex_state = 64},
  [4137] = {.lex_state = 64},
  [4138] = {.lex_state = 64},
  [4139] = {.lex_state = 64, .external_lex_state = 5},
  [4140] = {.lex_state = 64, .external_lex_state = 5},
  [4141] = {.lex_state = 64},
  [4142] = {.lex_state = 64},
  [4143] = {.lex_state = 64},
  [4144] = {.lex_state = 64, .external_lex_state = 5},
  [4145] = {.lex_state = 64, .external_lex_state = 5},
  [4146] = {.lex_state = 64},
  [4147] = {.lex_state = 64},
  [4148] = {.lex_state = 64, .external_lex_state = 5},
  [4149] = {.lex_state = 64, .external_lex_state = 5},
  [4150] = {.lex_state = 64},
  [4151] = {.lex_state = 64},
  [4152] = {.lex_state = 64},
  [4153] = {.lex_state = 64, .external_lex_state = 5},
  [4154] = {.lex_state = 64},
  [4155] = {.lex_state = 64, .external_lex_state = 5},
  [4156] = {.lex_state = 64},
  [4157] = {.lex_state = 64},
  [4158] = {.lex_state = 64},
  [4159] = {.lex_state = 64, .external_lex_state = 5},
  [4160] = {.lex_state = 64, .external_lex_state = 5},
  [4161] = {.lex_state = 64, .external_lex_state = 5},
  [4162] = {.lex_state = 64},
  [4163] = {.lex_state = 64},
  [4164] = {.lex_state = 64},
  [4165] = {.lex_state = 64},
  [4166] = {.lex_state = 64, .external_lex_state = 5},
  [4167] = {.lex_state = 64},
  [4168] = {.lex_state = 0, .external_lex_state = 5},
  [4169] = {.lex_state = 64, .external_lex_state = 5},
  [4170] = {.lex_state = 64},
  [4171] = {.lex_state = 64},
  [4172] = {.lex_state = 64},
  [4173] = {.lex_state = 64, .external_lex_state = 5},
  [4174] = {.lex_state = 64},
  [4175] = {.lex_state = 64, .external_lex_state = 5},
  [4176] = {.lex_state = 64, .external_lex_state = 5},
  [4177] = {.lex_state = 64, .external_lex_state = 5},
  [4178] = {.lex_state = 64},
  [4179] = {.lex_state = 64},
  [4180] = {.lex_state = 64, .external_lex_state = 5},
  [4181] = {.lex_state = 64},
  [4182] = {.lex_state = 64, .external_lex_state = 5},
  [4183] = {.lex_state = 64},
  [4184] = {.lex_state = 64},
  [4185] = {.lex_state = 64},
  [4186] = {.lex_state = 64, .external_lex_state = 5},
  [4187] = {.lex_state = 10},
  [4188] = {.lex_state = 64},
  [4189] = {.lex_state = 64},
  [4190] = {.lex_state = 64, .external_lex_state = 5},
  [4191] = {.lex_state = 64, .external_lex_state = 5},
  [4192] = {.lex_state = 0, .external_lex_state = 5},
  [4193] = {.lex_state = 64},
  [4194] = {.lex_state = 64},
  [4195] = {.lex_state = 64},
  [4196] = {.lex_state = 64},
  [4197] = {.lex_state = 64},
  [4198] = {.lex_state = 64},
  [4199] = {.lex_state = 64},
  [4200] = {.lex_state = 64},
  [4201] = {.lex_state = 64},
  [4202] = {.lex_state = 64},
  [4203] = {.lex_state = 64, .external_lex_state = 5},
  [4204] = {.lex_state = 64},
  [4205] = {.lex_state = 0, .external_lex_state = 5},
  [4206] = {.lex_state = 64},
  [4207] = {.lex_state = 64},
  [4208] = {.lex_state = 64},
  [4209] = {.lex_state = 64},
  [4210] = {.lex_state = 64},
  [4211] = {.lex_state = 64},
  [4212] = {.lex_state = 64},
  [4213] = {.lex_state = 64},
  [4214] = {.lex_state = 64},
  [4215] = {.lex_state = 64},
  [4216] = {.lex_state = 64, .external_lex_state = 5},
  [4217] = {.lex_state = 64},
  [4218] = {.lex_state = 64},
  [4219] = {.lex_state = 64},
  [4220] = {.lex_state = 64},
  [4221] = {.lex_state = 64},
  [4222] = {.lex_state = 64},
  [4223] = {.lex_state = 64},
  [4224] = {.lex_state = 64, .external_lex_state = 5},
  [4225] = {.lex_state = 64},
  [4226] = {.lex_state = 64},
  [4227] = {.lex_state = 0, .external_lex_state = 5},
  [4228] = {.lex_state = 64},
  [4229] = {.lex_state = 10},
  [4230] = {.lex_state = 64},
  [4231] = {.lex_state = 64},
  [4232] = {.lex_state = 64},
  [4233] = {.lex_state = 64},
  [4234] = {.lex_state = 0, .external_lex_state = 5},
  [4235] = {.lex_state = 64},
  [4236] = {.lex_state = 64},
  [4237] = {.lex_state = 64},
  [4238] = {.lex_state = 64},
  [4239] = {.lex_state = 64},
  [4240] = {.lex_state = 64},
  [4241] = {.lex_state = 64},
  [4242] = {.lex_state = 64},
  [4243] = {.lex_state = 64, .external_lex_state = 5},
  [4244] = {.lex_state = 64},
  [4245] = {.lex_state = 64},
  [4246] = {.lex_state = 15, .external_lex_state = 7},
  [4247] = {.lex_state = 0, .external_lex_state = 5},
  [4248] = {.lex_state = 0, .external_lex_state = 5},
  [4249] = {.lex_state = 15, .external_lex_state = 7},
  [4250] = {.lex_state = 0, .external_lex_state = 5},
  [4251] = {.lex_state = 64},
  [4252] = {.lex_state = 64},
  [4253] = {.lex_state = 15},
  [4254] = {.lex_state = 15},
  [4255] = {.lex_state = 64},
  [4256] = {.lex_state = 64},
  [4257] = {.lex_state = 64},
  [4258] = {.lex_state = 0, .external_lex_state = 5},
  [4259] = {.lex_state = 64},
  [4260] = {.lex_state = 0, .external_lex_state = 5},
  [4261] = {.lex_state = 64},
  [4262] = {.lex_state = 64},
  [4263] = {.lex_state = 64},
  [4264] = {.lex_state = 64},
  [4265] = {.lex_state = 15, .external_lex_state = 7},
  [4266] = {.lex_state = 64},
  [4267] = {.lex_state = 15, .external_lex_state = 7},
  [4268] = {.lex_state = 64},
  [4269] = {.lex_state = 64},
  [4270] = {.lex_state = 64},
  [4271] = {.lex_state = 64},
  [4272] = {.lex_state = 64},
  [4273] = {.lex_state = 0, .external_lex_state = 5},
  [4274] = {.lex_state = 64},
  [4275] = {.lex_state = 15},
  [4276] = {.lex_state = 64},
  [4277] = {.lex_state = 15},
  [4278] = {.lex_state = 64},
  [4279] = {.lex_state = 64},
  [4280] = {.lex_state = 64},
  [4281] = {.lex_state = 15, .external_lex_state = 7},
  [4282] = {.lex_state = 64},
  [4283] = {.lex_state = 64},
  [4284] = {.lex_state = 64},
  [4285] = {.lex_state = 64, .external_lex_state = 5},
  [4286] = {.lex_state = 64},
  [4287] = {.lex_state = 64},
  [4288] = {.lex_state = 15, .external_lex_state = 7},
  [4289] = {.lex_state = 64},
  [4290] = {.lex_state = 64},
  [4291] = {.lex_state = 0, .external_lex_state = 5},
  [4292] = {.lex_state = 64},
  [4293] = {.lex_state = 0, .external_lex_state = 5},
  [4294] = {.lex_state = 64, .external_lex_state = 5},
  [4295] = {.lex_state = 64},
  [4296] = {.lex_state = 64},
  [4297] = {.lex_state = 64},
  [4298] = {.lex_state = 15, .external_lex_state = 7},
  [4299] = {.lex_state = 64},
  [4300] = {.lex_state = 0, .external_lex_state = 5},
  [4301] = {.lex_state = 64},
  [4302] = {.lex_state = 0, .external_lex_state = 5},
  [4303] = {.lex_state = 64},
  [4304] = {.lex_state = 64},
  [4305] = {.lex_state = 15},
  [4306] = {.lex_state = 0, .external_lex_state = 5},
  [4307] = {.lex_state = 64},
  [4308] = {.lex_state = 0, .external_lex_state = 5},
  [4309] = {.lex_state = 64},
  [4310] = {.lex_state = 64},
  [4311] = {.lex_state = 64},
  [4312] = {.lex_state = 0, .external_lex_state = 5},
  [4313] = {.lex_state = 64},
  [4314] = {.lex_state = 64},
  [4315] = {.lex_state = 64},
  [4316] = {.lex_state = 64, .external_lex_state = 5},
  [4317] = {.lex_state = 0, .external_lex_state = 5},
  [4318] = {.lex_state = 64},
  [4319] = {.lex_state = 0, .external_lex_state = 5},
  [4320] = {.lex_state = 64},
  [4321] = {.lex_state = 64, .external_lex_state = 5},
  [4322] = {.lex_state = 64, .external_lex_state = 5},
  [4323] = {.lex_state = 64},
  [4324] = {.lex_state = 64},
  [4325] = {.lex_state = 0, .external_lex_state = 5},
  [4326] = {.lex_state = 64},
  [4327] = {.lex_state = 15, .external_lex_state = 7},
  [4328] = {.lex_state = 0, .external_lex_state = 5},
  [4329] = {.lex_state = 64},
  [4330] = {.lex_state = 64},
  [4331] = {.lex_state = 64},
  [4332] = {.lex_state = 0, .external_lex_state = 5},
  [4333] = {.lex_state = 64},
  [4334] = {.lex_state = 0, .external_lex_state = 5},
  [4335] = {.lex_state = 0, .external_lex_state = 5},
  [4336] = {.lex_state = 0, .external_lex_state = 5},
  [4337] = {.lex_state = 64},
  [4338] = {.lex_state = 64, .external_lex_state = 5},
  [4339] = {.lex_state = 0, .external_lex_state = 5},
  [4340] = {.lex_state = 64},
  [4341] = {.lex_state = 0},
  [4342] = {.lex_state = 64},
  [4343] = {.lex_state = 64, .external_lex_state = 5},
  [4344] = {.lex_state = 64, .external_lex_state = 5},
  [4345] = {.lex_state = 64},
  [4346] = {.lex_state = 64},
  [4347] = {.lex_state = 0, .external_lex_state = 5},
  [4348] = {.lex_state = 64, .external_lex_state = 5},
  [4349] = {.lex_state = 15},
  [4350] = {.lex_state = 10},
  [4351] = {.lex_state = 64},
  [4352] = {.lex_state = 0, .external_lex_state = 5},
  [4353] = {.lex_state = 64},
  [4354] = {.lex_state = 64},
  [4355] = {.lex_state = 0, .external_lex_state = 5},
  [4356] = {.lex_state = 64},
  [4357] = {.lex_state = 15},
  [4358] = {.lex_state = 64, .external_lex_state = 5},
  [4359] = {.lex_state = 0, .external_lex_state = 5},
  [4360] = {.lex_state = 64, .external_lex_state = 5},
  [4361] = {.lex_state = 0, .external_lex_state = 5},
  [4362] = {.lex_state = 64},
  [4363] = {.lex_state = 15},
  [4364] = {.lex_state = 15},
  [4365] = {.lex_state = 64},
  [4366] = {.lex_state = 64},
  [4367] = {.lex_state = 64},
  [4368] = {.lex_state = 64},
  [4369] = {.lex_state = 64},
  [4370] = {.lex_state = 64},
  [4371] = {.lex_state = 64},
  [4372] = {.lex_state = 64},
  [4373] = {.lex_state = 64},
  [4374] = {.lex_state = 0, .external_lex_state = 5},
  [4375] = {.lex_state = 15, .external_lex_state = 7},
  [4376] = {.lex_state = 64},
  [4377] = {.lex_state = 64, .external_lex_state = 5},
  [4378] = {.lex_state = 64},
  [4379] = {.lex_state = 64, .external_lex_state = 5},
  [4380] = {.lex_state = 64},
  [4381] = {.lex_state = 64},
  [4382] = {.lex_state = 64, .external_lex_state = 5},
  [4383] = {.lex_state = 64},
  [4384] = {.lex_state = 0, .external_lex_state = 5},
  [4385] = {.lex_state = 64},
  [4386] = {.lex_state = 64},
  [4387] = {.lex_state = 64, .external_lex_state = 5},
  [4388] = {.lex_state = 64, .external_lex_state = 5},
  [4389] = {.lex_state = 0},
  [4390] = {.lex_state = 0, .external_lex_state = 5},
  [4391] = {.lex_state = 0, .external_lex_state = 5},
  [4392] = {.lex_state = 64},
  [4393] = {.lex_state = 64},
  [4394] = {.lex_state = 64, .external_lex_state = 6},
  [4395] = {.lex_state = 64},
  [4396] = {.lex_state = 64},
  [4397] = {.lex_state = 64},
  [4398] = {.lex_state = 64},
  [4399] = {.lex_state = 64},
  [4400] = {.lex_state = 64},
  [4401] = {.lex_state = 0},
  [4402] = {.lex_state = 64},
  [4403] = {.lex_state = 64},
  [4404] = {.lex_state = 64},
  [4405] = {.lex_state = 64},
  [4406] = {.lex_state = 64},
  [4407] = {.lex_state = 0},
  [4408] = {.lex_state = 0},
  [4409] = {.lex_state = 64, .external_lex_state = 5},
  [4410] = {.lex_state = 64, .external_lex_state = 5},
  [4411] = {.lex_state = 0, .external_lex_state = 5},
  [4412] = {.lex_state = 0},
  [4413] = {.lex_state = 0, .external_lex_state = 5},
  [4414] = {.lex_state = 64, .external_lex_state = 6},
  [4415] = {.lex_state = 64},
  [4416] = {.lex_state = 64},
  [4417] = {.lex_state = 64},
  [4418] = {.lex_state = 0, .external_lex_state = 5},
  [4419] = {.lex_state = 64},
  [4420] = {.lex_state = 64},
  [4421] = {.lex_state = 64},
  [4422] = {.lex_state = 64, .external_lex_state = 5},
  [4423] = {.lex_state = 64},
  [4424] = {.lex_state = 0, .external_lex_state = 5},
  [4425] = {.lex_state = 64},
  [4426] = {.lex_state = 64, .external_lex_state = 5},
  [4427] = {.lex_state = 64, .external_lex_state = 5},
  [4428] = {.lex_state = 64},
  [4429] = {.lex_state = 0, .external_lex_state = 5},
  [4430] = {.lex_state = 64},
  [4431] = {.lex_state = 64},
  [4432] = {.lex_state = 64},
  [4433] = {.lex_state = 64},
  [4434] = {.lex_state = 0, .external_lex_state = 5},
  [4435] = {.lex_state = 0, .external_lex_state = 5},
  [4436] = {.lex_state = 64},
  [4437] = {.lex_state = 64, .external_lex_state = 5},
  [4438] = {.lex_state = 64, .external_lex_state = 6},
  [4439] = {.lex_state = 64},
  [4440] = {.lex_state = 0, .external_lex_state = 5},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0, .external_lex_state = 5},
  [4443] = {.lex_state = 0, .external_lex_state = 5},
  [4444] = {.lex_state = 0, .external_lex_state = 5},
  [4445] = {.lex_state = 64},
  [4446] = {.lex_state = 64, .external_lex_state = 6},
  [4447] = {.lex_state = 64, .external_lex_state = 5},
  [4448] = {.lex_state = 64, .external_lex_state = 5},
  [4449] = {.lex_state = 64},
  [4450] = {.lex_state = 64, .external_lex_state = 5},
  [4451] = {.lex_state = 64},
  [4452] = {.lex_state = 64},
  [4453] = {.lex_state = 0, .external_lex_state = 5},
  [4454] = {.lex_state = 64, .external_lex_state = 5},
  [4455] = {.lex_state = 64},
  [4456] = {.lex_state = 0, .external_lex_state = 5},
  [4457] = {.lex_state = 0, .external_lex_state = 5},
  [4458] = {.lex_state = 0, .external_lex_state = 5},
  [4459] = {.lex_state = 64},
  [4460] = {.lex_state = 0, .external_lex_state = 5},
  [4461] = {.lex_state = 0, .external_lex_state = 5},
  [4462] = {.lex_state = 0, .external_lex_state = 5},
  [4463] = {.lex_state = 64},
  [4464] = {.lex_state = 0, .external_lex_state = 5},
  [4465] = {.lex_state = 0, .external_lex_state = 5},
  [4466] = {.lex_state = 0, .external_lex_state = 5},
  [4467] = {.lex_state = 64},
  [4468] = {.lex_state = 64},
  [4469] = {.lex_state = 0, .external_lex_state = 5},
  [4470] = {.lex_state = 0, .external_lex_state = 5},
  [4471] = {.lex_state = 0, .external_lex_state = 5},
  [4472] = {.lex_state = 0, .external_lex_state = 5},
  [4473] = {.lex_state = 64},
  [4474] = {.lex_state = 64, .external_lex_state = 5},
  [4475] = {.lex_state = 0, .external_lex_state = 5},
  [4476] = {.lex_state = 0, .external_lex_state = 5},
  [4477] = {.lex_state = 64},
  [4478] = {.lex_state = 64},
  [4479] = {.lex_state = 0, .external_lex_state = 5},
  [4480] = {.lex_state = 64},
  [4481] = {.lex_state = 0},
  [4482] = {.lex_state = 0, .external_lex_state = 5},
  [4483] = {.lex_state = 64},
  [4484] = {.lex_state = 64, .external_lex_state = 6},
  [4485] = {.lex_state = 64},
  [4486] = {.lex_state = 64},
  [4487] = {.lex_state = 64},
  [4488] = {.lex_state = 0, .external_lex_state = 5},
  [4489] = {.lex_state = 0, .external_lex_state = 5},
  [4490] = {.lex_state = 64},
  [4491] = {.lex_state = 64},
  [4492] = {.lex_state = 0, .external_lex_state = 5},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 64},
  [4495] = {.lex_state = 64, .external_lex_state = 6},
  [4496] = {.lex_state = 64, .external_lex_state = 5},
  [4497] = {.lex_state = 64},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 64},
  [4500] = {.lex_state = 0, .external_lex_state = 5},
  [4501] = {.lex_state = 64},
  [4502] = {.lex_state = 0, .external_lex_state = 5},
  [4503] = {.lex_state = 64},
  [4504] = {.lex_state = 64, .external_lex_state = 5},
  [4505] = {.lex_state = 64},
  [4506] = {.lex_state = 0, .external_lex_state = 5},
  [4507] = {.lex_state = 64},
  [4508] = {.lex_state = 0, .external_lex_state = 5},
  [4509] = {.lex_state = 0, .external_lex_state = 5},
  [4510] = {.lex_state = 0, .external_lex_state = 5},
  [4511] = {.lex_state = 64, .external_lex_state = 6},
  [4512] = {.lex_state = 0, .external_lex_state = 5},
  [4513] = {.lex_state = 64},
  [4514] = {.lex_state = 64},
  [4515] = {.lex_state = 0, .external_lex_state = 5},
  [4516] = {.lex_state = 64, .external_lex_state = 5},
  [4517] = {.lex_state = 64, .external_lex_state = 6},
  [4518] = {.lex_state = 0, .external_lex_state = 5},
  [4519] = {.lex_state = 0, .external_lex_state = 5},
  [4520] = {.lex_state = 64},
  [4521] = {.lex_state = 0, .external_lex_state = 5},
  [4522] = {.lex_state = 64},
  [4523] = {.lex_state = 0, .external_lex_state = 5},
  [4524] = {.lex_state = 64},
  [4525] = {.lex_state = 0, .external_lex_state = 5},
  [4526] = {.lex_state = 0, .external_lex_state = 5},
  [4527] = {.lex_state = 0},
  [4528] = {.lex_state = 64},
  [4529] = {.lex_state = 64},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 64, .external_lex_state = 5},
  [4532] = {.lex_state = 0},
  [4533] = {.lex_state = 64},
  [4534] = {.lex_state = 0, .external_lex_state = 5},
  [4535] = {.lex_state = 64},
  [4536] = {.lex_state = 64, .external_lex_state = 6},
  [4537] = {.lex_state = 0, .external_lex_state = 5},
  [4538] = {.lex_state = 0, .external_lex_state = 5},
  [4539] = {.lex_state = 64},
  [4540] = {.lex_state = 64, .external_lex_state = 6},
  [4541] = {.lex_state = 64},
  [4542] = {.lex_state = 0},
  [4543] = {.lex_state = 64},
  [4544] = {.lex_state = 64},
  [4545] = {.lex_state = 64},
  [4546] = {.lex_state = 64},
  [4547] = {.lex_state = 64},
  [4548] = {.lex_state = 10},
  [4549] = {.lex_state = 0, .external_lex_state = 5},
  [4550] = {.lex_state = 64},
  [4551] = {.lex_state = 0, .external_lex_state = 5},
  [4552] = {.lex_state = 64, .external_lex_state = 6},
  [4553] = {.lex_state = 64},
  [4554] = {.lex_state = 0},
  [4555] = {.lex_state = 64},
  [4556] = {.lex_state = 0, .external_lex_state = 5},
  [4557] = {.lex_state = 0, .external_lex_state = 5},
  [4558] = {.lex_state = 64},
  [4559] = {.lex_state = 64},
  [4560] = {.lex_state = 0},
  [4561] = {.lex_state = 64},
  [4562] = {.lex_state = 64, .external_lex_state = 5},
  [4563] = {.lex_state = 64, .external_lex_state = 5},
  [4564] = {.lex_state = 64},
  [4565] = {.lex_state = 64},
  [4566] = {.lex_state = 0},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 0, .external_lex_state = 5},
  [4569] = {.lex_state = 64, .external_lex_state = 6},
  [4570] = {.lex_state = 0, .external_lex_state = 5},
  [4571] = {.lex_state = 0, .external_lex_state = 5},
  [4572] = {.lex_state = 0, .external_lex_state = 5},
  [4573] = {.lex_state = 64, .external_lex_state = 5},
  [4574] = {.lex_state = 64},
  [4575] = {.lex_state = 64},
  [4576] = {.lex_state = 64},
  [4577] = {.lex_state = 64},
  [4578] = {.lex_state = 64},
  [4579] = {.lex_state = 0, .external_lex_state = 5},
  [4580] = {.lex_state = 64, .external_lex_state = 6},
  [4581] = {.lex_state = 0, .external_lex_state = 5},
  [4582] = {.lex_state = 64},
  [4583] = {.lex_state = 64},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 0, .external_lex_state = 5},
  [4586] = {.lex_state = 0, .external_lex_state = 5},
  [4587] = {.lex_state = 0},
  [4588] = {.lex_state = 64},
  [4589] = {.lex_state = 0},
  [4590] = {.lex_state = 0},
  [4591] = {.lex_state = 64, .external_lex_state = 6},
  [4592] = {.lex_state = 64},
  [4593] = {.lex_state = 64},
  [4594] = {.lex_state = 0, .external_lex_state = 5},
  [4595] = {.lex_state = 0, .external_lex_state = 5},
  [4596] = {.lex_state = 10},
  [4597] = {.lex_state = 0, .external_lex_state = 5},
  [4598] = {.lex_state = 0, .external_lex_state = 5},
  [4599] = {.lex_state = 64, .external_lex_state = 6},
  [4600] = {.lex_state = 64},
  [4601] = {.lex_state = 0, .external_lex_state = 5},
  [4602] = {.lex_state = 0, .external_lex_state = 5},
  [4603] = {.lex_state = 0, .external_lex_state = 5},
  [4604] = {.lex_state = 0, .external_lex_state = 5},
  [4605] = {.lex_state = 0, .external_lex_state = 5},
  [4606] = {.lex_state = 64},
  [4607] = {.lex_state = 64},
  [4608] = {.lex_state = 0},
  [4609] = {.lex_state = 64},
  [4610] = {.lex_state = 0},
  [4611] = {.lex_state = 64},
  [4612] = {.lex_state = 0, .external_lex_state = 5},
  [4613] = {.lex_state = 0, .external_lex_state = 5},
  [4614] = {.lex_state = 0},
  [4615] = {.lex_state = 64},
  [4616] = {.lex_state = 0, .external_lex_state = 5},
  [4617] = {.lex_state = 64},
  [4618] = {.lex_state = 0},
  [4619] = {.lex_state = 0},
  [4620] = {.lex_state = 0, .external_lex_state = 5},
  [4621] = {.lex_state = 0, .external_lex_state = 5},
  [4622] = {.lex_state = 64},
  [4623] = {.lex_state = 0, .external_lex_state = 5},
  [4624] = {.lex_state = 64, .external_lex_state = 5},
  [4625] = {.lex_state = 0, .external_lex_state = 5},
  [4626] = {.lex_state = 10},
  [4627] = {.lex_state = 0, .external_lex_state = 5},
  [4628] = {.lex_state = 0, .external_lex_state = 5},
  [4629] = {.lex_state = 64, .external_lex_state = 5},
  [4630] = {.lex_state = 0, .external_lex_state = 5},
  [4631] = {.lex_state = 0, .external_lex_state = 5},
  [4632] = {.lex_state = 64},
  [4633] = {.lex_state = 0, .external_lex_state = 5},
  [4634] = {.lex_state = 0, .external_lex_state = 5},
  [4635] = {.lex_state = 0, .external_lex_state = 5},
  [4636] = {.lex_state = 64},
  [4637] = {.lex_state = 0, .external_lex_state = 5},
  [4638] = {.lex_state = 64},
  [4639] = {.lex_state = 0, .external_lex_state = 5},
  [4640] = {.lex_state = 0, .external_lex_state = 5},
  [4641] = {.lex_state = 0, .external_lex_state = 5},
  [4642] = {.lex_state = 0, .external_lex_state = 5},
  [4643] = {.lex_state = 0, .external_lex_state = 5},
  [4644] = {.lex_state = 64},
  [4645] = {.lex_state = 0, .external_lex_state = 5},
  [4646] = {.lex_state = 0, .external_lex_state = 5},
  [4647] = {.lex_state = 64},
  [4648] = {.lex_state = 64},
  [4649] = {.lex_state = 0, .external_lex_state = 5},
  [4650] = {.lex_state = 64, .external_lex_state = 5},
  [4651] = {.lex_state = 64},
  [4652] = {.lex_state = 64},
  [4653] = {.lex_state = 0, .external_lex_state = 5},
  [4654] = {.lex_state = 64},
  [4655] = {.lex_state = 0, .external_lex_state = 5},
  [4656] = {.lex_state = 0, .external_lex_state = 5},
  [4657] = {.lex_state = 0, .external_lex_state = 5},
  [4658] = {.lex_state = 64, .external_lex_state = 5},
  [4659] = {.lex_state = 64},
  [4660] = {.lex_state = 64},
  [4661] = {.lex_state = 64, .external_lex_state = 5},
  [4662] = {.lex_state = 64, .external_lex_state = 5},
  [4663] = {.lex_state = 64},
  [4664] = {.lex_state = 64},
  [4665] = {.lex_state = 64},
  [4666] = {.lex_state = 0, .external_lex_state = 5},
  [4667] = {.lex_state = 0, .external_lex_state = 5},
  [4668] = {.lex_state = 0, .external_lex_state = 5},
  [4669] = {.lex_state = 0},
  [4670] = {.lex_state = 0, .external_lex_state = 5},
  [4671] = {.lex_state = 0, .external_lex_state = 5},
  [4672] = {.lex_state = 0, .external_lex_state = 5},
  [4673] = {.lex_state = 0, .external_lex_state = 5},
  [4674] = {.lex_state = 0, .external_lex_state = 5},
  [4675] = {.lex_state = 0, .external_lex_state = 5},
  [4676] = {.lex_state = 64},
  [4677] = {.lex_state = 0, .external_lex_state = 5},
  [4678] = {.lex_state = 0, .external_lex_state = 5},
  [4679] = {.lex_state = 0, .external_lex_state = 5},
  [4680] = {.lex_state = 64},
  [4681] = {.lex_state = 0, .external_lex_state = 5},
  [4682] = {.lex_state = 64},
  [4683] = {.lex_state = 0, .external_lex_state = 5},
  [4684] = {.lex_state = 0, .external_lex_state = 5},
  [4685] = {.lex_state = 0, .external_lex_state = 5},
  [4686] = {.lex_state = 10},
  [4687] = {.lex_state = 0, .external_lex_state = 5},
  [4688] = {.lex_state = 0, .external_lex_state = 5},
  [4689] = {.lex_state = 0, .external_lex_state = 5},
  [4690] = {.lex_state = 0, .external_lex_state = 5},
  [4691] = {.lex_state = 14},
  [4692] = {.lex_state = 64},
  [4693] = {.lex_state = 64},
  [4694] = {.lex_state = 64},
  [4695] = {.lex_state = 64},
  [4696] = {.lex_state = 64},
  [4697] = {.lex_state = 64},
  [4698] = {.lex_state = 64},
  [4699] = {.lex_state = 64},
  [4700] = {.lex_state = 64},
  [4701] = {.lex_state = 64},
  [4702] = {.lex_state = 0, .external_lex_state = 5},
  [4703] = {.lex_state = 64},
  [4704] = {.lex_state = 64},
  [4705] = {.lex_state = 0, .external_lex_state = 5},
  [4706] = {.lex_state = 64},
  [4707] = {.lex_state = 64},
  [4708] = {.lex_state = 0},
  [4709] = {.lex_state = 17},
  [4710] = {.lex_state = 64},
  [4711] = {.lex_state = 64},
  [4712] = {.lex_state = 17},
  [4713] = {.lex_state = 0},
  [4714] = {.lex_state = 0, .external_lex_state = 5},
  [4715] = {.lex_state = 0, .external_lex_state = 5},
  [4716] = {.lex_state = 14},
  [4717] = {.lex_state = 64, .external_lex_state = 5},
  [4718] = {.lex_state = 64},
  [4719] = {.lex_state = 64},
  [4720] = {.lex_state = 14},
  [4721] = {.lex_state = 17},
  [4722] = {.lex_state = 64},
  [4723] = {.lex_state = 0},
  [4724] = {.lex_state = 14},
  [4725] = {.lex_state = 14},
  [4726] = {.lex_state = 64},
  [4727] = {.lex_state = 17},
  [4728] = {.lex_state = 17},
  [4729] = {.lex_state = 64},
  [4730] = {.lex_state = 64},
  [4731] = {.lex_state = 64},
  [4732] = {.lex_state = 64},
  [4733] = {.lex_state = 64, .external_lex_state = 5},
  [4734] = {.lex_state = 64, .external_lex_state = 6},
  [4735] = {.lex_state = 64, .external_lex_state = 6},
  [4736] = {.lex_state = 64, .external_lex_state = 6},
  [4737] = {.lex_state = 64, .external_lex_state = 6},
  [4738] = {.lex_state = 64},
  [4739] = {.lex_state = 64},
  [4740] = {.lex_state = 0},
  [4741] = {.lex_state = 64},
  [4742] = {.lex_state = 64},
  [4743] = {.lex_state = 64},
  [4744] = {.lex_state = 64},
  [4745] = {.lex_state = 64},
  [4746] = {.lex_state = 64},
  [4747] = {.lex_state = 64},
  [4748] = {.lex_state = 64},
  [4749] = {.lex_state = 64},
  [4750] = {.lex_state = 0, .external_lex_state = 5},
  [4751] = {.lex_state = 0, .external_lex_state = 5},
  [4752] = {.lex_state = 0},
  [4753] = {.lex_state = 0},
  [4754] = {.lex_state = 0},
  [4755] = {.lex_state = 0},
  [4756] = {.lex_state = 0},
  [4757] = {.lex_state = 64},
  [4758] = {.lex_state = 64},
  [4759] = {.lex_state = 0},
  [4760] = {.lex_state = 64},
  [4761] = {.lex_state = 64},
  [4762] = {.lex_state = 64},
  [4763] = {.lex_state = 64},
  [4764] = {.lex_state = 64},
  [4765] = {.lex_state = 64},
  [4766] = {.lex_state = 64},
  [4767] = {.lex_state = 64},
  [4768] = {.lex_state = 64},
  [4769] = {.lex_state = 64},
  [4770] = {.lex_state = 64},
  [4771] = {.lex_state = 64},
  [4772] = {.lex_state = 64},
  [4773] = {.lex_state = 17},
  [4774] = {.lex_state = 17},
  [4775] = {.lex_state = 14},
  [4776] = {.lex_state = 64},
  [4777] = {.lex_state = 64},
  [4778] = {.lex_state = 0},
  [4779] = {.lex_state = 64},
  [4780] = {.lex_state = 14},
  [4781] = {.lex_state = 64},
  [4782] = {.lex_state = 64},
  [4783] = {.lex_state = 64},
  [4784] = {.lex_state = 64},
  [4785] = {.lex_state = 64},
  [4786] = {.lex_state = 64},
  [4787] = {.lex_state = 64},
  [4788] = {.lex_state = 64},
  [4789] = {.lex_state = 17},
  [4790] = {.lex_state = 64},
  [4791] = {.lex_state = 64},
  [4792] = {.lex_state = 64},
  [4793] = {.lex_state = 0},
  [4794] = {.lex_state = 64},
  [4795] = {.lex_state = 64},
  [4796] = {.lex_state = 64},
  [4797] = {.lex_state = 0},
  [4798] = {.lex_state = 64},
  [4799] = {.lex_state = 64},
  [4800] = {.lex_state = 64},
  [4801] = {.lex_state = 64},
  [4802] = {.lex_state = 64},
  [4803] = {.lex_state = 0, .external_lex_state = 5},
  [4804] = {.lex_state = 64},
  [4805] = {.lex_state = 17},
  [4806] = {.lex_state = 14},
  [4807] = {.lex_state = 64},
  [4808] = {.lex_state = 64},
  [4809] = {.lex_state = 17},
  [4810] = {.lex_state = 14},
  [4811] = {.lex_state = 64},
  [4812] = {.lex_state = 64},
  [4813] = {.lex_state = 0, .external_lex_state = 5},
  [4814] = {.lex_state = 64},
  [4815] = {.lex_state = 64},
  [4816] = {.lex_state = 64},
  [4817] = {.lex_state = 14},
  [4818] = {.lex_state = 64},
  [4819] = {.lex_state = 64},
  [4820] = {.lex_state = 15, .external_lex_state = 7},
  [4821] = {.lex_state = 64},
  [4822] = {.lex_state = 64},
  [4823] = {.lex_state = 64},
  [4824] = {.lex_state = 0},
  [4825] = {.lex_state = 17},
  [4826] = {.lex_state = 14},
  [4827] = {.lex_state = 64},
  [4828] = {.lex_state = 64},
  [4829] = {.lex_state = 64},
  [4830] = {.lex_state = 64},
  [4831] = {.lex_state = 64},
  [4832] = {.lex_state = 64},
  [4833] = {.lex_state = 64},
  [4834] = {.lex_state = 17},
  [4835] = {.lex_state = 14},
  [4836] = {.lex_state = 64},
  [4837] = {.lex_state = 64},
  [4838] = {.lex_state = 14},
  [4839] = {.lex_state = 17},
  [4840] = {.lex_state = 0},
  [4841] = {.lex_state = 64},
  [4842] = {.lex_state = 64},
  [4843] = {.lex_state = 0},
  [4844] = {.lex_state = 64},
  [4845] = {.lex_state = 64},
  [4846] = {.lex_state = 64},
  [4847] = {.lex_state = 64},
  [4848] = {.lex_state = 64},
  [4849] = {.lex_state = 0, .external_lex_state = 5},
  [4850] = {.lex_state = 17},
  [4851] = {.lex_state = 64},
  [4852] = {.lex_state = 14},
  [4853] = {.lex_state = 64},
  [4854] = {.lex_state = 17},
  [4855] = {.lex_state = 64},
  [4856] = {.lex_state = 64},
  [4857] = {.lex_state = 14},
  [4858] = {.lex_state = 64},
  [4859] = {.lex_state = 0},
  [4860] = {.lex_state = 64},
  [4861] = {.lex_state = 64},
  [4862] = {.lex_state = 64},
  [4863] = {.lex_state = 17},
  [4864] = {.lex_state = 14},
  [4865] = {.lex_state = 64},
  [4866] = {.lex_state = 14},
  [4867] = {.lex_state = 17},
  [4868] = {.lex_state = 64},
  [4869] = {.lex_state = 64},
  [4870] = {.lex_state = 64},
  [4871] = {.lex_state = 64},
  [4872] = {.lex_state = 64},
  [4873] = {.lex_state = 64},
  [4874] = {.lex_state = 0},
  [4875] = {.lex_state = 0},
  [4876] = {.lex_state = 0},
  [4877] = {.lex_state = 0},
  [4878] = {.lex_state = 0},
  [4879] = {.lex_state = 0},
  [4880] = {.lex_state = 64},
  [4881] = {.lex_state = 0},
  [4882] = {.lex_state = 64},
  [4883] = {.lex_state = 0},
  [4884] = {.lex_state = 0, .external_lex_state = 5},
  [4885] = {.lex_state = 0},
  [4886] = {.lex_state = 0},
  [4887] = {.lex_state = 64},
  [4888] = {.lex_state = 0, .external_lex_state = 5},
  [4889] = {.lex_state = 64},
  [4890] = {.lex_state = 0, .external_lex_state = 5},
  [4891] = {.lex_state = 64},
  [4892] = {.lex_state = 64},
  [4893] = {.lex_state = 0, .external_lex_state = 5},
  [4894] = {.lex_state = 0, .external_lex_state = 5},
  [4895] = {.lex_state = 0},
  [4896] = {.lex_state = 64},
  [4897] = {.lex_state = 0},
  [4898] = {.lex_state = 0},
  [4899] = {.lex_state = 0},
  [4900] = {.lex_state = 64},
  [4901] = {.lex_state = 0},
  [4902] = {.lex_state = 64},
  [4903] = {.lex_state = 0},
  [4904] = {.lex_state = 0},
  [4905] = {.lex_state = 0},
  [4906] = {.lex_state = 64},
  [4907] = {.lex_state = 0},
  [4908] = {.lex_state = 64},
  [4909] = {.lex_state = 64},
  [4910] = {.lex_state = 0, .external_lex_state = 5},
  [4911] = {.lex_state = 64},
  [4912] = {.lex_state = 64},
  [4913] = {.lex_state = 0},
  [4914] = {.lex_state = 0},
  [4915] = {.lex_state = 64},
  [4916] = {.lex_state = 0},
  [4917] = {.lex_state = 64},
  [4918] = {.lex_state = 0},
  [4919] = {.lex_state = 0},
  [4920] = {.lex_state = 0},
  [4921] = {.lex_state = 0},
  [4922] = {.lex_state = 64},
  [4923] = {.lex_state = 64},
  [4924] = {.lex_state = 0},
  [4925] = {.lex_state = 0},
  [4926] = {.lex_state = 0},
  [4927] = {.lex_state = 0},
  [4928] = {.lex_state = 0},
  [4929] = {.lex_state = 0},
  [4930] = {.lex_state = 64},
  [4931] = {.lex_state = 64},
  [4932] = {.lex_state = 0},
  [4933] = {.lex_state = 0},
  [4934] = {.lex_state = 0},
  [4935] = {.lex_state = 0, .external_lex_state = 5},
  [4936] = {.lex_state = 0, .external_lex_state = 5},
  [4937] = {.lex_state = 0},
  [4938] = {.lex_state = 0, .external_lex_state = 5},
  [4939] = {.lex_state = 0, .external_lex_state = 5},
  [4940] = {.lex_state = 0},
  [4941] = {.lex_state = 0, .external_lex_state = 5},
  [4942] = {.lex_state = 0, .external_lex_state = 5},
  [4943] = {.lex_state = 0, .external_lex_state = 5},
  [4944] = {.lex_state = 0},
  [4945] = {.lex_state = 0, .external_lex_state = 5},
  [4946] = {.lex_state = 64},
  [4947] = {.lex_state = 64},
  [4948] = {.lex_state = 0},
  [4949] = {.lex_state = 0},
  [4950] = {.lex_state = 0, .external_lex_state = 5},
  [4951] = {.lex_state = 64},
  [4952] = {.lex_state = 64},
  [4953] = {.lex_state = 0},
  [4954] = {.lex_state = 64},
  [4955] = {.lex_state = 0},
  [4956] = {.lex_state = 0},
  [4957] = {.lex_state = 0},
  [4958] = {.lex_state = 0},
  [4959] = {.lex_state = 0},
  [4960] = {.lex_state = 0},
  [4961] = {.lex_state = 0, .external_lex_state = 5},
  [4962] = {.lex_state = 0, .external_lex_state = 5},
  [4963] = {.lex_state = 0, .external_lex_state = 5},
  [4964] = {.lex_state = 0, .external_lex_state = 5},
  [4965] = {.lex_state = 0, .external_lex_state = 5},
  [4966] = {.lex_state = 0, .external_lex_state = 5},
  [4967] = {.lex_state = 0, .external_lex_state = 5},
  [4968] = {.lex_state = 0, .external_lex_state = 5},
  [4969] = {.lex_state = 0, .external_lex_state = 5},
  [4970] = {.lex_state = 0, .external_lex_state = 5},
  [4971] = {.lex_state = 0},
  [4972] = {.lex_state = 0},
  [4973] = {.lex_state = 0},
  [4974] = {.lex_state = 64},
  [4975] = {.lex_state = 0},
  [4976] = {.lex_state = 0},
  [4977] = {.lex_state = 0},
  [4978] = {.lex_state = 0, .external_lex_state = 5},
  [4979] = {.lex_state = 0},
  [4980] = {.lex_state = 0},
  [4981] = {.lex_state = 0, .external_lex_state = 5},
  [4982] = {.lex_state = 0, .external_lex_state = 5},
  [4983] = {.lex_state = 64},
  [4984] = {.lex_state = 0, .external_lex_state = 5},
  [4985] = {.lex_state = 64},
  [4986] = {.lex_state = 0, .external_lex_state = 5},
  [4987] = {.lex_state = 0, .external_lex_state = 5},
  [4988] = {.lex_state = 0, .external_lex_state = 5},
  [4989] = {.lex_state = 0, .external_lex_state = 5},
  [4990] = {.lex_state = 0, .external_lex_state = 5},
  [4991] = {.lex_state = 0, .external_lex_state = 5},
  [4992] = {.lex_state = 64},
  [4993] = {.lex_state = 64},
  [4994] = {.lex_state = 0, .external_lex_state = 5},
  [4995] = {.lex_state = 0, .external_lex_state = 5},
  [4996] = {.lex_state = 0, .external_lex_state = 5},
  [4997] = {.lex_state = 0},
  [4998] = {.lex_state = 0, .external_lex_state = 5},
  [4999] = {.lex_state = 0, .external_lex_state = 5},
  [5000] = {.lex_state = 0, .external_lex_state = 5},
  [5001] = {.lex_state = 0},
  [5002] = {.lex_state = 0, .external_lex_state = 5},
  [5003] = {.lex_state = 0},
  [5004] = {.lex_state = 0, .external_lex_state = 5},
  [5005] = {.lex_state = 0, .external_lex_state = 5},
  [5006] = {.lex_state = 0, .external_lex_state = 5},
  [5007] = {.lex_state = 64},
  [5008] = {.lex_state = 0, .external_lex_state = 5},
  [5009] = {.lex_state = 0},
  [5010] = {.lex_state = 64},
  [5011] = {.lex_state = 10},
  [5012] = {.lex_state = 0},
  [5013] = {.lex_state = 0},
  [5014] = {.lex_state = 0},
  [5015] = {.lex_state = 0},
  [5016] = {.lex_state = 0},
  [5017] = {.lex_state = 0},
  [5018] = {.lex_state = 64},
  [5019] = {.lex_state = 64},
  [5020] = {.lex_state = 10},
  [5021] = {.lex_state = 0},
  [5022] = {.lex_state = 0},
  [5023] = {.lex_state = 10},
  [5024] = {.lex_state = 0},
  [5025] = {.lex_state = 0},
  [5026] = {.lex_state = 0},
  [5027] = {.lex_state = 64},
  [5028] = {.lex_state = 64},
  [5029] = {.lex_state = 0},
  [5030] = {.lex_state = 64},
  [5031] = {.lex_state = 0},
  [5032] = {.lex_state = 0},
  [5033] = {.lex_state = 0},
  [5034] = {.lex_state = 64},
  [5035] = {.lex_state = 0},
  [5036] = {.lex_state = 64},
  [5037] = {.lex_state = 0},
  [5038] = {.lex_state = 0},
  [5039] = {.lex_state = 0},
  [5040] = {.lex_state = 64},
  [5041] = {.lex_state = 0},
  [5042] = {.lex_state = 0},
  [5043] = {.lex_state = 64, .external_lex_state = 5},
  [5044] = {.lex_state = 64},
  [5045] = {.lex_state = 64, .external_lex_state = 5},
  [5046] = {.lex_state = 64},
  [5047] = {.lex_state = 64},
  [5048] = {.lex_state = 64},
  [5049] = {.lex_state = 64},
  [5050] = {.lex_state = 64},
  [5051] = {.lex_state = 64},
  [5052] = {.lex_state = 0},
  [5053] = {.lex_state = 0},
  [5054] = {.lex_state = 0},
  [5055] = {.lex_state = 64},
  [5056] = {.lex_state = 64},
  [5057] = {.lex_state = 0},
  [5058] = {.lex_state = 0},
  [5059] = {.lex_state = 0},
  [5060] = {.lex_state = 0},
  [5061] = {.lex_state = 0},
  [5062] = {.lex_state = 0},
  [5063] = {.lex_state = 0},
  [5064] = {.lex_state = 0},
  [5065] = {.lex_state = 64},
  [5066] = {.lex_state = 0},
  [5067] = {.lex_state = 0},
  [5068] = {.lex_state = 64},
  [5069] = {.lex_state = 64},
  [5070] = {.lex_state = 0},
  [5071] = {.lex_state = 64},
  [5072] = {.lex_state = 64},
  [5073] = {.lex_state = 64},
  [5074] = {.lex_state = 64},
  [5075] = {.lex_state = 64},
  [5076] = {.lex_state = 0},
  [5077] = {.lex_state = 64},
  [5078] = {.lex_state = 0},
  [5079] = {.lex_state = 0},
  [5080] = {.lex_state = 0},
  [5081] = {.lex_state = 0},
  [5082] = {.lex_state = 64},
  [5083] = {.lex_state = 64},
  [5084] = {.lex_state = 0},
  [5085] = {.lex_state = 0},
  [5086] = {.lex_state = 0},
  [5087] = {.lex_state = 64},
  [5088] = {.lex_state = 64},
  [5089] = {.lex_state = 64},
  [5090] = {.lex_state = 0},
  [5091] = {.lex_state = 0},
  [5092] = {.lex_state = 64},
  [5093] = {.lex_state = 0},
  [5094] = {.lex_state = 0},
  [5095] = {.lex_state = 0, .external_lex_state = 5},
  [5096] = {.lex_state = 64},
  [5097] = {.lex_state = 64},
  [5098] = {.lex_state = 64},
  [5099] = {.lex_state = 64},
  [5100] = {.lex_state = 64},
  [5101] = {.lex_state = 64},
  [5102] = {.lex_state = 0},
  [5103] = {.lex_state = 64},
  [5104] = {.lex_state = 0},
  [5105] = {.lex_state = 0},
  [5106] = {.lex_state = 0},
  [5107] = {.lex_state = 0},
  [5108] = {.lex_state = 0},
  [5109] = {.lex_state = 0},
  [5110] = {.lex_state = 64},
  [5111] = {.lex_state = 0},
  [5112] = {.lex_state = 64},
  [5113] = {.lex_state = 64},
  [5114] = {.lex_state = 64},
  [5115] = {.lex_state = 64},
  [5116] = {.lex_state = 64},
  [5117] = {.lex_state = 64},
  [5118] = {.lex_state = 64},
  [5119] = {.lex_state = 64},
  [5120] = {.lex_state = 64},
  [5121] = {.lex_state = 0},
  [5122] = {.lex_state = 0},
  [5123] = {.lex_state = 64},
  [5124] = {.lex_state = 64},
  [5125] = {.lex_state = 64},
  [5126] = {.lex_state = 64},
  [5127] = {.lex_state = 0},
  [5128] = {.lex_state = 64},
  [5129] = {.lex_state = 64},
  [5130] = {.lex_state = 0},
  [5131] = {.lex_state = 0},
  [5132] = {.lex_state = 64},
  [5133] = {.lex_state = 0},
  [5134] = {.lex_state = 0, .external_lex_state = 5},
  [5135] = {.lex_state = 64},
  [5136] = {.lex_state = 0},
  [5137] = {.lex_state = 0},
  [5138] = {.lex_state = 0},
  [5139] = {.lex_state = 0},
  [5140] = {.lex_state = 0},
  [5141] = {.lex_state = 64},
  [5142] = {.lex_state = 64},
  [5143] = {.lex_state = 0},
  [5144] = {.lex_state = 64},
  [5145] = {.lex_state = 0},
  [5146] = {.lex_state = 64},
  [5147] = {.lex_state = 0},
  [5148] = {.lex_state = 0},
  [5149] = {.lex_state = 0},
  [5150] = {.lex_state = 0},
  [5151] = {.lex_state = 0},
  [5152] = {.lex_state = 64},
  [5153] = {.lex_state = 0},
  [5154] = {.lex_state = 64},
  [5155] = {.lex_state = 0},
  [5156] = {.lex_state = 64},
  [5157] = {.lex_state = 0},
  [5158] = {.lex_state = 64},
  [5159] = {.lex_state = 0, .external_lex_state = 5},
  [5160] = {.lex_state = 0, .external_lex_state = 5},
  [5161] = {.lex_state = 64},
  [5162] = {.lex_state = 0},
  [5163] = {.lex_state = 64},
  [5164] = {.lex_state = 64},
  [5165] = {.lex_state = 0},
  [5166] = {.lex_state = 64},
  [5167] = {.lex_state = 64},
  [5168] = {.lex_state = 0},
  [5169] = {.lex_state = 64},
  [5170] = {.lex_state = 0},
  [5171] = {.lex_state = 0, .external_lex_state = 5},
  [5172] = {.lex_state = 64},
  [5173] = {.lex_state = 0},
  [5174] = {.lex_state = 0, .external_lex_state = 5},
  [5175] = {.lex_state = 64},
  [5176] = {.lex_state = 64},
  [5177] = {.lex_state = 0, .external_lex_state = 5},
  [5178] = {.lex_state = 64},
  [5179] = {.lex_state = 64},
  [5180] = {.lex_state = 0},
  [5181] = {.lex_state = 0},
  [5182] = {.lex_state = 64},
  [5183] = {.lex_state = 0},
  [5184] = {.lex_state = 0},
  [5185] = {.lex_state = 0},
  [5186] = {.lex_state = 0, .external_lex_state = 5},
  [5187] = {.lex_state = 64},
  [5188] = {.lex_state = 0, .external_lex_state = 5},
  [5189] = {.lex_state = 0, .external_lex_state = 5},
  [5190] = {.lex_state = 0, .external_lex_state = 5},
  [5191] = {.lex_state = 64},
  [5192] = {.lex_state = 0},
  [5193] = {.lex_state = 64},
  [5194] = {.lex_state = 64},
  [5195] = {.lex_state = 64},
  [5196] = {.lex_state = 64},
  [5197] = {.lex_state = 0},
  [5198] = {.lex_state = 64},
  [5199] = {.lex_state = 64},
  [5200] = {.lex_state = 0},
  [5201] = {.lex_state = 0},
  [5202] = {.lex_state = 0},
  [5203] = {.lex_state = 0},
  [5204] = {.lex_state = 0},
  [5205] = {.lex_state = 0},
  [5206] = {.lex_state = 64},
  [5207] = {.lex_state = 0},
  [5208] = {.lex_state = 0},
  [5209] = {.lex_state = 64},
  [5210] = {.lex_state = 64},
  [5211] = {.lex_state = 0},
  [5212] = {.lex_state = 64},
  [5213] = {.lex_state = 64},
  [5214] = {.lex_state = 64},
  [5215] = {.lex_state = 64},
  [5216] = {.lex_state = 64},
  [5217] = {.lex_state = 64},
  [5218] = {.lex_state = 0},
  [5219] = {.lex_state = 0, .external_lex_state = 5},
  [5220] = {.lex_state = 0},
  [5221] = {.lex_state = 64},
  [5222] = {.lex_state = 0, .external_lex_state = 5},
  [5223] = {.lex_state = 0},
  [5224] = {.lex_state = 64},
  [5225] = {.lex_state = 0},
  [5226] = {.lex_state = 64},
  [5227] = {.lex_state = 0},
  [5228] = {.lex_state = 64},
  [5229] = {.lex_state = 64},
  [5230] = {.lex_state = 64},
  [5231] = {.lex_state = 64},
  [5232] = {.lex_state = 0},
  [5233] = {.lex_state = 0, .external_lex_state = 5},
  [5234] = {.lex_state = 0},
  [5235] = {.lex_state = 0},
  [5236] = {.lex_state = 64},
  [5237] = {.lex_state = 0},
  [5238] = {.lex_state = 64},
  [5239] = {.lex_state = 0},
  [5240] = {.lex_state = 0},
  [5241] = {.lex_state = 0, .external_lex_state = 5},
  [5242] = {.lex_state = 64},
  [5243] = {.lex_state = 0, .external_lex_state = 5},
  [5244] = {.lex_state = 0, .external_lex_state = 5},
  [5245] = {.lex_state = 0},
  [5246] = {.lex_state = 0},
  [5247] = {.lex_state = 0},
  [5248] = {.lex_state = 0},
  [5249] = {.lex_state = 0},
  [5250] = {.lex_state = 0},
  [5251] = {.lex_state = 0},
  [5252] = {.lex_state = 0},
  [5253] = {.lex_state = 0},
  [5254] = {.lex_state = 0},
  [5255] = {.lex_state = 64},
  [5256] = {.lex_state = 64},
  [5257] = {.lex_state = 0},
  [5258] = {.lex_state = 64},
  [5259] = {.lex_state = 0},
  [5260] = {.lex_state = 0},
  [5261] = {.lex_state = 64},
  [5262] = {.lex_state = 0},
  [5263] = {.lex_state = 0},
  [5264] = {.lex_state = 64},
  [5265] = {.lex_state = 64},
  [5266] = {.lex_state = 64},
  [5267] = {.lex_state = 0},
  [5268] = {.lex_state = 0},
  [5269] = {.lex_state = 0},
  [5270] = {.lex_state = 0},
  [5271] = {.lex_state = 64},
  [5272] = {.lex_state = 64},
  [5273] = {.lex_state = 0},
  [5274] = {.lex_state = 64},
  [5275] = {.lex_state = 0},
  [5276] = {.lex_state = 0},
  [5277] = {.lex_state = 64},
  [5278] = {.lex_state = 64},
  [5279] = {.lex_state = 64},
  [5280] = {.lex_state = 0},
  [5281] = {.lex_state = 0},
  [5282] = {.lex_state = 64},
  [5283] = {.lex_state = 64},
  [5284] = {.lex_state = 64},
  [5285] = {.lex_state = 0},
  [5286] = {.lex_state = 64},
  [5287] = {.lex_state = 0},
  [5288] = {.lex_state = 64},
  [5289] = {.lex_state = 64},
  [5290] = {.lex_state = 64},
  [5291] = {.lex_state = 64},
  [5292] = {.lex_state = 64},
  [5293] = {.lex_state = 64},
  [5294] = {.lex_state = 64},
  [5295] = {.lex_state = 64},
  [5296] = {.lex_state = 64},
  [5297] = {.lex_state = 64},
  [5298] = {.lex_state = 64},
  [5299] = {.lex_state = 64},
  [5300] = {.lex_state = 64},
  [5301] = {.lex_state = 0, .external_lex_state = 5},
  [5302] = {.lex_state = 64},
  [5303] = {.lex_state = 0},
  [5304] = {.lex_state = 64},
  [5305] = {.lex_state = 0},
  [5306] = {.lex_state = 64},
  [5307] = {.lex_state = 0},
  [5308] = {.lex_state = 0},
  [5309] = {.lex_state = 0},
  [5310] = {.lex_state = 64},
  [5311] = {.lex_state = 64},
  [5312] = {.lex_state = 0},
  [5313] = {.lex_state = 0, .external_lex_state = 5},
  [5314] = {.lex_state = 0},
  [5315] = {.lex_state = 0},
  [5316] = {.lex_state = 64},
  [5317] = {.lex_state = 64},
  [5318] = {.lex_state = 64},
  [5319] = {.lex_state = 0},
  [5320] = {.lex_state = 64},
  [5321] = {.lex_state = 0},
  [5322] = {.lex_state = 64},
  [5323] = {.lex_state = 64},
  [5324] = {.lex_state = 0},
  [5325] = {.lex_state = 0},
  [5326] = {.lex_state = 64},
  [5327] = {.lex_state = 0, .external_lex_state = 5},
  [5328] = {.lex_state = 0, .external_lex_state = 5},
  [5329] = {.lex_state = 64},
  [5330] = {.lex_state = 64},
  [5331] = {.lex_state = 64},
  [5332] = {.lex_state = 64},
  [5333] = {.lex_state = 0},
  [5334] = {.lex_state = 64},
  [5335] = {.lex_state = 64},
  [5336] = {.lex_state = 64},
  [5337] = {.lex_state = 0},
  [5338] = {.lex_state = 64},
  [5339] = {.lex_state = 0},
  [5340] = {.lex_state = 64},
  [5341] = {.lex_state = 64},
  [5342] = {.lex_state = 64},
  [5343] = {.lex_state = 0},
  [5344] = {.lex_state = 64},
  [5345] = {.lex_state = 64},
  [5346] = {.lex_state = 64},
  [5347] = {.lex_state = 0},
  [5348] = {.lex_state = 64},
  [5349] = {.lex_state = 64},
  [5350] = {.lex_state = 0},
  [5351] = {.lex_state = 64},
  [5352] = {.lex_state = 64},
  [5353] = {.lex_state = 0, .external_lex_state = 5},
  [5354] = {.lex_state = 64},
  [5355] = {.lex_state = 0},
  [5356] = {.lex_state = 0},
  [5357] = {.lex_state = 0},
  [5358] = {.lex_state = 0},
  [5359] = {.lex_state = 64},
  [5360] = {.lex_state = 64},
  [5361] = {.lex_state = 0},
  [5362] = {.lex_state = 0},
  [5363] = {.lex_state = 0},
  [5364] = {.lex_state = 0, .external_lex_state = 5},
  [5365] = {.lex_state = 0},
  [5366] = {.lex_state = 0},
  [5367] = {.lex_state = 0, .external_lex_state = 5},
  [5368] = {.lex_state = 64},
  [5369] = {.lex_state = 64},
  [5370] = {.lex_state = 0},
  [5371] = {.lex_state = 0},
  [5372] = {.lex_state = 0},
  [5373] = {.lex_state = 0},
  [5374] = {.lex_state = 0},
  [5375] = {.lex_state = 0},
  [5376] = {.lex_state = 64},
  [5377] = {.lex_state = 64},
  [5378] = {.lex_state = 64},
  [5379] = {.lex_state = 64},
  [5380] = {.lex_state = 64},
  [5381] = {.lex_state = 64},
  [5382] = {.lex_state = 64},
  [5383] = {.lex_state = 64},
  [5384] = {.lex_state = 64},
  [5385] = {.lex_state = 64},
  [5386] = {.lex_state = 0},
  [5387] = {.lex_state = 64},
  [5388] = {.lex_state = 64},
  [5389] = {.lex_state = 64},
  [5390] = {.lex_state = 64},
  [5391] = {.lex_state = 64},
  [5392] = {.lex_state = 0},
  [5393] = {.lex_state = 64},
  [5394] = {.lex_state = 0},
  [5395] = {.lex_state = 64},
  [5396] = {.lex_state = 64},
  [5397] = {.lex_state = 64},
  [5398] = {.lex_state = 64},
  [5399] = {.lex_state = 64},
  [5400] = {.lex_state = 0},
  [5401] = {.lex_state = 0},
  [5402] = {.lex_state = 64},
  [5403] = {.lex_state = 64},
  [5404] = {.lex_state = 64},
  [5405] = {.lex_state = 64},
  [5406] = {.lex_state = 64},
  [5407] = {.lex_state = 0},
  [5408] = {.lex_state = 64},
  [5409] = {.lex_state = 64},
  [5410] = {.lex_state = 64},
  [5411] = {.lex_state = 0},
  [5412] = {.lex_state = 64},
  [5413] = {.lex_state = 0},
  [5414] = {.lex_state = 64},
  [5415] = {.lex_state = 0},
  [5416] = {.lex_state = 0},
  [5417] = {.lex_state = 0},
  [5418] = {.lex_state = 0},
  [5419] = {.lex_state = 0},
  [5420] = {.lex_state = 0},
  [5421] = {.lex_state = 0},
  [5422] = {.lex_state = 0},
  [5423] = {.lex_state = 0},
  [5424] = {.lex_state = 0},
  [5425] = {.lex_state = 0},
  [5426] = {.lex_state = 64},
  [5427] = {.lex_state = 0},
  [5428] = {.lex_state = 64},
  [5429] = {.lex_state = 64},
  [5430] = {.lex_state = 0},
  [5431] = {.lex_state = 0},
  [5432] = {.lex_state = 0},
  [5433] = {.lex_state = 0},
  [5434] = {.lex_state = 0},
  [5435] = {.lex_state = 0},
  [5436] = {.lex_state = 0},
  [5437] = {.lex_state = 64},
  [5438] = {.lex_state = 0},
  [5439] = {.lex_state = 0},
  [5440] = {.lex_state = 0},
  [5441] = {.lex_state = 11},
  [5442] = {.lex_state = 0},
  [5443] = {.lex_state = 0},
  [5444] = {.lex_state = 0},
  [5445] = {.lex_state = 0},
  [5446] = {.lex_state = 0},
  [5447] = {.lex_state = 0},
  [5448] = {.lex_state = 0},
  [5449] = {.lex_state = 0},
  [5450] = {.lex_state = 0},
  [5451] = {.lex_state = 0},
  [5452] = {.lex_state = 0},
  [5453] = {.lex_state = 64},
  [5454] = {.lex_state = 0},
  [5455] = {.lex_state = 0},
  [5456] = {.lex_state = 0},
  [5457] = {.lex_state = 0},
  [5458] = {.lex_state = 0},
  [5459] = {.lex_state = 0},
  [5460] = {.lex_state = 0},
  [5461] = {.lex_state = 0},
  [5462] = {.lex_state = 64},
  [5463] = {.lex_state = 0},
  [5464] = {.lex_state = 0},
  [5465] = {.lex_state = 0},
  [5466] = {.lex_state = 0},
  [5467] = {.lex_state = 0},
  [5468] = {.lex_state = 0},
  [5469] = {.lex_state = 11},
  [5470] = {.lex_state = 0},
  [5471] = {.lex_state = 0},
  [5472] = {.lex_state = 0},
  [5473] = {.lex_state = 0},
  [5474] = {.lex_state = 64},
  [5475] = {.lex_state = 0},
  [5476] = {.lex_state = 0},
  [5477] = {.lex_state = 0},
  [5478] = {.lex_state = 0},
  [5479] = {.lex_state = 64},
  [5480] = {.lex_state = 64},
  [5481] = {.lex_state = 0},
  [5482] = {.lex_state = 64},
  [5483] = {.lex_state = 64},
  [5484] = {.lex_state = 64},
  [5485] = {.lex_state = 0},
  [5486] = {.lex_state = 0},
  [5487] = {.lex_state = 0},
  [5488] = {.lex_state = 0},
  [5489] = {.lex_state = 0},
  [5490] = {.lex_state = 64},
  [5491] = {.lex_state = 64},
  [5492] = {.lex_state = 0},
  [5493] = {.lex_state = 64},
  [5494] = {.lex_state = 0},
  [5495] = {.lex_state = 0},
  [5496] = {.lex_state = 64},
  [5497] = {.lex_state = 64},
  [5498] = {.lex_state = 0},
  [5499] = {.lex_state = 0},
  [5500] = {.lex_state = 0},
  [5501] = {.lex_state = 64},
  [5502] = {.lex_state = 0},
  [5503] = {.lex_state = 0},
  [5504] = {.lex_state = 0},
  [5505] = {.lex_state = 0},
  [5506] = {.lex_state = 0},
  [5507] = {.lex_state = 0},
  [5508] = {.lex_state = 0},
  [5509] = {.lex_state = 0},
  [5510] = {.lex_state = 0},
  [5511] = {.lex_state = 64},
  [5512] = {.lex_state = 0},
  [5513] = {.lex_state = 0},
  [5514] = {.lex_state = 0},
  [5515] = {.lex_state = 0},
  [5516] = {.lex_state = 0},
  [5517] = {.lex_state = 0},
  [5518] = {.lex_state = 0},
  [5519] = {.lex_state = 0},
  [5520] = {.lex_state = 0},
  [5521] = {.lex_state = 0},
  [5522] = {.lex_state = 64},
  [5523] = {.lex_state = 64},
  [5524] = {.lex_state = 0},
  [5525] = {.lex_state = 0},
  [5526] = {.lex_state = 0},
  [5527] = {.lex_state = 0},
  [5528] = {.lex_state = 0},
  [5529] = {.lex_state = 0},
  [5530] = {.lex_state = 0},
  [5531] = {.lex_state = 64},
  [5532] = {.lex_state = 0},
  [5533] = {.lex_state = 64},
  [5534] = {.lex_state = 64},
  [5535] = {.lex_state = 0},
  [5536] = {.lex_state = 0},
  [5537] = {.lex_state = 0},
  [5538] = {.lex_state = 0},
  [5539] = {.lex_state = 0},
  [5540] = {.lex_state = 11},
  [5541] = {.lex_state = 0},
  [5542] = {.lex_state = 1},
  [5543] = {.lex_state = 0},
  [5544] = {.lex_state = 0},
  [5545] = {.lex_state = 0},
  [5546] = {.lex_state = 0},
  [5547] = {.lex_state = 1},
  [5548] = {.lex_state = 0},
  [5549] = {.lex_state = 0},
  [5550] = {.lex_state = 0},
  [5551] = {.lex_state = 0},
  [5552] = {.lex_state = 0},
  [5553] = {.lex_state = 0},
  [5554] = {.lex_state = 0},
  [5555] = {.lex_state = 64},
  [5556] = {.lex_state = 0},
  [5557] = {.lex_state = 0},
  [5558] = {.lex_state = 0},
  [5559] = {.lex_state = 0},
  [5560] = {.lex_state = 64},
  [5561] = {.lex_state = 64},
  [5562] = {.lex_state = 0},
  [5563] = {.lex_state = 0},
  [5564] = {.lex_state = 0},
  [5565] = {.lex_state = 0},
  [5566] = {.lex_state = 64},
  [5567] = {.lex_state = 0},
  [5568] = {.lex_state = 0},
  [5569] = {.lex_state = 0},
  [5570] = {.lex_state = 0},
  [5571] = {.lex_state = 64},
  [5572] = {.lex_state = 0},
  [5573] = {.lex_state = 1},
  [5574] = {.lex_state = 0},
  [5575] = {.lex_state = 0},
  [5576] = {.lex_state = 64},
  [5577] = {.lex_state = 0},
  [5578] = {.lex_state = 0},
  [5579] = {.lex_state = 0},
  [5580] = {.lex_state = 0},
  [5581] = {.lex_state = 0},
  [5582] = {.lex_state = 11},
  [5583] = {.lex_state = 0},
  [5584] = {.lex_state = 64},
  [5585] = {.lex_state = 64},
  [5586] = {.lex_state = 0},
  [5587] = {.lex_state = 0},
  [5588] = {.lex_state = 0},
  [5589] = {.lex_state = 0},
  [5590] = {.lex_state = 64},
  [5591] = {.lex_state = 0},
  [5592] = {.lex_state = 0},
  [5593] = {.lex_state = 0},
  [5594] = {.lex_state = 0},
  [5595] = {.lex_state = 11},
  [5596] = {.lex_state = 0},
  [5597] = {.lex_state = 64},
  [5598] = {.lex_state = 0},
  [5599] = {.lex_state = 0},
  [5600] = {.lex_state = 11},
  [5601] = {.lex_state = 0},
  [5602] = {.lex_state = 64},
  [5603] = {.lex_state = 64},
  [5604] = {.lex_state = 64},
  [5605] = {.lex_state = 64},
  [5606] = {.lex_state = 0},
  [5607] = {.lex_state = 0},
  [5608] = {.lex_state = 0},
  [5609] = {.lex_state = 1},
  [5610] = {.lex_state = 64},
  [5611] = {.lex_state = 0},
  [5612] = {.lex_state = 64},
  [5613] = {.lex_state = 64},
  [5614] = {.lex_state = 0},
  [5615] = {.lex_state = 64},
  [5616] = {.lex_state = 64},
  [5617] = {.lex_state = 0},
  [5618] = {.lex_state = 0},
  [5619] = {.lex_state = 64},
  [5620] = {.lex_state = 64},
  [5621] = {.lex_state = 0},
  [5622] = {.lex_state = 0},
  [5623] = {.lex_state = 64},
  [5624] = {.lex_state = 0},
  [5625] = {.lex_state = 64},
  [5626] = {.lex_state = 64},
  [5627] = {.lex_state = 64},
  [5628] = {.lex_state = 0},
  [5629] = {.lex_state = 0},
  [5630] = {.lex_state = 0},
  [5631] = {.lex_state = 0},
  [5632] = {.lex_state = 0},
  [5633] = {.lex_state = 0},
  [5634] = {.lex_state = 64},
  [5635] = {.lex_state = 0},
  [5636] = {.lex_state = 64},
  [5637] = {.lex_state = 11},
  [5638] = {.lex_state = 64},
  [5639] = {.lex_state = 0},
  [5640] = {.lex_state = 0},
  [5641] = {.lex_state = 0},
  [5642] = {.lex_state = 0},
  [5643] = {.lex_state = 0},
  [5644] = {.lex_state = 64},
  [5645] = {.lex_state = 64},
  [5646] = {.lex_state = 64},
  [5647] = {.lex_state = 0},
  [5648] = {.lex_state = 64},
  [5649] = {.lex_state = 0},
  [5650] = {.lex_state = 0},
  [5651] = {.lex_state = 0},
  [5652] = {.lex_state = 64},
  [5653] = {.lex_state = 0},
  [5654] = {.lex_state = 64},
  [5655] = {.lex_state = 0},
  [5656] = {.lex_state = 64},
  [5657] = {.lex_state = 64},
  [5658] = {.lex_state = 0},
  [5659] = {.lex_state = 64},
  [5660] = {.lex_state = 0},
  [5661] = {.lex_state = 0},
  [5662] = {.lex_state = 0},
  [5663] = {.lex_state = 0},
  [5664] = {.lex_state = 64},
  [5665] = {.lex_state = 64},
  [5666] = {.lex_state = 0},
  [5667] = {.lex_state = 11},
  [5668] = {.lex_state = 0},
  [5669] = {.lex_state = 64},
  [5670] = {.lex_state = 0},
  [5671] = {.lex_state = 0},
  [5672] = {.lex_state = 0},
  [5673] = {.lex_state = 0},
  [5674] = {.lex_state = 0},
  [5675] = {.lex_state = 0},
  [5676] = {.lex_state = 0},
  [5677] = {.lex_state = 0},
  [5678] = {.lex_state = 0},
  [5679] = {.lex_state = 0},
  [5680] = {.lex_state = 0},
  [5681] = {.lex_state = 0},
  [5682] = {.lex_state = 64},
  [5683] = {.lex_state = 0},
  [5684] = {.lex_state = 0},
  [5685] = {.lex_state = 0},
  [5686] = {.lex_state = 0},
  [5687] = {.lex_state = 0},
  [5688] = {.lex_state = 64},
  [5689] = {.lex_state = 64},
  [5690] = {.lex_state = 0},
  [5691] = {.lex_state = 0},
  [5692] = {.lex_state = 0},
  [5693] = {.lex_state = 0},
  [5694] = {.lex_state = 64},
  [5695] = {.lex_state = 0},
  [5696] = {.lex_state = 0},
  [5697] = {.lex_state = 0},
  [5698] = {.lex_state = 64},
  [5699] = {.lex_state = 0},
  [5700] = {.lex_state = 0},
  [5701] = {.lex_state = 0},
  [5702] = {.lex_state = 11},
  [5703] = {.lex_state = 0},
  [5704] = {.lex_state = 64},
  [5705] = {.lex_state = 0},
  [5706] = {.lex_state = 0},
  [5707] = {.lex_state = 0},
  [5708] = {.lex_state = 64},
  [5709] = {.lex_state = 0},
  [5710] = {.lex_state = 64},
  [5711] = {.lex_state = 0},
  [5712] = {.lex_state = 0},
  [5713] = {.lex_state = 0},
  [5714] = {.lex_state = 0},
  [5715] = {.lex_state = 0},
  [5716] = {.lex_state = 0},
  [5717] = {.lex_state = 0},
  [5718] = {.lex_state = 0},
  [5719] = {.lex_state = 0},
  [5720] = {.lex_state = 64},
  [5721] = {.lex_state = 0},
  [5722] = {.lex_state = 0},
  [5723] = {.lex_state = 64},
  [5724] = {.lex_state = 64},
  [5725] = {.lex_state = 0},
  [5726] = {.lex_state = 0},
  [5727] = {.lex_state = 1},
  [5728] = {.lex_state = 64},
  [5729] = {.lex_state = 0},
  [5730] = {.lex_state = 0},
  [5731] = {.lex_state = 0},
  [5732] = {.lex_state = 0},
  [5733] = {.lex_state = 0},
  [5734] = {.lex_state = 0},
  [5735] = {.lex_state = 0},
  [5736] = {.lex_state = 0},
  [5737] = {.lex_state = 0},
  [5738] = {.lex_state = 0},
  [5739] = {.lex_state = 0},
  [5740] = {.lex_state = 64},
  [5741] = {.lex_state = 64},
  [5742] = {.lex_state = 64},
  [5743] = {.lex_state = 64},
  [5744] = {.lex_state = 0},
  [5745] = {.lex_state = 64},
  [5746] = {.lex_state = 0},
  [5747] = {.lex_state = 0},
  [5748] = {.lex_state = 0},
  [5749] = {.lex_state = 0},
  [5750] = {.lex_state = 0},
  [5751] = {.lex_state = 0},
  [5752] = {.lex_state = 0},
  [5753] = {.lex_state = 0},
  [5754] = {.lex_state = 64},
  [5755] = {.lex_state = 64},
  [5756] = {.lex_state = 64},
  [5757] = {.lex_state = 0},
  [5758] = {.lex_state = 0},
  [5759] = {.lex_state = 0},
  [5760] = {.lex_state = 0},
  [5761] = {.lex_state = 1},
  [5762] = {.lex_state = 0},
  [5763] = {.lex_state = 0},
  [5764] = {.lex_state = 0},
  [5765] = {.lex_state = 0},
  [5766] = {.lex_state = 0},
  [5767] = {.lex_state = 0},
  [5768] = {.lex_state = 0},
  [5769] = {.lex_state = 0},
  [5770] = {.lex_state = 1},
  [5771] = {.lex_state = 0},
  [5772] = {.lex_state = 0},
  [5773] = {.lex_state = 0},
  [5774] = {.lex_state = 64},
  [5775] = {.lex_state = 0},
  [5776] = {.lex_state = 0},
  [5777] = {.lex_state = 0},
  [5778] = {.lex_state = 0},
  [5779] = {.lex_state = 0},
  [5780] = {.lex_state = 0},
  [5781] = {.lex_state = 0},
  [5782] = {.lex_state = 0},
  [5783] = {.lex_state = 1},
  [5784] = {.lex_state = 0},
  [5785] = {.lex_state = 0},
  [5786] = {.lex_state = 0},
  [5787] = {.lex_state = 0},
  [5788] = {.lex_state = 0},
  [5789] = {.lex_state = 0},
  [5790] = {.lex_state = 0},
  [5791] = {.lex_state = 0},
  [5792] = {.lex_state = 1},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token_PIPE_PIPE = 2,
  ts_external_token__function_signature_automatic_semicolon = 3,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [ts_external_token__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
};

static bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [6] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [7] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5753),
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [2] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5025),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5025),
    [sym_pair] = STATE(5025),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5024),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(111),
    [anon_sym_namespace] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(127),
    [anon_sym_static] = ACTIONS(129),
    [anon_sym_readonly] = ACTIONS(131),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(133),
    [anon_sym_set] = ACTIONS(133),
    [anon_sym_public] = ACTIONS(135),
    [anon_sym_private] = ACTIONS(135),
    [anon_sym_protected] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_any] = ACTIONS(139),
    [anon_sym_number] = ACTIONS(139),
    [anon_sym_boolean] = ACTIONS(139),
    [anon_sym_string] = ACTIONS(139),
    [anon_sym_symbol] = ACTIONS(139),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [3] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5025),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5025),
    [sym_pair] = STATE(5025),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5024),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(141),
    [anon_sym_export] = ACTIONS(143),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(145),
    [anon_sym_namespace] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(149),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(153),
    [anon_sym_static] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(157),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(159),
    [anon_sym_set] = ACTIONS(159),
    [anon_sym_public] = ACTIONS(161),
    [anon_sym_private] = ACTIONS(161),
    [anon_sym_protected] = ACTIONS(161),
    [anon_sym_module] = ACTIONS(163),
    [anon_sym_any] = ACTIONS(165),
    [anon_sym_number] = ACTIONS(165),
    [anon_sym_boolean] = ACTIONS(165),
    [anon_sym_string] = ACTIONS(165),
    [anon_sym_symbol] = ACTIONS(165),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [4] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5052),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5052),
    [sym_pair] = STATE(5052),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5053),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(167),
    [anon_sym_export] = ACTIONS(169),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(171),
    [anon_sym_namespace] = ACTIONS(173),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(175),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(177),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(179),
    [anon_sym_static] = ACTIONS(181),
    [anon_sym_readonly] = ACTIONS(183),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(185),
    [anon_sym_set] = ACTIONS(185),
    [anon_sym_public] = ACTIONS(187),
    [anon_sym_private] = ACTIONS(187),
    [anon_sym_protected] = ACTIONS(187),
    [anon_sym_module] = ACTIONS(189),
    [anon_sym_any] = ACTIONS(191),
    [anon_sym_number] = ACTIONS(191),
    [anon_sym_boolean] = ACTIONS(191),
    [anon_sym_string] = ACTIONS(191),
    [anon_sym_symbol] = ACTIONS(191),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [5] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(4980),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(4980),
    [sym_pair] = STATE(4980),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(4979),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(193),
    [anon_sym_export] = ACTIONS(195),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(197),
    [anon_sym_namespace] = ACTIONS(199),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(201),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(205),
    [anon_sym_static] = ACTIONS(207),
    [anon_sym_readonly] = ACTIONS(209),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(211),
    [anon_sym_set] = ACTIONS(211),
    [anon_sym_public] = ACTIONS(213),
    [anon_sym_private] = ACTIONS(213),
    [anon_sym_protected] = ACTIONS(213),
    [anon_sym_module] = ACTIONS(215),
    [anon_sym_any] = ACTIONS(217),
    [anon_sym_number] = ACTIONS(217),
    [anon_sym_boolean] = ACTIONS(217),
    [anon_sym_string] = ACTIONS(217),
    [anon_sym_symbol] = ACTIONS(217),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [6] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5025),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5025),
    [sym_pair] = STATE(5025),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5024),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(111),
    [anon_sym_namespace] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(127),
    [anon_sym_static] = ACTIONS(129),
    [anon_sym_readonly] = ACTIONS(131),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(133),
    [anon_sym_set] = ACTIONS(133),
    [anon_sym_public] = ACTIONS(135),
    [anon_sym_private] = ACTIONS(135),
    [anon_sym_protected] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_any] = ACTIONS(139),
    [anon_sym_number] = ACTIONS(139),
    [anon_sym_boolean] = ACTIONS(139),
    [anon_sym_string] = ACTIONS(139),
    [anon_sym_symbol] = ACTIONS(139),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [7] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5052),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5052),
    [sym_pair] = STATE(5052),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5053),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(221),
    [anon_sym_export] = ACTIONS(223),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(225),
    [anon_sym_namespace] = ACTIONS(227),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(231),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(233),
    [anon_sym_static] = ACTIONS(235),
    [anon_sym_readonly] = ACTIONS(237),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(239),
    [anon_sym_set] = ACTIONS(239),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(243),
    [anon_sym_any] = ACTIONS(245),
    [anon_sym_number] = ACTIONS(245),
    [anon_sym_boolean] = ACTIONS(245),
    [anon_sym_string] = ACTIONS(245),
    [anon_sym_symbol] = ACTIONS(245),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [8] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5064),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5064),
    [sym_pair] = STATE(5064),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5063),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(247),
    [anon_sym_export] = ACTIONS(249),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(251),
    [anon_sym_namespace] = ACTIONS(253),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(257),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(259),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_readonly] = ACTIONS(263),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(265),
    [anon_sym_set] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(269),
    [anon_sym_any] = ACTIONS(271),
    [anon_sym_number] = ACTIONS(271),
    [anon_sym_boolean] = ACTIONS(271),
    [anon_sym_string] = ACTIONS(271),
    [anon_sym_symbol] = ACTIONS(271),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [9] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5025),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5025),
    [sym_pair] = STATE(5025),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5024),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(111),
    [anon_sym_namespace] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(273),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(127),
    [anon_sym_static] = ACTIONS(129),
    [anon_sym_readonly] = ACTIONS(131),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(133),
    [anon_sym_set] = ACTIONS(133),
    [anon_sym_public] = ACTIONS(135),
    [anon_sym_private] = ACTIONS(135),
    [anon_sym_protected] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_any] = ACTIONS(139),
    [anon_sym_number] = ACTIONS(139),
    [anon_sym_boolean] = ACTIONS(139),
    [anon_sym_string] = ACTIONS(139),
    [anon_sym_symbol] = ACTIONS(139),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [10] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5736),
    [sym_object_assignment_pattern] = STATE(5026),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5736),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5736),
    [sym_spread_element] = STATE(5052),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(3355),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_rest_pattern] = STATE(5026),
    [sym_method_definition] = STATE(5052),
    [sym_pair] = STATE(5052),
    [sym_pair_pattern] = STATE(5026),
    [sym__property_name] = STATE(4233),
    [sym_computed_property_name] = STATE(4233),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_accessibility_modifier] = STATE(3763),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [aux_sym_object_repeat1] = STATE(5053),
    [aux_sym_object_pattern_repeat1] = STATE(5022),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_export] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(279),
    [anon_sym_namespace] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_RBRACE] = ACTIONS(175),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(283),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(125),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(285),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_readonly] = ACTIONS(289),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(291),
    [anon_sym_set] = ACTIONS(291),
    [anon_sym_public] = ACTIONS(293),
    [anon_sym_private] = ACTIONS(293),
    [anon_sym_protected] = ACTIONS(293),
    [anon_sym_module] = ACTIONS(295),
    [anon_sym_any] = ACTIONS(297),
    [anon_sym_number] = ACTIONS(297),
    [anon_sym_boolean] = ACTIONS(297),
    [anon_sym_string] = ACTIONS(297),
    [anon_sym_symbol] = ACTIONS(297),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [11] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_export] = ACTIONS(304),
    [anon_sym_default] = ACTIONS(307),
    [anon_sym_type] = ACTIONS(309),
    [anon_sym_namespace] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_typeof] = ACTIONS(318),
    [anon_sym_import] = ACTIONS(321),
    [anon_sym_var] = ACTIONS(324),
    [anon_sym_let] = ACTIONS(327),
    [anon_sym_const] = ACTIONS(330),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(336),
    [anon_sym_switch] = ACTIONS(339),
    [anon_sym_for] = ACTIONS(342),
    [anon_sym_LPAREN] = ACTIONS(345),
    [anon_sym_await] = ACTIONS(348),
    [anon_sym_while] = ACTIONS(351),
    [anon_sym_do] = ACTIONS(354),
    [anon_sym_try] = ACTIONS(357),
    [anon_sym_with] = ACTIONS(360),
    [anon_sym_break] = ACTIONS(363),
    [anon_sym_continue] = ACTIONS(366),
    [anon_sym_debugger] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(372),
    [anon_sym_throw] = ACTIONS(375),
    [anon_sym_SEMI] = ACTIONS(378),
    [anon_sym_case] = ACTIONS(307),
    [anon_sym_yield] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_SLASH] = ACTIONS(390),
    [anon_sym_class] = ACTIONS(393),
    [anon_sym_async] = ACTIONS(396),
    [anon_sym_function] = ACTIONS(399),
    [anon_sym_new] = ACTIONS(402),
    [anon_sym_PLUS] = ACTIONS(405),
    [anon_sym_DASH] = ACTIONS(405),
    [anon_sym_TILDE] = ACTIONS(333),
    [anon_sym_void] = ACTIONS(318),
    [anon_sym_delete] = ACTIONS(318),
    [anon_sym_PLUS_PLUS] = ACTIONS(408),
    [anon_sym_DASH_DASH] = ACTIONS(408),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(414),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [sym_number] = ACTIONS(420),
    [sym_this] = ACTIONS(423),
    [sym_super] = ACTIONS(423),
    [sym_true] = ACTIONS(423),
    [sym_false] = ACTIONS(423),
    [sym_null] = ACTIONS(423),
    [sym_undefined] = ACTIONS(423),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_declare] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(432),
    [anon_sym_readonly] = ACTIONS(432),
    [anon_sym_abstract] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(432),
    [anon_sym_set] = ACTIONS(432),
    [anon_sym_public] = ACTIONS(432),
    [anon_sym_private] = ACTIONS(432),
    [anon_sym_protected] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(438),
    [anon_sym_any] = ACTIONS(432),
    [anon_sym_number] = ACTIONS(432),
    [anon_sym_boolean] = ACTIONS(432),
    [anon_sym_string] = ACTIONS(432),
    [anon_sym_symbol] = ACTIONS(432),
    [anon_sym_interface] = ACTIONS(441),
    [anon_sym_enum] = ACTIONS(444),
  },
  [12] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(447),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(449),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(447),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [13] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(451),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [14] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(455),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(457),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(455),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [15] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [16] = {
    [sym_export_statement] = STATE(34),
    [sym_declaration] = STATE(34),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(34),
    [sym_expression_statement] = STATE(34),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(34),
    [sym_if_statement] = STATE(34),
    [sym_switch_statement] = STATE(34),
    [sym_for_statement] = STATE(34),
    [sym_for_in_statement] = STATE(34),
    [sym_while_statement] = STATE(34),
    [sym_do_statement] = STATE(34),
    [sym_try_statement] = STATE(34),
    [sym_with_statement] = STATE(34),
    [sym_break_statement] = STATE(34),
    [sym_continue_statement] = STATE(34),
    [sym_debugger_statement] = STATE(34),
    [sym_return_statement] = STATE(34),
    [sym_throw_statement] = STATE(34),
    [sym_empty_statement] = STATE(34),
    [sym_labeled_statement] = STATE(34),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(34),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [17] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [18] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [19] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [ts_builtin_sym_end] = ACTIONS(469),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [20] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [21] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [ts_builtin_sym_end] = ACTIONS(473),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [22] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [23] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [24] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [25] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [26] = {
    [sym_export_statement] = STATE(31),
    [sym_declaration] = STATE(31),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(31),
    [sym_expression_statement] = STATE(31),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(31),
    [sym_if_statement] = STATE(31),
    [sym_switch_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_for_in_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_do_statement] = STATE(31),
    [sym_try_statement] = STATE(31),
    [sym_with_statement] = STATE(31),
    [sym_break_statement] = STATE(31),
    [sym_continue_statement] = STATE(31),
    [sym_debugger_statement] = STATE(31),
    [sym_return_statement] = STATE(31),
    [sym_throw_statement] = STATE(31),
    [sym_empty_statement] = STATE(31),
    [sym_labeled_statement] = STATE(31),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(31),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(483),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [27] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [ts_builtin_sym_end] = ACTIONS(473),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [28] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [29] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [30] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [31] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [32] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [33] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [34] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [35] = {
    [sym_export_statement] = STATE(1159),
    [sym_declaration] = STATE(1159),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1159),
    [sym_expression_statement] = STATE(1159),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1159),
    [sym_if_statement] = STATE(1159),
    [sym_switch_statement] = STATE(1159),
    [sym_for_statement] = STATE(1159),
    [sym_for_in_statement] = STATE(1159),
    [sym_while_statement] = STATE(1159),
    [sym_do_statement] = STATE(1159),
    [sym_try_statement] = STATE(1159),
    [sym_with_statement] = STATE(1159),
    [sym_break_statement] = STATE(1159),
    [sym_continue_statement] = STATE(1159),
    [sym_debugger_statement] = STATE(1159),
    [sym_return_statement] = STATE(1159),
    [sym_throw_statement] = STATE(1159),
    [sym_empty_statement] = STATE(1159),
    [sym_labeled_statement] = STATE(1159),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [36] = {
    [sym_export_statement] = STATE(1175),
    [sym_declaration] = STATE(1175),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1175),
    [sym_expression_statement] = STATE(1175),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1175),
    [sym_if_statement] = STATE(1175),
    [sym_switch_statement] = STATE(1175),
    [sym_for_statement] = STATE(1175),
    [sym_for_in_statement] = STATE(1175),
    [sym_while_statement] = STATE(1175),
    [sym_do_statement] = STATE(1175),
    [sym_try_statement] = STATE(1175),
    [sym_with_statement] = STATE(1175),
    [sym_break_statement] = STATE(1175),
    [sym_continue_statement] = STATE(1175),
    [sym_debugger_statement] = STATE(1175),
    [sym_return_statement] = STATE(1175),
    [sym_throw_statement] = STATE(1175),
    [sym_empty_statement] = STATE(1175),
    [sym_labeled_statement] = STATE(1175),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [37] = {
    [sym_export_statement] = STATE(1067),
    [sym_declaration] = STATE(1067),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1067),
    [sym_expression_statement] = STATE(1067),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1067),
    [sym_if_statement] = STATE(1067),
    [sym_switch_statement] = STATE(1067),
    [sym_for_statement] = STATE(1067),
    [sym_for_in_statement] = STATE(1067),
    [sym_while_statement] = STATE(1067),
    [sym_do_statement] = STATE(1067),
    [sym_try_statement] = STATE(1067),
    [sym_with_statement] = STATE(1067),
    [sym_break_statement] = STATE(1067),
    [sym_continue_statement] = STATE(1067),
    [sym_debugger_statement] = STATE(1067),
    [sym_return_statement] = STATE(1067),
    [sym_throw_statement] = STATE(1067),
    [sym_empty_statement] = STATE(1067),
    [sym_labeled_statement] = STATE(1067),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [38] = {
    [sym_export_statement] = STATE(4993),
    [sym_declaration] = STATE(4993),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(4993),
    [sym_expression_statement] = STATE(4993),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(4993),
    [sym_if_statement] = STATE(4993),
    [sym_switch_statement] = STATE(4993),
    [sym_for_statement] = STATE(4993),
    [sym_for_in_statement] = STATE(4993),
    [sym_while_statement] = STATE(4993),
    [sym_do_statement] = STATE(4993),
    [sym_try_statement] = STATE(4993),
    [sym_with_statement] = STATE(4993),
    [sym_break_statement] = STATE(4993),
    [sym_continue_statement] = STATE(4993),
    [sym_debugger_statement] = STATE(4993),
    [sym_return_statement] = STATE(4993),
    [sym_throw_statement] = STATE(4993),
    [sym_empty_statement] = STATE(4993),
    [sym_labeled_statement] = STATE(4993),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [39] = {
    [sym_export_statement] = STATE(1147),
    [sym_declaration] = STATE(1135),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1134),
    [sym_expression_statement] = STATE(1120),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1115),
    [sym_if_statement] = STATE(1113),
    [sym_switch_statement] = STATE(1111),
    [sym_for_statement] = STATE(1110),
    [sym_for_in_statement] = STATE(1078),
    [sym_while_statement] = STATE(1099),
    [sym_do_statement] = STATE(1095),
    [sym_try_statement] = STATE(1123),
    [sym_with_statement] = STATE(1075),
    [sym_break_statement] = STATE(1077),
    [sym_continue_statement] = STATE(1079),
    [sym_debugger_statement] = STATE(1083),
    [sym_return_statement] = STATE(1084),
    [sym_throw_statement] = STATE(1090),
    [sym_empty_statement] = STATE(1092),
    [sym_labeled_statement] = STATE(1108),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [40] = {
    [sym_export_statement] = STATE(1106),
    [sym_declaration] = STATE(1106),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1106),
    [sym_expression_statement] = STATE(1106),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1106),
    [sym_if_statement] = STATE(1106),
    [sym_switch_statement] = STATE(1106),
    [sym_for_statement] = STATE(1106),
    [sym_for_in_statement] = STATE(1106),
    [sym_while_statement] = STATE(1106),
    [sym_do_statement] = STATE(1106),
    [sym_try_statement] = STATE(1106),
    [sym_with_statement] = STATE(1106),
    [sym_break_statement] = STATE(1106),
    [sym_continue_statement] = STATE(1106),
    [sym_debugger_statement] = STATE(1106),
    [sym_return_statement] = STATE(1106),
    [sym_throw_statement] = STATE(1106),
    [sym_empty_statement] = STATE(1106),
    [sym_labeled_statement] = STATE(1106),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [41] = {
    [sym_export_statement] = STATE(1127),
    [sym_declaration] = STATE(1132),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1137),
    [sym_expression_statement] = STATE(1138),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1148),
    [sym_if_statement] = STATE(1194),
    [sym_switch_statement] = STATE(1151),
    [sym_for_statement] = STATE(1169),
    [sym_for_in_statement] = STATE(1174),
    [sym_while_statement] = STATE(1180),
    [sym_do_statement] = STATE(1187),
    [sym_try_statement] = STATE(1142),
    [sym_with_statement] = STATE(1196),
    [sym_break_statement] = STATE(1201),
    [sym_continue_statement] = STATE(1204),
    [sym_debugger_statement] = STATE(1157),
    [sym_return_statement] = STATE(1139),
    [sym_throw_statement] = STATE(1133),
    [sym_empty_statement] = STATE(1124),
    [sym_labeled_statement] = STATE(1121),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [42] = {
    [sym_export_statement] = STATE(1117),
    [sym_declaration] = STATE(1117),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1117),
    [sym_expression_statement] = STATE(1117),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1117),
    [sym_if_statement] = STATE(1117),
    [sym_switch_statement] = STATE(1117),
    [sym_for_statement] = STATE(1117),
    [sym_for_in_statement] = STATE(1117),
    [sym_while_statement] = STATE(1117),
    [sym_do_statement] = STATE(1117),
    [sym_try_statement] = STATE(1117),
    [sym_with_statement] = STATE(1117),
    [sym_break_statement] = STATE(1117),
    [sym_continue_statement] = STATE(1117),
    [sym_debugger_statement] = STATE(1117),
    [sym_return_statement] = STATE(1117),
    [sym_throw_statement] = STATE(1117),
    [sym_empty_statement] = STATE(1117),
    [sym_labeled_statement] = STATE(1117),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [43] = {
    [sym_export_statement] = STATE(1147),
    [sym_declaration] = STATE(1135),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1134),
    [sym_expression_statement] = STATE(1120),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1115),
    [sym_if_statement] = STATE(1113),
    [sym_switch_statement] = STATE(1111),
    [sym_for_statement] = STATE(1110),
    [sym_for_in_statement] = STATE(1078),
    [sym_while_statement] = STATE(1099),
    [sym_do_statement] = STATE(1095),
    [sym_try_statement] = STATE(1123),
    [sym_with_statement] = STATE(1075),
    [sym_break_statement] = STATE(1077),
    [sym_continue_statement] = STATE(1079),
    [sym_debugger_statement] = STATE(1083),
    [sym_return_statement] = STATE(1084),
    [sym_throw_statement] = STATE(1090),
    [sym_empty_statement] = STATE(1092),
    [sym_labeled_statement] = STATE(1108),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [44] = {
    [sym_export_statement] = STATE(1106),
    [sym_declaration] = STATE(1106),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1106),
    [sym_expression_statement] = STATE(1106),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1106),
    [sym_if_statement] = STATE(1106),
    [sym_switch_statement] = STATE(1106),
    [sym_for_statement] = STATE(1106),
    [sym_for_in_statement] = STATE(1106),
    [sym_while_statement] = STATE(1106),
    [sym_do_statement] = STATE(1106),
    [sym_try_statement] = STATE(1106),
    [sym_with_statement] = STATE(1106),
    [sym_break_statement] = STATE(1106),
    [sym_continue_statement] = STATE(1106),
    [sym_debugger_statement] = STATE(1106),
    [sym_return_statement] = STATE(1106),
    [sym_throw_statement] = STATE(1106),
    [sym_empty_statement] = STATE(1106),
    [sym_labeled_statement] = STATE(1106),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [45] = {
    [sym_export_statement] = STATE(1127),
    [sym_declaration] = STATE(1132),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1137),
    [sym_expression_statement] = STATE(1138),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1148),
    [sym_if_statement] = STATE(1194),
    [sym_switch_statement] = STATE(1151),
    [sym_for_statement] = STATE(1169),
    [sym_for_in_statement] = STATE(1174),
    [sym_while_statement] = STATE(1180),
    [sym_do_statement] = STATE(1187),
    [sym_try_statement] = STATE(1142),
    [sym_with_statement] = STATE(1196),
    [sym_break_statement] = STATE(1201),
    [sym_continue_statement] = STATE(1204),
    [sym_debugger_statement] = STATE(1157),
    [sym_return_statement] = STATE(1139),
    [sym_throw_statement] = STATE(1133),
    [sym_empty_statement] = STATE(1124),
    [sym_labeled_statement] = STATE(1121),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [46] = {
    [sym_export_statement] = STATE(1175),
    [sym_declaration] = STATE(1175),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1175),
    [sym_expression_statement] = STATE(1175),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1175),
    [sym_if_statement] = STATE(1175),
    [sym_switch_statement] = STATE(1175),
    [sym_for_statement] = STATE(1175),
    [sym_for_in_statement] = STATE(1175),
    [sym_while_statement] = STATE(1175),
    [sym_do_statement] = STATE(1175),
    [sym_try_statement] = STATE(1175),
    [sym_with_statement] = STATE(1175),
    [sym_break_statement] = STATE(1175),
    [sym_continue_statement] = STATE(1175),
    [sym_debugger_statement] = STATE(1175),
    [sym_return_statement] = STATE(1175),
    [sym_throw_statement] = STATE(1175),
    [sym_empty_statement] = STATE(1175),
    [sym_labeled_statement] = STATE(1175),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [47] = {
    [sym_export_statement] = STATE(1159),
    [sym_declaration] = STATE(1159),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1159),
    [sym_expression_statement] = STATE(1159),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1159),
    [sym_if_statement] = STATE(1159),
    [sym_switch_statement] = STATE(1159),
    [sym_for_statement] = STATE(1159),
    [sym_for_in_statement] = STATE(1159),
    [sym_while_statement] = STATE(1159),
    [sym_do_statement] = STATE(1159),
    [sym_try_statement] = STATE(1159),
    [sym_with_statement] = STATE(1159),
    [sym_break_statement] = STATE(1159),
    [sym_continue_statement] = STATE(1159),
    [sym_debugger_statement] = STATE(1159),
    [sym_return_statement] = STATE(1159),
    [sym_throw_statement] = STATE(1159),
    [sym_empty_statement] = STATE(1159),
    [sym_labeled_statement] = STATE(1159),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [48] = {
    [sym_export_statement] = STATE(1129),
    [sym_declaration] = STATE(1129),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1129),
    [sym_expression_statement] = STATE(1129),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1129),
    [sym_if_statement] = STATE(1129),
    [sym_switch_statement] = STATE(1129),
    [sym_for_statement] = STATE(1129),
    [sym_for_in_statement] = STATE(1129),
    [sym_while_statement] = STATE(1129),
    [sym_do_statement] = STATE(1129),
    [sym_try_statement] = STATE(1129),
    [sym_with_statement] = STATE(1129),
    [sym_break_statement] = STATE(1129),
    [sym_continue_statement] = STATE(1129),
    [sym_debugger_statement] = STATE(1129),
    [sym_return_statement] = STATE(1129),
    [sym_throw_statement] = STATE(1129),
    [sym_empty_statement] = STATE(1129),
    [sym_labeled_statement] = STATE(1129),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [49] = {
    [sym_export_statement] = STATE(1117),
    [sym_declaration] = STATE(1117),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1117),
    [sym_expression_statement] = STATE(1117),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1117),
    [sym_if_statement] = STATE(1117),
    [sym_switch_statement] = STATE(1117),
    [sym_for_statement] = STATE(1117),
    [sym_for_in_statement] = STATE(1117),
    [sym_while_statement] = STATE(1117),
    [sym_do_statement] = STATE(1117),
    [sym_try_statement] = STATE(1117),
    [sym_with_statement] = STATE(1117),
    [sym_break_statement] = STATE(1117),
    [sym_continue_statement] = STATE(1117),
    [sym_debugger_statement] = STATE(1117),
    [sym_return_statement] = STATE(1117),
    [sym_throw_statement] = STATE(1117),
    [sym_empty_statement] = STATE(1117),
    [sym_labeled_statement] = STATE(1117),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [50] = {
    [sym_export_statement] = STATE(1103),
    [sym_declaration] = STATE(1103),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1103),
    [sym_expression_statement] = STATE(1103),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1103),
    [sym_if_statement] = STATE(1103),
    [sym_switch_statement] = STATE(1103),
    [sym_for_statement] = STATE(1103),
    [sym_for_in_statement] = STATE(1103),
    [sym_while_statement] = STATE(1103),
    [sym_do_statement] = STATE(1103),
    [sym_try_statement] = STATE(1103),
    [sym_with_statement] = STATE(1103),
    [sym_break_statement] = STATE(1103),
    [sym_continue_statement] = STATE(1103),
    [sym_debugger_statement] = STATE(1103),
    [sym_return_statement] = STATE(1103),
    [sym_throw_statement] = STATE(1103),
    [sym_empty_statement] = STATE(1103),
    [sym_labeled_statement] = STATE(1103),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [51] = {
    [sym_export_statement] = STATE(5704),
    [sym_declaration] = STATE(5704),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(5704),
    [sym_expression_statement] = STATE(5704),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(5704),
    [sym_if_statement] = STATE(5704),
    [sym_switch_statement] = STATE(5704),
    [sym_for_statement] = STATE(5704),
    [sym_for_in_statement] = STATE(5704),
    [sym_while_statement] = STATE(5704),
    [sym_do_statement] = STATE(5704),
    [sym_try_statement] = STATE(5704),
    [sym_with_statement] = STATE(5704),
    [sym_break_statement] = STATE(5704),
    [sym_continue_statement] = STATE(5704),
    [sym_debugger_statement] = STATE(5704),
    [sym_return_statement] = STATE(5704),
    [sym_throw_statement] = STATE(5704),
    [sym_empty_statement] = STATE(5704),
    [sym_labeled_statement] = STATE(5704),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [52] = {
    [sym_export_statement] = STATE(1103),
    [sym_declaration] = STATE(1103),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1103),
    [sym_expression_statement] = STATE(1103),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1103),
    [sym_if_statement] = STATE(1103),
    [sym_switch_statement] = STATE(1103),
    [sym_for_statement] = STATE(1103),
    [sym_for_in_statement] = STATE(1103),
    [sym_while_statement] = STATE(1103),
    [sym_do_statement] = STATE(1103),
    [sym_try_statement] = STATE(1103),
    [sym_with_statement] = STATE(1103),
    [sym_break_statement] = STATE(1103),
    [sym_continue_statement] = STATE(1103),
    [sym_debugger_statement] = STATE(1103),
    [sym_return_statement] = STATE(1103),
    [sym_throw_statement] = STATE(1103),
    [sym_empty_statement] = STATE(1103),
    [sym_labeled_statement] = STATE(1103),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(3076),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4331),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_type] = ACTIONS(503),
    [anon_sym_namespace] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(523),
    [anon_sym_static] = ACTIONS(525),
    [anon_sym_readonly] = ACTIONS(525),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(525),
    [anon_sym_set] = ACTIONS(525),
    [anon_sym_public] = ACTIONS(525),
    [anon_sym_private] = ACTIONS(525),
    [anon_sym_protected] = ACTIONS(525),
    [anon_sym_module] = ACTIONS(527),
    [anon_sym_any] = ACTIONS(525),
    [anon_sym_number] = ACTIONS(525),
    [anon_sym_boolean] = ACTIONS(525),
    [anon_sym_string] = ACTIONS(525),
    [anon_sym_symbol] = ACTIONS(525),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [53] = {
    [sym_export_statement] = STATE(1129),
    [sym_declaration] = STATE(1129),
    [sym_import] = STATE(2381),
    [sym_import_statement] = STATE(1129),
    [sym_expression_statement] = STATE(1129),
    [sym_variable_declaration] = STATE(1172),
    [sym_lexical_declaration] = STATE(1172),
    [sym_statement_block] = STATE(1129),
    [sym_if_statement] = STATE(1129),
    [sym_switch_statement] = STATE(1129),
    [sym_for_statement] = STATE(1129),
    [sym_for_in_statement] = STATE(1129),
    [sym_while_statement] = STATE(1129),
    [sym_do_statement] = STATE(1129),
    [sym_try_statement] = STATE(1129),
    [sym_with_statement] = STATE(1129),
    [sym_break_statement] = STATE(1129),
    [sym_continue_statement] = STATE(1129),
    [sym_debugger_statement] = STATE(1129),
    [sym_return_statement] = STATE(1129),
    [sym_throw_statement] = STATE(1129),
    [sym_empty_statement] = STATE(1129),
    [sym_labeled_statement] = STATE(1129),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2966),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_class_declaration] = STATE(1172),
    [sym_function] = STATE(2381),
    [sym_function_declaration] = STATE(1172),
    [sym_generator_function] = STATE(2381),
    [sym_generator_function_declaration] = STATE(1172),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_sequence_expression] = STATE(5160),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_function_signature] = STATE(1172),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_ambient_declaration] = STATE(1172),
    [sym_abstract_class_declaration] = STATE(1172),
    [sym_module] = STATE(1172),
    [sym_internal_module] = STATE(170),
    [sym_import_alias] = STATE(1172),
    [sym_interface_declaration] = STATE(1172),
    [sym_enum_declaration] = STATE(1172),
    [sym_type_alias_declaration] = STATE(1172),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4296),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_readonly] = ACTIONS(95),
    [anon_sym_abstract] = ACTIONS(97),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(95),
    [anon_sym_private] = ACTIONS(95),
    [anon_sym_protected] = ACTIONS(95),
    [anon_sym_module] = ACTIONS(99),
    [anon_sym_any] = ACTIONS(95),
    [anon_sym_number] = ACTIONS(95),
    [anon_sym_boolean] = ACTIONS(95),
    [anon_sym_string] = ACTIONS(95),
    [anon_sym_symbol] = ACTIONS(95),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [54] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2876),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(4977),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(4976),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(555),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [55] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2914),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5013),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5012),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(607),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [56] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(609),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [57] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2915),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5060),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5059),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(611),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [58] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2914),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5013),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5012),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [59] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(615),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [60] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2914),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5013),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5012),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(617),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [61] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(619),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [62] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2914),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5013),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5012),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(621),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [63] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(623),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [64] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [65] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2914),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5013),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5012),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(627),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [66] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2876),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(4977),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(4976),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [67] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2915),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5060),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5059),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(631),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [68] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(5033),
    [sym_optional_tuple_parameter] = STATE(5033),
    [sym_optional_type] = STATE(5033),
    [sym_rest_type] = STATE(5033),
    [sym__tuple_type_member] = STATE(5033),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(633),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [69] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(637),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [70] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(639),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [71] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2864),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_assignment_pattern] = STATE(5014),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_spread_element] = STATE(5061),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3490),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4566),
    [sym_pattern] = STATE(4756),
    [sym_rest_pattern] = STATE(4441),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4381),
    [sym_tuple_parameter] = STATE(4895),
    [sym_optional_tuple_parameter] = STATE(4895),
    [sym_optional_type] = STATE(4895),
    [sym_rest_type] = STATE(4895),
    [sym__tuple_type_member] = STATE(4895),
    [sym_constructor_type] = STATE(4381),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4381),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5130),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4381),
    [sym_union_type] = STATE(4381),
    [sym_intersection_type] = STATE(4381),
    [sym_function_type] = STATE(4381),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [aux_sym_array_repeat1] = STATE(5066),
    [aux_sym_array_pattern_repeat1] = STATE(5001),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(531),
    [anon_sym_namespace] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(567),
    [anon_sym_QMARK] = ACTIONS(569),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(595),
    [sym_false] = ACTIONS(595),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(531),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_readonly] = ACTIONS(597),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [anon_sym_public] = ACTIONS(531),
    [anon_sym_private] = ACTIONS(531),
    [anon_sym_protected] = ACTIONS(531),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(599),
    [anon_sym_number] = ACTIONS(599),
    [anon_sym_boolean] = ACTIONS(599),
    [anon_sym_string] = ACTIONS(599),
    [anon_sym_symbol] = ACTIONS(599),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(603),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [72] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2699),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym__formal_parameter] = STATE(5017),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_sequence_expression] = STATE(5705),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4560),
    [sym_pattern] = STATE(4142),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym_accessibility_modifier] = STATE(3746),
    [sym_required_parameter] = STATE(5017),
    [sym_optional_parameter] = STATE(5017),
    [sym__parameter_name] = STATE(4142),
    [sym__type] = STATE(4847),
    [sym_constructor_type] = STATE(4847),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4847),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5203),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4847),
    [sym_union_type] = STATE(4847),
    [sym_intersection_type] = STATE(4847),
    [sym_function_type] = STATE(4847),
    [aux_sym_export_statement_repeat1] = STATE(3677),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(645),
    [anon_sym_namespace] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_typeof] = ACTIONS(651),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(659),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(671),
    [sym_this] = ACTIONS(673),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(645),
    [anon_sym_static] = ACTIONS(645),
    [anon_sym_readonly] = ACTIONS(677),
    [anon_sym_get] = ACTIONS(645),
    [anon_sym_set] = ACTIONS(645),
    [anon_sym_public] = ACTIONS(679),
    [anon_sym_private] = ACTIONS(679),
    [anon_sym_protected] = ACTIONS(679),
    [anon_sym_module] = ACTIONS(645),
    [anon_sym_any] = ACTIONS(681),
    [anon_sym_number] = ACTIONS(681),
    [anon_sym_boolean] = ACTIONS(681),
    [anon_sym_string] = ACTIONS(681),
    [anon_sym_symbol] = ACTIONS(681),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [73] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2647),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym__formal_parameter] = STATE(5017),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_sequence_expression] = STATE(5456),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4560),
    [sym_pattern] = STATE(4142),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym_accessibility_modifier] = STATE(3746),
    [sym_required_parameter] = STATE(5017),
    [sym_optional_parameter] = STATE(5017),
    [sym__parameter_name] = STATE(4142),
    [sym__type] = STATE(4847),
    [sym_constructor_type] = STATE(4847),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4847),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5203),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4847),
    [sym_union_type] = STATE(4847),
    [sym_intersection_type] = STATE(4847),
    [sym_function_type] = STATE(4847),
    [aux_sym_export_statement_repeat1] = STATE(3677),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(645),
    [anon_sym_namespace] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_typeof] = ACTIONS(651),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(659),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(671),
    [sym_this] = ACTIONS(673),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(645),
    [anon_sym_static] = ACTIONS(645),
    [anon_sym_readonly] = ACTIONS(677),
    [anon_sym_get] = ACTIONS(645),
    [anon_sym_set] = ACTIONS(645),
    [anon_sym_public] = ACTIONS(679),
    [anon_sym_private] = ACTIONS(679),
    [anon_sym_protected] = ACTIONS(679),
    [anon_sym_module] = ACTIONS(645),
    [anon_sym_any] = ACTIONS(681),
    [anon_sym_number] = ACTIONS(681),
    [anon_sym_boolean] = ACTIONS(681),
    [anon_sym_string] = ACTIONS(681),
    [anon_sym_symbol] = ACTIONS(681),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [74] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2604),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym__formal_parameter] = STATE(5017),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_sequence_expression] = STATE(5535),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4560),
    [sym_pattern] = STATE(4142),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym_accessibility_modifier] = STATE(3746),
    [sym_required_parameter] = STATE(5017),
    [sym_optional_parameter] = STATE(5017),
    [sym__parameter_name] = STATE(4142),
    [sym__type] = STATE(4847),
    [sym_constructor_type] = STATE(4847),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4847),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5203),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4847),
    [sym_union_type] = STATE(4847),
    [sym_intersection_type] = STATE(4847),
    [sym_function_type] = STATE(4847),
    [aux_sym_export_statement_repeat1] = STATE(3677),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(645),
    [anon_sym_namespace] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_typeof] = ACTIONS(651),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(659),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(671),
    [sym_this] = ACTIONS(673),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(645),
    [anon_sym_static] = ACTIONS(645),
    [anon_sym_readonly] = ACTIONS(677),
    [anon_sym_get] = ACTIONS(645),
    [anon_sym_set] = ACTIONS(645),
    [anon_sym_public] = ACTIONS(679),
    [anon_sym_private] = ACTIONS(679),
    [anon_sym_protected] = ACTIONS(679),
    [anon_sym_module] = ACTIONS(645),
    [anon_sym_any] = ACTIONS(681),
    [anon_sym_number] = ACTIONS(681),
    [anon_sym_boolean] = ACTIONS(681),
    [anon_sym_string] = ACTIONS(681),
    [anon_sym_symbol] = ACTIONS(681),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [75] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2735),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym__formal_parameter] = STATE(5017),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_sequence_expression] = STATE(5655),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4560),
    [sym_pattern] = STATE(4142),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym_accessibility_modifier] = STATE(3746),
    [sym_required_parameter] = STATE(5017),
    [sym_optional_parameter] = STATE(5017),
    [sym__parameter_name] = STATE(4142),
    [sym__type] = STATE(4847),
    [sym_constructor_type] = STATE(4847),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4847),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5203),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4847),
    [sym_union_type] = STATE(4847),
    [sym_intersection_type] = STATE(4847),
    [sym_function_type] = STATE(4847),
    [aux_sym_export_statement_repeat1] = STATE(3677),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(645),
    [anon_sym_namespace] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_typeof] = ACTIONS(651),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(659),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(671),
    [sym_this] = ACTIONS(673),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(645),
    [anon_sym_static] = ACTIONS(645),
    [anon_sym_readonly] = ACTIONS(677),
    [anon_sym_get] = ACTIONS(645),
    [anon_sym_set] = ACTIONS(645),
    [anon_sym_public] = ACTIONS(679),
    [anon_sym_private] = ACTIONS(679),
    [anon_sym_protected] = ACTIONS(679),
    [anon_sym_module] = ACTIONS(645),
    [anon_sym_any] = ACTIONS(681),
    [anon_sym_number] = ACTIONS(681),
    [anon_sym_boolean] = ACTIONS(681),
    [anon_sym_string] = ACTIONS(681),
    [anon_sym_symbol] = ACTIONS(681),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [76] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2735),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4385),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4385),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym__formal_parameter] = STATE(5017),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4385),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_sequence_expression] = STATE(5655),
    [sym_string] = STATE(3446),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4560),
    [sym_pattern] = STATE(4142),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym_accessibility_modifier] = STATE(3746),
    [sym_required_parameter] = STATE(5017),
    [sym_optional_parameter] = STATE(5017),
    [sym__parameter_name] = STATE(4142),
    [sym__type] = STATE(4729),
    [sym_constructor_type] = STATE(4729),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4729),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5203),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4729),
    [sym_union_type] = STATE(4729),
    [sym_intersection_type] = STATE(4729),
    [sym_function_type] = STATE(4729),
    [aux_sym_export_statement_repeat1] = STATE(3677),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(645),
    [anon_sym_namespace] = ACTIONS(647),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_typeof] = ACTIONS(651),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(659),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_PIPE] = ACTIONS(667),
    [anon_sym_PLUS] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(671),
    [sym_this] = ACTIONS(673),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(645),
    [anon_sym_static] = ACTIONS(645),
    [anon_sym_readonly] = ACTIONS(677),
    [anon_sym_get] = ACTIONS(645),
    [anon_sym_set] = ACTIONS(645),
    [anon_sym_public] = ACTIONS(679),
    [anon_sym_private] = ACTIONS(679),
    [anon_sym_protected] = ACTIONS(679),
    [anon_sym_module] = ACTIONS(645),
    [anon_sym_any] = ACTIONS(681),
    [anon_sym_number] = ACTIONS(681),
    [anon_sym_boolean] = ACTIONS(681),
    [anon_sym_string] = ACTIONS(681),
    [anon_sym_symbol] = ACTIONS(681),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [77] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(3052),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5009),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5009),
    [sym_nested_identifier] = STATE(5772),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5009),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2832),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4584),
    [sym_pattern] = STATE(5333),
    [sym_rest_pattern] = STATE(4124),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3859),
    [sym__type] = STATE(3991),
    [sym_constructor_type] = STATE(3991),
    [sym__primary_type] = STATE(3906),
    [sym_infer_type] = STATE(3991),
    [sym_conditional_type] = STATE(3917),
    [sym_generic_type] = STATE(3917),
    [sym_type_query] = STATE(3917),
    [sym_index_type_query] = STATE(3917),
    [sym_lookup_type] = STATE(3917),
    [sym_literal_type] = STATE(3917),
    [sym__number] = STATE(3897),
    [sym_existential_type] = STATE(3917),
    [sym_flow_maybe_type] = STATE(3917),
    [sym_parenthesized_type] = STATE(3917),
    [sym_predefined_type] = STATE(3917),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3917),
    [sym_type_parameters] = STATE(5137),
    [sym_array_type] = STATE(3917),
    [sym_tuple_type] = STATE(3917),
    [sym_readonly_type] = STATE(3991),
    [sym_union_type] = STATE(3991),
    [sym_intersection_type] = STATE(3991),
    [sym_function_type] = STATE(3991),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(685),
    [anon_sym_export] = ACTIONS(687),
    [anon_sym_STAR] = ACTIONS(689),
    [anon_sym_type] = ACTIONS(687),
    [anon_sym_namespace] = ACTIONS(691),
    [anon_sym_LBRACE] = ACTIONS(693),
    [anon_sym_typeof] = ACTIONS(695),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(697),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(703),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(707),
    [anon_sym_PIPE] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(711),
    [anon_sym_DASH] = ACTIONS(711),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(713),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(715),
    [sym_this] = ACTIONS(717),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(719),
    [sym_false] = ACTIONS(719),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(687),
    [anon_sym_static] = ACTIONS(687),
    [anon_sym_readonly] = ACTIONS(721),
    [anon_sym_get] = ACTIONS(687),
    [anon_sym_set] = ACTIONS(687),
    [anon_sym_public] = ACTIONS(687),
    [anon_sym_private] = ACTIONS(687),
    [anon_sym_protected] = ACTIONS(687),
    [anon_sym_module] = ACTIONS(687),
    [anon_sym_any] = ACTIONS(723),
    [anon_sym_number] = ACTIONS(723),
    [anon_sym_boolean] = ACTIONS(723),
    [anon_sym_string] = ACTIONS(723),
    [anon_sym_symbol] = ACTIONS(723),
    [anon_sym_infer] = ACTIONS(725),
    [anon_sym_keyof] = ACTIONS(727),
    [anon_sym_LBRACE_PIPE] = ACTIONS(729),
  },
  [78] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(2034),
    [sym_expression] = STATE(3003),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5701),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5701),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5703),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(2034),
    [sym_subscript_expression] = STATE(2034),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3803),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5701),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(3344),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2034),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(592),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(731),
    [anon_sym_export] = ACTIONS(733),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(733),
    [anon_sym_namespace] = ACTIONS(735),
    [anon_sym_LBRACE] = ACTIONS(737),
    [anon_sym_typeof] = ACTIONS(739),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(743),
    [anon_sym_LPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(747),
    [anon_sym_yield] = ACTIONS(749),
    [anon_sym_LBRACK] = ACTIONS(751),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(755),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_new] = ACTIONS(759),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(767),
    [anon_sym_DASH] = ACTIONS(767),
    [anon_sym_TILDE] = ACTIONS(743),
    [anon_sym_void] = ACTIONS(769),
    [anon_sym_delete] = ACTIONS(771),
    [anon_sym_PLUS_PLUS] = ACTIONS(773),
    [anon_sym_DASH_DASH] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(775),
    [sym_this] = ACTIONS(777),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(779),
    [sym_false] = ACTIONS(779),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(733),
    [anon_sym_static] = ACTIONS(733),
    [anon_sym_readonly] = ACTIONS(781),
    [anon_sym_get] = ACTIONS(733),
    [anon_sym_set] = ACTIONS(733),
    [anon_sym_public] = ACTIONS(733),
    [anon_sym_private] = ACTIONS(733),
    [anon_sym_protected] = ACTIONS(733),
    [anon_sym_module] = ACTIONS(733),
    [anon_sym_any] = ACTIONS(783),
    [anon_sym_number] = ACTIONS(783),
    [anon_sym_boolean] = ACTIONS(783),
    [anon_sym_string] = ACTIONS(783),
    [anon_sym_symbol] = ACTIONS(783),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [79] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2090),
    [sym_expression] = STATE(3105),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5563),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5563),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5693),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2090),
    [sym_subscript_expression] = STATE(2090),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3807),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5563),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2731),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2090),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(609),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(787),
    [anon_sym_export] = ACTIONS(789),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(789),
    [anon_sym_namespace] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_typeof] = ACTIONS(795),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(797),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(799),
    [anon_sym_yield] = ACTIONS(801),
    [anon_sym_LBRACK] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(807),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(809),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(811),
    [anon_sym_DASH] = ACTIONS(811),
    [anon_sym_TILDE] = ACTIONS(797),
    [anon_sym_void] = ACTIONS(813),
    [anon_sym_delete] = ACTIONS(815),
    [anon_sym_PLUS_PLUS] = ACTIONS(817),
    [anon_sym_DASH_DASH] = ACTIONS(817),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(819),
    [sym_this] = ACTIONS(821),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(823),
    [sym_false] = ACTIONS(823),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(789),
    [anon_sym_static] = ACTIONS(789),
    [anon_sym_readonly] = ACTIONS(825),
    [anon_sym_get] = ACTIONS(789),
    [anon_sym_set] = ACTIONS(789),
    [anon_sym_public] = ACTIONS(789),
    [anon_sym_private] = ACTIONS(789),
    [anon_sym_protected] = ACTIONS(789),
    [anon_sym_module] = ACTIONS(789),
    [anon_sym_any] = ACTIONS(827),
    [anon_sym_number] = ACTIONS(827),
    [anon_sym_boolean] = ACTIONS(827),
    [anon_sym_string] = ACTIONS(827),
    [anon_sym_symbol] = ACTIONS(827),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [80] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1330),
    [sym_expression] = STATE(3188),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5618),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5618),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5668),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1330),
    [sym_subscript_expression] = STATE(1330),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3817),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5618),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3356),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1330),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(678),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(829),
    [anon_sym_export] = ACTIONS(831),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(831),
    [anon_sym_namespace] = ACTIONS(833),
    [anon_sym_LBRACE] = ACTIONS(835),
    [anon_sym_typeof] = ACTIONS(837),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(839),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(841),
    [anon_sym_yield] = ACTIONS(843),
    [anon_sym_LBRACK] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(847),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(849),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_TILDE] = ACTIONS(839),
    [anon_sym_void] = ACTIONS(853),
    [anon_sym_delete] = ACTIONS(855),
    [anon_sym_PLUS_PLUS] = ACTIONS(857),
    [anon_sym_DASH_DASH] = ACTIONS(857),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(859),
    [sym_this] = ACTIONS(861),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(863),
    [sym_false] = ACTIONS(863),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(831),
    [anon_sym_static] = ACTIONS(831),
    [anon_sym_readonly] = ACTIONS(865),
    [anon_sym_get] = ACTIONS(831),
    [anon_sym_set] = ACTIONS(831),
    [anon_sym_public] = ACTIONS(831),
    [anon_sym_private] = ACTIONS(831),
    [anon_sym_protected] = ACTIONS(831),
    [anon_sym_module] = ACTIONS(831),
    [anon_sym_any] = ACTIONS(867),
    [anon_sym_number] = ACTIONS(867),
    [anon_sym_boolean] = ACTIONS(867),
    [anon_sym_string] = ACTIONS(867),
    [anon_sym_symbol] = ACTIONS(867),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [81] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2719),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(3159),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1803),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(610),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(869),
    [anon_sym_export] = ACTIONS(871),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(871),
    [anon_sym_namespace] = ACTIONS(873),
    [anon_sym_LBRACE] = ACTIONS(875),
    [anon_sym_typeof] = ACTIONS(877),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(879),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(881),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_new] = ACTIONS(883),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(885),
    [anon_sym_DASH] = ACTIONS(885),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(887),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(889),
    [sym_this] = ACTIONS(891),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(893),
    [sym_false] = ACTIONS(893),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(871),
    [anon_sym_static] = ACTIONS(871),
    [anon_sym_readonly] = ACTIONS(895),
    [anon_sym_get] = ACTIONS(871),
    [anon_sym_set] = ACTIONS(871),
    [anon_sym_public] = ACTIONS(871),
    [anon_sym_private] = ACTIONS(871),
    [anon_sym_protected] = ACTIONS(871),
    [anon_sym_module] = ACTIONS(871),
    [anon_sym_any] = ACTIONS(897),
    [anon_sym_number] = ACTIONS(897),
    [anon_sym_boolean] = ACTIONS(897),
    [anon_sym_string] = ACTIONS(897),
    [anon_sym_symbol] = ACTIONS(897),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [82] = {
    [sym_import] = STATE(3250),
    [sym_parenthesized_expression] = STATE(2053),
    [sym_expression] = STATE(2791),
    [sym_primary_expression] = STATE(3248),
    [sym_yield_expression] = STATE(3245),
    [sym_object] = STATE(3250),
    [sym_object_pattern] = STATE(5666),
    [sym_array] = STATE(3250),
    [sym_array_pattern] = STATE(5666),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(3250),
    [sym_function] = STATE(3250),
    [sym_generator_function] = STATE(3250),
    [sym_arrow_function] = STATE(3250),
    [sym__call_signature] = STATE(5680),
    [sym_call_expression] = STATE(3250),
    [sym_new_expression] = STATE(3245),
    [sym_await_expression] = STATE(3245),
    [sym_member_expression] = STATE(2053),
    [sym_subscript_expression] = STATE(2053),
    [sym_assignment_expression] = STATE(3245),
    [sym__augmented_assignment_lhs] = STATE(3812),
    [sym_augmented_assignment_expression] = STATE(3245),
    [sym__destructuring_pattern] = STATE(5666),
    [sym_ternary_expression] = STATE(3245),
    [sym_binary_expression] = STATE(3245),
    [sym_unary_expression] = STATE(3245),
    [sym_update_expression] = STATE(3245),
    [sym_string] = STATE(3313),
    [sym_template_string] = STATE(3250),
    [sym_regex] = STATE(3250),
    [sym_meta_property] = STATE(3250),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2053),
    [sym_type_assertion] = STATE(3245),
    [sym_as_expression] = STATE(3245),
    [sym_internal_module] = STATE(3245),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(806),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4719),
    [sym_identifier] = ACTIONS(899),
    [anon_sym_export] = ACTIONS(901),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(901),
    [anon_sym_namespace] = ACTIONS(903),
    [anon_sym_LBRACE] = ACTIONS(905),
    [anon_sym_typeof] = ACTIONS(907),
    [anon_sym_import] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(911),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_await] = ACTIONS(915),
    [anon_sym_yield] = ACTIONS(917),
    [anon_sym_LBRACK] = ACTIONS(919),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(921),
    [anon_sym_class] = ACTIONS(923),
    [anon_sym_async] = ACTIONS(925),
    [anon_sym_function] = ACTIONS(927),
    [anon_sym_new] = ACTIONS(929),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(931),
    [anon_sym_DASH] = ACTIONS(931),
    [anon_sym_TILDE] = ACTIONS(911),
    [anon_sym_void] = ACTIONS(933),
    [anon_sym_delete] = ACTIONS(935),
    [anon_sym_PLUS_PLUS] = ACTIONS(937),
    [anon_sym_DASH_DASH] = ACTIONS(937),
    [anon_sym_DQUOTE] = ACTIONS(939),
    [anon_sym_SQUOTE] = ACTIONS(941),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [sym_number] = ACTIONS(945),
    [sym_this] = ACTIONS(947),
    [sym_super] = ACTIONS(949),
    [sym_true] = ACTIONS(951),
    [sym_false] = ACTIONS(951),
    [sym_null] = ACTIONS(949),
    [sym_undefined] = ACTIONS(949),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(901),
    [anon_sym_static] = ACTIONS(901),
    [anon_sym_readonly] = ACTIONS(953),
    [anon_sym_get] = ACTIONS(901),
    [anon_sym_set] = ACTIONS(901),
    [anon_sym_public] = ACTIONS(901),
    [anon_sym_private] = ACTIONS(901),
    [anon_sym_protected] = ACTIONS(901),
    [anon_sym_module] = ACTIONS(901),
    [anon_sym_any] = ACTIONS(955),
    [anon_sym_number] = ACTIONS(955),
    [anon_sym_boolean] = ACTIONS(955),
    [anon_sym_string] = ACTIONS(955),
    [anon_sym_symbol] = ACTIONS(955),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [83] = {
    [sym_import] = STATE(3250),
    [sym_parenthesized_expression] = STATE(2036),
    [sym_expression] = STATE(2614),
    [sym_primary_expression] = STATE(3248),
    [sym_yield_expression] = STATE(3245),
    [sym_object] = STATE(3250),
    [sym_object_pattern] = STATE(5722),
    [sym_array] = STATE(3250),
    [sym_array_pattern] = STATE(5722),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(3250),
    [sym_function] = STATE(3250),
    [sym_generator_function] = STATE(3250),
    [sym_arrow_function] = STATE(3250),
    [sym__call_signature] = STATE(5718),
    [sym_call_expression] = STATE(3250),
    [sym_new_expression] = STATE(3245),
    [sym_await_expression] = STATE(3245),
    [sym_member_expression] = STATE(2036),
    [sym_subscript_expression] = STATE(2036),
    [sym_assignment_expression] = STATE(3245),
    [sym__augmented_assignment_lhs] = STATE(3798),
    [sym_augmented_assignment_expression] = STATE(3245),
    [sym__destructuring_pattern] = STATE(5722),
    [sym_ternary_expression] = STATE(3245),
    [sym_binary_expression] = STATE(3245),
    [sym_unary_expression] = STATE(3245),
    [sym_update_expression] = STATE(3245),
    [sym_string] = STATE(3333),
    [sym_template_string] = STATE(3250),
    [sym_regex] = STATE(3250),
    [sym_meta_property] = STATE(3250),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2036),
    [sym_type_assertion] = STATE(3245),
    [sym_as_expression] = STATE(3245),
    [sym_internal_module] = STATE(3245),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(760),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4719),
    [sym_identifier] = ACTIONS(957),
    [anon_sym_export] = ACTIONS(959),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(959),
    [anon_sym_namespace] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [anon_sym_typeof] = ACTIONS(965),
    [anon_sym_import] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(967),
    [anon_sym_LPAREN] = ACTIONS(913),
    [anon_sym_await] = ACTIONS(969),
    [anon_sym_yield] = ACTIONS(971),
    [anon_sym_LBRACK] = ACTIONS(973),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(975),
    [anon_sym_class] = ACTIONS(923),
    [anon_sym_async] = ACTIONS(977),
    [anon_sym_function] = ACTIONS(927),
    [anon_sym_new] = ACTIONS(979),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(981),
    [anon_sym_DASH] = ACTIONS(981),
    [anon_sym_TILDE] = ACTIONS(967),
    [anon_sym_void] = ACTIONS(983),
    [anon_sym_delete] = ACTIONS(985),
    [anon_sym_PLUS_PLUS] = ACTIONS(987),
    [anon_sym_DASH_DASH] = ACTIONS(987),
    [anon_sym_DQUOTE] = ACTIONS(939),
    [anon_sym_SQUOTE] = ACTIONS(941),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [sym_number] = ACTIONS(989),
    [sym_this] = ACTIONS(991),
    [sym_super] = ACTIONS(949),
    [sym_true] = ACTIONS(993),
    [sym_false] = ACTIONS(993),
    [sym_null] = ACTIONS(949),
    [sym_undefined] = ACTIONS(949),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(959),
    [anon_sym_static] = ACTIONS(959),
    [anon_sym_readonly] = ACTIONS(995),
    [anon_sym_get] = ACTIONS(959),
    [anon_sym_set] = ACTIONS(959),
    [anon_sym_public] = ACTIONS(959),
    [anon_sym_private] = ACTIONS(959),
    [anon_sym_protected] = ACTIONS(959),
    [anon_sym_module] = ACTIONS(959),
    [anon_sym_any] = ACTIONS(997),
    [anon_sym_number] = ACTIONS(997),
    [anon_sym_boolean] = ACTIONS(997),
    [anon_sym_string] = ACTIONS(997),
    [anon_sym_symbol] = ACTIONS(997),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [84] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2500),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5699),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5699),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5699),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2498),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(999),
    [anon_sym_export] = ACTIONS(1001),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1001),
    [anon_sym_namespace] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [anon_sym_typeof] = ACTIONS(1007),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(1009),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1011),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1013),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1015),
    [anon_sym_DASH] = ACTIONS(1015),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1017),
    [sym_this] = ACTIONS(1019),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1021),
    [sym_false] = ACTIONS(1021),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1001),
    [anon_sym_static] = ACTIONS(1001),
    [anon_sym_readonly] = ACTIONS(1023),
    [anon_sym_get] = ACTIONS(1001),
    [anon_sym_set] = ACTIONS(1001),
    [anon_sym_public] = ACTIONS(1001),
    [anon_sym_private] = ACTIONS(1001),
    [anon_sym_protected] = ACTIONS(1001),
    [anon_sym_module] = ACTIONS(1001),
    [anon_sym_any] = ACTIONS(1025),
    [anon_sym_number] = ACTIONS(1025),
    [anon_sym_boolean] = ACTIONS(1025),
    [anon_sym_string] = ACTIONS(1025),
    [anon_sym_symbol] = ACTIONS(1025),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [85] = {
    [sym_import] = STATE(2751),
    [sym_parenthesized_expression] = STATE(1494),
    [sym_expression] = STATE(2365),
    [sym_primary_expression] = STATE(2752),
    [sym_yield_expression] = STATE(2753),
    [sym_object] = STATE(2751),
    [sym_object_pattern] = STATE(5764),
    [sym_array] = STATE(2751),
    [sym_array_pattern] = STATE(5764),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2751),
    [sym_function] = STATE(2751),
    [sym_generator_function] = STATE(2751),
    [sym_arrow_function] = STATE(2751),
    [sym__call_signature] = STATE(5784),
    [sym_call_expression] = STATE(2751),
    [sym_new_expression] = STATE(2753),
    [sym_await_expression] = STATE(2753),
    [sym_member_expression] = STATE(1494),
    [sym_subscript_expression] = STATE(1494),
    [sym_assignment_expression] = STATE(2753),
    [sym__augmented_assignment_lhs] = STATE(3810),
    [sym_augmented_assignment_expression] = STATE(2753),
    [sym__destructuring_pattern] = STATE(5764),
    [sym_ternary_expression] = STATE(2753),
    [sym_binary_expression] = STATE(2753),
    [sym_unary_expression] = STATE(2753),
    [sym_update_expression] = STATE(2753),
    [sym_string] = STATE(2770),
    [sym_template_string] = STATE(2751),
    [sym_regex] = STATE(2751),
    [sym_meta_property] = STATE(2751),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1494),
    [sym_type_assertion] = STATE(2753),
    [sym_as_expression] = STATE(2753),
    [sym_internal_module] = STATE(2753),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(797),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4704),
    [sym_identifier] = ACTIONS(1027),
    [anon_sym_export] = ACTIONS(1029),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1029),
    [anon_sym_namespace] = ACTIONS(1031),
    [anon_sym_LBRACE] = ACTIONS(1033),
    [anon_sym_typeof] = ACTIONS(1035),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1039),
    [anon_sym_LPAREN] = ACTIONS(1041),
    [anon_sym_await] = ACTIONS(1043),
    [anon_sym_yield] = ACTIONS(1045),
    [anon_sym_LBRACK] = ACTIONS(1047),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1049),
    [anon_sym_class] = ACTIONS(1051),
    [anon_sym_async] = ACTIONS(1053),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_new] = ACTIONS(1057),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1059),
    [anon_sym_DASH] = ACTIONS(1059),
    [anon_sym_TILDE] = ACTIONS(1039),
    [anon_sym_void] = ACTIONS(1061),
    [anon_sym_delete] = ACTIONS(1063),
    [anon_sym_PLUS_PLUS] = ACTIONS(1065),
    [anon_sym_DASH_DASH] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(1067),
    [anon_sym_SQUOTE] = ACTIONS(1069),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [sym_number] = ACTIONS(1073),
    [sym_this] = ACTIONS(1075),
    [sym_super] = ACTIONS(1077),
    [sym_true] = ACTIONS(1079),
    [sym_false] = ACTIONS(1079),
    [sym_null] = ACTIONS(1077),
    [sym_undefined] = ACTIONS(1077),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1029),
    [anon_sym_static] = ACTIONS(1029),
    [anon_sym_readonly] = ACTIONS(1081),
    [anon_sym_get] = ACTIONS(1029),
    [anon_sym_set] = ACTIONS(1029),
    [anon_sym_public] = ACTIONS(1029),
    [anon_sym_private] = ACTIONS(1029),
    [anon_sym_protected] = ACTIONS(1029),
    [anon_sym_module] = ACTIONS(1029),
    [anon_sym_any] = ACTIONS(1083),
    [anon_sym_number] = ACTIONS(1083),
    [anon_sym_boolean] = ACTIONS(1083),
    [anon_sym_string] = ACTIONS(1083),
    [anon_sym_symbol] = ACTIONS(1083),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [86] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(2042),
    [sym_expression] = STATE(2496),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5622),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5622),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5621),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(2042),
    [sym_subscript_expression] = STATE(2042),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3809),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5622),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2377),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2042),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(817),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1085),
    [anon_sym_export] = ACTIONS(1087),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1087),
    [anon_sym_namespace] = ACTIONS(1089),
    [anon_sym_LBRACE] = ACTIONS(1091),
    [anon_sym_typeof] = ACTIONS(1093),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1095),
    [anon_sym_LPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(1097),
    [anon_sym_yield] = ACTIONS(1099),
    [anon_sym_LBRACK] = ACTIONS(1101),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1105),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_new] = ACTIONS(1107),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_TILDE] = ACTIONS(1095),
    [anon_sym_void] = ACTIONS(1111),
    [anon_sym_delete] = ACTIONS(1113),
    [anon_sym_PLUS_PLUS] = ACTIONS(1115),
    [anon_sym_DASH_DASH] = ACTIONS(1115),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(1117),
    [sym_this] = ACTIONS(1119),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(1121),
    [sym_false] = ACTIONS(1121),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1087),
    [anon_sym_static] = ACTIONS(1087),
    [anon_sym_readonly] = ACTIONS(1123),
    [anon_sym_get] = ACTIONS(1087),
    [anon_sym_set] = ACTIONS(1087),
    [anon_sym_public] = ACTIONS(1087),
    [anon_sym_private] = ACTIONS(1087),
    [anon_sym_protected] = ACTIONS(1087),
    [anon_sym_module] = ACTIONS(1087),
    [anon_sym_any] = ACTIONS(1125),
    [anon_sym_number] = ACTIONS(1125),
    [anon_sym_boolean] = ACTIONS(1125),
    [anon_sym_string] = ACTIONS(1125),
    [anon_sym_symbol] = ACTIONS(1125),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [87] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1413),
    [sym_expression] = STATE(2225),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5492),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5763),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1413),
    [sym_subscript_expression] = STATE(1413),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3805),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2322),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1413),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(674),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1127),
    [anon_sym_export] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1129),
    [anon_sym_namespace] = ACTIONS(1131),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_typeof] = ACTIONS(1135),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1137),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1139),
    [anon_sym_yield] = ACTIONS(1141),
    [anon_sym_LBRACK] = ACTIONS(1143),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1145),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1147),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1149),
    [anon_sym_DASH] = ACTIONS(1149),
    [anon_sym_TILDE] = ACTIONS(1137),
    [anon_sym_void] = ACTIONS(1151),
    [anon_sym_delete] = ACTIONS(1153),
    [anon_sym_PLUS_PLUS] = ACTIONS(1155),
    [anon_sym_DASH_DASH] = ACTIONS(1155),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1157),
    [sym_this] = ACTIONS(1159),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1161),
    [sym_false] = ACTIONS(1161),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1129),
    [anon_sym_static] = ACTIONS(1129),
    [anon_sym_readonly] = ACTIONS(1163),
    [anon_sym_get] = ACTIONS(1129),
    [anon_sym_set] = ACTIONS(1129),
    [anon_sym_public] = ACTIONS(1129),
    [anon_sym_private] = ACTIONS(1129),
    [anon_sym_protected] = ACTIONS(1129),
    [anon_sym_module] = ACTIONS(1129),
    [anon_sym_any] = ACTIONS(1165),
    [anon_sym_number] = ACTIONS(1165),
    [anon_sym_boolean] = ACTIONS(1165),
    [anon_sym_string] = ACTIONS(1165),
    [anon_sym_symbol] = ACTIONS(1165),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [88] = {
    [sym_import] = STATE(2751),
    [sym_parenthesized_expression] = STATE(1521),
    [sym_expression] = STATE(2428),
    [sym_primary_expression] = STATE(2752),
    [sym_yield_expression] = STATE(2753),
    [sym_object] = STATE(2751),
    [sym_object_pattern] = STATE(5448),
    [sym_array] = STATE(2751),
    [sym_array_pattern] = STATE(5448),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2751),
    [sym_function] = STATE(2751),
    [sym_generator_function] = STATE(2751),
    [sym_arrow_function] = STATE(2751),
    [sym__call_signature] = STATE(5443),
    [sym_call_expression] = STATE(2751),
    [sym_new_expression] = STATE(2753),
    [sym_await_expression] = STATE(2753),
    [sym_member_expression] = STATE(1521),
    [sym_subscript_expression] = STATE(1521),
    [sym_assignment_expression] = STATE(2753),
    [sym__augmented_assignment_lhs] = STATE(3804),
    [sym_augmented_assignment_expression] = STATE(2753),
    [sym__destructuring_pattern] = STATE(5448),
    [sym_ternary_expression] = STATE(2753),
    [sym_binary_expression] = STATE(2753),
    [sym_unary_expression] = STATE(2753),
    [sym_update_expression] = STATE(2753),
    [sym_string] = STATE(2762),
    [sym_template_string] = STATE(2751),
    [sym_regex] = STATE(2751),
    [sym_meta_property] = STATE(2751),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1521),
    [sym_type_assertion] = STATE(2753),
    [sym_as_expression] = STATE(2753),
    [sym_internal_module] = STATE(2753),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(893),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4704),
    [sym_identifier] = ACTIONS(1167),
    [anon_sym_export] = ACTIONS(1169),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1169),
    [anon_sym_namespace] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1173),
    [anon_sym_typeof] = ACTIONS(1175),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1177),
    [anon_sym_LPAREN] = ACTIONS(1041),
    [anon_sym_await] = ACTIONS(1179),
    [anon_sym_yield] = ACTIONS(1181),
    [anon_sym_LBRACK] = ACTIONS(1183),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1049),
    [anon_sym_class] = ACTIONS(1051),
    [anon_sym_async] = ACTIONS(1185),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_new] = ACTIONS(1187),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1189),
    [anon_sym_DASH] = ACTIONS(1189),
    [anon_sym_TILDE] = ACTIONS(1177),
    [anon_sym_void] = ACTIONS(1191),
    [anon_sym_delete] = ACTIONS(1193),
    [anon_sym_PLUS_PLUS] = ACTIONS(1195),
    [anon_sym_DASH_DASH] = ACTIONS(1195),
    [anon_sym_DQUOTE] = ACTIONS(1067),
    [anon_sym_SQUOTE] = ACTIONS(1069),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [sym_number] = ACTIONS(1197),
    [sym_this] = ACTIONS(1199),
    [sym_super] = ACTIONS(1077),
    [sym_true] = ACTIONS(1201),
    [sym_false] = ACTIONS(1201),
    [sym_null] = ACTIONS(1077),
    [sym_undefined] = ACTIONS(1077),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1169),
    [anon_sym_static] = ACTIONS(1169),
    [anon_sym_readonly] = ACTIONS(1203),
    [anon_sym_get] = ACTIONS(1169),
    [anon_sym_set] = ACTIONS(1169),
    [anon_sym_public] = ACTIONS(1169),
    [anon_sym_private] = ACTIONS(1169),
    [anon_sym_protected] = ACTIONS(1169),
    [anon_sym_module] = ACTIONS(1169),
    [anon_sym_any] = ACTIONS(1205),
    [anon_sym_number] = ACTIONS(1205),
    [anon_sym_boolean] = ACTIONS(1205),
    [anon_sym_string] = ACTIONS(1205),
    [anon_sym_symbol] = ACTIONS(1205),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [89] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(2045),
    [sym_expression] = STATE(2853),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5502),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5502),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5500),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(2045),
    [sym_subscript_expression] = STATE(2045),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3816),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5502),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(3271),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2045),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(501),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1207),
    [anon_sym_export] = ACTIONS(1209),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1209),
    [anon_sym_namespace] = ACTIONS(1211),
    [anon_sym_LBRACE] = ACTIONS(1213),
    [anon_sym_typeof] = ACTIONS(1215),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1217),
    [anon_sym_LPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(1219),
    [anon_sym_yield] = ACTIONS(1221),
    [anon_sym_LBRACK] = ACTIONS(1223),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1225),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_new] = ACTIONS(1227),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1229),
    [anon_sym_DASH] = ACTIONS(1229),
    [anon_sym_TILDE] = ACTIONS(1217),
    [anon_sym_void] = ACTIONS(1231),
    [anon_sym_delete] = ACTIONS(1233),
    [anon_sym_PLUS_PLUS] = ACTIONS(1235),
    [anon_sym_DASH_DASH] = ACTIONS(1235),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(1237),
    [sym_this] = ACTIONS(1239),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(1241),
    [sym_false] = ACTIONS(1241),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1209),
    [anon_sym_static] = ACTIONS(1209),
    [anon_sym_readonly] = ACTIONS(1243),
    [anon_sym_get] = ACTIONS(1209),
    [anon_sym_set] = ACTIONS(1209),
    [anon_sym_public] = ACTIONS(1209),
    [anon_sym_private] = ACTIONS(1209),
    [anon_sym_protected] = ACTIONS(1209),
    [anon_sym_module] = ACTIONS(1209),
    [anon_sym_any] = ACTIONS(1245),
    [anon_sym_number] = ACTIONS(1245),
    [anon_sym_boolean] = ACTIONS(1245),
    [anon_sym_string] = ACTIONS(1245),
    [anon_sym_symbol] = ACTIONS(1245),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [90] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2069),
    [sym_expression] = STATE(2898),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5737),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5737),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5734),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2069),
    [sym_subscript_expression] = STATE(2069),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3815),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5737),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2322),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2069),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(901),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1247),
    [anon_sym_export] = ACTIONS(1249),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1249),
    [anon_sym_namespace] = ACTIONS(1251),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_typeof] = ACTIONS(1253),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1255),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1257),
    [anon_sym_yield] = ACTIONS(1259),
    [anon_sym_LBRACK] = ACTIONS(1143),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1261),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1263),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1265),
    [anon_sym_DASH] = ACTIONS(1265),
    [anon_sym_TILDE] = ACTIONS(1255),
    [anon_sym_void] = ACTIONS(1267),
    [anon_sym_delete] = ACTIONS(1269),
    [anon_sym_PLUS_PLUS] = ACTIONS(1271),
    [anon_sym_DASH_DASH] = ACTIONS(1271),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1157),
    [sym_this] = ACTIONS(1159),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1161),
    [sym_false] = ACTIONS(1161),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1249),
    [anon_sym_static] = ACTIONS(1249),
    [anon_sym_readonly] = ACTIONS(1273),
    [anon_sym_get] = ACTIONS(1249),
    [anon_sym_set] = ACTIONS(1249),
    [anon_sym_public] = ACTIONS(1249),
    [anon_sym_private] = ACTIONS(1249),
    [anon_sym_protected] = ACTIONS(1249),
    [anon_sym_module] = ACTIONS(1249),
    [anon_sym_any] = ACTIONS(1275),
    [anon_sym_number] = ACTIONS(1275),
    [anon_sym_boolean] = ACTIONS(1275),
    [anon_sym_string] = ACTIONS(1275),
    [anon_sym_symbol] = ACTIONS(1275),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [91] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2040),
    [sym_expression] = STATE(2913),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5433),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5433),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5451),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2040),
    [sym_subscript_expression] = STATE(2040),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3814),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5433),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2498),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2040),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(803),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1277),
    [anon_sym_export] = ACTIONS(1279),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1279),
    [anon_sym_namespace] = ACTIONS(1281),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [anon_sym_typeof] = ACTIONS(1283),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1285),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1287),
    [anon_sym_yield] = ACTIONS(1289),
    [anon_sym_LBRACK] = ACTIONS(1009),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1291),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1293),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1295),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(1297),
    [anon_sym_TILDE] = ACTIONS(1285),
    [anon_sym_void] = ACTIONS(1299),
    [anon_sym_delete] = ACTIONS(1301),
    [anon_sym_PLUS_PLUS] = ACTIONS(1303),
    [anon_sym_DASH_DASH] = ACTIONS(1303),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1017),
    [sym_this] = ACTIONS(1019),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1021),
    [sym_false] = ACTIONS(1021),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1279),
    [anon_sym_static] = ACTIONS(1279),
    [anon_sym_readonly] = ACTIONS(1305),
    [anon_sym_get] = ACTIONS(1279),
    [anon_sym_set] = ACTIONS(1279),
    [anon_sym_public] = ACTIONS(1279),
    [anon_sym_private] = ACTIONS(1279),
    [anon_sym_protected] = ACTIONS(1279),
    [anon_sym_module] = ACTIONS(1279),
    [anon_sym_any] = ACTIONS(1307),
    [anon_sym_number] = ACTIONS(1307),
    [anon_sym_boolean] = ACTIONS(1307),
    [anon_sym_string] = ACTIONS(1307),
    [anon_sym_symbol] = ACTIONS(1307),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [92] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2054),
    [sym_expression] = STATE(2652),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5574),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5574),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5432),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2054),
    [sym_subscript_expression] = STATE(2054),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3797),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5574),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2322),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2054),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(696),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1309),
    [anon_sym_export] = ACTIONS(1311),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1311),
    [anon_sym_namespace] = ACTIONS(1313),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_typeof] = ACTIONS(1315),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1317),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1319),
    [anon_sym_yield] = ACTIONS(1321),
    [anon_sym_LBRACK] = ACTIONS(1143),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1323),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1325),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1327),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1329),
    [anon_sym_DASH] = ACTIONS(1329),
    [anon_sym_TILDE] = ACTIONS(1317),
    [anon_sym_void] = ACTIONS(1331),
    [anon_sym_delete] = ACTIONS(1333),
    [anon_sym_PLUS_PLUS] = ACTIONS(1335),
    [anon_sym_DASH_DASH] = ACTIONS(1335),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1157),
    [sym_this] = ACTIONS(1159),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1161),
    [sym_false] = ACTIONS(1161),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1311),
    [anon_sym_static] = ACTIONS(1311),
    [anon_sym_readonly] = ACTIONS(1337),
    [anon_sym_get] = ACTIONS(1311),
    [anon_sym_set] = ACTIONS(1311),
    [anon_sym_public] = ACTIONS(1311),
    [anon_sym_private] = ACTIONS(1311),
    [anon_sym_protected] = ACTIONS(1311),
    [anon_sym_module] = ACTIONS(1311),
    [anon_sym_any] = ACTIONS(1339),
    [anon_sym_number] = ACTIONS(1339),
    [anon_sym_boolean] = ACTIONS(1339),
    [anon_sym_string] = ACTIONS(1339),
    [anon_sym_symbol] = ACTIONS(1339),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [93] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(1411),
    [sym_expression] = STATE(2320),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5460),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5460),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5458),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1411),
    [sym_subscript_expression] = STATE(1411),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3799),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5460),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1411),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_type_arguments] = STATE(841),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1341),
    [anon_sym_export] = ACTIONS(1343),
    [anon_sym_STAR] = ACTIONS(1345),
    [anon_sym_type] = ACTIONS(1343),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1349),
    [anon_sym_LBRACE] = ACTIONS(1351),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1355),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1357),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(1359),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1361),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1365),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1367),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1357),
    [anon_sym_DASH] = ACTIONS(1357),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1369),
    [anon_sym_void] = ACTIONS(1355),
    [anon_sym_delete] = ACTIONS(1355),
    [anon_sym_PLUS_PLUS] = ACTIONS(1371),
    [anon_sym_DASH_DASH] = ACTIONS(1371),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1343),
    [anon_sym_static] = ACTIONS(1343),
    [anon_sym_readonly] = ACTIONS(1343),
    [anon_sym_get] = ACTIONS(1343),
    [anon_sym_set] = ACTIONS(1343),
    [anon_sym_public] = ACTIONS(1343),
    [anon_sym_private] = ACTIONS(1343),
    [anon_sym_protected] = ACTIONS(1343),
    [anon_sym_module] = ACTIONS(1343),
    [anon_sym_any] = ACTIONS(1343),
    [anon_sym_number] = ACTIONS(1343),
    [anon_sym_boolean] = ACTIONS(1343),
    [anon_sym_string] = ACTIONS(1343),
    [anon_sym_symbol] = ACTIONS(1343),
    [anon_sym_extends] = ACTIONS(1347),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1353),
    [sym__automatic_semicolon] = ACTIONS(1353),
  },
  [94] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2056),
    [sym_expression] = STATE(3209),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5449),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5449),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5587),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2056),
    [sym_subscript_expression] = STATE(2056),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3808),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5449),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3356),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2056),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(598),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1373),
    [anon_sym_export] = ACTIONS(1375),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1375),
    [anon_sym_namespace] = ACTIONS(1377),
    [anon_sym_LBRACE] = ACTIONS(1379),
    [anon_sym_typeof] = ACTIONS(1381),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1383),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1385),
    [anon_sym_yield] = ACTIONS(1387),
    [anon_sym_LBRACK] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1389),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1391),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1393),
    [anon_sym_DASH] = ACTIONS(1393),
    [anon_sym_TILDE] = ACTIONS(1383),
    [anon_sym_void] = ACTIONS(1395),
    [anon_sym_delete] = ACTIONS(1397),
    [anon_sym_PLUS_PLUS] = ACTIONS(1399),
    [anon_sym_DASH_DASH] = ACTIONS(1399),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(859),
    [sym_this] = ACTIONS(861),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(863),
    [sym_false] = ACTIONS(863),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1375),
    [anon_sym_static] = ACTIONS(1375),
    [anon_sym_readonly] = ACTIONS(1401),
    [anon_sym_get] = ACTIONS(1375),
    [anon_sym_set] = ACTIONS(1375),
    [anon_sym_public] = ACTIONS(1375),
    [anon_sym_private] = ACTIONS(1375),
    [anon_sym_protected] = ACTIONS(1375),
    [anon_sym_module] = ACTIONS(1375),
    [anon_sym_any] = ACTIONS(1403),
    [anon_sym_number] = ACTIONS(1403),
    [anon_sym_boolean] = ACTIONS(1403),
    [anon_sym_string] = ACTIONS(1403),
    [anon_sym_symbol] = ACTIONS(1403),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [95] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1771),
    [sym_expression] = STATE(2661),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5527),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5527),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5471),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1771),
    [sym_subscript_expression] = STATE(1771),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3800),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5527),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2731),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1771),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(518),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1405),
    [anon_sym_export] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1407),
    [anon_sym_namespace] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1411),
    [anon_sym_typeof] = ACTIONS(1413),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1417),
    [anon_sym_yield] = ACTIONS(1419),
    [anon_sym_LBRACK] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1421),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1423),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1425),
    [anon_sym_DASH] = ACTIONS(1425),
    [anon_sym_TILDE] = ACTIONS(1415),
    [anon_sym_void] = ACTIONS(1427),
    [anon_sym_delete] = ACTIONS(1429),
    [anon_sym_PLUS_PLUS] = ACTIONS(1431),
    [anon_sym_DASH_DASH] = ACTIONS(1431),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(819),
    [sym_this] = ACTIONS(821),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(823),
    [sym_false] = ACTIONS(823),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1407),
    [anon_sym_static] = ACTIONS(1407),
    [anon_sym_readonly] = ACTIONS(1433),
    [anon_sym_get] = ACTIONS(1407),
    [anon_sym_set] = ACTIONS(1407),
    [anon_sym_public] = ACTIONS(1407),
    [anon_sym_private] = ACTIONS(1407),
    [anon_sym_protected] = ACTIONS(1407),
    [anon_sym_module] = ACTIONS(1407),
    [anon_sym_any] = ACTIONS(1435),
    [anon_sym_number] = ACTIONS(1435),
    [anon_sym_boolean] = ACTIONS(1435),
    [anon_sym_string] = ACTIONS(1435),
    [anon_sym_symbol] = ACTIONS(1435),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [96] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2078),
    [sym_expression] = STATE(3127),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5544),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5544),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5545),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2078),
    [sym_subscript_expression] = STATE(2078),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3811),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5544),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2731),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2078),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(689),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1437),
    [anon_sym_export] = ACTIONS(1439),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1439),
    [anon_sym_namespace] = ACTIONS(1441),
    [anon_sym_LBRACE] = ACTIONS(1411),
    [anon_sym_typeof] = ACTIONS(1443),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1445),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1447),
    [anon_sym_yield] = ACTIONS(1449),
    [anon_sym_LBRACK] = ACTIONS(803),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1451),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1453),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1455),
    [anon_sym_DASH] = ACTIONS(1455),
    [anon_sym_TILDE] = ACTIONS(1445),
    [anon_sym_void] = ACTIONS(1457),
    [anon_sym_delete] = ACTIONS(1459),
    [anon_sym_PLUS_PLUS] = ACTIONS(1461),
    [anon_sym_DASH_DASH] = ACTIONS(1461),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(819),
    [sym_this] = ACTIONS(821),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(823),
    [sym_false] = ACTIONS(823),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1439),
    [anon_sym_static] = ACTIONS(1439),
    [anon_sym_readonly] = ACTIONS(1463),
    [anon_sym_get] = ACTIONS(1439),
    [anon_sym_set] = ACTIONS(1439),
    [anon_sym_public] = ACTIONS(1439),
    [anon_sym_private] = ACTIONS(1439),
    [anon_sym_protected] = ACTIONS(1439),
    [anon_sym_module] = ACTIONS(1439),
    [anon_sym_any] = ACTIONS(1465),
    [anon_sym_number] = ACTIONS(1465),
    [anon_sym_boolean] = ACTIONS(1465),
    [anon_sym_string] = ACTIONS(1465),
    [anon_sym_symbol] = ACTIONS(1465),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [97] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2620),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(4754),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(4754),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(4754),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(3487),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4401),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4478),
    [sym_constructor_type] = STATE(4478),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4478),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(576),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5173),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4478),
    [sym_union_type] = STATE(4478),
    [sym_intersection_type] = STATE(4478),
    [sym_function_type] = STATE(4478),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1467),
    [anon_sym_export] = ACTIONS(1001),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1001),
    [anon_sym_namespace] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1469),
    [anon_sym_typeof] = ACTIONS(1471),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(1473),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1011),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1475),
    [anon_sym_QMARK] = ACTIONS(1477),
    [anon_sym_AMP] = ACTIONS(1479),
    [anon_sym_PIPE] = ACTIONS(1481),
    [anon_sym_PLUS] = ACTIONS(1483),
    [anon_sym_DASH] = ACTIONS(1483),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(577),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1485),
    [sym_this] = ACTIONS(1487),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1489),
    [sym_false] = ACTIONS(1489),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1001),
    [anon_sym_static] = ACTIONS(1001),
    [anon_sym_readonly] = ACTIONS(1491),
    [anon_sym_get] = ACTIONS(1001),
    [anon_sym_set] = ACTIONS(1001),
    [anon_sym_public] = ACTIONS(1001),
    [anon_sym_private] = ACTIONS(1001),
    [anon_sym_protected] = ACTIONS(1001),
    [anon_sym_module] = ACTIONS(1001),
    [anon_sym_any] = ACTIONS(1493),
    [anon_sym_number] = ACTIONS(1493),
    [anon_sym_boolean] = ACTIONS(1493),
    [anon_sym_string] = ACTIONS(1493),
    [anon_sym_symbol] = ACTIONS(1493),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(1495),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [98] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1413),
    [sym_expression] = STATE(2177),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5492),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5492),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5763),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1413),
    [sym_subscript_expression] = STATE(1413),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3805),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5492),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2186),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1413),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1497),
    [anon_sym_export] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(1499),
    [anon_sym_type] = ACTIONS(1129),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1131),
    [anon_sym_LBRACE] = ACTIONS(1501),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1153),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1503),
    [anon_sym_LPAREN] = ACTIONS(1505),
    [anon_sym_RPAREN] = ACTIONS(1353),
    [anon_sym_await] = ACTIONS(1139),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_COLON] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1141),
    [anon_sym_LBRACK] = ACTIONS(1507),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1145),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1509),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1503),
    [anon_sym_DASH] = ACTIONS(1503),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1137),
    [anon_sym_void] = ACTIONS(1153),
    [anon_sym_delete] = ACTIONS(1153),
    [anon_sym_PLUS_PLUS] = ACTIONS(1155),
    [anon_sym_DASH_DASH] = ACTIONS(1155),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1511),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1129),
    [anon_sym_static] = ACTIONS(1129),
    [anon_sym_readonly] = ACTIONS(1129),
    [anon_sym_get] = ACTIONS(1129),
    [anon_sym_set] = ACTIONS(1129),
    [anon_sym_public] = ACTIONS(1129),
    [anon_sym_private] = ACTIONS(1129),
    [anon_sym_protected] = ACTIONS(1129),
    [anon_sym_module] = ACTIONS(1129),
    [anon_sym_any] = ACTIONS(1129),
    [anon_sym_number] = ACTIONS(1129),
    [anon_sym_boolean] = ACTIONS(1129),
    [anon_sym_string] = ACTIONS(1129),
    [anon_sym_symbol] = ACTIONS(1129),
    [anon_sym_extends] = ACTIONS(1347),
  },
  [99] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(1411),
    [sym_expression] = STATE(2291),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5460),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5460),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5458),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1411),
    [sym_subscript_expression] = STATE(1411),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3799),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5460),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2377),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(1411),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(841),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1513),
    [anon_sym_export] = ACTIONS(1343),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1343),
    [anon_sym_namespace] = ACTIONS(1349),
    [anon_sym_LBRACE] = ACTIONS(1515),
    [anon_sym_typeof] = ACTIONS(1517),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1369),
    [anon_sym_LPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(1359),
    [anon_sym_yield] = ACTIONS(1361),
    [anon_sym_LBRACK] = ACTIONS(1519),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1365),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_new] = ACTIONS(1521),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1523),
    [anon_sym_DASH] = ACTIONS(1523),
    [anon_sym_TILDE] = ACTIONS(1369),
    [anon_sym_void] = ACTIONS(1525),
    [anon_sym_delete] = ACTIONS(1355),
    [anon_sym_PLUS_PLUS] = ACTIONS(1371),
    [anon_sym_DASH_DASH] = ACTIONS(1371),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(1117),
    [sym_this] = ACTIONS(1119),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(1121),
    [sym_false] = ACTIONS(1121),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1343),
    [anon_sym_static] = ACTIONS(1343),
    [anon_sym_readonly] = ACTIONS(1527),
    [anon_sym_get] = ACTIONS(1343),
    [anon_sym_set] = ACTIONS(1343),
    [anon_sym_public] = ACTIONS(1343),
    [anon_sym_private] = ACTIONS(1343),
    [anon_sym_protected] = ACTIONS(1343),
    [anon_sym_module] = ACTIONS(1343),
    [anon_sym_any] = ACTIONS(1529),
    [anon_sym_number] = ACTIONS(1529),
    [anon_sym_boolean] = ACTIONS(1529),
    [anon_sym_string] = ACTIONS(1529),
    [anon_sym_symbol] = ACTIONS(1529),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [100] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2062),
    [sym_expression] = STATE(2585),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5548),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5548),
    [sym_nested_identifier] = STATE(5684),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5554),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2062),
    [sym_subscript_expression] = STATE(2062),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3806),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5548),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2322),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4498),
    [sym_non_null_expression] = STATE(2062),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4301),
    [sym_constructor_type] = STATE(4301),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4301),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_type_arguments] = STATE(546),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5111),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4301),
    [sym_union_type] = STATE(4301),
    [sym_intersection_type] = STATE(4301),
    [sym_function_type] = STATE(4301),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1531),
    [anon_sym_export] = ACTIONS(1533),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_type] = ACTIONS(1533),
    [anon_sym_namespace] = ACTIONS(1535),
    [anon_sym_LBRACE] = ACTIONS(1537),
    [anon_sym_typeof] = ACTIONS(1539),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1541),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(1543),
    [anon_sym_yield] = ACTIONS(1545),
    [anon_sym_LBRACK] = ACTIONS(1547),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1549),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(1551),
    [anon_sym_QMARK] = ACTIONS(761),
    [anon_sym_AMP] = ACTIONS(763),
    [anon_sym_PIPE] = ACTIONS(765),
    [anon_sym_PLUS] = ACTIONS(1553),
    [anon_sym_DASH] = ACTIONS(1553),
    [anon_sym_TILDE] = ACTIONS(1541),
    [anon_sym_void] = ACTIONS(1555),
    [anon_sym_delete] = ACTIONS(1557),
    [anon_sym_PLUS_PLUS] = ACTIONS(1559),
    [anon_sym_DASH_DASH] = ACTIONS(1559),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1157),
    [sym_this] = ACTIONS(1159),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(1161),
    [sym_false] = ACTIONS(1161),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1533),
    [anon_sym_static] = ACTIONS(1533),
    [anon_sym_readonly] = ACTIONS(1561),
    [anon_sym_get] = ACTIONS(1533),
    [anon_sym_set] = ACTIONS(1533),
    [anon_sym_public] = ACTIONS(1533),
    [anon_sym_private] = ACTIONS(1533),
    [anon_sym_protected] = ACTIONS(1533),
    [anon_sym_module] = ACTIONS(1533),
    [anon_sym_any] = ACTIONS(1563),
    [anon_sym_number] = ACTIONS(1563),
    [anon_sym_boolean] = ACTIONS(1563),
    [anon_sym_string] = ACTIONS(1563),
    [anon_sym_symbol] = ACTIONS(1563),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(785),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [101] = {
    [sym_import] = STATE(2751),
    [sym_parenthesized_expression] = STATE(1494),
    [sym_expression] = STATE(2372),
    [sym_primary_expression] = STATE(2752),
    [sym_yield_expression] = STATE(2753),
    [sym_object] = STATE(2751),
    [sym_object_pattern] = STATE(5764),
    [sym_array] = STATE(2751),
    [sym_array_pattern] = STATE(5764),
    [sym_class] = STATE(2751),
    [sym_function] = STATE(2751),
    [sym_generator_function] = STATE(2751),
    [sym_arrow_function] = STATE(2751),
    [sym__call_signature] = STATE(5784),
    [sym_call_expression] = STATE(2751),
    [sym_new_expression] = STATE(2753),
    [sym_await_expression] = STATE(2753),
    [sym_member_expression] = STATE(1494),
    [sym_subscript_expression] = STATE(1494),
    [sym_assignment_expression] = STATE(2753),
    [sym__augmented_assignment_lhs] = STATE(3810),
    [sym_augmented_assignment_expression] = STATE(2753),
    [sym__destructuring_pattern] = STATE(5764),
    [sym_ternary_expression] = STATE(2753),
    [sym_binary_expression] = STATE(2753),
    [sym_unary_expression] = STATE(2753),
    [sym_update_expression] = STATE(2753),
    [sym_string] = STATE(2751),
    [sym_template_string] = STATE(2751),
    [sym_regex] = STATE(2751),
    [sym_meta_property] = STATE(2751),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1494),
    [sym_type_assertion] = STATE(2753),
    [sym_as_expression] = STATE(2753),
    [sym_internal_module] = STATE(2753),
    [sym_type_arguments] = STATE(797),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4704),
    [sym_identifier] = ACTIONS(1565),
    [anon_sym_export] = ACTIONS(1029),
    [anon_sym_STAR] = ACTIONS(1567),
    [anon_sym_type] = ACTIONS(1029),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1031),
    [anon_sym_LBRACE] = ACTIONS(1569),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1063),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1571),
    [anon_sym_LPAREN] = ACTIONS(1573),
    [anon_sym_await] = ACTIONS(1043),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1045),
    [anon_sym_LBRACK] = ACTIONS(1575),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1049),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(1051),
    [anon_sym_async] = ACTIONS(1053),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1577),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1571),
    [anon_sym_DASH] = ACTIONS(1571),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1039),
    [anon_sym_void] = ACTIONS(1063),
    [anon_sym_delete] = ACTIONS(1063),
    [anon_sym_PLUS_PLUS] = ACTIONS(1065),
    [anon_sym_DASH_DASH] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(1067),
    [anon_sym_SQUOTE] = ACTIONS(1069),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [sym_number] = ACTIONS(1579),
    [sym_this] = ACTIONS(1077),
    [sym_super] = ACTIONS(1077),
    [sym_true] = ACTIONS(1077),
    [sym_false] = ACTIONS(1077),
    [sym_null] = ACTIONS(1077),
    [sym_undefined] = ACTIONS(1077),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1029),
    [anon_sym_static] = ACTIONS(1029),
    [anon_sym_readonly] = ACTIONS(1029),
    [anon_sym_get] = ACTIONS(1029),
    [anon_sym_set] = ACTIONS(1029),
    [anon_sym_public] = ACTIONS(1029),
    [anon_sym_private] = ACTIONS(1029),
    [anon_sym_protected] = ACTIONS(1029),
    [anon_sym_module] = ACTIONS(1029),
    [anon_sym_any] = ACTIONS(1029),
    [anon_sym_number] = ACTIONS(1029),
    [anon_sym_boolean] = ACTIONS(1029),
    [anon_sym_string] = ACTIONS(1029),
    [anon_sym_symbol] = ACTIONS(1029),
    [anon_sym_extends] = ACTIONS(1347),
    [sym__automatic_semicolon] = ACTIONS(1353),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1353),
  },
  [102] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(1464),
    [sym_expression] = STATE(2446),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5699),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5699),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5617),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(1464),
    [sym_subscript_expression] = STATE(1464),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3801),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5699),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2186),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1464),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_type_arguments] = STATE(576),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1581),
    [anon_sym_export] = ACTIONS(1001),
    [anon_sym_STAR] = ACTIONS(1583),
    [anon_sym_type] = ACTIONS(1001),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1501),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(579),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1585),
    [anon_sym_LPAREN] = ACTIONS(1505),
    [anon_sym_RPAREN] = ACTIONS(1353),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_COLON] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(1507),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1011),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1587),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1585),
    [anon_sym_DASH] = ACTIONS(1585),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(545),
    [anon_sym_void] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1511),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1001),
    [anon_sym_static] = ACTIONS(1001),
    [anon_sym_readonly] = ACTIONS(1001),
    [anon_sym_get] = ACTIONS(1001),
    [anon_sym_set] = ACTIONS(1001),
    [anon_sym_public] = ACTIONS(1001),
    [anon_sym_private] = ACTIONS(1001),
    [anon_sym_protected] = ACTIONS(1001),
    [anon_sym_module] = ACTIONS(1001),
    [anon_sym_any] = ACTIONS(1001),
    [anon_sym_number] = ACTIONS(1001),
    [anon_sym_boolean] = ACTIONS(1001),
    [anon_sym_string] = ACTIONS(1001),
    [anon_sym_symbol] = ACTIONS(1001),
  },
  [103] = {
    [sym_object_pattern] = STATE(4124),
    [sym_array_pattern] = STATE(4124),
    [sym_nested_identifier] = STATE(5684),
    [sym__destructuring_pattern] = STATE(4124),
    [sym_string] = STATE(3831),
    [sym_formal_parameters] = STATE(5633),
    [sym_pattern] = STATE(4558),
    [sym_rest_pattern] = STATE(4124),
    [sym_nested_type_identifier] = STATE(3813),
    [sym__type] = STATE(4122),
    [sym_constructor_type] = STATE(4122),
    [sym__primary_type] = STATE(3841),
    [sym_infer_type] = STATE(4122),
    [sym_conditional_type] = STATE(3860),
    [sym_generic_type] = STATE(3860),
    [sym_type_query] = STATE(3860),
    [sym_index_type_query] = STATE(3860),
    [sym_lookup_type] = STATE(3860),
    [sym_literal_type] = STATE(3860),
    [sym__number] = STATE(3862),
    [sym_existential_type] = STATE(3860),
    [sym_flow_maybe_type] = STATE(3860),
    [sym_parenthesized_type] = STATE(3860),
    [sym_predefined_type] = STATE(3860),
    [sym_object_type] = STATE(3860),
    [sym_type_parameters] = STATE(5201),
    [sym_array_type] = STATE(3860),
    [sym_tuple_type] = STATE(3860),
    [sym_readonly_type] = STATE(4122),
    [sym_union_type] = STATE(4122),
    [sym_intersection_type] = STATE(4122),
    [sym_function_type] = STATE(4122),
    [sym_identifier] = ACTIONS(1589),
    [anon_sym_export] = ACTIONS(1591),
    [anon_sym_STAR] = ACTIONS(1593),
    [anon_sym_type] = ACTIONS(1591),
    [anon_sym_EQ] = ACTIONS(1595),
    [anon_sym_as] = ACTIONS(1598),
    [anon_sym_namespace] = ACTIONS(1591),
    [anon_sym_LBRACE] = ACTIONS(1600),
    [anon_sym_COMMA] = ACTIONS(1602),
    [anon_sym_typeof] = ACTIONS(1605),
    [anon_sym_BANG] = ACTIONS(1598),
    [anon_sym_LPAREN] = ACTIONS(1607),
    [anon_sym_RPAREN] = ACTIONS(1602),
    [anon_sym_in] = ACTIONS(1598),
    [anon_sym_COLON] = ACTIONS(1602),
    [anon_sym_LBRACK] = ACTIONS(1609),
    [anon_sym_LT] = ACTIONS(1611),
    [anon_sym_GT] = ACTIONS(1598),
    [anon_sym_SLASH] = ACTIONS(1598),
    [anon_sym_DOT] = ACTIONS(1598),
    [anon_sym_async] = ACTIONS(1591),
    [anon_sym_EQ_GT] = ACTIONS(1613),
    [anon_sym_QMARK_DOT] = ACTIONS(1615),
    [anon_sym_new] = ACTIONS(1617),
    [anon_sym_PLUS_EQ] = ACTIONS(1619),
    [anon_sym_DASH_EQ] = ACTIONS(1619),
    [anon_sym_STAR_EQ] = ACTIONS(1619),
    [anon_sym_SLASH_EQ] = ACTIONS(1619),
    [anon_sym_PERCENT_EQ] = ACTIONS(1619),
    [anon_sym_CARET_EQ] = ACTIONS(1619),
    [anon_sym_AMP_EQ] = ACTIONS(1619),
    [anon_sym_PIPE_EQ] = ACTIONS(1619),
    [anon_sym_GT_GT_EQ] = ACTIONS(1619),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1619),
    [anon_sym_LT_LT_EQ] = ACTIONS(1619),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1619),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1619),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1619),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1619),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_QMARK] = ACTIONS(1621),
    [anon_sym_AMP_AMP] = ACTIONS(1598),
    [anon_sym_PIPE_PIPE] = ACTIONS(1598),
    [anon_sym_GT_GT] = ACTIONS(1598),
    [anon_sym_GT_GT_GT] = ACTIONS(1598),
    [anon_sym_LT_LT] = ACTIONS(1598),
    [anon_sym_AMP] = ACTIONS(1623),
    [anon_sym_CARET] = ACTIONS(1598),
    [anon_sym_PIPE] = ACTIONS(1625),
    [anon_sym_PLUS] = ACTIONS(1627),
    [anon_sym_DASH] = ACTIONS(1627),
    [anon_sym_PERCENT] = ACTIONS(1598),
    [anon_sym_STAR_STAR] = ACTIONS(1598),
    [anon_sym_LT_EQ] = ACTIONS(1615),
    [anon_sym_EQ_EQ] = ACTIONS(1598),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1615),
    [anon_sym_BANG_EQ] = ACTIONS(1598),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1615),
    [anon_sym_GT_EQ] = ACTIONS(1615),
    [anon_sym_QMARK_QMARK] = ACTIONS(1598),
    [anon_sym_instanceof] = ACTIONS(1598),
    [anon_sym_void] = ACTIONS(1629),
    [anon_sym_PLUS_PLUS] = ACTIONS(1615),
    [anon_sym_DASH_DASH] = ACTIONS(1615),
    [anon_sym_DQUOTE] = ACTIONS(1631),
    [anon_sym_SQUOTE] = ACTIONS(1633),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1615),
    [sym_number] = ACTIONS(1635),
    [sym_this] = ACTIONS(1637),
    [sym_true] = ACTIONS(1639),
    [sym_false] = ACTIONS(1639),
    [anon_sym_declare] = ACTIONS(1591),
    [anon_sym_static] = ACTIONS(1591),
    [anon_sym_readonly] = ACTIONS(1641),
    [anon_sym_get] = ACTIONS(1591),
    [anon_sym_set] = ACTIONS(1591),
    [anon_sym_public] = ACTIONS(1591),
    [anon_sym_private] = ACTIONS(1591),
    [anon_sym_protected] = ACTIONS(1591),
    [anon_sym_module] = ACTIONS(1591),
    [anon_sym_any] = ACTIONS(1643),
    [anon_sym_number] = ACTIONS(1643),
    [anon_sym_boolean] = ACTIONS(1643),
    [anon_sym_string] = ACTIONS(1643),
    [anon_sym_symbol] = ACTIONS(1643),
    [anon_sym_infer] = ACTIONS(601),
    [anon_sym_keyof] = ACTIONS(683),
    [anon_sym_LBRACE_PIPE] = ACTIONS(605),
  },
  [104] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(2042),
    [sym_expression] = STATE(2515),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5622),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5622),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5621),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(2042),
    [sym_subscript_expression] = STATE(2042),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3809),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5622),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2042),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_type_arguments] = STATE(817),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1645),
    [anon_sym_export] = ACTIONS(1087),
    [anon_sym_STAR] = ACTIONS(1647),
    [anon_sym_type] = ACTIONS(1087),
    [anon_sym_EQ] = ACTIONS(1347),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1089),
    [anon_sym_LBRACE] = ACTIONS(1649),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1113),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1651),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(1097),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1099),
    [anon_sym_LBRACK] = ACTIONS(1653),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1105),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1655),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1651),
    [anon_sym_DASH] = ACTIONS(1651),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1095),
    [anon_sym_void] = ACTIONS(1113),
    [anon_sym_delete] = ACTIONS(1113),
    [anon_sym_PLUS_PLUS] = ACTIONS(1115),
    [anon_sym_DASH_DASH] = ACTIONS(1115),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1087),
    [anon_sym_static] = ACTIONS(1087),
    [anon_sym_readonly] = ACTIONS(1087),
    [anon_sym_get] = ACTIONS(1087),
    [anon_sym_set] = ACTIONS(1087),
    [anon_sym_public] = ACTIONS(1087),
    [anon_sym_private] = ACTIONS(1087),
    [anon_sym_protected] = ACTIONS(1087),
    [anon_sym_module] = ACTIONS(1087),
    [anon_sym_any] = ACTIONS(1087),
    [anon_sym_number] = ACTIONS(1087),
    [anon_sym_boolean] = ACTIONS(1087),
    [anon_sym_string] = ACTIONS(1087),
    [anon_sym_symbol] = ACTIONS(1087),
    [anon_sym_extends] = ACTIONS(1347),
    [sym__automatic_semicolon] = ACTIONS(1353),
  },
  [105] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2062),
    [sym_expression] = STATE(2676),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5548),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5548),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5554),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2062),
    [sym_subscript_expression] = STATE(2062),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3806),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5548),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2186),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2062),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_type_arguments] = STATE(546),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1657),
    [anon_sym_export] = ACTIONS(1533),
    [anon_sym_STAR] = ACTIONS(1659),
    [anon_sym_type] = ACTIONS(1533),
    [anon_sym_EQ] = ACTIONS(1347),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1535),
    [anon_sym_LBRACE] = ACTIONS(1661),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1557),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1663),
    [anon_sym_LPAREN] = ACTIONS(1505),
    [anon_sym_RPAREN] = ACTIONS(1353),
    [anon_sym_await] = ACTIONS(1543),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_yield] = ACTIONS(1545),
    [anon_sym_LBRACK] = ACTIONS(1665),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1549),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1667),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1663),
    [anon_sym_DASH] = ACTIONS(1663),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1541),
    [anon_sym_void] = ACTIONS(1557),
    [anon_sym_delete] = ACTIONS(1557),
    [anon_sym_PLUS_PLUS] = ACTIONS(1559),
    [anon_sym_DASH_DASH] = ACTIONS(1559),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1511),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1533),
    [anon_sym_static] = ACTIONS(1533),
    [anon_sym_readonly] = ACTIONS(1533),
    [anon_sym_get] = ACTIONS(1533),
    [anon_sym_set] = ACTIONS(1533),
    [anon_sym_public] = ACTIONS(1533),
    [anon_sym_private] = ACTIONS(1533),
    [anon_sym_protected] = ACTIONS(1533),
    [anon_sym_module] = ACTIONS(1533),
    [anon_sym_any] = ACTIONS(1533),
    [anon_sym_number] = ACTIONS(1533),
    [anon_sym_boolean] = ACTIONS(1533),
    [anon_sym_string] = ACTIONS(1533),
    [anon_sym_symbol] = ACTIONS(1533),
    [anon_sym_extends] = ACTIONS(1347),
  },
  [106] = {
    [sym_import] = STATE(2751),
    [sym_parenthesized_expression] = STATE(1521),
    [sym_expression] = STATE(2529),
    [sym_primary_expression] = STATE(2752),
    [sym_yield_expression] = STATE(2753),
    [sym_object] = STATE(2751),
    [sym_object_pattern] = STATE(5448),
    [sym_array] = STATE(2751),
    [sym_array_pattern] = STATE(5448),
    [sym_class] = STATE(2751),
    [sym_function] = STATE(2751),
    [sym_generator_function] = STATE(2751),
    [sym_arrow_function] = STATE(2751),
    [sym__call_signature] = STATE(5443),
    [sym_call_expression] = STATE(2751),
    [sym_new_expression] = STATE(2753),
    [sym_await_expression] = STATE(2753),
    [sym_member_expression] = STATE(1521),
    [sym_subscript_expression] = STATE(1521),
    [sym_assignment_expression] = STATE(2753),
    [sym__augmented_assignment_lhs] = STATE(3804),
    [sym_augmented_assignment_expression] = STATE(2753),
    [sym__destructuring_pattern] = STATE(5448),
    [sym_ternary_expression] = STATE(2753),
    [sym_binary_expression] = STATE(2753),
    [sym_unary_expression] = STATE(2753),
    [sym_update_expression] = STATE(2753),
    [sym_string] = STATE(2751),
    [sym_template_string] = STATE(2751),
    [sym_regex] = STATE(2751),
    [sym_meta_property] = STATE(2751),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1521),
    [sym_type_assertion] = STATE(2753),
    [sym_as_expression] = STATE(2753),
    [sym_internal_module] = STATE(2753),
    [sym_type_arguments] = STATE(893),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4704),
    [sym_identifier] = ACTIONS(1669),
    [anon_sym_export] = ACTIONS(1169),
    [anon_sym_STAR] = ACTIONS(1671),
    [anon_sym_type] = ACTIONS(1169),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1569),
    [anon_sym_typeof] = ACTIONS(1193),
    [anon_sym_import] = ACTIONS(1037),
    [anon_sym_BANG] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(1573),
    [anon_sym_await] = ACTIONS(1179),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1181),
    [anon_sym_LBRACK] = ACTIONS(1575),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1049),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(1051),
    [anon_sym_async] = ACTIONS(1185),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1675),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1673),
    [anon_sym_DASH] = ACTIONS(1673),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1177),
    [anon_sym_void] = ACTIONS(1193),
    [anon_sym_delete] = ACTIONS(1193),
    [anon_sym_PLUS_PLUS] = ACTIONS(1195),
    [anon_sym_DASH_DASH] = ACTIONS(1195),
    [anon_sym_DQUOTE] = ACTIONS(1067),
    [anon_sym_SQUOTE] = ACTIONS(1069),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [sym_number] = ACTIONS(1579),
    [sym_this] = ACTIONS(1077),
    [sym_super] = ACTIONS(1077),
    [sym_true] = ACTIONS(1077),
    [sym_false] = ACTIONS(1077),
    [sym_null] = ACTIONS(1077),
    [sym_undefined] = ACTIONS(1077),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1169),
    [anon_sym_static] = ACTIONS(1169),
    [anon_sym_readonly] = ACTIONS(1169),
    [anon_sym_get] = ACTIONS(1169),
    [anon_sym_set] = ACTIONS(1169),
    [anon_sym_public] = ACTIONS(1169),
    [anon_sym_private] = ACTIONS(1169),
    [anon_sym_protected] = ACTIONS(1169),
    [anon_sym_module] = ACTIONS(1169),
    [anon_sym_any] = ACTIONS(1169),
    [anon_sym_number] = ACTIONS(1169),
    [anon_sym_boolean] = ACTIONS(1169),
    [anon_sym_string] = ACTIONS(1169),
    [anon_sym_symbol] = ACTIONS(1169),
    [anon_sym_extends] = ACTIONS(1347),
    [sym__automatic_semicolon] = ACTIONS(1353),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1353),
  },
  [107] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(1803),
    [sym_expression] = STATE(2670),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5751),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5751),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5752),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(1803),
    [sym_subscript_expression] = STATE(1803),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3802),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5751),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(1803),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_type_arguments] = STATE(610),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1677),
    [anon_sym_export] = ACTIONS(871),
    [anon_sym_STAR] = ACTIONS(1679),
    [anon_sym_type] = ACTIONS(871),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(873),
    [anon_sym_LBRACE] = ACTIONS(1351),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RBRACE] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(881),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_number] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(871),
    [anon_sym_static] = ACTIONS(871),
    [anon_sym_readonly] = ACTIONS(871),
    [anon_sym_get] = ACTIONS(871),
    [anon_sym_set] = ACTIONS(871),
    [anon_sym_public] = ACTIONS(871),
    [anon_sym_private] = ACTIONS(871),
    [anon_sym_protected] = ACTIONS(871),
    [anon_sym_module] = ACTIONS(871),
    [anon_sym_any] = ACTIONS(871),
    [anon_sym_number] = ACTIONS(871),
    [anon_sym_boolean] = ACTIONS(871),
    [anon_sym_string] = ACTIONS(871),
    [anon_sym_symbol] = ACTIONS(871),
    [sym__automatic_semicolon] = ACTIONS(1353),
  },
  [108] = {
    [sym_import] = STATE(3250),
    [sym_parenthesized_expression] = STATE(2036),
    [sym_expression] = STATE(2570),
    [sym_primary_expression] = STATE(3248),
    [sym_yield_expression] = STATE(3245),
    [sym_object] = STATE(3250),
    [sym_object_pattern] = STATE(5722),
    [sym_array] = STATE(3250),
    [sym_array_pattern] = STATE(5722),
    [sym_class] = STATE(3250),
    [sym_function] = STATE(3250),
    [sym_generator_function] = STATE(3250),
    [sym_arrow_function] = STATE(3250),
    [sym__call_signature] = STATE(5718),
    [sym_call_expression] = STATE(3250),
    [sym_new_expression] = STATE(3245),
    [sym_await_expression] = STATE(3245),
    [sym_member_expression] = STATE(2036),
    [sym_subscript_expression] = STATE(2036),
    [sym_assignment_expression] = STATE(3245),
    [sym__augmented_assignment_lhs] = STATE(3798),
    [sym_augmented_assignment_expression] = STATE(3245),
    [sym__destructuring_pattern] = STATE(5722),
    [sym_ternary_expression] = STATE(3245),
    [sym_binary_expression] = STATE(3245),
    [sym_unary_expression] = STATE(3245),
    [sym_update_expression] = STATE(3245),
    [sym_string] = STATE(3250),
    [sym_template_string] = STATE(3250),
    [sym_regex] = STATE(3250),
    [sym_meta_property] = STATE(3250),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2036),
    [sym_type_assertion] = STATE(3245),
    [sym_as_expression] = STATE(3245),
    [sym_internal_module] = STATE(3245),
    [sym_type_arguments] = STATE(760),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4719),
    [sym_identifier] = ACTIONS(1681),
    [anon_sym_export] = ACTIONS(959),
    [anon_sym_STAR] = ACTIONS(1683),
    [anon_sym_type] = ACTIONS(959),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(1685),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(985),
    [anon_sym_import] = ACTIONS(909),
    [anon_sym_BANG] = ACTIONS(1687),
    [anon_sym_LPAREN] = ACTIONS(1689),
    [anon_sym_await] = ACTIONS(969),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_yield] = ACTIONS(971),
    [anon_sym_LBRACK] = ACTIONS(1691),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(975),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(923),
    [anon_sym_async] = ACTIONS(977),
    [anon_sym_function] = ACTIONS(927),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1693),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1687),
    [anon_sym_DASH] = ACTIONS(1687),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(967),
    [anon_sym_void] = ACTIONS(985),
    [anon_sym_delete] = ACTIONS(985),
    [anon_sym_PLUS_PLUS] = ACTIONS(987),
    [anon_sym_DASH_DASH] = ACTIONS(987),
    [anon_sym_DQUOTE] = ACTIONS(939),
    [anon_sym_SQUOTE] = ACTIONS(941),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(943),
    [sym_number] = ACTIONS(1695),
    [sym_this] = ACTIONS(949),
    [sym_super] = ACTIONS(949),
    [sym_true] = ACTIONS(949),
    [sym_false] = ACTIONS(949),
    [sym_null] = ACTIONS(949),
    [sym_undefined] = ACTIONS(949),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(959),
    [anon_sym_static] = ACTIONS(959),
    [anon_sym_readonly] = ACTIONS(959),
    [anon_sym_get] = ACTIONS(959),
    [anon_sym_set] = ACTIONS(959),
    [anon_sym_public] = ACTIONS(959),
    [anon_sym_private] = ACTIONS(959),
    [anon_sym_protected] = ACTIONS(959),
    [anon_sym_module] = ACTIONS(959),
    [anon_sym_any] = ACTIONS(959),
    [anon_sym_number] = ACTIONS(959),
    [anon_sym_boolean] = ACTIONS(959),
    [anon_sym_string] = ACTIONS(959),
    [anon_sym_symbol] = ACTIONS(959),
    [anon_sym_extends] = ACTIONS(1347),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1353),
  },
  [109] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2069),
    [sym_expression] = STATE(2937),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5737),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5737),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5734),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2069),
    [sym_subscript_expression] = STATE(2069),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3815),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5737),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2186),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2069),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_type_arguments] = STATE(901),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1697),
    [anon_sym_export] = ACTIONS(1249),
    [anon_sym_STAR] = ACTIONS(1699),
    [anon_sym_type] = ACTIONS(1249),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1251),
    [anon_sym_LBRACE] = ACTIONS(1501),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1269),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1701),
    [anon_sym_LPAREN] = ACTIONS(1505),
    [anon_sym_await] = ACTIONS(1257),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_yield] = ACTIONS(1259),
    [anon_sym_LBRACK] = ACTIONS(1507),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(805),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1261),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_EQ_GT] = ACTIONS(1353),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1703),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1701),
    [anon_sym_DASH] = ACTIONS(1701),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1255),
    [anon_sym_void] = ACTIONS(1269),
    [anon_sym_delete] = ACTIONS(1269),
    [anon_sym_PLUS_PLUS] = ACTIONS(1271),
    [anon_sym_DASH_DASH] = ACTIONS(1271),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1511),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1249),
    [anon_sym_static] = ACTIONS(1249),
    [anon_sym_readonly] = ACTIONS(1249),
    [anon_sym_get] = ACTIONS(1249),
    [anon_sym_set] = ACTIONS(1249),
    [anon_sym_public] = ACTIONS(1249),
    [anon_sym_private] = ACTIONS(1249),
    [anon_sym_protected] = ACTIONS(1249),
    [anon_sym_module] = ACTIONS(1249),
    [anon_sym_any] = ACTIONS(1249),
    [anon_sym_number] = ACTIONS(1249),
    [anon_sym_boolean] = ACTIONS(1249),
    [anon_sym_string] = ACTIONS(1249),
    [anon_sym_symbol] = ACTIONS(1249),
    [anon_sym_extends] = ACTIONS(1347),
  },
  [110] = {
    [sym_import] = STATE(2186),
    [sym_parenthesized_expression] = STATE(2054),
    [sym_expression] = STATE(2733),
    [sym_primary_expression] = STATE(2210),
    [sym_yield_expression] = STATE(2213),
    [sym_object] = STATE(2186),
    [sym_object_pattern] = STATE(5574),
    [sym_array] = STATE(2186),
    [sym_array_pattern] = STATE(5574),
    [sym_class] = STATE(2186),
    [sym_function] = STATE(2186),
    [sym_generator_function] = STATE(2186),
    [sym_arrow_function] = STATE(2186),
    [sym__call_signature] = STATE(5432),
    [sym_call_expression] = STATE(2186),
    [sym_new_expression] = STATE(2213),
    [sym_await_expression] = STATE(2213),
    [sym_member_expression] = STATE(2054),
    [sym_subscript_expression] = STATE(2054),
    [sym_assignment_expression] = STATE(2213),
    [sym__augmented_assignment_lhs] = STATE(3797),
    [sym_augmented_assignment_expression] = STATE(2213),
    [sym__destructuring_pattern] = STATE(5574),
    [sym_ternary_expression] = STATE(2213),
    [sym_binary_expression] = STATE(2213),
    [sym_unary_expression] = STATE(2213),
    [sym_update_expression] = STATE(2213),
    [sym_string] = STATE(2186),
    [sym_template_string] = STATE(2186),
    [sym_regex] = STATE(2186),
    [sym_meta_property] = STATE(2186),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2054),
    [sym_type_assertion] = STATE(2213),
    [sym_as_expression] = STATE(2213),
    [sym_internal_module] = STATE(2213),
    [sym_type_arguments] = STATE(696),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4786),
    [sym_identifier] = ACTIONS(1705),
    [anon_sym_export] = ACTIONS(1311),
    [anon_sym_STAR] = ACTIONS(1707),
    [anon_sym_type] = ACTIONS(1311),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1313),
    [anon_sym_LBRACE] = ACTIONS(1501),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_typeof] = ACTIONS(1333),
    [anon_sym_import] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(1709),
    [anon_sym_LPAREN] = ACTIONS(1505),
    [anon_sym_await] = ACTIONS(1319),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_yield] = ACTIONS(1321),
    [anon_sym_LBRACK] = ACTIONS(1507),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1323),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(1325),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1711),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1709),
    [anon_sym_DASH] = ACTIONS(1709),
    [anon_sym_PERCENT] = ACTIONS(1353),
    [anon_sym_STAR_STAR] = ACTIONS(1353),
    [anon_sym_LT_EQ] = ACTIONS(1353),
    [anon_sym_EQ_EQ] = ACTIONS(1347),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1353),
    [anon_sym_BANG_EQ] = ACTIONS(1347),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1353),
    [anon_sym_GT_EQ] = ACTIONS(1353),
    [anon_sym_QMARK_QMARK] = ACTIONS(1353),
    [anon_sym_instanceof] = ACTIONS(1347),
    [anon_sym_TILDE] = ACTIONS(1317),
    [anon_sym_void] = ACTIONS(1333),
    [anon_sym_delete] = ACTIONS(1333),
    [anon_sym_PLUS_PLUS] = ACTIONS(1335),
    [anon_sym_DASH_DASH] = ACTIONS(1335),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_SQUOTE] = ACTIONS(585),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(587),
    [sym_number] = ACTIONS(1511),
    [sym_this] = ACTIONS(593),
    [sym_super] = ACTIONS(593),
    [sym_true] = ACTIONS(593),
    [sym_false] = ACTIONS(593),
    [sym_null] = ACTIONS(593),
    [sym_undefined] = ACTIONS(593),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_declare] = ACTIONS(1311),
    [anon_sym_static] = ACTIONS(1311),
    [anon_sym_readonly] = ACTIONS(1311),
    [anon_sym_get] = ACTIONS(1311),
    [anon_sym_set] = ACTIONS(1311),
    [anon_sym_public] = ACTIONS(1311),
    [anon_sym_private] = ACTIONS(1311),
    [anon_sym_protected] = ACTIONS(1311),
    [anon_sym_module] = ACTIONS(1311),
    [anon_sym_any] = ACTIONS(1311),
    [anon_sym_number] = ACTIONS(1311),
    [anon_sym_boolean] = ACTIONS(1311),
    [anon_sym_string] = ACTIONS(1311),
    [anon_sym_symbol] = ACTIONS(1311),
    [anon_sym_implements] = ACTIONS(1347),
    [anon_sym_extends] = ACTIONS(1347),
  },
  [111] = {
    [sym_import] = STATE(2381),
    [sym_parenthesized_expression] = STATE(2045),
    [sym_expression] = STATE(2983),
    [sym_primary_expression] = STATE(2387),
    [sym_yield_expression] = STATE(2392),
    [sym_object] = STATE(2381),
    [sym_object_pattern] = STATE(5502),
    [sym_array] = STATE(2381),
    [sym_array_pattern] = STATE(5502),
    [sym_class] = STATE(2381),
    [sym_function] = STATE(2381),
    [sym_generator_function] = STATE(2381),
    [sym_arrow_function] = STATE(2381),
    [sym__call_signature] = STATE(5500),
    [sym_call_expression] = STATE(2381),
    [sym_new_expression] = STATE(2392),
    [sym_await_expression] = STATE(2392),
    [sym_member_expression] = STATE(2045),
    [sym_subscript_expression] = STATE(2045),
    [sym_assignment_expression] = STATE(2392),
    [sym__augmented_assignment_lhs] = STATE(3816),
    [sym_augmented_assignment_expression] = STATE(2392),
    [sym__destructuring_pattern] = STATE(5502),
    [sym_ternary_expression] = STATE(2392),
    [sym_binary_expression] = STATE(2392),
    [sym_unary_expression] = STATE(2392),
    [sym_update_expression] = STATE(2392),
    [sym_string] = STATE(2381),
    [sym_template_string] = STATE(2381),
    [sym_regex] = STATE(2381),
    [sym_meta_property] = STATE(2381),
    [sym_decorator] = STATE(3775),
    [sym_formal_parameters] = STATE(4587),
    [sym_non_null_expression] = STATE(2045),
    [sym_type_assertion] = STATE(2392),
    [sym_as_expression] = STATE(2392),
    [sym_internal_module] = STATE(2392),
    [sym_type_arguments] = STATE(501),
    [sym_type_parameters] = STATE(5162),
    [aux_sym_export_statement_repeat1] = STATE(4742),
    [sym_identifier] = ACTIONS(1713),
    [anon_sym_export] = ACTIONS(1209),
    [anon_sym_STAR] = ACTIONS(1715),
    [anon_sym_type] = ACTIONS(1209),
    [anon_sym_as] = ACTIONS(1347),
    [anon_sym_namespace] = ACTIONS(1211),
    [anon_sym_LBRACE] = ACTIONS(1351),
    [anon_sym_typeof] = ACTIONS(1233),
    [anon_sym_import] = ACTIONS(741),
    [anon_sym_BANG] = ACTIONS(1717),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(1219),
    [anon_sym_in] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_yield] = ACTIONS(1221),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1347),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(1347),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_async] = ACTIONS(1225),
    [anon_sym_function] = ACTIONS(757),
    [anon_sym_QMARK_DOT] = ACTIONS(1353),
    [anon_sym_new] = ACTIONS(1719),
    [anon_sym_QMARK] = ACTIONS(1347),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_GT_GT] = ACTIONS(1347),
    [anon_sym_GT_GT_GT] = ACTIONS(1353),
    [anon_sym_LT_LT] = ACTIONS(1353),
    [anon_sym_AMP] = ACTIONS(1347),
    [anon_sym_CARET] = ACTIONS(1353),
    [anon_sym_PIPE] = ACTIONS(1347),
    [anon_sym_PLUS] = ACTIONS(1717),
    [anon_sym_DASH] = ACTIONS(1717),
    [anon_sym_PERCENT] = ACTIONS