use once_cell::sync::Lazy;
use tree_sitter::Language;

pub static BASH: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_bash() });
pub static C: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_c() });
pub static CPP: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_cpp() });
pub static CSS: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_css() });
pub static HTML: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_html() });
pub static JAVASCRIPT: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_javascript() });
pub static JSON: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_json() });
pub static MARKDOWN: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_markdown() });
pub static PYTHON: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_python() });
pub static RUST: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_rust() });
pub static TYPESCRIPT: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_typescript() });
pub static TSX: Lazy<Language> = Lazy::new(|| unsafe { tree_sitter_tsx() });

#[link(name = "tree-sitter-bash-parser")]
extern "C" {
    fn tree_sitter_bash() -> Language;
}
#[link(name = "tree-sitter-c")]
extern "C" {
    fn tree_sitter_c() -> Language;
}
#[link(name = "tree-sitter-cpp-parser")]
extern "C" {
    fn tree_sitter_cpp() -> Language;
}
#[link(name = "tree-sitter-css")]
extern "C" {
    fn tree_sitter_css() -> Language;
}
#[link(name = "tree-sitter-html-parser")]
extern "C" {
    fn tree_sitter_html() -> Language;
}
#[link(name = "tree-sitter-javascript")]
extern "C" {
    fn tree_sitter_javascript() -> Language;
}
#[link(name = "tree-sitter-json")]
extern "C" {
    fn tree_sitter_json() -> Language;
}
#[link(name = "tree-sitter-markdown-parser")]
extern "C" {
    fn tree_sitter_markdown() -> Language;
}
#[link(name = "tree-sitter-python-parser")]
extern "C" {
    fn tree_sitter_python() -> Language;
}
#[link(name = "tree-sitter-rust")]
extern "C" {
    fn tree_sitter_rust() -> Language;
}
#[link(name = "tree-sitter-typescript")]
extern "C" {
    fn tree_sitter_typescript() -> Language;
}
#[link(name = "tree-sitter-tsx")]
extern "C" {
    fn tree_sitter_tsx() -> Language;
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn instantiate_all_languages() {
        assert!(BASH.node_kind_count() > 0);
        assert!(C.node_kind_count() > 0);
        assert!(CPP.node_kind_count() > 0);
        assert!(CSS.node_kind_count() > 0);
        assert!(HTML.node_kind_count() > 0);
        assert!(JAVASCRIPT.node_kind_count() > 0);
        assert!(JSON.node_kind_count() > 0);
        assert!(MARKDOWN.node_kind_count() > 0);
        assert!(PYTHON.node_kind_count() > 0);
        assert!(RUST.node_kind_count() > 0);
        assert!(TYPESCRIPT.node_kind_count() > 0);
        assert!(TSX.node_kind_count() > 0);
    }
}
