use crate::zfs_mount;
use crate::yubi;
use std::{io::Read, process::exit};
use std::env;
use std::fs;
use sha2::{Sha512, Digest};

pub fn pam_mode_yubi(base_dir: &String) {
  
    let user = env::var("PAM_USER").expect("Var not found"); // Get username from environment
    let stdin = std::io::stdin();
    let mut pass = String::new();
    stdin.read_line(&mut pass).unwrap(); // Get password from stdin(pam_exec.so)
    let key = yubi::get_hash(&pass);
    let key = match key {
        Ok(key) => key,
        Err(error) => panic!("{}", error),
    };
    zfs_mount::zfs_pam_mount(&key, base_dir.to_owned(), &user); // Unlock and mount ZFS Dataset

    exit(0);
}

pub fn pam_mode_file(base_dir: &String, file: &String) {
  
    let user = env::var("PAM_USER").expect("User Var not found"); // Get username from environment
    let stdin = std::io::stdin();
    let mut passhash = String::new();
    stdin.read_line(&mut passhash).unwrap();
    passhash.push_str("zauthrs");
    let passhash = Sha512::digest(&passhash.as_bytes());

    let mut f = fs::File::open(&file).expect("Failed to open file");
    let mut file_hash :Vec<u8>= Vec::new();
    f.read_to_end(&mut file_hash).expect("Failed reading Keyfile");
    let file_hash = Sha512::digest(&file_hash);

    let key = [file_hash,passhash].concat();
    let key = Sha512::digest(&key);

    zfs_mount::zfs_pam_mount(&format!("{:x}", &key), base_dir.clone(), &user); // Unlock and mount ZFS Dataset

    exit(0);
}