use std::io::prelude::*;
use std::process::Command;

pub fn zfs_pam_mount(key: &String, root: String, user: &String) {
    let mut dir = root.to_owned();

    if !dir.ends_with("/") {
        dir.push('/');
    }
    dir.push_str(&user); // Prepare home root zzfs directory

    let mut zfs = Command::new("zfs") // Call zfs mount
        .arg("load-key")
        .arg("-L")
        .arg("prompt")
        .arg(&dir)
        .stdin(std::process::Stdio::piped())
        .spawn()
        .expect("Failed zfs load-key");

    zfs.stdin // Supply encryption key via stdin
        .as_mut()
        .expect("failed to get zfs stdin")
        .write_all(&key.as_bytes())
        .expect("Faile to write to stdin");

    zfs.wait().unwrap();

    let zfs_list = Command::new("zfs")
        .arg("list")
        .arg("-H")
        .arg("-o")
        .arg("name")
        .arg("-r")
        .arg(&dir)
        .output()
        .expect("Failed to run list command");

    let out = String::from_utf8(zfs_list.stdout).expect("Failed to parse list output");

    let list: Vec<&str> = out.split("\n").collect();

    for i in list.iter() {
        let mut zfs_mount = Command::new("zfs")
            .arg("mount")
            .arg(&i)
            .spawn()
            .expect("Failed zfs mount");
        zfs_mount.wait().expect("Failed ZFS mount");
    }
}

pub fn zfs_mount(key: String, dataset: String) {
    let mut zfs = Command::new("zfs") // Call zfs mount
        .arg("load-key")
        .arg("-L")
        .arg("prompt")
        .arg(&dataset)
        .stdin(std::process::Stdio::piped())
        .spawn()
        .expect("Failed zfs load-key");

    zfs.stdin // Supply encryption key via stdin
        .as_mut()
        .expect("failed to get zfs stdin")
        .write_all(&key.as_bytes())
        .expect("Faile to write to stdin");

    zfs.wait().unwrap();

    let zfs_list = Command::new("zfs")
        .arg("list")
        .arg("-H")
        .arg("-o")
        .arg("name")
        .arg("-r")
        .arg(&dataset)
        .output()
        .expect("Failed to run list command");

    let out = String::from_utf8(zfs_list.stdout).expect("Failed to parse list output");

    let list: Vec<&str> = out.split("\n").collect();

    for i in list.iter() {
        let mut zfs_mount = Command::new("zfs")
            .arg("mount")
            .arg(&i)
            .spawn()
            .expect("Failed zfs mount");
        zfs_mount.wait().expect("Failed ZFS mount");
    }
}
