use crate::span::Span;
use std::fmt;

#[derive(Clone, Debug)]
pub(crate) struct ParseError {
    pub(crate) span: Span,
    pub(crate) message: String,
}

impl fmt::Display for ParseError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.message)
    }
}
