//! 🐢⚡ This crate is the core of Zap. It contains all the
//! fundamental rendering primitives.
//!
//! Internally it depends on [`zaplib_shader_compiler`] and [`zaplib_vector`],
//! for shader compilation and vector graphics (mostly for fonts) respectively.
//!
//! If you need to use higher-level widgets, use `zaplib_widget`.

// Necessary in cx_xlib
#![allow(temporary_cstring_as_ptr)]
// Not great but we do these comparisons all over the place..
#![allow(clippy::float_cmp)]
// We want to use links to private fields, since we use `--document-private-items`.
#![allow(rustdoc::private_intra_doc_links)]

#[macro_use]
mod macros;

mod cx;

#[cfg(all(not(feature = "ipc"), any(target_os = "linux")))]
mod cx_linux;
#[cfg(all(not(feature = "ipc"), target_os = "linux"))]
mod cx_opengl;
#[cfg(all(not(feature = "ipc"), target_os = "linux"))]
mod cx_xlib;

#[cfg(all(not(feature = "ipc"), any(target_os = "macos")))]
mod cx_apple;
#[cfg(all(not(feature = "ipc"), target_os = "macos"))]
mod cx_cocoa;
#[cfg(all(not(feature = "ipc"), any(target_os = "macos")))]
mod cx_macos;
#[cfg(all(not(feature = "ipc"), target_os = "macos"))]
mod cx_metal;

#[cfg(all(not(feature = "ipc"), target_os = "windows"))]
mod cx_dx11;
#[cfg(all(not(feature = "ipc"), target_os = "windows"))]
mod cx_win32;
#[cfg(all(not(feature = "ipc"), any(target_os = "windows")))]
mod cx_windows;

#[cfg(all(not(feature = "ipc"), target_arch = "wasm32"))]
mod cx_wasm32;
#[cfg(all(not(feature = "ipc"), target_arch = "wasm32"))]
mod cx_webgl;

#[cfg(all(not(feature = "ipc"), any(target_os = "linux", target_os = "macos", target_os = "windows")))]
mod cx_desktop;

mod cx_app_load;

mod animator;
mod area;
mod cursor;
mod draw_input_type;
mod draw_tree;
mod elements;
mod events;
mod fonts;
mod geometry;
mod hash;
mod pass;
mod profile;
mod read_seek;
mod shader;
mod texture;
mod turtle;
mod universal_instant;
pub mod universal_thread;
mod window;

mod drawcolor;
mod drawcube;
mod drawimage;
mod drawquad;
mod drawtext;
mod menu;
mod std_shader;

pub use crate::cx::*;
pub use crate::drawcolor::*;
pub use crate::drawcube::*;
pub use crate::drawimage::*;
pub use crate::drawquad::*;
pub use crate::drawtext::*;
pub use crate::elements::*;
pub use crate::std_shader::*;
