(function () {
    self.importScripts(new URL("cx_webgl_Rpc.js", location.href).href);

    const rpc = new Rpc(self);

    rpc.receive("run", ({ wasmPath, memory, ctx_ptr }) => {
        // TODO(Paras): Env functions copied from cx_webgl_worker but should probably get shared.
        function _console_log(chars_ptr, len) {
            let out = "";
            let array = new Uint32Array(memory.buffer, chars_ptr, len);
            for (let i = 0; i < len; i++) {
                out += String.fromCharCode(array[i]);
            }
            console.log(out);
        }
        const thread_spawn = (ctx_ptr) => {
            const worker = new Worker(self.location);
            const workerRpc = new Rpc(worker);
            workerRpc.send("run", { wasmPath, memory, ctx_ptr });
        };
        const env = { _console_log, memory, read_user_file_range: () => { }, thread_spawn };

        return new Promise((resolve, reject) => {
            WebAssembly.instantiateStreaming(fetch(wasmPath), { env }).then(results => {
                // TODO(Paras): Eventually call `process_to_wasm` instead of a custom exported function.
                results.instance.exports.run_function_pointer(ctx_ptr);
                resolve();
            }, reject);
        });
    });
})();


