use anyhow::Result;
use async_trait::async_trait;
use nipper::Document;
use regex::RegexSet;
use url::Url;

use crate::{Extractor, HttpClient, Info};

pub struct HentaiFoundry;

#[async_trait]
impl Extractor for HentaiFoundry {
    fn url_tester(&self) -> RegexSet {
        RegexSet::empty()
    }

    async fn get_info(&self, http_client: &HttpClient, url: &str) -> Result<Info> {
        let mut url: Url = url.parse()?;
        url.set_query(Some("enterAgree=1"));

        let resp = http_client.get(url).send().await?.text().await?;
        let document = Document::from(&resp);
        let img = document.select("img.center").attr("src").unwrap();
        let img: Url = img.replacen("//", "https://", 1).parse()?;

        Ok(Info::Image {
            url: img,
            width: None,
            height: None,
        })
    }
}
