use anyhow::Result;
use clap::{crate_version, App, Arg};
use std::env::current_dir;
use yuyu_core::client::ClientBuilder;

#[tokio::main]
async fn main() -> Result<()> {
    let matches = App::new("yuyu")
        .version(crate_version!())
        .about("Download anything from anywhere")
        .arg(Arg::with_name("url").required(true))
        .arg(Arg::with_name("output").short("o").takes_value(true))
        .get_matches();

    // Unwrapping here is very stupid
    let url = matches.value_of("url").unwrap();
    let path = if let Some(m) = matches.value_of("output") {
        m.parse()?
    } else {
        current_dir()?
    };

    let client = ClientBuilder::new().build()?;
    client.download(&path, url).await?;

    Ok(())
}
