use serde::de::DeserializeOwned;
use ureq::{SerdeValue, Response, Error, Agent};
use crate::structs::oanda_order::OandaOrder;

pub trait HttpOandaPost {
    fn post_with_resp<T>(agent:Agent, url:&str, body:SerdeValue) -> Result<Response, Error>
    where T:DeserializeOwned{
        let resp = agent
            .post(url)
            .send_json(body);
        resp
    }
}

impl HttpOandaPost for OandaOrder {}
