use serde::de::DeserializeOwned;
use ureq::{SerdeValue, Response, Error, Agent};
use crate::structs::oanda_instrument::OandaInstrument;
use crate::structs::oanda_trade::OandaTrade;

pub trait HttpOandaGet {
    fn call<T>(agent:Agent,url:&str) -> Result<Response, Error>
        where T:DeserializeOwned{
        let resp = agent
            .get(url)
            .call();
        resp
    }
}

impl HttpOandaGet for OandaInstrument {}
impl HttpOandaGet for OandaTrade {}

