use chrono::{DateTime, Utc};
use crate::traits::http_oanda_get::HttpOandaGet;
use ureq::{Response, Error, Agent};

#[derive(Serialize, Deserialize, Debug )]
pub struct OandaTrade {
    pub trades:Vec<OandaTradeDetail>,
}

#[derive(Serialize, Deserialize, Debug )]
pub struct OandaTradeDetail {
    #[serde(rename(serialize = "openTime", deserialize = "openTime"))]
    pub open_time: DateTime<Utc>,
}

impl OandaTrade {
    pub fn get_trades(agent:Agent,account:&str) -> Result<Response,Error>{
        let url = format!("https://api-fxtrade.oanda.com/v3/accounts/{}/trades",account);
        Self::call::<OandaTrade>(agent,url.as_ref())
    }
}
