use ureq::{Response, Error, Agent};
use crate::traits::http_oanda_post::HttpOandaPost;

#[derive(Serialize, Deserialize, Debug, Clone )]
pub struct OandaOrder {
    pub order: OandaOrderDetail,
}

#[derive(Serialize, Deserialize, Debug, Clone )]
pub struct OandaOrderDetailTakeProfitStopLoss {
    pub price: String,
}

#[derive(Serialize, Deserialize, Debug, Clone )]
pub struct OandaOrderDetail {
    #[serde(rename(serialize = "type", deserialize = "type"))]
    pub order_type: String,
    pub instrument: String,
    pub units: f64,
    #[serde(rename(serialize = "takeProfitOnFill", deserialize = "takeProfitOnFill"))]
    pub tp: OandaOrderDetailTakeProfitStopLoss,
    #[serde(rename(serialize = "stopLossOnFill", deserialize = "stopLossOnFill"))]
    pub sl: OandaOrderDetailTakeProfitStopLoss,
}

#[derive(Serialize, Deserialize, Debug )]
pub struct OandaResponseBasic {
    #[serde(rename(serialize = "lastTransactionID", deserialize = "lastTransactionID"))]
    pub last_transaction_id: String,
}

impl OandaOrder {
    pub fn order(agent:Agent,account:&str, order_detail:OandaOrderDetail)-> Result<Response,Error>{
        let url = format!(
            "https://api-fxtrade.oanda.com/v3/accounts/{}/orders",account);
        let request_map = serde_json::to_value(order_detail).expect("could convert to hashmap");
        println!("{:?}",request_map);
        let resp =
            Self::post_with_resp::<OandaResponseBasic>(agent,url.as_str(), request_map);
        resp
    }
}
