use serde::{Deserialize, Serialize, de::DeserializeOwned};
use crate::structs::oanda_candle::OandaCandle;
use ureq::{Agent, Response, Error};
use crate::traits::http_oanda_get::HttpOandaGet;

#[derive(Serialize, Deserialize, Debug )]
pub struct OandaInstrument {
    pub instrument:String,
    pub candles:Vec<OandaCandle>
}

impl OandaInstrument {
    pub fn get_latest(agent:Agent, instrument:&str)-> Result<Response,Error>{
        let url = format!(
            "https://api-fxtrade.oanda.com/v3/instruments/{}/candles?alignmentTimezone=UTC&count=1&smooth=false&price=BAM",instrument);
        Self::call::<OandaInstrument>(agent,url.as_ref())
    }
}
