use serde::{Deserialize, Serialize, de::DeserializeOwned};

#[derive(Serialize, Deserialize, Debug, Clone, Default )]
pub struct OandaCandlePrice {
    pub o:String,
    pub h:String,
    pub l:String,
    pub c:String,
}

impl OandaCandlePrice {
    pub fn o_num(&self)->f64{
        self.o.parse::<f64>().unwrap()
    }
    pub fn h_num(&self)->f64{
        self.h.parse::<f64>().unwrap()
    }
    pub fn l_num(&self)->f64{
        self.l.parse::<f64>().unwrap()
    }
    pub fn c_num(&self)->f64{
        self.c.parse::<f64>().unwrap()
    }
    pub fn tp_price(&self,pips:f64)->f64{
        self.o_num()+pips
    }
    pub fn sl_price(&self,pips:f64)->f64{
        self.c_num()-pips
    }
}
