use serde::{Deserialize, Serialize, de::DeserializeOwned};
use crate::structs::oanda_candle_price::OandaCandlePrice;


#[derive(Serialize, Deserialize, Debug, Clone )]
pub struct OandaCandle {
    pub complete:bool,
    pub bid: OandaCandlePrice,
    pub mid: OandaCandlePrice,
    pub ask: OandaCandlePrice,
}

impl OandaCandle {
    pub fn get_buy_price(self) -> OandaCandlePrice{
        self.bid
    }
    pub fn get_sell_price(self) -> OandaCandlePrice{
        self.ask
    }
}
