use clap::{App, AppSettings};
mod assets_copier;
mod data_extractor;
mod file_content_loader;
mod folder_copier;
mod html_compiler;
mod initializer;
mod index_compiler;
mod pages_compiler;
mod sanitizer;
mod settings_serializer;
mod template_filler;
mod template_finder;
mod template_initializer;
mod video_serializer;

fn main() {
    let matches = App::new("Yoctolio")
        .version("0.3.0")
        .author("Florian Girardo <florian@barbrousse.net>")
        .about("Static video portfolio generator")
        .setting(AppSettings::SubcommandRequiredElseHelp)
        .subcommand(
            App::new("init")
                .about("Initialize a portfolio")
        )
        .subcommand(
            App::new("build")
                .about("Compile an existing portfolio into a usable website")
        )
        .get_matches();

      match matches.subcommand() {
          Some(("init", _sub_matches)) => {
              match initializer::call() {
                  Err(_e) => println!("An error occured when creating folder, the initilization was stopped") ,
                  _ => ()
              }
          }
          Some(("build", _sub_matches)) => {
              assets_copier::call();
              index_compiler::call();
              pages_compiler::call();
          }
           _ => unreachable!(),
      }
}
