use std::fs;

pub fn call() -> Result<(), std::io::Error> {
    match create_directories() {
        Err(e) => return Err(e),
        _ => copy_all_files()
    }
}

fn create_directories() -> Result<(), std::io::Error> {
    let directories = vec!["config", "templates", "templates/assets", "templates/assets/css", "templates/pages", "templates/partials"];
    for directory in directories {
        println!("create: {:?}", &directory);
        let directory_copy = fs::create_dir_all(directory);
        match directory_copy {
            Err(e) => return Err(e),
            _ => ()
        }
    }
    Ok(())
}

fn copy_all_files() -> Result<(), std::io::Error> {
    println!("create: config files");
    let config = include_str!("init/config/config.txt");
    fs::write("config/config.txt", config)?;
    let clips = include_str!("init/config/clips.txt");
    fs::write("config/clips.txt", clips)?;
    let tags = include_str!("init/config/tags.txt");
    fs::write("config/tags.txt", tags)?;
    println!("create: template files");
    let piddly = include_str!("init/templates/assets/css/piddly.css");
    fs::write("templates/assets/css/piddly.css", piddly)?;
    let style = include_str!("init/templates/assets/css/style.css");
    fs::write("templates/assets/css/style.css", style)?;
    let category_section = include_str!("init/templates/category_section.html");
    fs::write("templates/category_section.html", category_section)?;
    let description = include_str!("init/templates/description.html");
    fs::write("templates/description.html", description)?;
    let index = include_str!("init/templates/index.html");
    fs::write("templates/index.html", index)?;
    let menu_item = include_str!("init/templates/menu_item.html");
    fs::write("templates/menu_item.html", menu_item)?;
    let menu = include_str!("init/templates/menu.html");
    fs::write("templates/menu.html", menu)?;
    let tag = include_str!("init/templates/tag.html");
    fs::write("templates/tag.html", tag)?;
    let vimeo_video = include_str!("init/templates/vimeo_video.html");
    fs::write("templates/vimeo_video.html", vimeo_video)?;
    let year_section = include_str!("init/templates/year_section.html");
    fs::write("templates/year_section.html", year_section)?;
    let youtube_video = include_str!("init/templates/youtube_video.html");
    fs::write("templates/youtube_video.html", youtube_video)?;
    let about = include_str!("init/templates/pages/about.html");
    fs::write("templates/pages/about.html", about)?;
    let head = include_str!("init/templates/partials/head.html");
    fs::write("templates/partials/head.html", head)?;
    let header = include_str!("init/templates/partials/header.html");
    fs::write("templates/partials/header.html", header)?;
    let navigation = include_str!("init/templates/partials/navigation.html");
    fs::write("templates/partials/navigation.html", navigation)?;
    Ok(())
}
