use super::*;
use crate::records::CSTNode;
use lsp_document::TextAdapter;

pub use lsp_types::{Position as LSPPosition, Range as LSPRange};

impl TextIndex {
    #[inline]
    pub fn get_lsp_range(&self, start: usize, end: usize) -> LSPRange {
        let range = self.inner.offset_range_to_range(Range { start, end });
        match range.and_then(|f| self.inner.range_to_lsp_range(&f)) {
            Some(s) => s,
            None => LSPRange { start: self.get_lsp_position(start), end: self.get_lsp_position(end) },
        }
    }
    #[inline]
    pub fn get_lsp_position(&self, offset: usize) -> LSPPosition {
        let p = self.inner.offset_to_pos(offset.min(self.inner.text().len()));
        match p.and_then(|f| self.inner.pos_to_lsp_pos(&f)) {
            Some(s) => s,
            None => LSPPosition { line: self.lines as u32 + 1, character: 0 },
        }
    }
}

impl<R> CSTNode<R> {
    #[inline]
    pub fn get_lsp_range(&self, text: &TextIndex) -> LSPRange {
        text.get_lsp_range(self.range.start, self.range.end)
    }
    #[inline]
    pub fn get_lsp_start(&self, lines: &TextIndex) -> LSPPosition {
        lines.get_lsp_position(self.range.start)
    }
    #[inline]
    pub fn get_lsp_end(&self, lines: &TextIndex) -> LSPPosition {
        lines.get_lsp_position(self.range.end)
    }
}
