# Changelog

## 16.1.1

### Patch Changes

- [#681](https://github.com/primer/octicons/pull/681) [`c394d9a`](https://github.com/primer/octicons/commit/c394d9a556666beed4912797fb78f34190796511) Thanks [@jonrohan](https://github.com/jonrohan)! - Adding changesets workflow to octicons for releasing.

* [#684](https://github.com/primer/octicons/pull/684) [`9ed6154`](https://github.com/primer/octicons/commit/9ed615464cc405d9264cb933d4fe5f05ff14a219) Thanks [@ashygee](https://github.com/ashygee)! - Add 12px usage guidelines

- [#677](https://github.com/primer/octicons/pull/677) [`777f229`](https://github.com/primer/octicons/commit/777f2290b4662f2d769096ac3c121e61e92a0ff2) Thanks [@benkoshy](https://github.com/benkoshy)! - update: installation instructions

## 16.1.0

### 🚀 New features

- Added first set of 12px filled icons https://github.com/primer/octicons/pull/676

### 🐛 Bug fix

- Adjusted 'no-entry' size to match other circle icons https://github.com/primer/octicons/pull/673

## 16.0.0

### 💥 Breaking changes

- Rename 16px `select-single` icon to `single-select` https://github.com/primer/octicons/pull/665

### 🚀 New features

- `iterations` https://github.com/primer/octicons/pull/667

### 🧽 Chores

- Bump dependencies

## 15.2.0

### 🚀 New features

- Add `stack` icons https://github.com/primer/octicons/pull/659
- Add `person-fill` and `telescope-fill` icons https://github.com/primer/octicons/pull/660

## 15.1.0

### 🚀 New features

- `bell-fill-16` https://github.com/primer/octicons/pull/657

## 15.0.1

### 🐛 Bug fix

- Modify `duplicate` icon to differentiate from `copy` https://github.com/primer/octicons/pull/647

## 15.0.0

### 💥 Breaking changes

- Rename `duplicate` icon to `copy` https://github.com/primer/octicons/pull/643
- Rename `clippy` icon to `paste` https://github.com/primer/octicons/pull/643

## 14.2.2

### 🐛 Bug fix

- Update `issue-reopened` https://github.com/primer/octicons/pull/633

## 14.2.1

### 🐛 Bug fix

- fix vectors for 24px sort icons https://github.com/primer/octicons/pull/627 (🙏 @metonym)

## 14.2.0

### 🚀 New features

- `key-asterisk-16` https://github.com/primer/octicons/pull/623
- `sort-asc` https://github.com/primer/octicons/pull/619
- `sort-desc` https://github.com/primer/octicons/pull/619

### 🧽 Chores

- Remove unused dependency on nokogiri https://github.com/primer/octicons/pull/609 (🙏 @cschlack)

## 14.1.0

### 🚀 New features

- `git-pull-request-draft` https://github.com/primer/octicons/pull/613
- `git-pull-request-closed` https://github.com/primer/octicons/pull/613

## 14.0.0

### 💥 Breaking changes

- Remove `octoface` https://github.com/primer/octicons/pull/611
- Rename `git-fork-24` to `repo-forked-24` https://github.com/primer/octicons/pull/593

### 🚀 New features

- `number` https://github.com/primer/octicons/pull/592
- `hash` (previously `number`) https://github.com/primer/octicons/pull/592
- `diamond` https://github.com/primer/octicons/pull/616
- `single-select` https://github.com/primer/octicons/pull/612
- `rows` https://github.com/primer/octicons/pull/617
- `columns` https://github.com/primer/octicons/pull/617
- `issue-draft` https://github.com/primer/octicons/pull/614

### 💅 Enhancements

- `issue-opened` https://github.com/primer/octicons/pull/614
- `issue-closed` https://github.com/primer/octicons/pull/614

### 🐛 Fixes

- Fix 24px `arrow-up` icon https://github.com/primer/octicons/pull/594
- Prevent clipping using `overflow: visible` https://github.com/primer/octicons/pull/607

## 13.0.0

### 🚀 New features

- `table` https://github.com/primer/octicons/pull/564
- `person-add` https://github.com/primer/octicons/pull/573
- `blocked` https://github.com/primer/octicons/pull/576
- `duplicate` https://github.com/primer/octicons/pull/576
- `dependabot`https://github.com/primer/octicons/pull/585
- `codescan` https://github.com/primer/octicons/pull/588
- `browser` https://github.com/primer/octicons/pull/575
- `sidebar` icons https://github.com/primer/octicons/pull/569
- `codespaces` https://github.com/primer/octicons/pull/587

### 💥 Breaking changes

- Remove 24px `insights` icon https://github.com/primer/octicons/pull/574
- Remove 24px `copy` icon https://github.com/primer/octicons/pull/586

### 💅 Enhancements

- Use more explicit dependencies for Rails helper https://github.com/primer/octicons/pull/565

### 🐛 Fixes

- Fix `megaphone-16` https://github.com/primer/octicons/pull/554
- Fix `circle` icon https://github.com/primer/octicons/pull/584

## 12.1.0

### React

### 💅 Enhancements

- Add icon-specific class names to each icon component https://github.com/primer/octicons/pull/453 @FloEdelmann
- Add `fill` prop to each icon component https://github.com/primer/octicons/pull/551 @macno

## 12.0.0

### 🚀 New features

- `bug` (https://github.com/primer/octicons/pull/543)
- `multi-select` (https://github.com/primer/octicons/pull/534)

### 💅 Enhancements

- Make octicon helper slightly faster (@jhawthorn & @seejohnrun) (#536)

### 💥 Breaking changes

- Rename 16px `trashcan` icon to `trash` (@fermion 🙇) (https://github.com/primer/octicons/pull/538)

### 🧽Chores

- Dependency updates (#525, #524, #523, #522, #520)

## 11.3.0

### 🚀 New features

- `number` (https://github.com/primer/octicons/pull/541)
- `video` (https://github.com/primer/octicons/pull/540)

### 🐛 Fixes

- Fix rendering of arrows in Safari (@aaronshekey https://github.com/primer/octicons/pull/527)

## 11.2.0

### 🚀 New features

- `strikethrough` (https://github.com/primer/octicons/pull/518)

### 🐛 Fixes

- Align `plus` and `dash` icon (https://github.com/primer/octicons/pull/447)
- Small edits in JS documentation (https://github.com/primer/octicons/pull/499)

### 🧽Chores

- Dependency updates

## 11.1.0

### 🚀 New features

- `container` (https://github.com/primer/octicons/pull/507)
- `squirrel` 24px icon (https://github.com/primer/octicons/pull/508)

### 🐛 Fixes

- Corrected stroke for 24px `smiley` (https://github.com/primer/octicons/pull/509)

## 11.0.0

### 💅 Enhancements

- Cache retrieval of Octicon SVG paths (https://github.com/primer/octicons/pull/491)

### 💥 Breaking changes

- Fix 24px icon names https://github.com/primer/octicons/pull/465 (@BenJetson 🙇)
  - `unverifed-24.svg` → `unverified-24.svg`
  - `file-symlink-24.svg` → `file-symlink-file-24.svg`
  - `fire-24.svg` → `flame-24.svg`
  - `eye-slash-24.svg` → `eye-closed-24.svg`
- Remove 24px `settings` icon. Use `gear` instead https://github.com/primer/octicons/pull/493

## 10.1.0

### 🚀 New features

- [`arrow-switch`](https://github.com/primer/octicons/pull/486)
- [`file-badge`](https://github.com/primer/octicons/pull/464)
- [`x-circle`, `x-circle-fill`, `circle`](https://github.com/primer/octicons/pull/455)

### 🐛 Fixes

- Corrected positioning for `triangle-down` [#459](https://github.com/primer/octicons/pull/459)

### 🧽Chores

- Dependency updates

## 10.0.0

### All packages

- We've given Octicons a new look ✨ Some icons have new names and some icons haven't been redesigned yet. The following table documents those changes. If you're using an octicon in v9.x that doesn't have an equivelent in v10.0 yet, let us know by [opening an issue](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D).

| v9.x                     | v10.0                     | Notes                                                                                                                                               |
| ------------------------ | ------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
| `arrow-small-down`       | `arrow-down`              |                                                                                                                                                     |
| `arrow-small-left`       | `arrow-left`              |                                                                                                                                                     |
| `arrow-small-right`      | `arrow-right`             |                                                                                                                                                     |
| `arrow-small-up`         | `arrow-up`                |                                                                                                                                                     |
| `browser`                |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `bug`                    |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `circuit-board`          | `cpu`                     |                                                                                                                                                     |
| `cloud-download`         | `download`                |                                                                                                                                                     |
| `cloud-upload`           | `upload`                  |                                                                                                                                                     |
| `dashboard`              | `meter`                   |                                                                                                                                                     |
| `dependent`              | `package-dependents`      |                                                                                                                                                     |
| `device-camera`          |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `file-pdf`               | `file`                    |                                                                                                                                                     |
| `file-symlink-directory` | `file-submodule`          |                                                                                                                                                     |
| `gist-secret`            | `lock`                    |                                                                                                                                                     |
| `gist`                   | `code-square`             |                                                                                                                                                     |
| `github-action`          |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `heart-outline`          | `heart`                   |                                                                                                                                                     |
| `internal-repo`          | `repo`                    |                                                                                                                                                     |
| `jersey`                 | `people`                  |                                                                                                                                                     |
| `keyboard`               |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `line-arrow-down`        | `arrow-down`              |                                                                                                                                                     |
| `line-arrow-left`        | `arrow-left`              |                                                                                                                                                     |
| `line-arrow-right`       | `arrow-right`             |                                                                                                                                                     |
| `line-arrow-up`          | `arrow-up`                |                                                                                                                                                     |
| `mail-read`              | `mail`                    |                                                                                                                                                     |
| `no-newline`             | `no-entry`                |                                                                                                                                                     |
| `paintcan`               | `paintbrush`              |                                                                                                                                                     |
| `plus-small`             | `plus`                    |                                                                                                                                                     |
| `primitive-dot-stroke`   | `dot`                     |                                                                                                                                                     |
| `primitive-dot`          | `dot-fill`                |                                                                                                                                                     |
| `primitive-square`       | `square-fill`             |                                                                                                                                                     |
| `radio-tower`            | `broadcast`               |                                                                                                                                                     |
| `repo-clone`             |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `repo-force-push`        | `repo-push`               |                                                                                                                                                     |
| `repo-pull`              |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `repo-template-private`  |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |
| `request-changes`        | `diff`                    |                                                                                                                                                     |
| `saved`                  | `bookmark`                |                                                                                                                                                     |
| `text-size`              | `heading` or `typography` |                                                                                                                                                     |
| `unsaved`                | `bookmark-slash`          |                                                                                                                                                     |
| `watch`                  | `hourglass`               |                                                                                                                                                     |
| `workflow-all`           |                           | [Request this icon](https://github.com/primer/octicons/issues/new?assignees=&labels=icon+request&template=icon-request.md&title=%5BIcon+request%5D) |

- We designed a set of 24px icons—as well as 16px icons—to accommodate interfaces that need larger icons. All package implementations now choose which SVG to render based on the size passed in.

### React (@primer/octicons-react)

- Icon components (e.g. `AlertIcon`, `ArrowRightIcon`, etc.) now accept `size`, `ariaLabel`, `verticalAlign`, and `className` props and can be used on their own. No need to pass them to the `Octicon` component.

  ```jsx
  <AlertIcon size={24} />
  ```

- Icon components will now choose the best SVG icon to render based on the `size` passed in.

- The `Octicon` component is deprecated. Use icon components on their own instead:

  ```diff
  - <Octicon icon={AlertIcon} />
  + <AlertIcon />
  ```

#### BREAKING CHANGES 💥

- All icon component names now include `Icon` at the end (e.g. `Alert` → `AlertIcon`).

- In order to enable tree-shaking, we removed the `iconsByName` and `getIconByName` exports.

- `Octicon` no longer accepts `width` or `height` props. Use the `size` prop instead. In cases where the width and height of an icon are not equal (e.g. logos), the height will be set to the value of the `size` prop and the `width` will be scaled proportionally.

- We renamed the `ariaLabel` prop to `aria-label` to be consistent with React: https://reactjs.org/docs/accessibility.html#wai-aria

  ```diff
  - <AlertIcon ariaLabel="alert">
  + <AlertIcon aria-label="alert">
  ```

- Setting `verticalAlign="top"` on the `Octicon` component or any icon component will now apply a `vertical-align: top;` style to the `<svg>`. Previously, we were translating "top" to "text-top." So setting `verticalAlign="top"` would apply a `vertical-align: text-top;` style to the `<svg>`. If you want a vertical alignment of "text-top," set the `verticalAlign` prop to `"text-top"`.

- Custom icon components passed to the `Octicon` component now need to render the entire `<svg>`, not just the `<path>`.

```diff
function CirclesIcon() {
  return (
-   <React.Fragment>
+   <svg viewBox="0 0 30 10" width="30" height="10">
      <circle r={5} cx={5} cy={5}/>
      <circle r={5} cx={15} cy={5}/>
      <circle r={5} cx={25} cy={5}/>
-   </React.Fragment>
+   </svg>
  )
}

- CirclesIcon.size = [30, 10]
```

### JavaScript (@primer/octicons)

#### BREAKING CHANGES 💥

- The structure of each icon object has been updated to allow support multiple SVGs per icon:

##### Before

```js
octicons.alert
// {
//     symbol: 'alert',
//     keywords: ['warning', 'triangle', 'exclamation', 'point'],
//     toSVG: [Function],
//     width: 16,
//     height: 16,
//     path: '<path d="M8.865 1.52c-.18-.31-.51-.5-.87-.5s-.69.19-.87.5L.275 13.5c-.18.31-.18.69 0 1 .19.31.52.5.87.5h13.7c.36 0 .69-.19.86-.5.17-.31.18-.69.01-1L8.865 1.52zM8.995 13h-2v-2h2v2zm0-3h-2V6h2v4z"/>',
//     options: {
//         version: '1.1',
//         width: '16',
//         height: '16',
//         viewBox: '0 0 16 16',
//         class: 'octicon octicon-alert',
//         'aria-hidden': 'true'
//     },
// }
```

#### After

```js
octicons.alert
// {
//     symbol: 'alert',
//     keywords: ['warning', 'triangle', 'exclamation', 'point'],
//     toSVG: [Function]
//     heights: {
//         16: {
//             width: 16,
//             path: '<path d="M8.865 1.52c-.18-.31-.51-.5-.87-.5s-.69.19-.87.5L.275 13.5c-.18.31-.18.69 0 1 .19.31.52.5.87.5h13.7c.36 0 .69-.19.86-.5.17-.31.18-.69.01-1L8.865 1.52zM8.995 13h-2v-2h2v2zm0-3h-2V6h2v4z"/>',
//             options: {
//                 version: '1.1',
//                 width: '16',
//                 height: '16',
//                 viewBox: '0 0 16 16',
//                 class: 'octicon octicon-alert',
//                 'aria-hidden': 'true'
//             },
//         },
//         24: ...
//     }
// }
```

## 9.6.0

### features

- New icon `north-star` https://github.com/primer/octicons/pull/380

## 9.5.0

### features

- New icon `internal-repo` https://github.com/primer/octicons/pull/375

## 9.4.0

### features

- New icons `heart-outline` `infinity` `line-arrow-up` `line-arrow-down` `line-arrow-right` `line-arrow-left` https://github.com/primer/octicons/pull/365

### Chores

- Contributing docs updates and issue template updates #367

### Bugs

- Update `heart` glyphs removing extra points https://github.com/primer/octicons/pull/365

## 9.3.1

### Bugfix

- Workflow icon had a cutoff edge.

## 9.3.0

### 🚀 New features

- Workflow icons https://github.com/primer/octicons/pull/356 @ashygee
- Allow 'unset' value for verticalAlign property https://github.com/primer/octicons/pull/354 @Fs00

## 9.2.0

### 🚀 New features

- [x] New icons for save/unsave and primitive dot stroke https://github.com/primer/octicons/pull/351 @ashygee @colinkeany

### 🧽 Chores

- [x] Migrating to new yml actions syntax https://github.com/primer/octicons/pull/332 @max & @jonrohan
- [x] Update jekyll gemspec to support Jekyll 4.0 https://github.com/primer/octicons/pull/347 @ntotten

### 🐛 Bugs

- [x] Octicons react isn't including className https://github.com/primer/octicons/pull/271 @pocke

## 9.1.1

### 🐛 Bug Fix

- [x] renamed the original shield icon to `shield-lock` https://github.com/primer/octicons/issues/323 @ashygee
- [x] test for duplicate icons https://github.com/primer/octicons/pull/322 @jonrohan

## 9.1.0

### 🚀 New features

- [x] Adding skip icon https://github.com/primer/octicons/pull/318 @ashygee

## 9.0.0

### 💥 Breaking changes

- [x] Rename `octicons` to `@primer/octicons` https://github.com/primer/octicons/pull/311
- [x] Rename `@githubprimer/octicons-react` to `@primer/octicons-react` https://github.com/primer/octicons/pull/311

### 🚀 New features

- [x] Adding a shield icon https://github.com/primer/octicons/pull/310 @ashygee @donokuda
- [x] Adding new repo icons https://github.com/primer/octicons/issues/316 @superbryntendo

## 8.5.0

- a11y aria-hidden update from @muan https://github.com/primer/octicons/pull/295
- Verified icons poor rendering. @ashygee https://github.com/primer/octicons/pull/297
- Docs update for contributing @ashygee https://github.com/primer/octicons/pull/298

## 8.4.2

### 💅🏼 Enhancement

- Thumbs up/down icons needed some vector improvements. https://github.com/primer/octicons/pull/287

### 🐛 Bug Fix

- Node package missing `build/build.css` file. https://github.com/primer/octicons/pull/292

## 8.4.1

### 🐛 Bug Fix

- Rollup files missing from octicons react package https://github.com/primer/octicons/issues/282

## 8.4.0

### 🏠 Internal

- Using Actions to build and deploy Octicons https://github.com/primer/octicons/pull/276

#### Committers: 1

- Jon Rohan ([jonrohan](https://github.com/jonrohan))

## 8.3.0

- New "changes requested" icon https://github.com/primer/octicons/pull/267
- Contrib Doc Updates https://github.com/primer/octicons/pull/256
- Updating licenses to 2019 https://github.com/primer/octicons/pull/272

## 8.2.0

- Add `fold-up` and `fold-down` icons, courtesy of @pmarsceill

## 8.1.3

- Add `eye-closed` icon, courtesy of @colinkeany

## 8.1.2

- Patch release for failed 8.1.1 release

## 8.1.1

- Fix for `list-ordered` icon https://github.com/primer/octicons/pull/252
- In React Octicons, we set aria-hidden to false if there's an aria-label provided

## 8.1.0

- Add the `arrow-both` icon courtesy of @venetucci
- TypeScript types are now available thanks to @j-f1!
- Fix CI builds for outside contributors (as long as they aren't changing octicons)
- Fix typo in README
- Update README with `@githubprimer/octicons-react scope`
- Publish release candidates from any branch beginning with `release`

## 8.0.0

- Breaking changes in `octicons_react` [#225](https://github.com/primer/octicons/pull/225)
- After the initial release of octicons_react https://github.com/primer/octicons/releases/tag/v7.4.0, we needed to rename the scope of the package. Due to some deployment conflicts in our pipelines.

## 7.4.0

- This release marks the first official version of Octicons for React! Check out the `@github/octicons-react` package on npm for more info, or peruse the long-running PR [#222](https://github.com/primer/octicons/pull/222).
- CI status is now reported to the `#design-ops` Slack channel
- Jekyll Octicons has moved in this repo from `lib/jekyll-octicons` to `lib/octicons_jekyll`

## 7.3.0

- Fix for heart icon https://github.com/primer/octicons/pull/211
- Adding an archive icon created by @colinkeany
- Fixes https://github.com/primer/octicons/issues/182
- Fixed versioning strategy https://github.com/primer/octicons/pull/#208

## Archived releases

### Octicons_node 7.0.0

- Removing `file-text` and `mail-reply` icons. Use `file` and `reply` respectively.
- Removing spritesheet calls and `toSVGUse` method.

### Octicons_gem 5.0.4

- Removing `file-text` and `mail-reply` icons. Use `file` and `reply` respectively.
- Removing spritesheet calls and `to_svg_use` method.

### 6.0.1

Fixes:

- Typo `kebab-veritcal` becomes `kebab-vertical`

### 6.0.0

Added:

- `kebab-horizontal` and `kebab-vertical` icons
- Polyfill for the `Object.assign` function

Removes:

- Removing a duplicate `ellipses` icon from the set. Use `ellipsis` instead.

### 5.0.1

Fixes:

- projects icon renders as a block, using `fill-rule` fixes it

### 5.0.0

Adds:

- `project`
- `note`
- `screen-full`
- `screen-normal`
- More node.js api endpoints for accessing icons https://github.com/primer/octicons/pull/120
- Creating a spritesheet demo https://github.com/primer/octicons/pull/121

Removes:

- Deprecating support for the webfont https://github.com/primer/octicons/pull/117
- Stop checking `/build/` directory into repository https://github.com/primer/octicons/pull/118
- Removing sass as a dependency https://github.com/primer/octicons/pull/119

### 4.4.0

Adds:

- svg.json file that is accessible from node require

### 4.3.0

Fixes:

- Vertical alignment on `italic`

Modifies:

- `person`
- `organization`

### 4.2.1

Fixes:

- Removing inline sourcemap from `min` versions of css.

### 4.2.0

Adds:

- Keywords.json file that has an index of all octicons with alias names

### 4.1.1 (June 16, 2016)

Fixes:

- Putting the `$octicons-font-path` back in the scss file.

### 4.1.0 (June 6, 2016)

Adds:

- Installation docs https://github.com/primer/octicons/pull/94
- `grabber`
- `plus-small`

Modifies:

- `smiley`

Refines:

- Renames `mail-reply` to `reply` and refines its shape.

Fixes:

- Revert license back to SPDX standard

### 4.0.0 (June 6, 2016)

Adds:

- Whole new grunt build system including svg sprite sheet.
- adding css min https://github.com/primer/octicons/pull/60
- adding woff2 format https://github.com/primer/octicons/issues/3
- creates spritesheet of svg files https://github.com/primer/octicons/issues/88

Removes:

- Bower support

Fixes:

- all svg icons include viewBox https://github.com/primer/octicons/issues/87
- license in package.json https://github.com/primer/octicons/issues/85

### 3.5.0 (February 12, 2016)

Adds:

- `unverified`

Refines:

- `verified`

### 3.4.1 (January 24, 2016)

This includes various SVG viewport refinements.

Refines:

- `thumbs-down`
- `logo-github`

### 3.4.0 (January 22, 2016)

Adds:

- `verified`
- `smiley`

Removes:

- `color-mode`

Refines:

- `primitive-dot`
- `horizontal-rule`
- `triangle-down`
- `triangle-up`
- `triangle-left`
- `triangle-right`
- `globe`
- `flame`
- `comment-discussion`

### 3.3.0 (November 12, 2015)

Adds:

- `logo-gist`

Resizes all our SVG to be 16x16 instead of 1024x1024

### 3.2.0 (November 6, 2015)

Adds:

- `bold`
- `text-size`
- `italic`
- `tasklist`

It also normalizes some styling in:

- `list-unordered`
- `list-ordered`
- `quote`
- `mention`
- `bookmark`
- `threebars`

Removes

- `screen-normal`
- `screen-full`

### 3.1.0 (August 13, 2015)

Adds

- `shield`

This thickens stroke widths slightly on the following icons:

- `circle-slash`
- `clock`
- `cloud-upload`
- `cloud-download`
- `dashboard`
- `info`
- `issue-closed`
- `issue`
- `issue-reopened`
- `history`
- `question`
- `search`

Fills `comment-discussion`

Thickens `x` to match `checkmark`

### 3.0.1 (August 10, 2015)

Some files were missing in `3.0.0`

### 3.0.0 (August 10, 2015)

Removes

- `microscope`
- `beer`
- `split`
- `puzzle`
- `steps`
- `podium`
- `timer`
- all `alignment` icons
- all `move` icons
- all `playback` icons
- all `jump` icons

Adds

- `beaker`
- `bell`
- `desktop-download`
- `watch`

Line-weight changes, sizing normalization, and new drawings

- `circle-slash`
- `lock`
- `cloud-upload`
- `cloud-download`
- `plus`
- `✕`
- `broadcast`
- `lock`
- all `repo` icons
- organization
- person
- all `chevrons` & `triangles`
- all `diff` icons
- `clippy`
- all `issue` and circular icons
- `rss`
- `ruby`
- `cancel`
- `settings`
- `mirror`
- `external-link`
- `history`
- `gear`
- `settings`
- `info`
- `history`
- `package`
- `gist-secret`
- `rocket`
- `law`
- `telescope`
- `search`
- `tag`
- `normal-screen`
- `iphone`
- `no-new-line`
- `desktop`
- all `git` icons
- `circuit-board`
- `heart`
- `home`
- `briefcase`
- `wiki`
- `bookmark`
- `briefcase`
- `calendar`
- `color-mode`
- `comment`
- `discussions`
- `credit-card`
- `dashboard`
- `camera`
- `video`
- `bug`
- `desktop`
- `ellipses`
- `eye`
- all `files` & `folders`
- `fold`
- `unfold`
- `gift`
- `graph`
- `hubot`
- `inbox`
- `jersey`
- `keyboard`
- `light-bulb`
- `link`
- `location`
- `mail`
- `mail-read`
- `marker`
- `plug`
- `mute`
- `pencil`
- `push-pin`
- `fullscreen`
- `unfullscreen`
- `server`
- `sign-in`
- `sign-out`
- `tag`
- `terminal`
- `thumbs-up`
- `thumbs-down`
- `trash`
- `unmute`
- `versions`
- `gist`
- `key`
- `megaphone`
- `checklist`

## 2.4.1 (June 2, 2015)

- Add the scss file I forgot to include

## 2.4.0 (June 2, 2015)

- Add `octicons.scss`
- Revert path changes to `sprockets-octicons.scss`, as they broke octicons in sprockets.

## 2.3.0 (May 28, 2015)

- Add a path variable to `sprockets-octicons.scss` to be consistent with octicons.less`

## 2.2.3 (May 21, 2015)

- Use SPDX license identifiers in package.json

## 2.2.2 (April 1, 2015)

Fixes file icons for

- `file-binary`
- `file-code`
- `file-media`
- `file-pdf`
- `file-symlink-file`
- `file-text`
- `file-zip`

## 2.2.1 (March 30, 2015)

- Fix vector artifact and smooth curves in `mark-github`

## 2.2.0 (Feb 18, 2015)

- Add two new icons: `thumbsup` and `thumbsdown`

## 2.0.1 (June 16, 2014)

- Add mention of github.com/logos to the license

## 2.0.0 (June 16, 2014)

- Hello world
