use css_style::{prelude::*, StyleUpdater};

#[derive(Debug, Copy, Clone, PartialEq, Eq)]
enum ScrollValue {
    Auto,
    Off,
    On,
}

#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Scroll {
    x: ScrollValue,
    y: ScrollValue,
}

impl Scroll {
    pub fn auto() -> Self {
        Self {
            x: ScrollValue::Auto,
            y: ScrollValue::Auto,
        }
    }

    pub fn off() -> Self {
        Self {
            x: ScrollValue::Off,
            y: ScrollValue::Off,
        }
    }

    pub fn on() -> Self {
        Self {
            x: ScrollValue::On,
            y: ScrollValue::On,
        }
    }

    pub fn x_off(mut self) -> Self {
        self.x = ScrollValue::Off;
        self
    }

    pub fn x_on(mut self) -> Self {
        self.x = ScrollValue::On;
        self
    }

    pub fn x_auto(mut self) -> Self {
        self.x = ScrollValue::Auto;
        self
    }

    pub fn y_off(mut self) -> Self {
        self.y = ScrollValue::Off;
        self
    }

    pub fn y_on(mut self) -> Self {
        self.y = ScrollValue::On;
        self
    }

    pub fn y_auto(mut self) -> Self {
        self.y = ScrollValue::Auto;
        self
    }
}

impl StyleUpdater for Scroll {
    fn update_style(self, style: Style) -> Style {
        let get_val = |val| match val {
            ScrollValue::Auto => "auto",
            ScrollValue::Off => "hidden",
            ScrollValue::On => "scroll",
        };
        style
            .insert("overflow-x", get_val(self.x))
            .insert("overflow-y", get_val(self.y))
    }
}
