use css_style::{
    calc::{calc, Calc},
    margin, padding,
    unit::percent,
};

pub(crate) fn calc_width(
    padding: Option<&padding::Padding>,
    margin: Option<&margin::Margin>,
) -> Calc {
    let calc_pad =
        |padding: Option<&padding::Length>| padding.and_then(|p| Calc::try_from(p.clone()).ok());
    let calc_marg =
        |margin: Option<&margin::Length>| margin.and_then(|p| Calc::try_from(p.clone()).ok());

    calc(percent(1.0))
        .try_sub(calc_pad(padding.map(|p| p.left.as_ref()).flatten()))
        .try_sub(calc_pad(padding.map(|p| p.right.as_ref()).flatten()))
        .try_sub(calc_marg(margin.map(|m| m.left.as_ref()).flatten()))
        .try_sub(calc_marg(margin.map(|m| m.right.as_ref()).flatten()))
}

pub(crate) fn calc_height(
    padding: Option<&padding::Padding>,
    margin: Option<&margin::Margin>,
) -> Calc {
    let calc_pad =
        |padding: Option<&padding::Length>| padding.and_then(|p| Calc::try_from(p.clone()).ok());
    let calc_marg =
        |margin: Option<&margin::Length>| margin.and_then(|p| Calc::try_from(p.clone()).ok());

    calc(percent(1.0))
        .try_sub(calc_pad(padding.map(|p| p.top.as_ref()).flatten()))
        .try_sub(calc_pad(padding.map(|p| p.bottom.as_ref()).flatten()))
        .try_sub(calc_marg(margin.map(|m| m.top.as_ref()).flatten()))
        .try_sub(calc_marg(margin.map(|m| m.bottom.as_ref()).flatten()))
}
