# yew-layout

[![master docs](https://img.shields.io/badge/docs-master-blue.svg)](https://malrusayni.gitlab.io/yew-layout/yew_layout/)
&middot;
[![crate info](https://img.shields.io/crates/v/yew-layout.svg)](https://crates.io/crates/yew-layout)
&middot;
[![pipeline](https://gitlab.com/MAlrusayni/yew-layout/badges/master/pipeline.svg)](https://gitlab.com/MAlrusayni/yew-layout/pipelines)
&middot;
[![rustc version](https://img.shields.io/badge/rustc-stable-green.svg)](https://crates.io/crates/yew-layout)
&middot;
[![unsafe forbidden](https://img.shields.io/badge/unsafe-forbidden-success.svg)](https://github.com/rust-secure-code/safety-dance/)

This crate provides you a layouts components based on [**Yew
Framwork**](https://crates.io/crates/yew), those components are used to build
your view. [See API Docs](https://malrusayni.gitlab.io/yew-layout/yew_layout/)

**NOTE:** yew-layout is not (yet) prodction ready but is good for use in side
projects and internal tools.

# Available Layouts

- **Row**: A layout that align it's children horizontally.
- **Column**: A layout that align it's children vertically.

# Features

- **Reasonable Defaults**: All layouts have reasonable default properties
  values, which work very well with most use cases.
- **Rich Properties**: All layouts have rich properties that can be tweaked in
  many different ways to fit other use cases.
- **Consistent Properties**: Layouts almost have the same properties, So if you
  decied to change from `Row` to `Column` just do it and properties would work
  the same, thier behavior would change to match the currnt layout type!.
- **Powered By Flexbox**: `Row` and `Column` uses Flexbox behind the scene,
  there is no black magic fortunately.

# Goal

The goal for this crate is to provide you a layout types that is used to
layout your views, nothing else.

# Qucik Example

```rust
use yew_layout::{Align, AlignRows, Column, CrossAlign, Row, RowProps};
use css_style::{unit::px, Gap, Margin, Padding};
use yew::prelude::*;

pub struct App;

impl Component for App {
    type Message = ();
    type Properties = ();

    fn create(ctx: &Context<Self>) -> Self {
        App
    }

    fn view(&self, ctx: &Context<Self>) -> Html {
        html! {
            <div style={ "width: 400px; height: 400px; background: silver" }>
                <Column align={ Align::Center } cross_align={ CrossAlign::Center }>
                    <Row align={ Align::Center }
                         align_rows={ AlignRows::SpaceBetween }
                         wrap=true
                         expand_by=3.0
                         gap={ Gap::from(px(12)) }
                         padding={ Padding::default().y(px(12)) }
                         margin={ Margin::default().x(px(20)) }>
                         {
                             (0..=11)
                                 .into_iter()
                                 .map(|_| html!{
                                     <div style={ "background: blue; height: 40px; width: 40px;" }></div>
                                 }).collect::<Html>()
                         }
                    </Row>
                    <Row expand_by=1.5>
                        <h1>{ "This is another row" }</h1>
                    </Row>
                </Column>
            </div>
        }
    }
}
```

this would look like:
![master docs](./screenshots/quick-example.png)
