include!(concat!(env!("OUT_DIR"), "/script.rs")); // generated by build.rs

const MASK: usize = BLOCK_SIZE - 1;
const SHIFT: usize = MASK.count_ones() as usize;

/// Look up the script for a character.
///
/// ### Example
///
/// ```
/// use unicode_script::{get_script, Script};
///
/// assert_eq!(get_script('A'), Script::Latin);
/// assert_eq!(get_script('カ'), Script::Katakana);
/// ```
pub fn get_script(chr: char) -> Script {
    let u = chr as u32;

    if u <= LAST_CODEPOINT {
        return SCRIPT_BLOCKS
            [SCRIPT_BLOCK_OFFSETS[u as usize >> SHIFT] as usize + (u as usize & MASK)];
    } else {
        return Unknown; // Zzzz
    }
}
